/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractFileName;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.local.LocalFileNameParser;

public class LocalFileName
extends AbstractFileName {
    private final String rootFile;

    protected LocalFileName(String scheme, String rootFile, String path) {
        super(scheme, path);
        this.rootFile = rootFile;
    }

    public static LocalFileName parseUri(String uri, boolean uriEncoded, LocalFileNameParser parser) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        String scheme = UriParser.extractScheme(uri, name);
        if (uriEncoded) {
            UriParser.decode(name, 0, name.length());
        }
        UriParser.fixSeparators(name);
        String rootFile = parser.extractRootPrefix(uri, name);
        UriParser.normalisePath(name);
        String path = name.toString();
        return new LocalFileName(scheme, rootFile, path);
    }

    public String getRootFile() {
        return this.rootFile;
    }

    protected FileName createName(String path) {
        return new LocalFileName(this.getScheme(), this.rootFile, path);
    }

    protected void appendRootUri(StringBuffer buffer) {
        buffer.append(this.getScheme());
        buffer.append("://");
        buffer.append(this.rootFile);
    }
}

