/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Base64 {
    public static final String LINE_SEPARATOR = "\n";
    public static final int LINE_SIZE = 76;
    private static final char[] intToBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    public static OutputStream newEncoder(Writer pWriter) {
        return Base64.newEncoder(pWriter, 76, LINE_SEPARATOR);
    }

    public static OutputStream newEncoder(final Writer pWriter, int pLineSize, String pSeparator) {
        Encoder encoder = new Encoder(new char[4096], pLineSize, pSeparator){

            protected void writeBuffer(char[] pBuffer, int pOffset, int pLen) throws IOException {
                pWriter.write(pBuffer, pOffset, pLen);
            }
        };
        return new EncoderOutputStream(encoder);
    }

    public static String encode(byte[] pBuffer, int pOffset, int pLength) {
        return Base64.encode(pBuffer, pOffset, pLength, 76, LINE_SEPARATOR);
    }

    public static String encode(byte[] pBuffer, int pOffset, int pLength, int pLineSize, String pSeparator) {
        StringWriter sw = new StringWriter();
        OutputStream ostream = Base64.newEncoder(sw, pLineSize, pSeparator);
        try {
            ostream.write(pBuffer, pOffset, pLength);
            ostream.close();
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
        return sw.toString();
    }

    public static String encode(byte[] pBuffer) {
        return Base64.encode(pBuffer, 0, pBuffer.length);
    }

    public Writer newDecoder(final OutputStream pStream) {
        return new Writer(){
            private final Decoder decoder = new Decoder(this, 1024){
                private final /* synthetic */ 2 this$1;
                {
                    this.this$1 = this$1;
                }

                protected void writeBuffer(byte[] pBytes, int pOffset, int pLen) throws IOException {
                    2.access$200(this.this$1).write(pBytes, pOffset, pLen);
                }
            };

            public void close() throws IOException {
                this.flush();
            }

            public void flush() throws IOException {
                this.decoder.flush();
                pStream.flush();
            }

            public void write(char[] cbuf, int off, int len) throws IOException {
                this.decoder.write(cbuf, off, len);
            }

            static /* synthetic */ OutputStream access$200(2 x0) {
                return x0.pStream;
            }
        };
    }

    public static byte[] decode(char[] pBuffer, int pOffset, int pLength) throws DecodingException {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Decoder d = new Decoder(1024){

            protected void writeBuffer(byte[] pBuf, int pOff, int pLen) throws IOException {
                baos.write(pBuf, pOff, pLen);
            }
        };
        try {
            d.write(pBuffer, pOffset, pLength);
            d.flush();
        }
        catch (DecodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
        return baos.toByteArray();
    }

    public static byte[] decode(char[] pBuffer) throws DecodingException {
        return Base64.decode(pBuffer, 0, pBuffer.length);
    }

    public static byte[] decode(String pBuffer) throws DecodingException {
        return Base64.decode(pBuffer.toCharArray());
    }

    public static abstract class Decoder {
        private final byte[] byteBuffer;
        private int byteBufferOffset;
        private int num;
        private int numBytes;
        private int eofBytes;

        protected Decoder(int pBufLen) {
            this.byteBuffer = new byte[pBufLen];
        }

        protected abstract void writeBuffer(byte[] var1, int var2, int var3) throws IOException;

        public void write(char[] pData, int pOffset, int pLen) throws IOException {
            block6: for (int i = 0; i < pLen; ++i) {
                byte result;
                char c;
                if (Character.isWhitespace(c = pData[pOffset++])) continue;
                if (c == '=') {
                    ++this.eofBytes;
                    this.num <<= 6;
                    switch (++this.numBytes) {
                        case 1: 
                        case 2: {
                            throw new DecodingException("Unexpected end of stream character (=)");
                        }
                        case 3: {
                            continue block6;
                        }
                        case 4: {
                            this.byteBuffer[this.byteBufferOffset++] = (byte)(this.num >> 16);
                            if (this.eofBytes == 1) {
                                this.byteBuffer[this.byteBufferOffset++] = (byte)(this.num >> 8);
                            }
                            this.writeBuffer(this.byteBuffer, 0, this.byteBufferOffset);
                            this.byteBufferOffset = 0;
                            continue block6;
                        }
                        case 5: {
                            throw new DecodingException("Trailing garbage detected");
                        }
                        default: {
                            throw new IllegalStateException("Invalid value for numBytes");
                        }
                    }
                }
                if (this.eofBytes > 0) {
                    throw new DecodingException("Base64 characters after end of stream character (=) detected.");
                }
                if (c >= '\u0000' && c < base64ToInt.length && (result = base64ToInt[c]) >= 0) {
                    this.num = (this.num << 6) + result;
                    if (++this.numBytes != 4) continue;
                    this.byteBuffer[this.byteBufferOffset++] = (byte)(this.num >> 16);
                    this.byteBuffer[this.byteBufferOffset++] = (byte)(this.num >> 8 & 0xFF);
                    this.byteBuffer[this.byteBufferOffset++] = (byte)(this.num & 0xFF);
                    if (this.byteBufferOffset + 3 > this.byteBuffer.length) {
                        this.writeBuffer(this.byteBuffer, 0, this.byteBufferOffset);
                        this.byteBufferOffset = 0;
                    }
                    this.num = 0;
                    this.numBytes = 0;
                    continue;
                }
                if (Character.isWhitespace(c)) continue;
                throw new DecodingException("Invalid Base64 character: " + c);
            }
        }

        public void flush() throws IOException {
            if (this.numBytes != 0 && this.numBytes != 4) {
                throw new DecodingException("Unexpected end of file");
            }
            if (this.byteBufferOffset > 0) {
                this.writeBuffer(this.byteBuffer, 0, this.byteBufferOffset);
                this.byteBufferOffset = 0;
            }
        }
    }

    public static class SAXEncoder
    extends Encoder {
        private final ContentHandler handler;

        public SAXEncoder(char[] pBuffer, int pWrapSize, String pSep, ContentHandler pHandler) {
            super(pBuffer, pWrapSize, pSep);
            this.handler = pHandler;
        }

        protected void writeBuffer(char[] pChars, int pOffset, int pLen) throws IOException {
            try {
                this.handler.characters(pChars, pOffset, pLen);
            }
            catch (SAXException e) {
                throw new SAXIOException(e);
            }
        }
    }

    public static class EncoderOutputStream
    extends OutputStream {
        private final Encoder encoder;
        private final byte[] oneByte = new byte[1];

        public EncoderOutputStream(Encoder pEncoder) {
            this.encoder = pEncoder;
        }

        public void write(int b) throws IOException {
            this.oneByte[0] = (byte)b;
            this.encoder.write(this.oneByte, 0, 1);
        }

        public void write(byte[] pBuffer, int pOffset, int pLen) throws IOException {
            this.encoder.write(pBuffer, pOffset, pLen);
        }

        public void close() throws IOException {
            this.encoder.flush();
        }
    }

    public static abstract class Encoder {
        private int num;
        private int numBytes;
        private final char[] charBuffer;
        private int charOffset;
        private final int wrapSize;
        private final int skipChars;
        private final String sep;
        private int lineChars = 0;

        protected Encoder(char[] pBuffer, int pWrapSize, String pSep) {
            this.charBuffer = pBuffer;
            this.sep = pSep == null ? null : Base64.LINE_SEPARATOR;
            this.skipChars = pWrapSize == 0 ? 4 : 4 + this.sep.length();
            int n = this.wrapSize = this.skipChars == 4 ? 0 : pWrapSize;
            if (this.wrapSize < 0 || this.wrapSize % 4 > 0) {
                throw new IllegalArgumentException("Illegal argument for wrap size: " + pWrapSize + "(Expected nonnegative multiple of 4)");
            }
            if (pBuffer.length < this.skipChars) {
                throw new IllegalArgumentException("The buffer must contain at least " + this.skipChars + " characters, but has " + pBuffer.length);
            }
        }

        protected abstract void writeBuffer(char[] var1, int var2, int var3) throws IOException;

        private void wrap() {
            for (int j = 0; j < this.sep.length(); ++j) {
                this.charBuffer[this.charOffset++] = this.sep.charAt(j);
            }
            this.lineChars = 0;
        }

        public void write(byte[] pBuffer, int pOffset, int pLen) throws IOException {
            for (int i = 0; i < pLen; ++i) {
                int b;
                if ((b = pBuffer[pOffset++]) < 0) {
                    b += 256;
                }
                this.num = (this.num << 8) + b;
                if (++this.numBytes != 3) continue;
                this.charBuffer[this.charOffset++] = intToBase64[this.num >> 18];
                this.charBuffer[this.charOffset++] = intToBase64[this.num >> 12 & 0x3F];
                this.charBuffer[this.charOffset++] = intToBase64[this.num >> 6 & 0x3F];
                this.charBuffer[this.charOffset++] = intToBase64[this.num & 0x3F];
                if (this.wrapSize > 0) {
                    this.lineChars += 4;
                    if (this.lineChars >= this.wrapSize) {
                        this.wrap();
                    }
                }
                this.num = 0;
                this.numBytes = 0;
                if (this.charOffset + this.skipChars <= this.charBuffer.length) continue;
                this.writeBuffer(this.charBuffer, 0, this.charOffset);
                this.charOffset = 0;
            }
        }

        public void flush() throws IOException {
            if (this.numBytes > 0) {
                if (this.numBytes == 1) {
                    this.charBuffer[this.charOffset++] = intToBase64[this.num >> 2];
                    this.charBuffer[this.charOffset++] = intToBase64[this.num << 4 & 0x3F];
                    this.charBuffer[this.charOffset++] = 61;
                    this.charBuffer[this.charOffset++] = 61;
                } else {
                    this.charBuffer[this.charOffset++] = intToBase64[this.num >> 10];
                    this.charBuffer[this.charOffset++] = intToBase64[this.num >> 4 & 0x3F];
                    this.charBuffer[this.charOffset++] = intToBase64[this.num << 2 & 0x3F];
                    this.charBuffer[this.charOffset++] = 61;
                }
                this.lineChars += 4;
                this.num = 0;
                this.numBytes = 0;
            }
            if (this.wrapSize > 0 && this.lineChars > 0) {
                this.wrap();
            }
            if (this.charOffset > 0) {
                this.writeBuffer(this.charBuffer, 0, this.charOffset);
                this.charOffset = 0;
            }
        }
    }

    public static class SAXIOException
    extends IOException {
        private static final long serialVersionUID = 3258131345216451895L;
        final SAXException saxException;

        SAXIOException(SAXException e) {
            this.saxException = e;
        }

        public SAXException getSAXException() {
            return this.saxException;
        }
    }

    public static class DecodingException
    extends IOException {
        private static final long serialVersionUID = 3257006574836135478L;

        DecodingException(String pMessage) {
            super(pMessage);
        }
    }
}

