/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcTransportImpl;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.parser.XmlRpcResponseParser;
import org.apache.xmlrpc.serializer.XmlRpcWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class XmlRpcStreamTransport
extends XmlRpcTransportImpl {
    private static final SAXParserFactory spf = SAXParserFactory.newInstance();

    protected XmlRpcStreamTransport(XmlRpcClient pClient) {
        super(pClient);
    }

    protected abstract Object newConnection(XmlRpcStreamRequestConfig var1) throws XmlRpcClientException;

    protected abstract void closeConnection(Object var1) throws XmlRpcClientException;

    protected void initConnection(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws XmlRpcClientException {
    }

    protected abstract OutputStream newOutputStream(XmlRpcStreamRequestConfig var1, Object var2) throws XmlRpcClientException;

    protected void closeOutputStream(OutputStream pStream) throws XmlRpcClientException {
        try {
            pStream.close();
        }
        catch (IOException e) {
            throw new XmlRpcClientException("Failed to close output stream.", e);
        }
    }

    protected OutputStream getOutputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws XmlRpcClientException {
        OutputStream result = this.newOutputStream(pConfig, pConnection);
        if (pConfig.isGzipCompressing()) {
            try {
                result = new GZIPOutputStream(result);
            }
            catch (IOException e) {
                throw new XmlRpcClientException("Failed to attach gzip encoding to output stream", e);
            }
        }
        return result;
    }

    protected abstract InputStream newInputStream(XmlRpcStreamRequestConfig var1, Object var2) throws XmlRpcException;

    protected abstract InputStream newInputStream(XmlRpcStreamRequestConfig var1, Object var2, byte[] var3) throws XmlRpcException;

    protected void closeInputStream(InputStream pStream) throws XmlRpcClientException {
        try {
            pStream.close();
        }
        catch (IOException e) {
            throw new XmlRpcClientException("Failed to close output stream.", e);
        }
    }

    protected abstract boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig var1, Object var2);

    protected InputStream getInputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection, byte[] pContent) throws XmlRpcException {
        InputStream istream = pContent == null ? this.newInputStream(pConfig, pConnection) : this.newInputStream(pConfig, pConnection, pContent);
        if (this.isResponseGzipCompressed(pConfig, pConnection)) {
            try {
                istream = new GZIPInputStream(istream);
            }
            catch (IOException e) {
                throw new XmlRpcClientException("Failed to attach gzip decompression to the response stream", e);
            }
        }
        return istream;
    }

    protected boolean isUsingByteArrayOutput(XmlRpcStreamRequestConfig pConfig) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object sendRequest(XmlRpcRequest pRequest) throws XmlRpcException {
        block25: {
            config = (XmlRpcStreamRequestConfig)pRequest.getConfig();
            connection = this.newConnection(config);
            try {
                this.initConnection(config, connection);
                if (this.isUsingByteArrayOutput(config)) {
                    baos = new ByteArrayOutputStream();
                    if (config.isGzipCompressing()) {
                        try {
                            ostream = new GZIPOutputStream(baos);
                        }
                        catch (IOException e) {
                            throw new XmlRpcClientException("Failed to create GZIPOutputStream: " + e.getMessage(), e);
                        }
                    } else {
                        ostream = baos;
                    }
                } else {
                    baos = null;
                    ostream = this.getOutputStream(config, connection);
                }
                try {
                    this.writeRequest(config, ostream, pRequest);
                    this.closeOutputStream(ostream);
                    ostream = null;
                    var8_8 = null;
                    ** if (ostream == null) goto lbl-1000
                }
                catch (Throwable var7_12) {
                    var8_9 = null;
                    if (ostream != null) {
                        try {
                            this.closeOutputStream(ostream);
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                    }
                    throw var7_12;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        this.closeOutputStream(ostream);
                    }
                    catch (Throwable ignore) {}
                }
lbl-1000:
                // 2 sources

                {
                }
                istream = this.getInputStream(config, connection, baos == null ? null : baos.toByteArray());
                try {
                    result = this.readResponse(config, istream);
                    this.closeInputStream(istream);
                    istream = null;
                    var11_14 = null;
                    ** if (istream == null) goto lbl-1000
                }
                catch (Throwable var10_18) {
                    var11_15 = null;
                    if (istream != null) {
                        try {
                            this.closeInputStream(istream);
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                    }
                    throw var10_18;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        this.closeInputStream(istream);
                    }
                    catch (Throwable ignore) {}
                }
lbl-1000:
                // 2 sources

                {
                }
                this.closeConnection(connection);
                connection = null;
                var8_8 = result;
                var14_19 = null;
                if (connection == null) break block25;
            }
            catch (Throwable var13_23) {
                block26: {
                    var14_20 = null;
                    if (connection == null) break block26;
                    try {
                        this.closeConnection(connection);
                    }
                    catch (Throwable ignore) {}
                }
                throw var13_23;
            }
            try {
                this.closeConnection(connection);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return var8_8;
    }

    protected XMLReader newXMLReader() throws XmlRpcClientException {
        try {
            return spf.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw new XmlRpcClientException("Failed to create XMLReader: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new XmlRpcClientException("Failed to create XMLReader: " + e.getMessage(), e);
        }
    }

    protected Object readResponse(XmlRpcStreamRequestConfig pConfig, InputStream pStream) throws XmlRpcException {
        XmlRpcResponseParser xp;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int res;
            byte[] buffer = new byte[1024];
            while ((res = pStream.read(buffer)) != -1) {
                if (res <= 0) continue;
                baos.write(buffer, 0, res);
            }
        }
        catch (IOException e) {
            throw new XmlRpcClientException(e.getMessage(), e);
        }
        pStream = new ByteArrayInputStream(baos.toByteArray());
        InputSource isource = new InputSource(pStream);
        XMLReader xr = this.newXMLReader();
        try {
            xp = new XmlRpcResponseParser(pConfig, this.getClient().getTypeFactory());
            xr.setContentHandler(xp);
            xr.parse(isource);
        }
        catch (SAXException e) {
            throw new XmlRpcClientException("Failed to parse servers response: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlRpcClientException("Failed to read servers response: " + e.getMessage(), e);
        }
        if (xp.isSuccess()) {
            return xp.getResult();
        }
        throw new XmlRpcException(xp.getErrorCode(), xp.getErrorMessage());
    }

    protected void writeRequest(XmlRpcStreamRequestConfig pConfig, OutputStream pStream, XmlRpcRequest pRequest) throws XmlRpcException {
        ContentHandler h = this.getClient().getXmlWriterFactory().getXmlWriter(pConfig, pStream);
        XmlRpcWriter xw = new XmlRpcWriter(pConfig, h, this.getClient().getTypeFactory());
        try {
            xw.write(pRequest);
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex != null && ex instanceof XmlRpcException) {
                throw (XmlRpcException)ex;
            }
            throw new XmlRpcClientException("Failed to send request: " + e.getMessage(), e);
        }
    }

    static {
        spf.setNamespaceAware(true);
        spf.setValidating(false);
    }
}

