/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.webserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.StringTokenizer;
import org.apache.xmlrpc.common.XmlRpcHttpRequestConfig;
import org.apache.xmlrpc.common.XmlRpcNotAuthorizedException;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.server.XmlRpcHttpServerConfig;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.util.HttpUtil;
import org.apache.xmlrpc.util.LimitedInputStream;
import org.apache.xmlrpc.util.ThreadPool;
import org.apache.xmlrpc.webserver.RequestData;
import org.apache.xmlrpc.webserver.WebServer;

public class Connection
implements ThreadPool.Task {
    private static final String US_ASCII = "US-ASCII";
    private static final byte[] ctype = Connection.toHTTPBytes("Content-Type: text/xml\r\n");
    private static final byte[] clength = Connection.toHTTPBytes("Content-Length: ");
    private static final byte[] newline = Connection.toHTTPBytes("\r\n");
    private static final byte[] doubleNewline = Connection.toHTTPBytes("\r\n\r\n");
    private static final byte[] conkeep = Connection.toHTTPBytes("Connection: Keep-Alive\r\n");
    private static final byte[] conclose = Connection.toHTTPBytes("Connection: close\r\n");
    private static final byte[] ok = Connection.toHTTPBytes(" 200 OK\r\n");
    private static final byte[] serverName = Connection.toHTTPBytes("Server: Apache XML-RPC 1.0\r\n");
    private static final byte[] wwwAuthenticate = Connection.toHTTPBytes("WWW-Authenticate: Basic realm=XML-RPC\r\n");
    private final WebServer webServer;
    private final Socket socket;
    private final InputStream input;
    private final OutputStream output;
    private final XmlRpcStreamServer server;
    private byte[] buffer;

    private static final byte[] toHTTPBytes(String text) {
        try {
            return text.getBytes(US_ASCII);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e.getMessage() + ": HTTP requires US-ASCII encoding");
        }
    }

    public Connection(WebServer pWebServer, XmlRpcStreamServer pServer, Socket pSocket) throws IOException {
        this.webServer = pWebServer;
        this.server = pServer;
        this.socket = pSocket;
        this.socket.setSoTimeout(30000);
        this.input = new BufferedInputStream(this.socket.getInputStream()){

            public void close() throws IOException {
            }
        };
        this.output = new BufferedOutputStream(this.socket.getOutputStream());
    }

    private RequestData getRequestConfig() throws IOException {
        RequestData result = new RequestData(this);
        XmlRpcHttpServerConfig serverConfig = (XmlRpcHttpServerConfig)this.server.getConfig();
        result.setBasicEncoding(serverConfig.getBasicEncoding());
        result.setContentLengthOptional(serverConfig.isContentLengthOptional());
        result.setEnabledForExtensions(serverConfig.isEnabledForExtensions());
        String line = this.readLine();
        if (line != null && line.length() == 0 && ((line = this.readLine()) == null || line.length() == 0)) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(line);
        String method = tokens.nextToken();
        if (!"POST".equalsIgnoreCase(method)) {
            throw new BadRequestException(method);
        }
        result.setMethod(method);
        tokens.nextToken();
        String httpVersion = tokens.nextToken();
        result.setHttpVersion(httpVersion);
        result.setKeepAlive(serverConfig.isKeepAliveEnabled() && "HTTP/1.1".equals(httpVersion));
        do {
            if ((line = this.readLine()) == null) continue;
            String lineLower = line.toLowerCase();
            if (lineLower.startsWith("content-length:")) {
                String cLength = line.substring("content-length:".length());
                result.setContentLength(Integer.parseInt(cLength.trim()));
                continue;
            }
            if (lineLower.startsWith("connection:")) {
                result.setKeepAlive(serverConfig.isKeepAliveEnabled() && lineLower.indexOf("keep-alive") > -1);
                continue;
            }
            if (!lineLower.startsWith("authorization:")) continue;
            String credentials = line.substring("authorization:".length());
            HttpUtil.parseAuthorization(result, credentials);
        } while (line != null && line.length() != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            RequestData data;
            int i = 0;
            while ((data = this.getRequestConfig()) != null) {
                this.server.execute(data, this);
                this.output.flush();
                if (!data.isKeepAlive()) break;
                if (!data.isSuccess()) {
                    break;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            this.webServer.log(t);
        }
        finally {
            try {
                this.socket.close();
            }
            catch (Throwable ignore) {}
        }
    }

    private String readLine() throws IOException {
        int next;
        if (this.buffer == null) {
            this.buffer = new byte[2048];
        }
        int count = 0;
        while ((next = this.input.read()) >= 0 && next != 10) {
            if (next != 13) {
                this.buffer[count++] = (byte)next;
            }
            if (count < this.buffer.length) continue;
            throw new IOException("HTTP Header too long");
        }
        return new String(this.buffer, 0, count, US_ASCII);
    }

    public InputStream getInputStream(RequestData pData) {
        int contentLength = pData.getContentLength();
        if (contentLength == -1) {
            return this.input;
        }
        return new LimitedInputStream(this.input, contentLength);
    }

    public OutputStream getOutputStream(XmlRpcStreamRequestConfig pConfig) {
        boolean useContentLength = pConfig instanceof XmlRpcHttpRequestConfig ? !pConfig.isEnabledForExtensions() || !((XmlRpcHttpRequestConfig)pConfig).isContentLengthOptional() : true;
        if (useContentLength) {
            return new ByteArrayOutputStream();
        }
        return this.output;
    }

    public void writeResponse(RequestData pData, OutputStream pBuffer) throws IOException {
        ByteArrayOutputStream response = (ByteArrayOutputStream)pBuffer;
        this.writeResponseHeader(pData, response.size());
        response.writeTo(this.output);
    }

    public void writeResponseHeader(RequestData pData, int pContentLength) throws IOException {
        this.output.write(Connection.toHTTPBytes(pData.getHttpVersion()));
        this.output.write(ok);
        this.output.write(serverName);
        this.output.write(pData.isKeepAlive() ? conkeep : conclose);
        this.output.write(ctype);
        if (pContentLength != -1) {
            this.output.write(clength);
            this.output.write(Connection.toHTTPBytes(Integer.toString(pContentLength)));
            this.output.write(doubleNewline);
        } else {
            this.output.write(newline);
        }
        pData.setSuccess(true);
    }

    public void writeError(RequestData pData, Throwable pError, OutputStream pStream) throws IOException {
        ByteArrayOutputStream errorResponse = (ByteArrayOutputStream)pStream;
        this.writeErrorHeader(pData, pError, errorResponse.size());
        errorResponse.writeTo(this.output);
    }

    public void writeErrorHeader(RequestData pData, Throwable pError, int pContentLength) throws IOException {
        if (pError instanceof BadRequestException) {
            this.output.write(Connection.toHTTPBytes(pData.getHttpVersion()));
            this.output.write(Connection.toHTTPBytes(" 400 Bad Request"));
            this.output.write(newline);
            this.output.write(serverName);
            this.output.write(doubleNewline);
            this.output.write(Connection.toHTTPBytes("Method " + pData.getMethod() + " not implemented (try POST)"));
        } else if (pError instanceof XmlRpcNotAuthorizedException) {
            this.output.write(Connection.toHTTPBytes(pData.getHttpVersion()));
            this.output.write(Connection.toHTTPBytes(" 401 Unauthorized"));
            this.output.write(newline);
            this.output.write(serverName);
            this.output.write(wwwAuthenticate);
            this.output.write(doubleNewline);
            this.output.write(Connection.toHTTPBytes("Method " + pData.getMethod() + " requires a " + "valid user name and password"));
        } else {
            this.output.write(Connection.toHTTPBytes(pData.getHttpVersion()));
            this.output.write(ok);
            this.output.write(serverName);
            this.output.write(conclose);
            this.output.write(ctype);
            if (pContentLength != -1) {
                this.output.write(clength);
                this.output.write(Connection.toHTTPBytes(Integer.toString(pContentLength)));
            }
            this.output.write(doubleNewline);
        }
    }

    private static class BadRequestException
    extends IOException {
        private static final long serialVersionUID = 3257848779234554934L;

        BadRequestException(String pMethod) {
            super(pMethod);
        }
    }
}

