/*
 * Decompiled with CFR 0.152.
 */
package dart;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class DartClient {
    static Logger logger = Logger.getLogger(class$dart$DartClient == null ? (class$dart$DartClient = DartClient.class$("dart.DartClient")) : class$dart$DartClient);
    static /* synthetic */ Class class$dart$DartClient;

    public static void main(String[] args) {
        String o;
        XmlRpcClient admin;
        XmlRpcClientConfigImpl config;
        BasicConfigurator.configure();
        logger.info("Starting DartClient");
        PosixParser parser = new PosixParser();
        Options options = new Options();
        CommandLine cmd = null;
        int port = 8081;
        boolean printHelp = false;
        options.addOption("p", "port", true, "XML-RPC Port to connect to, 8081 is default");
        options.addOption("s", "server", true, "Server to connect to, localhost is default");
        options.addOption("h", "help", false, "Print help message");
        options.addOption("q", "shutdown", false, "Shutdown the Server");
        options.addOption("r", "refresh", false, "Refresh Project resources");
        options.addOption("R", "refreshServer", false, "Refresh Server resources");
        options.addOption("g", "getstatus", false, "Get Server status");
        options.addOption("z", "schedulerstatus", false, "Get Scheduler status");
        options.addOption("d", "date", false, "Print the current date and exit");
        options.addOption("w", "password", true, "ProjectAdministrator password");
        options.addOption("u", "username", true, "ProjectAdministrator username");
        options.addOption("l", "sql", true, "SQL Commands to run on server");
        try {
            cmd = parser.parse(options, args);
        }
        catch (Exception e) {
            logger.error("Failed to parse commandline", e);
            printHelp = true;
        }
        String[] files = cmd.getArgs();
        if (cmd.hasOption("h") || printHelp || files.length < 1) {
            new HelpFormatter().printHelp("DartClient [options] Project <foo1.xml> <foo2.xml> ... <fooN.xml>\n\tTo use a proxy, specify -DproxyHost=host -DproxyPort=8080 on the commandline", options);
            System.exit(0);
        }
        try {
            port = Integer.parseInt(cmd.getOptionValue("p", "8081"));
        }
        catch (Exception e) {
            logger.error(cmd.getOptionValue("p", "8081") + " is not a valid port number");
            System.exit(1);
        }
        String project = files[0];
        XmlRpcClient client = null;
        try {
            config = new XmlRpcClientConfigImpl();
            config.setServerURL(new URL("http://" + cmd.getOptionValue("s", "localhost") + ":" + port + "/" + project + "/Command/"));
            client = new XmlRpcClient();
            client.setConfig(config);
        }
        catch (Exception e) {
            logger.error("Failed to create XmlRpcClient", e);
            System.exit(1);
        }
        if (cmd.hasOption("q")) {
            try {
                config = new XmlRpcClientConfigImpl();
                config.setServerURL(new URL("http://" + cmd.getOptionValue("s", "localhost") + ":" + port + "/DartServer/Command/"));
                admin = new XmlRpcClient();
                admin.setConfig(config);
                Vector<String> aa = new Vector<String>();
                aa.addElement("Foo");
                aa.addElement("bar");
                admin.execute("Administration.shutdown", aa);
            }
            catch (Exception e) {
                logger.error("Failed to shutdown project", e);
                System.exit(1);
            }
        }
        if (cmd.hasOption("r")) {
            try {
                client.execute("Submit.refresh", new Vector());
                System.exit(0);
            }
            catch (Exception e) {
                logger.error("Failed to refresh project", e);
                System.exit(1);
            }
        }
        if (cmd.hasOption("R")) {
            try {
                config = new XmlRpcClientConfigImpl();
                config.setServerURL(new URL("http://" + cmd.getOptionValue("s", "localhost") + ":" + port + "/DartServer/Command/"));
                admin = new XmlRpcClient();
                admin.setConfig(config);
                admin.execute("Administration.refresh", new Vector());
                System.exit(0);
            }
            catch (Exception e) {
                logger.error("Failed to refresh server", e);
                System.exit(1);
            }
        }
        if (cmd.hasOption("l")) {
            Vector<String> params = new Vector<String>();
            params.addElement(cmd.getOptionValue("u", ""));
            params.addElement(cmd.getOptionValue("w", ""));
            File SQL = new File(cmd.getOptionValue("l", ""));
            if (!SQL.exists()) {
                logger.error("File: " + SQL.toString() + " does not exist");
                System.exit(1);
            }
            try {
                BufferedReader in = new BufferedReader(new FileReader(SQL));
                StringWriter out = new StringWriter();
                char[] Data = new char[3000];
                while (true) {
                    int bytesRead = 0;
                    bytesRead = in.read(Data);
                    if (bytesRead == -1) break;
                    out.write(Data, 0, bytesRead);
                }
                params.addElement(out.toString());
                client.execute("ProjectAdministration.runSQL", params);
                System.exit(0);
            }
            catch (Exception adminEx) {
                logger.error("Failed to execute runSQL command", adminEx);
                System.exit(1);
            }
        }
        if (cmd.hasOption("g")) {
            try {
                config = new XmlRpcClientConfigImpl();
                config.setServerURL(new URL("http://" + cmd.getOptionValue("s", "localhost") + ":" + port + "/DartServer/Command/"));
                admin = new XmlRpcClient();
                admin.setConfig(config);
                o = (String)admin.execute("Administration.getStatus", new Vector());
                logger.info("Status: " + o);
                System.exit(0);
            }
            catch (Exception e) {
                logger.error("Failed to get project status", e);
                System.exit(1);
            }
        }
        if (cmd.hasOption("z")) {
            try {
                config = new XmlRpcClientConfigImpl();
                config.setServerURL(new URL("http://" + cmd.getOptionValue("s", "localhost") + ":" + port + "/DartServer/Command/"));
                admin = new XmlRpcClient();
                admin.setConfig(config);
                o = (String)admin.execute("Administration.getSchedulerStatus", new Vector());
                logger.info("Status: " + o);
                System.exit(0);
            }
            catch (Exception e) {
                logger.error("Failed to get project status", e);
                System.exit(1);
            }
        }
        for (int i = 1; i < files.length; ++i) {
            try {
                byte[] Data = new byte[32000];
                File inputfile = new File(files[i]);
                logger.info(inputfile + " Length: " + inputfile.length());
                if (inputfile.length() <= 4L) {
                    logger.info(inputfile.toString() + " short file, skipping");
                    continue;
                }
                if (inputfile.length() > 0xA00000L) {
                    long l = (long)((double)inputfile.length() / 1048576.0);
                    logger.warn("Skipping " + inputfile.toString() + " Length: " + l + "M");
                    continue;
                }
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputfile));
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                FilterOutputStream out = null;
                out = inputfile.getName().endsWith(".gz") ? new BufferedOutputStream(bytes) : new GZIPOutputStream(bytes);
                while (true) {
                    int bytesRead = 0;
                    bytesRead = ((InputStream)in).read(Data);
                    if (bytesRead == -1) break;
                    ((OutputStream)out).write(Data, 0, bytesRead);
                }
                if (out instanceof GZIPOutputStream) {
                    ((GZIPOutputStream)out).finish();
                }
                ((OutputStream)out).flush();
                if (bytes.toByteArray().length == 0) {
                    logger.error("bytes is zero length");
                }
                Vector<byte[]> params = new Vector<byte[]>();
                params.addElement(bytes.toByteArray());
                client.execute("Submit.put", params);
                ((InputStream)in).close();
                continue;
            }
            catch (Exception e) {
                logger.error("Failed to call Dart with file: " + files[i], e);
                System.exit(1);
            }
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

