/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.enum.Style;
import org.apache.axis.enum.Use;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.EnvelopeHandler;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.RPCHandler;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.toJava.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RPCElement
extends SOAPBodyElement {
    protected Vector params = new Vector();
    protected boolean needDeser = false;
    OperationDesc[] operations = null;

    public RPCElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context, OperationDesc[] operations) throws AxisFault {
        super(namespace, localName, prefix, attributes, context);
        SOAPService service;
        this.needDeser = true;
        MessageContext msgContext = context.getMessageContext();
        if (operations == null && msgContext != null && (service = msgContext.getService()) != null) {
            ServiceDesc serviceDesc = service.getInitializedServiceDesc(msgContext);
            String lc = Utils.xmlNameToJava(this.name);
            if (serviceDesc == null) {
                AxisFault.makeFault(new ClassNotFoundException(Messages.getMessage("noClassForService00", lc)));
            }
            operations = serviceDesc.getOperationsByName(lc);
        }
        this.operations = operations;
    }

    public RPCElement(String namespace, String methodName, Object[] args) {
        this.setNamespaceURI(namespace);
        this.name = methodName;
        int i = 0;
        while (args != null && i < args.length) {
            if (args[i] instanceof RPCParam) {
                this.addParam((RPCParam)args[i]);
            } else {
                String name = null;
                if (name == null) {
                    name = "arg" + i;
                }
                this.addParam(new RPCParam(namespace, name, args[i]));
            }
            ++i;
        }
    }

    public RPCElement(String methodName) {
        this.name = methodName;
    }

    public String getMethodName() {
        return this.name;
    }

    public void setNeedDeser(boolean needDeser) {
        this.needDeser = needDeser;
    }

    public void deserialize() throws SAXException {
        this.needDeser = false;
        MessageContext msgContext = this.context.getMessageContext();
        Message msg = msgContext.getCurrentMessage();
        SOAPConstants soapConstants = msgContext.getSOAPConstants();
        boolean isResponse = msg != null && "response".equals(msg.getMessageType());
        RPCHandler rpcHandler = new RPCHandler(this, isResponse);
        if (this.operations != null) {
            int numParams = this.getChildren() == null ? 0 : this.getChildren().size();
            SAXException savedException = null;
            boolean acceptMissingParams = msgContext.isPropertyTrue("acceptMissingParams", true);
            int i = 0;
            while (i < this.operations.length) {
                block19: {
                    OperationDesc operation = this.operations[i];
                    boolean needHeaderProcessing = this.needHeaderProcessing(operation, isResponse);
                    if (operation.getStyle() == Style.DOCUMENT || operation.getStyle() == Style.WRAPPED || operation.getUse() == Use.LITERAL || (acceptMissingParams ? operation.getNumInParams() >= numParams : operation.getNumInParams() == numParams)) {
                        boolean isEncoded = operation.getUse() == Use.ENCODED;
                        rpcHandler.setOperation(operation);
                        try {
                            if (operation.getStyle() == Style.DOCUMENT && operation.getNumInParams() > 0) {
                                this.context.pushElementHandler(rpcHandler);
                                this.context.setCurElement(null);
                            } else {
                                this.context.pushElementHandler(new EnvelopeHandler(rpcHandler));
                                this.context.setCurElement(this);
                            }
                            this.publishToHandler((ContentHandler)((Object)this.context));
                            if (needHeaderProcessing) {
                                this.processHeaders(operation, isResponse, this.context, rpcHandler);
                            }
                            boolean match = true;
                            int j = 0;
                            while (j < this.params.size() && match) {
                                Class sigType;
                                RPCParam rpcParam = (RPCParam)this.params.get(j);
                                Object value = rpcParam.getValue();
                                ParameterDesc paramDesc = rpcParam.getParamDesc();
                                if (paramDesc != null && paramDesc.getJavaType() != null && !JavaUtils.isConvertable(value, sigType = paramDesc.getJavaType(), isEncoded)) {
                                    match = false;
                                }
                                ++j;
                            }
                            if (!match) {
                                this.params = new Vector();
                                break block19;
                            }
                            msgContext.setOperation(operation);
                            return;
                        }
                        catch (SAXException e) {
                            savedException = e;
                            this.params = new Vector();
                        }
                        catch (AxisFault e) {
                            savedException = new SAXException(e);
                            this.params = new Vector();
                        }
                    }
                }
                ++i;
            }
            if (!msgContext.isClient() && soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                AxisFault fault = new AxisFault(Constants.FAULT_SOAP12_SENDER, "string", null, null);
                fault.addFaultSubCode(Constants.FAULT_SUBCODE_BADARGS);
                throw new SAXException(fault);
            }
            if (savedException != null) {
                throw savedException;
            }
            if (!msgContext.isClient()) {
                QName faultCode = new QName("Server.userException");
                if (soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    faultCode = Constants.FAULT_SOAP12_SENDER;
                }
                AxisFault fault = new AxisFault(faultCode, null, Messages.getMessage("noSuchOperation", this.name), null, null, null);
                throw new SAXException(fault);
            }
        }
        if (this.operations != null) {
            rpcHandler.setOperation(this.operations[0]);
        }
        if (this.operations != null && this.operations.length > 0 && this.operations[0].getStyle() == Style.DOCUMENT) {
            this.context.pushElementHandler(rpcHandler);
            this.context.setCurElement(null);
        } else {
            this.context.pushElementHandler(new EnvelopeHandler(rpcHandler));
            this.context.setCurElement(this);
        }
        this.publishToHandler((ContentHandler)((Object)this.context));
    }

    public RPCParam getParam(String name) throws SAXException {
        if (this.needDeser) {
            this.deserialize();
        }
        int i = 0;
        while (i < this.params.size()) {
            RPCParam param = (RPCParam)this.params.elementAt(i);
            if (param.getName().equals(name)) {
                return param;
            }
            ++i;
        }
        return null;
    }

    public Vector getParams() throws SAXException {
        if (this.needDeser) {
            this.deserialize();
        }
        return this.params;
    }

    public void addParam(RPCParam param) {
        param.setRPCCall(this);
        this.params.addElement(param);
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        boolean noParams;
        MessageContext msgContext = context.getMessageContext();
        boolean hasOperationElement = msgContext == null || msgContext.getOperationStyle() == Style.RPC || msgContext.getOperationStyle() == Style.WRAPPED;
        boolean bl = noParams = this.params.size() == 0;
        if (hasOperationElement || noParams) {
            if (this.encodingStyle != null && this.encodingStyle.equals("")) {
                context.registerPrefixForURI("", this.getNamespaceURI());
            }
            context.startElement(new QName(this.getNamespaceURI(), this.name), this.attributes);
        }
        int i = 0;
        while (i < this.params.size()) {
            RPCParam param = (RPCParam)this.params.elementAt(i);
            if (!hasOperationElement && this.encodingStyle != null && this.encodingStyle.equals("")) {
                context.registerPrefixForURI("", param.getQName().getNamespaceURI());
            }
            param.serialize(context);
            ++i;
        }
        if (hasOperationElement || noParams) {
            context.endElement();
        }
    }

    private boolean needHeaderProcessing(OperationDesc operation, boolean isResponse) {
        ArrayList paramDescs = operation.getParameters();
        if (paramDescs != null) {
            int j = 0;
            while (j < paramDescs.size()) {
                ParameterDesc paramDesc = (ParameterDesc)paramDescs.get(j);
                if (!isResponse && paramDesc.isInHeader() || isResponse && paramDesc.isOutHeader()) {
                    return true;
                }
                ++j;
            }
        }
        return isResponse && operation.getReturnParamDesc() != null && operation.getReturnParamDesc().isOutHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processHeaders(OperationDesc operation, boolean isResponse, DeserializationContext context, RPCHandler handler) throws AxisFault, SAXException {
        block10: {
            try {
                handler.setHeaderElement(true);
                SOAPElement envelope = this.getParentElement();
                while (true) {
                    if (envelope == null || envelope instanceof SOAPEnvelope) {
                        if (envelope != null) break;
                        Object var11_6 = null;
                        handler.setHeaderElement(false);
                        return;
                    }
                    envelope = envelope.getParentElement();
                }
                ArrayList paramDescs = operation.getParameters();
                if (paramDescs != null) {
                    int j = 0;
                    while (j < paramDescs.size()) {
                        ParameterDesc paramDesc = (ParameterDesc)paramDescs.get(j);
                        if (!isResponse && paramDesc.isInHeader() || isResponse && paramDesc.isOutHeader()) {
                            Enumeration headers = ((SOAPEnvelope)envelope).getHeadersByName(paramDesc.getQName().getNamespaceURI(), paramDesc.getQName().getLocalPart(), true);
                            while (headers != null && headers.hasMoreElements()) {
                                context.pushElementHandler(handler);
                                context.setCurElement(null);
                                ((MessageElement)headers.nextElement()).publishToHandler((ContentHandler)((Object)context));
                            }
                        }
                        ++j;
                    }
                }
                if (!isResponse || operation.getReturnParamDesc() == null || !operation.getReturnParamDesc().isOutHeader()) break block10;
                ParameterDesc paramDesc = operation.getReturnParamDesc();
                Enumeration headers = ((SOAPEnvelope)envelope).getHeadersByName(paramDesc.getQName().getNamespaceURI(), paramDesc.getQName().getLocalPart(), true);
                while (headers != null) {
                    if (!headers.hasMoreElements()) {
                        break;
                    }
                    context.pushElementHandler(handler);
                    context.setCurElement(null);
                    ((MessageElement)headers.nextElement()).publishToHandler((ContentHandler)((Object)context));
                }
            }
            catch (Throwable throwable) {
                Object var11_8 = null;
                handler.setHeaderElement(false);
                throw throwable;
            }
        }
        Object var11_7 = null;
        handler.setHeaderElement(false);
    }
}

