/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.apache.axis.enum.Scope;
import org.apache.axis.enum.Style;
import org.apache.axis.enum.Use;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionTE;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.FaultInfo;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaDeployWriter
extends JavaWriter {
    protected Definition definition;
    protected SymbolTable symbolTable;

    public JavaDeployWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, "deploy");
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    public void generate() throws IOException {
        if (this.emitter.isServerSide()) {
            super.generate();
        }
    }

    protected String getFileName() {
        String dir = this.emitter.getNamespaces().getAsDir(this.definition.getTargetNamespace());
        return dir + "deploy.wsdd";
    }

    protected void writeFileHeader(PrintWriter pw) throws IOException {
        pw.println(Messages.getMessage("deploy00"));
        pw.println(Messages.getMessage("deploy02"));
        pw.println(Messages.getMessage("deploy03"));
        pw.println(Messages.getMessage("deploy05"));
        pw.println(Messages.getMessage("deploy06"));
        pw.println(Messages.getMessage("deploy07"));
        pw.println(Messages.getMessage("deploy09"));
        pw.println();
        pw.println("<deployment");
        pw.println("    xmlns=\"http://xml.apache.org/axis/wsdd/\"");
        pw.println("    xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\">");
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        this.writeDeployServices(pw);
        pw.println("</deployment>");
    }

    protected void writeDeployServices(PrintWriter pw) throws IOException {
        Map serviceMap = this.definition.getServices();
        Iterator mapIterator = serviceMap.values().iterator();
        while (mapIterator.hasNext()) {
            Service myService = (Service)mapIterator.next();
            pw.println();
            pw.println("  <!-- " + Messages.getMessage("wsdlService00", myService.getQName().getLocalPart()) + " -->");
            pw.println();
            Iterator portIterator = myService.getPorts().values().iterator();
            while (portIterator.hasNext()) {
                Port myPort = (Port)portIterator.next();
                BindingEntry bEntry = this.symbolTable.getBindingEntry(myPort.getBinding().getQName());
                if (bEntry.getBindingType() != 0) continue;
                this.writeDeployPort(pw, myPort, myService, bEntry);
            }
        }
    }

    protected void writeDeployTypes(PrintWriter pw, Binding binding, boolean hasLiteral, boolean hasMIME, Use use) throws IOException {
        Vector types = this.symbolTable.getTypes();
        pw.println();
        if (hasMIME) {
            QName bQName = binding.getQName();
            this.writeTypeMapping(pw, bQName.getNamespaceURI(), "DataHandler", "javax.activation.DataHandler", "org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory", "org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory", use.getEncoding());
        }
        int i = 0;
        while (i < types.size()) {
            TypeEntry type = (TypeEntry)types.elementAt(i);
            boolean process = true;
            if (type.getBaseType() != null && type.getRefType() == null || type instanceof CollectionTE || type instanceof Element || !type.isReferenced() || type.isOnlyLiteralReferenced()) {
                process = false;
            }
            if (process) {
                String deserializerFactory;
                String serializerFactory;
                String namespaceURI = type.getQName().getNamespaceURI();
                String localPart = type.getQName().getLocalPart();
                String javaType = type.getName();
                String encodingStyle = "";
                if (!hasLiteral) {
                    encodingStyle = use.getEncoding();
                }
                if (javaType.endsWith("[]")) {
                    serializerFactory = "org.apache.axis.encoding.ser.ArraySerializerFactory";
                    deserializerFactory = "org.apache.axis.encoding.ser.ArrayDeserializerFactory";
                } else if (type.getNode() != null && Utils.getEnumerationBaseAndValues(type.getNode(), this.symbolTable) != null) {
                    serializerFactory = "org.apache.axis.encoding.ser.EnumSerializerFactory";
                    deserializerFactory = "org.apache.axis.encoding.ser.EnumDeserializerFactory";
                } else if (type.isSimpleType()) {
                    serializerFactory = "org.apache.axis.encoding.ser.SimpleSerializerFactory";
                    deserializerFactory = "org.apache.axis.encoding.ser.SimpleDeserializerFactory";
                } else if (type.getBaseType() != null) {
                    serializerFactory = "org.apache.axis.encoding.ser.SimpleSerializerFactory";
                    deserializerFactory = "org.apache.axis.encoding.ser.SimpleDeserializerFactory";
                } else {
                    serializerFactory = "org.apache.axis.encoding.ser.BeanSerializerFactory";
                    deserializerFactory = "org.apache.axis.encoding.ser.BeanDeserializerFactory";
                }
                this.writeTypeMapping(pw, namespaceURI, localPart, javaType, serializerFactory, deserializerFactory, encodingStyle);
            }
            ++i;
        }
    }

    protected void writeTypeMapping(PrintWriter pw, String namespaceURI, String localPart, String javaType, String serializerFactory, String deserializerFactory, String encodingStyle) throws IOException {
        pw.println("      <typeMapping");
        pw.println("        xmlns:ns=\"" + namespaceURI + "\"");
        pw.println("        qname=\"ns:" + localPart + '\"');
        pw.println("        type=\"java:" + javaType + '\"');
        pw.println("        serializer=\"" + serializerFactory + "\"");
        pw.println("        deserializer=\"" + deserializerFactory + "\"");
        pw.println("        encodingStyle=\"" + encodingStyle + "\"");
        pw.println("      />");
    }

    protected void writeDeployPort(PrintWriter pw, Port port, Service service, BindingEntry bEntry) throws IOException {
        String serviceName = port.getName();
        boolean hasLiteral = bEntry.hasLiteral();
        boolean hasMIME = Utils.hasMIME(bEntry);
        String prefix = "java";
        String styleStr = "";
        Use use = Use.DEFAULT;
        Iterator iterator = bEntry.getBinding().getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            UnknownExtensibilityElement unkElement;
            QName name;
            Object obj = iterator.next();
            if (obj instanceof SOAPBinding) {
                use = Use.ENCODED;
                continue;
            }
            if (!(obj instanceof UnknownExtensibilityElement) || !(name = (unkElement = (UnknownExtensibilityElement)obj).getElementType()).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !name.getLocalPart().equals("binding")) continue;
            use = Use.ENCODED;
        }
        if (this.symbolTable.isWrapped()) {
            styleStr = " style=\"" + Style.WRAPPED + "\"";
            use = Use.LITERAL;
        } else {
            styleStr = " style=\"" + bEntry.getBindingStyle().getName() + "\"";
            if (hasLiteral) {
                use = Use.LITERAL;
            }
        }
        String useStr = " use=\"" + use + "\"";
        pw.println("  <service name=\"" + serviceName + "\" provider=\"" + prefix + ":RPC" + "\"" + styleStr + useStr + ">");
        pw.println("      <parameter name=\"wsdlTargetNamespace\" value=\"" + service.getQName().getNamespaceURI() + "\"/>");
        pw.println("      <parameter name=\"wsdlServiceElement\" value=\"" + service.getQName().getLocalPart() + "\"/>");
        pw.println("      <parameter name=\"wsdlServicePort\" value=\"" + serviceName + "\"/>");
        if (hasMIME) {
            pw.println("      <parameter name=\"sendMultiRefs\" value=\"false\"/>");
        }
        this.writeDeployBinding(pw, bEntry);
        this.writeDeployTypes(pw, bEntry.getBinding(), hasLiteral, hasMIME, use);
        pw.println("  </service>");
    }

    protected void writeDeployBinding(PrintWriter pw, BindingEntry bEntry) throws IOException {
        Binding binding = bEntry.getBinding();
        String className = bEntry.getName();
        className = this.emitter.isSkeletonWanted() ? className + "Skeleton" : className + "Impl";
        pw.println("      <parameter name=\"className\" value=\"" + className + "\"/>");
        pw.println("      <parameter name=\"wsdlPortType\" value=\"" + binding.getPortType().getQName().getLocalPart() + "\"/>");
        HashSet<String> allowedMethods = new HashSet<String>();
        if (!this.emitter.isSkeletonWanted()) {
            Iterator operationsIterator = binding.getBindingOperations().iterator();
            while (operationsIterator.hasNext()) {
                BindingOperation bindingOper = (BindingOperation)operationsIterator.next();
                Operation operation = bindingOper.getOperation();
                OperationType type = operation.getStyle();
                String javaOperName = JavaUtils.xmlNameToJava(operation.getName());
                if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) continue;
                allowedMethods.add(javaOperName);
                Parameters params = this.symbolTable.getOperationParameters(operation, "", bEntry);
                if (params == null) continue;
                QName elementQName = Utils.getOperationQName(bindingOper, bEntry, this.symbolTable);
                QName returnQName = null;
                QName returnType = null;
                if (params.returnParam != null) {
                    returnQName = params.returnParam.getQName();
                    returnType = Utils.getXSIType(params.returnParam);
                }
                HashMap faultMap = bEntry.getFaults();
                ArrayList faults = null;
                if (faultMap != null) {
                    faults = (ArrayList)faultMap.get(bindingOper);
                }
                this.writeOperation(pw, javaOperName, elementQName, returnQName, returnType, params, binding.getQName(), faults);
            }
        }
        pw.print("      <parameter name=\"allowedMethods\" value=\"");
        if (allowedMethods.isEmpty()) {
            pw.println("*\"/>");
        } else {
            boolean first = true;
            Iterator i = allowedMethods.iterator();
            while (i.hasNext()) {
                String method = (String)i.next();
                if (first) {
                    pw.print(method);
                    first = false;
                    continue;
                }
                pw.print(" " + method);
            }
            pw.println("\"/>");
        }
        Scope scope = this.emitter.getScope();
        if (scope != null) {
            pw.println("      <parameter name=\"scope\" value=\"" + scope.getName() + "\"/>");
        }
    }

    protected void writeOperation(PrintWriter pw, String javaOperName, QName elementQName, QName returnQName, QName returnType, Parameters params, QName bindingQName, ArrayList faults) {
        pw.print("      <operation name=\"" + javaOperName + "\"");
        if (elementQName != null) {
            pw.print(" qname=\"" + Utils.genQNameAttributeString(elementQName, "operNS") + "\"");
        }
        if (returnQName != null) {
            pw.print(" returnQName=\"" + Utils.genQNameAttributeString(returnQName, "retNS") + "\"");
        }
        if (returnType != null) {
            pw.print(" returnType=\"" + Utils.genQNameAttributeString(returnType, "rtns") + "\"");
        }
        if (params.returnParam != null && params.returnParam.isOutHeader()) {
            pw.print(" returnHeader=\"true\"");
        }
        pw.println(" >");
        Vector paramList = params.list;
        int i = 0;
        while (i < paramList.size()) {
            Parameter param = (Parameter)paramList.elementAt(i);
            QName paramQName = param.getQName();
            QName paramType = Utils.getXSIType(param);
            pw.print("        <parameter");
            if (paramQName == null || "".equals(paramQName.getNamespaceURI())) {
                pw.print(" name=\"" + param.getName() + "\"");
            } else {
                pw.print(" qname=\"" + Utils.genQNameAttributeString(paramQName, "pns") + "\"");
            }
            pw.print(" type=\"" + Utils.genQNameAttributeString(paramType, "tns") + "\"");
            if (param.getMode() != 1) {
                pw.print(" mode=\"" + this.getModeString(param.getMode()) + "\"");
            }
            if (param.isInHeader()) {
                pw.print(" inHeader=\"true\"");
            }
            if (param.isOutHeader()) {
                pw.print(" outHeader=\"true\"");
            }
            pw.println("/>");
            ++i;
        }
        if (faults != null) {
            Iterator iterator = faults.iterator();
            while (iterator.hasNext()) {
                FaultInfo faultInfo = (FaultInfo)iterator.next();
                QName faultQName = faultInfo.getQName();
                if (faultQName == null) continue;
                String className = Utils.getFullExceptionName(faultInfo.getMessage(), this.symbolTable);
                pw.print("        <fault");
                pw.print(" name=\"" + faultInfo.getName() + "\"");
                pw.print(" qname=\"" + Utils.genQNameAttributeString(faultQName, "fns") + "\"");
                pw.print(" class=\"" + className + "\"");
                pw.print(" type=\"" + Utils.genQNameAttributeString(faultInfo.getXMLType(), "tns") + "\"");
                pw.println("/>");
            }
        }
        pw.println("      </operation>");
    }

    public String getModeString(byte mode) {
        if (mode == 1) {
            return "IN";
        }
        if (mode == 3) {
            return "INOUT";
        }
        return "OUT";
    }

    protected PrintWriter getPrintWriter(String filename) throws IOException {
        File file = new File(filename);
        File parent = new File(file.getParent());
        parent.mkdirs();
        FileOutputStream out = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
        return new PrintWriter(writer);
    }
}

