/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.ResourceMap;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ResourceConverter {
    protected final Class type;
    private static ResourceConverter[] resourceConvertersArray = new ResourceConverter[]{new BooleanResourceConverter("true", "on", "yes"), new IntegerResourceConverter(), new MessageFormatResourceConverter(), new FloatResourceConverter(), new DoubleResourceConverter(), new LongResourceConverter(), new ShortResourceConverter(), new ByteResourceConverter(), new URLResourceConverter(), new URIResourceConverter()};
    private static List<ResourceConverter> resourceConverters = new ArrayList<ResourceConverter>(Arrays.asList(resourceConvertersArray));

    public abstract Object parseString(String var1, ResourceMap var2) throws ResourceConverterException;

    public String toString(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    protected ResourceConverter(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        this.type = type;
    }

    private ResourceConverter() {
        this.type = null;
    }

    public boolean supportsType(Class testType) {
        return this.type.equals(testType);
    }

    public static void register(ResourceConverter resourceConverter) {
        if (resourceConverter == null) {
            throw new IllegalArgumentException("null resourceConverter");
        }
        resourceConverters.add(resourceConverter);
    }

    public static ResourceConverter forType(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        for (ResourceConverter sc : resourceConverters) {
            if (!sc.supportsType(type)) continue;
            return sc;
        }
        return null;
    }

    private static class BooleanResourceConverter
    extends ResourceConverter {
        private final String[] trueStrings;

        BooleanResourceConverter(String ... trueStrings) {
            super(Boolean.class);
            this.trueStrings = trueStrings;
        }

        public Object parseString(String s, ResourceMap ignore) {
            s = s.trim();
            for (String trueString : this.trueStrings) {
                if (!s.equalsIgnoreCase(trueString)) continue;
                return true;
            }
            return false;
        }

        public boolean supportsType(Class testType) {
            return testType.equals(Boolean.class) || testType.equals(Boolean.TYPE);
        }
    }

    private static class ByteResourceConverter
    extends NumberResourceConverter {
        ByteResourceConverter() {
            super(Byte.class, Byte.TYPE);
        }

        protected Number parseString(String s) throws NumberFormatException {
            return Byte.parseByte(s);
        }
    }

    private static class DoubleResourceConverter
    extends NumberResourceConverter {
        DoubleResourceConverter() {
            super(Double.class, Double.TYPE);
        }

        protected Number parseString(String s) throws NumberFormatException {
            return Double.parseDouble(s);
        }
    }

    private static class FloatResourceConverter
    extends NumberResourceConverter {
        FloatResourceConverter() {
            super(Float.class, Float.TYPE);
        }

        protected Number parseString(String s) throws NumberFormatException {
            return Float.valueOf(Float.parseFloat(s));
        }
    }

    private static class IntegerResourceConverter
    extends NumberResourceConverter {
        IntegerResourceConverter() {
            super(Integer.class, Integer.TYPE);
        }

        protected Number parseString(String s) throws NumberFormatException {
            return Integer.parseInt(s);
        }
    }

    private static class LongResourceConverter
    extends NumberResourceConverter {
        LongResourceConverter() {
            super(Long.class, Long.TYPE);
        }

        protected Number parseString(String s) throws NumberFormatException {
            return Long.parseLong(s);
        }
    }

    private static class MessageFormatResourceConverter
    extends ResourceConverter {
        MessageFormatResourceConverter() {
            super(MessageFormat.class);
        }

        public Object parseString(String s, ResourceMap ignore) {
            return new MessageFormat(s);
        }
    }

    private static abstract class NumberResourceConverter
    extends ResourceConverter {
        private final Class primitiveType;

        NumberResourceConverter(Class type, Class primitiveType) {
            super(type);
            this.primitiveType = primitiveType;
        }

        protected abstract Number parseString(String var1) throws NumberFormatException;

        public Object parseString(String s, ResourceMap ignore) throws ResourceConverterException {
            try {
                return this.parseString(s);
            }
            catch (NumberFormatException e) {
                throw new ResourceConverterException("invalid " + this.type.getSimpleName(), s, e);
            }
        }

        public boolean supportsType(Class testType) {
            return testType.equals(this.type) || testType.equals(this.primitiveType);
        }
    }

    public static class ResourceConverterException
    extends Exception {
        private final String badString;

        private String maybeShorten(String s) {
            int n = s.length();
            return n < 128 ? s : s.substring(0, 128) + "...[" + (n - 128) + " more characters]";
        }

        public ResourceConverterException(String message, String badString, Throwable cause) {
            super(message, cause);
            this.badString = this.maybeShorten(badString);
        }

        public ResourceConverterException(String message, String badString) {
            super(message);
            this.badString = this.maybeShorten(badString);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(super.toString());
            sb.append(" string: \"");
            sb.append(this.badString);
            sb.append("\"");
            return sb.toString();
        }
    }

    private static class ShortResourceConverter
    extends NumberResourceConverter {
        ShortResourceConverter() {
            super(Short.class, Short.TYPE);
        }

        protected Number parseString(String s) throws NumberFormatException {
            return Short.parseShort(s);
        }
    }

    private static class URIResourceConverter
    extends ResourceConverter {
        URIResourceConverter() {
            super(URI.class);
        }

        public Object parseString(String s, ResourceMap ignore) throws ResourceConverterException {
            try {
                return new URI(s);
            }
            catch (URISyntaxException e) {
                throw new ResourceConverterException("invalid URI", s, e);
            }
        }
    }

    private static class URLResourceConverter
    extends ResourceConverter {
        URLResourceConverter() {
            super(URL.class);
        }

        public Object parseString(String s, ResourceMap ignore) throws ResourceConverterException {
            try {
                return new URL(s);
            }
            catch (MalformedURLException e) {
                throw new ResourceConverterException("invalid URL", s, e);
            }
        }
    }
}

