/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.AbstractBean;
import application.Action;
import application.ApplicationActionMap;
import application.ApplicationContext;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

class TextActions
extends AbstractBean {
    private final ApplicationContext context;
    private final CaretListener textComponentCaretListener;
    private final PropertyChangeListener textComponentPCL;
    private final String markerActionKey = "TextActions.markerAction";
    private final javax.swing.Action markerAction;
    private boolean copyEnabled = false;
    private boolean cutEnabled = false;
    private boolean pasteEnabled = false;
    private boolean deleteEnabled = false;

    public TextActions(ApplicationContext context) {
        this.context = context;
        this.markerAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        this.textComponentCaretListener = new TextComponentCaretListener();
        this.textComponentPCL = new TextComponentPCL();
        this.getClipboard().addFlavorListener(new ClipboardListener());
    }

    private ApplicationContext getContext() {
        return this.context;
    }

    private JComponent getFocusOwner() {
        return this.getContext().getFocusOwner();
    }

    private Clipboard getClipboard() {
        return this.getContext().getClipboard();
    }

    void updateFocusOwner(JComponent oldOwner, JComponent newOwner) {
        JTextComponent text;
        if (oldOwner instanceof JTextComponent) {
            text = (JTextComponent)oldOwner;
            text.removeCaretListener(this.textComponentCaretListener);
            text.removePropertyChangeListener(this.textComponentPCL);
        }
        if (newOwner instanceof JTextComponent) {
            text = (JTextComponent)newOwner;
            this.maybeInstallTextActions(text);
            this.updateTextActions(text);
            text.addCaretListener(this.textComponentCaretListener);
            text.addPropertyChangeListener(this.textComponentPCL);
        } else if (newOwner == null) {
            this.setCopyEnabled(false);
            this.setCutEnabled(false);
            this.setPasteEnabled(false);
            this.setDeleteEnabled(false);
        }
    }

    private void updateTextActions(JTextComponent text) {
        Caret caret = text.getCaret();
        boolean selection = caret.getDot() != caret.getMark();
        boolean editable = text.isEditable();
        boolean data = this.getClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor);
        this.setCopyEnabled(selection);
        this.setCutEnabled(editable && selection);
        this.setDeleteEnabled(editable && selection);
        this.setPasteEnabled(editable && data);
    }

    private void maybeInstallTextActions(JTextComponent text) {
        ActionMap actionMap = text.getActionMap();
        if (actionMap.get("TextActions.markerAction") == null) {
            actionMap.put("TextActions.markerAction", this.markerAction);
            ApplicationActionMap textActions = this.getContext().getActionMap(this.getClass(), this);
            for (Object key : textActions.keys()) {
                actionMap.put(key, textActions.get(key));
            }
        }
    }

    private int getCurrentEventModifiers() {
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        return modifiers;
    }

    private void invokeTextAction(JTextComponent text, String actionName) {
        ActionMap actionMap = text.getActionMap().getParent();
        long eventTime = EventQueue.getMostRecentEventTime();
        int eventMods = this.getCurrentEventModifiers();
        ActionEvent actionEvent = new ActionEvent(text, 1001, actionName, eventTime, eventMods);
        actionMap.get(actionName).actionPerformed(actionEvent);
    }

    @Action(enabledProperty="cutEnabled")
    public void cut(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextComponent) {
            this.invokeTextAction((JTextComponent)src, "cut");
        }
    }

    public boolean isCutEnabled() {
        return this.cutEnabled;
    }

    public void setCutEnabled(boolean cutEnabled) {
        boolean oldValue = this.cutEnabled;
        this.cutEnabled = cutEnabled;
        this.firePropertyChange("cutEnabled", oldValue, this.cutEnabled);
    }

    @Action(enabledProperty="copyEnabled")
    public void copy(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextComponent) {
            this.invokeTextAction((JTextComponent)src, "copy");
        }
    }

    public boolean isCopyEnabled() {
        return this.copyEnabled;
    }

    public void setCopyEnabled(boolean copyEnabled) {
        boolean oldValue = this.copyEnabled;
        this.copyEnabled = copyEnabled;
        this.firePropertyChange("copyEnabled", oldValue, this.copyEnabled);
    }

    @Action(enabledProperty="pasteEnabled")
    public void paste(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextComponent) {
            this.invokeTextAction((JTextComponent)src, "paste");
        }
    }

    public boolean isPasteEnabled() {
        return this.pasteEnabled;
    }

    public void setPasteEnabled(boolean pasteEnabled) {
        boolean oldValue = this.pasteEnabled;
        this.pasteEnabled = pasteEnabled;
        this.firePropertyChange("pasteEnabled", oldValue, this.pasteEnabled);
    }

    @Action(enabledProperty="deleteEnabled")
    public void delete(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JTextComponent) {
            this.invokeTextAction((JTextComponent)src, "delete-next");
        }
    }

    public boolean isDeleteEnabled() {
        return this.deleteEnabled;
    }

    public void setDeleteEnabled(boolean deleteEnabled) {
        boolean oldValue = this.deleteEnabled;
        this.deleteEnabled = deleteEnabled;
        this.firePropertyChange("deleteEnabled", oldValue, this.deleteEnabled);
    }

    private final class ClipboardListener
    implements FlavorListener {
        private ClipboardListener() {
        }

        public void flavorsChanged(FlavorEvent e) {
            JComponent c = TextActions.this.getFocusOwner();
            if (c instanceof JTextComponent) {
                TextActions.this.updateTextActions((JTextComponent)c);
            }
        }
    }

    private final class TextComponentCaretListener
    implements CaretListener {
        private TextComponentCaretListener() {
        }

        public void caretUpdate(CaretEvent e) {
            TextActions.this.updateTextActions((JTextComponent)e.getSource());
        }
    }

    private final class TextComponentPCL
    implements PropertyChangeListener {
        private TextComponentPCL() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName == null || "editable".equals(propertyName)) {
                TextActions.this.updateTextActions((JTextComponent)e.getSource());
            }
        }
    }
}

