/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.gui.JargonTab;
import edu.sdsc.grid.gui.JargonTree;
import edu.sdsc.grid.gui.QueryPanel;
import edu.sdsc.grid.gui.QueryTab;
import edu.sdsc.grid.gui.TransferStatusPanel;
import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

class JargonGui
extends JFrame
implements ActionListener {
    private JTextField addresField;
    private GeneralFile selectedFile;
    private JTabbedPane tabPane;
    private JargonTab[] tabs;
    private JToolBar toolBar;
    static HashMap registerTabs = new HashMap();
    JComponent contentPane;
    JScrollPane mainPanel;
    JScrollPane sidePanel;
    private GridBagConstraints gridBagConstraints;
    private GeneralFileSystem[] fileSystems;
    JButton queryButton;
    JargonTree jargonTree;
    BrowseTab browseTab;
    QueryTab queryTab;
    String[] selectFieldNames = new String[]{"file comments", "size", "access constraint", "user name", "definable metadata for files"};
    MetaDataSelect[] selects = MetaDataSet.newSelection(this.selectFieldNames);
    static SRBAccount srbAccount;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        registerTabs.put("browseTab", JargonTree.class);
        registerTabs.put("transferTab", TransferStatusPanel.class);
        registerTabs.put("queryTab", QueryPanel.class);
        try {
            srbAccount = new SRBAccount();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public JargonGui() throws IOException {
        this((GeneralFile)null);
    }

    public JargonGui(String configFilePath) throws IOException {
        this(new LocalFile(configFilePath));
    }

    public JargonGui(GeneralFile configFile) throws IOException {
        if (configFile == null) {
            this.useTabs((GeneralFile)null);
        } else {
            this.useTabs(configFile);
        }
        this.init();
    }

    public JargonGui(JargonTab[] jargonTabs) throws IOException {
        if (jargonTabs == null) {
            this.useTabs((GeneralFile)null);
        } else {
            this.useTabs(jargonTabs);
        }
        this.init();
    }

    protected void finalize() throws Throwable {
        if (this.addresField != null) {
            this.addresField = null;
        }
        if (this.selectedFile != null) {
            this.selectedFile = null;
        }
        if (this.tabPane != null) {
            this.tabPane = null;
        }
        if (this.tabs != null) {
            this.tabs = null;
        }
        if (this.toolBar != null) {
            this.toolBar = null;
        }
        if (registerTabs != null) {
            registerTabs = null;
        }
        super.finalize();
    }

    private void init() throws IOException {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.gridBagConstraints = new GridBagConstraints();
        this.contentPane = (JComponent)this.getContentPane();
        Box toolBarBox = new Box(0);
        toolBarBox.add(Box.createGlue());
        this.toolBar = new JToolBar();
        ImageIcon buttonIcon = new ImageIcon("query.gif");
        this.queryButton = new JButton(buttonIcon);
        this.queryButton.setActionCommand("Query");
        this.queryButton.setToolTipText("Query");
        this.queryButton.setBackground(Color.WHITE);
        this.queryButton.setMargin(new Insets(0, 0, 0, 0));
        this.queryButton.addActionListener(this);
        this.toolBar.add(this.queryButton);
        toolBarBox.add((Component)this.toolBar, "West");
        this.gridBagConstraints.gridwidth = 0;
        JToolBar addressBar = new JToolBar();
        this.addresField = new JTextField(70);
        this.addresField.addActionListener(new ActionListener(){

            /*
             * Unable to fully structure code
             */
            public void actionPerformed(ActionEvent e) {
                block6: {
                    input = ((JTextField)e.getSource()).getText();
                    uri = null;
                    try {
                        uri = new URI(input);
                        JargonGui.access$0(JargonGui.this, FileFactory.newFile(uri));
                    }
                    catch (URISyntaxException ex) {
                        JOptionPane.showMessageDialog((Component)e.getSource(), "Cannot find " + input + ". Check the spelling and try again, or try " + "searching for the item by clicking the Query button and then " + "clicking Search.", "Address Bar", 0);
                    }
                    catch (SecurityException ex) {
                        i = 0;
                        ** while (i < JargonGui.access$3((JargonGui)JargonGui.this).length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        ++i;
                        continue;
lbl15:
                        // 1 sources

                        break block6;
                    }
                    catch (SRBException ex) {
                        JOptionPane.showMessageDialog((Component)e.getSource(), String.valueOf(ex.getMessage()) + "\n" + ex.getStandardMessage() + " " + ex.getType(), "Error", 0);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog((Component)e.getSource(), ex.getMessage(), "Error", 0);
                    }
                }
            }
        });
        this.addresField.setPreferredSize(new Dimension(500, 20));
        addressBar.add(new JLabel("Address "));
        addressBar.add(this.addresField);
        toolBarBox.add((Component)addressBar, "East");
        this.contentPane.add((Component)toolBarBox, "North");
        this.setSidePanel(this.browseTab);
        this.setMainPanel(this.queryTab);
        Box contentBox = new Box(0);
        contentBox.add((Component)this.sidePanel, "West");
        contentBox.add((Component)this.mainPanel, "East");
        this.contentPane.add((Component)contentBox, "South");
    }

    private void useTabs(GeneralFile configFile) throws IOException {
        try {
            GeneralFile[] files = new GeneralFile[]{FileFactory.newFile(new URI("file:///")), FileFactory.newFile(new SRBFileSystem(srbAccount), "/"), FileFactory.newFile(new SRBFileSystem(srbAccount), srbAccount.getHomeDirectory())};
            this.fileSystems = new GeneralFileSystem[files.length];
            this.fileSystems[0] = files[0].getFileSystem();
            this.fileSystems[1] = files[1].getFileSystem();
            this.fileSystems[2] = files[2].getFileSystem();
            this.jargonTree = new JargonTree(files);
            this.jargonTree.setEditable(false);
            this.jargonTree.useDefaultPopupMenu(true);
            this.browseTab = new BrowseTab(this.jargonTree);
            this.queryTab = new QueryTab(new QueryPanel(files[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void useTabs(JargonTab[] tabs) throws IOException {
    }

    void updateAddressBar(GeneralFile file) {
        this.selectedFile = file;
        this.addresField.setText(this.selectedFile.toString());
    }

    GeneralFile getSelectedFile() {
        return this.selectedFile;
    }

    private void setJToolBar(JToolBar toolBar) {
        if (toolBar == null) {
            return;
        }
        this.contentPane.add((Component)toolBar, this.gridBagConstraints);
    }

    public void setJMenuBar(JMenuBar menuBar) {
        if (menuBar == null) {
            return;
        }
        super.setJMenuBar(menuBar);
    }

    private void setSidePanel(JargonTab tab) throws IOException {
        if (this.sidePanel == null) {
            this.sidePanel = new JScrollPane(tab.getComponent());
            this.sidePanel.setPreferredSize(new Dimension(200, 490));
        } else {
            this.sidePanel.setViewportView(tab.getComponent(null));
        }
    }

    private void setMainPanel(JargonTab tab) throws IOException {
        if (this.mainPanel == null) {
            this.mainPanel = new JScrollPane(tab.getComponent());
            this.mainPanel.setPreferredSize(new Dimension(680, 490));
        } else {
            GeneralFile[] files = new GeneralFile[]{this.getSelectedFile()};
            this.mainPanel.setViewportView(tab.getComponent(files));
        }
        this.setJMenuBar(tab.getJMenuBar());
    }

    public void actionPerformed(ActionEvent e) {
        if (this.queryButton.getActionCommand().equals(e.getActionCommand())) {
            try {
                if (this.selectedFile != null) {
                    ((QueryPanel)this.queryTab.getComponent()).setFileSystem(this.selectedFile.getFileSystem());
                }
                this.setMainPanel(this.queryTab);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        JargonGui jargonGui = null;
        try {
            if (args.length == 0) {
                jargonGui = new JargonGui();
            } else if (args[0].equals("-uri")) {
                jargonGui = new JargonGui();
            } else if (args.length == 7) {
                srbAccount = new SRBAccount(args[0], Integer.parseInt(args[1]), args[2], args[3], args[4], args[5], args[6]);
                jargonGui = new JargonGui();
            } else if (args.length == 8) {
                srbAccount = new SRBAccount(args[0], Integer.parseInt(args[1]), args[2], args[3], args[4], args[5], args[6]);
                srbAccount.setCertificateAuthority(args[7]);
                jargonGui = new JargonGui();
            }
            jargonGui.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    System.exit(0);
                }
            });
            jargonGui.setTitle("DataGrid Explorer");
            jargonGui.pack();
            jargonGui.show();
            jargonGui.validate();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println(((SRBException)e).getStandardMessage());
        }
    }

    static /* synthetic */ void access$0(JargonGui jargonGui, GeneralFile generalFile) {
        jargonGui.selectedFile = generalFile;
    }

    static /* synthetic */ JTextField access$1(JargonGui jargonGui) {
        return jargonGui.addresField;
    }

    static /* synthetic */ GeneralFile access$2(JargonGui jargonGui) {
        return jargonGui.selectedFile;
    }

    static /* synthetic */ GeneralFileSystem[] access$3(JargonGui jargonGui) {
        return jargonGui.fileSystems;
    }

    class BrowseTab
    implements JargonTab {
        JargonTree display;
        public String tabName = "Browse";
        public int mnemonic = 66;

        public BrowseTab(JargonTree display) {
            this.display = display;
            display.addTreeSelectionListener(new TreeSelectionListener(this){
                final /* synthetic */ BrowseTab this$1;
                {
                    this.this$1 = browseTab;
                }

                public void valueChanged(TreeSelectionEvent e) {
                    Object selected = e.getPath().getLastPathComponent();
                    if (selected instanceof String) {
                        BrowseTab.access$0((BrowseTab)this.this$1).queryButton.setEnabled(false);
                    } else {
                        JargonGui.access$0(BrowseTab.access$0(this.this$1), (GeneralFile)selected);
                        JargonGui.access$1(BrowseTab.access$0(this.this$1)).setText(JargonGui.access$2(BrowseTab.access$0(this.this$1)).toString());
                        if (JargonGui.access$2(BrowseTab.access$0(this.this$1)) instanceof LocalFile) {
                            BrowseTab.access$0((BrowseTab)this.this$1).queryButton.setEnabled(false);
                        } else {
                            BrowseTab.access$0((BrowseTab)this.this$1).queryButton.setEnabled(true);
                        }
                    }
                }
            });
        }

        public Component getComponent() throws IOException {
            return this.display;
        }

        public Component getComponent(GeneralFile[] file) throws IOException {
            if (file == null) {
                return this.display;
            }
            this.display = new JargonTree(file);
            return this.display;
        }

        public JMenuBar getJMenuBar() {
            return null;
        }

        public JToolBar getJToolBar() {
            return null;
        }

        public GeneralFile getSelectedFile() {
            return (GeneralFile)this.display.getLastSelectedPathComponent();
        }

        public String getTabName() {
            return this.tabName;
        }

        public int getMnemonic() {
            return this.mnemonic;
        }

        static /* synthetic */ JargonGui access$0(BrowseTab browseTab) {
            return browseTab.JargonGui.this;
        }
    }
}

