/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.gui.JargonTreeModel;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.local.LocalFile;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class JargonTreeCellRenderer
implements TreeCellRenderer {
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof String) {
            if (value.equals(JargonTreeModel.TOP_LEVEL)) {
                return new JLabel(value.toString(), JargonTreeModel.FOLDER_ICON, 0);
            }
            return new JLabel((String)value, JargonTreeModel.FOLDER_ICON, 0);
        }
        if (value instanceof LocalFile) {
            if (leaf) {
                return new JLabel(((LocalFile)value).getName(), JargonTreeModel.FILE_ICON, 0);
            }
            return new JLabel(((LocalFile)value).getName(), JargonTreeModel.FOLDER_ICON, 0);
        }
        JargonTreeModel model = (JargonTreeModel)tree.getModel();
        GeneralFile file = (GeneralFile)value;
        if (leaf && model.showMetaData()) {
            JPanel panel = new JPanel();
            JLabel label = null;
            JTable table = null;
            Object[][] tableData = null;
            String[] tableNames = null;
            panel.setBackground(new Color(0, 0, 0, 0));
            panel.setLayout(new BoxLayout(panel, 0));
            label = new JLabel("", JargonTreeModel.FILE_ICON, 0);
            label.setAlignmentX(0.5f);
            panel.add(label);
            table = model.getMetaData(file);
            if (table != null) {
                table.setAlignmentX(0.0f);
                panel.add(table);
            }
            return panel;
        }
        if (leaf) {
            return new JLabel(file.getName(), JargonTreeModel.FILE_ICON, 0);
        }
        return new JLabel(file.getName(), JargonTreeModel.FOLDER_ICON, 0);
    }
}

