/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.io.MetaDataTable;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.BoxLayout;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class MetaDataTableDisplay
extends JTable {
    private MetaDataTable table;
    private int tableRows;

    MetaDataTableDisplay(MetaDataTable table) {
        this.table = table;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 0));
    }

    public int getRows() {
        return this.tableRows;
    }

    public void editingStopped(ChangeEvent e) {
        System.out.println("editingStopped " + e);
        super.editingStopped(e);
    }

    static JTable createMetaDataTable(MetaDataTable table) {
        int tableRows = table.getRowCount();
        int tableColumns = table.getColumnCount();
        Object[][] temp = new Object[tableRows][tableColumns];
        String value = null;
        Object[][] subData = null;
        int k = 0;
        int maxK = 0;
        int ii = 0;
        while (ii < tableRows) {
            int jj = 0;
            while (jj < tableColumns) {
                value = table.getStringValue(ii, jj);
                if (value != null && !value.equals("")) {
                    temp[ii][k] = value;
                    ++k;
                } else {
                    temp[ii][k] = "";
                }
                ++jj;
            }
            maxK = Math.max(k, maxK);
            k = 0;
            ++ii;
        }
        subData = new Object[tableRows][maxK];
        ii = 0;
        while (ii < tableRows) {
            System.arraycopy(temp[ii], 0, subData[ii], 0, maxK);
            ++ii;
        }
        JTable jTable = new JTable(subData, subData[0]);
        Font font = jTable.getFont();
        if (font == null) {
            font = new Font("SansSerif", 0, 12);
            jTable.setFont(font);
        }
        FontMetrics fontMetrics = jTable.getFontMetrics(font);
        int columnWidth = 0;
        int columnHeight = (tableRows + 1) * fontMetrics.getHeight();
        jTable.setPreferredScrollableViewportSize(new Dimension(columnWidth, columnHeight * 2));
        jTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                int row = e.getFirstRow();
                int column = e.getColumn();
                TableModel model = (TableModel)e.getSource();
                String columnName = model.getColumnName(column);
                Object data = model.getValueAt(row, column);
            }
        });
        return jTable;
    }
}

