/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.gui.ClausesPanel;
import edu.sdsc.grid.gui.ConditionChooser;
import edu.sdsc.grid.gui.MetaDataDisplay;
import edu.sdsc.grid.gui.SelectionChooser;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataGroup;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.srb.SRBFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class QueryPanel
extends JScrollPane
implements ActionListener {
    public static String LIST_BUTTON_TEXT = "List";
    static String LIST_BUTTON_IMG = "list.gif";
    public static String GRAPH_BUTTON_TEXT = "Graph";
    static String GRAPH_BUTTON_IMG = "graph.gif";
    public static String CLEAR_BUTTON_TEXT = "Clear";
    static String CLEAR_BUTTON_IMG = "clear.gif";
    public static String MORE_BUTTON_TEXT = "More Results";
    static String MORE_BUTTON_IMG = "More Results";
    public static String NO_RESULT = "No Result";
    private GeneralFileSystem fileSystem;
    private MetaDataGroup[] groups;
    private MetaDataField[] fields;
    private ClausesPanel conditionPanel;
    private ClausesPanel selectionPanel;
    private JButton listButton;
    private JButton graphButton;
    private JButton clearButton;
    private MetaDataRecordList[] rl;
    private JFrame frame;
    private JPanel panel;
    private GridBagConstraints gridBagConstraints;
    JScrollPane jScrollPane;
    private JButton moreButton;
    private JPanel containingPanel;

    public QueryPanel(GeneralFileSystem fileSystem) {
        this(fileSystem, MetaDataSet.getMetaDataGroups(true));
    }

    public QueryPanel(GeneralFileSystem fileSystem, MetaDataGroup[] groups) {
        this.fileSystem = fileSystem;
        this.groups = groups;
        this.conditionPanel = new ClausesPanel(new ConditionChooser(groups), "Where:");
        this.selectionPanel = new ClausesPanel(new SelectionChooser(groups), "Select:");
        this.init();
    }

    public QueryPanel(GeneralFileSystem fileSystem, MetaDataField[] fields) {
        this.fileSystem = fileSystem;
        this.fields = fields;
        this.conditionPanel = new ClausesPanel(new ConditionChooser(fields), "Where:");
        this.selectionPanel = new ClausesPanel(new SelectionChooser(fields), "Select:");
        this.init();
    }

    public QueryPanel(GeneralFile file) {
        this(file, MetaDataSet.getMetaDataGroups(true));
    }

    public QueryPanel(GeneralFile file, MetaDataGroup[] groups) {
        this.fileSystem = file.getFileSystem();
        this.groups = groups;
        this.conditionPanel = new ClausesPanel(new ConditionChooser(groups), "Where:");
        this.selectionPanel = new ClausesPanel(new SelectionChooser(groups), "Select:");
        this.addConditions(file);
        this.init();
    }

    public QueryPanel(GeneralFile file, MetaDataField[] fields) {
        this.fileSystem = file.getFileSystem();
        this.fields = fields;
        this.conditionPanel = new ClausesPanel(new ConditionChooser(fields), "Where:");
        this.selectionPanel = new ClausesPanel(new SelectionChooser(fields), "Select:");
        this.addConditions(file);
        this.init();
    }

    private void init() {
        this.containingPanel = new JPanel();
        this.containingPanel.setLayout(new GridBagLayout());
        this.containingPanel.setBackground(Color.WHITE);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridwidth = 0;
        this.gridBagConstraints.anchor = 17;
        this.setPreferredSize(new Dimension(640, 180));
        this.setMinimumSize(new Dimension(640, 180));
        this.setBackground(Color.WHITE);
        this.containingPanel.add((Component)this.conditionPanel, this.gridBagConstraints);
        this.containingPanel.add((Component)this.selectionPanel, this.gridBagConstraints);
        this.gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.gridBagConstraints.gridwidth = 1;
        this.listButton = new JButton(new ImageIcon(LIST_BUTTON_IMG));
        this.listButton.setActionCommand(LIST_BUTTON_TEXT);
        this.listButton.setToolTipText(LIST_BUTTON_TEXT);
        this.listButton.setMargin(new Insets(0, 0, 0, 0));
        this.setListButton(this.listButton);
        this.containingPanel.add((Component)this.listButton, this.gridBagConstraints);
        this.gridBagConstraints.gridwidth = -1;
        this.graphButton = new JButton(new ImageIcon(GRAPH_BUTTON_IMG));
        this.graphButton.setActionCommand(GRAPH_BUTTON_TEXT);
        this.graphButton.setToolTipText(GRAPH_BUTTON_TEXT);
        this.graphButton.setMargin(new Insets(0, 0, 0, 0));
        this.setGraphButton(this.graphButton);
        this.containingPanel.add((Component)this.graphButton, this.gridBagConstraints);
        this.gridBagConstraints.gridwidth = 0;
        this.clearButton = new JButton(new ImageIcon(CLEAR_BUTTON_IMG));
        this.clearButton.setActionCommand(CLEAR_BUTTON_TEXT);
        this.clearButton.setToolTipText(CLEAR_BUTTON_TEXT);
        this.clearButton.setMargin(new Insets(0, 0, 0, 0));
        this.setClearButton(this.clearButton);
        this.containingPanel.add((Component)this.clearButton, this.gridBagConstraints);
        this.gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.panel.setBackground(Color.WHITE);
        this.containingPanel.add((Component)this.panel, this.gridBagConstraints);
        this.setViewportView(this.containingPanel);
        this.conditionPanel.setContainer(this);
        this.selectionPanel.setContainer(this);
    }

    public void setFileSystem(GeneralFileSystem fileSystem) {
        if (fileSystem != null) {
            this.fileSystem = fileSystem;
        }
    }

    void setListButton(JButton listButton) {
        this.listButton = listButton;
        this.listButton.addActionListener(this);
    }

    void setGraphButton(JButton graphButton) {
        this.graphButton = graphButton;
        this.graphButton.addActionListener(this);
    }

    void setClearButton(JButton clearButton) {
        this.clearButton = clearButton;
        this.clearButton.addActionListener(this);
    }

    public GeneralFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public MetaDataCondition[] getConditions() {
        return (MetaDataCondition[])this.conditionPanel.getClauses(new MetaDataCondition[0]);
    }

    public MetaDataSelect[] getSelects() {
        return (MetaDataSelect[])this.selectionPanel.getClauses(new MetaDataSelect[0]);
    }

    public void addCondition(MetaDataCondition condition) {
        MetaDataCondition[] conditions = new MetaDataCondition[]{condition};
        this.addConditions(conditions);
    }

    public void addConditions(MetaDataCondition[] conditions) {
        this.conditionPanel.addClauses(conditions);
    }

    void addConditions(GeneralFile file) {
        Object[] iConditions = null;
        String fieldName = null;
        int operator = 0;
        String value = null;
        if (file.isDirectory()) {
            iConditions = new MetaDataCondition[1];
            fieldName = "directory name";
            operator = 0;
            value = file.getAbsolutePath();
            iConditions[0] = MetaDataSet.newCondition(fieldName, operator, value);
        } else {
            int replicaNumber;
            iConditions = new MetaDataCondition[3];
            fieldName = "directory name";
            operator = 0;
            value = file.getParent();
            iConditions[0] = MetaDataSet.newCondition(fieldName, operator, value);
            fieldName = "file name";
            value = file.getName();
            iConditions[1] = MetaDataSet.newCondition(fieldName, operator, value);
            if (file instanceof SRBFile && (replicaNumber = ((SRBFile)file).getReplicaNumber()) >= 0) {
                fieldName = "file replication enum";
                value = "" + replicaNumber;
                iConditions[2] = MetaDataSet.newCondition(fieldName, operator, value);
            }
        }
        this.conditionPanel.addClauses(iConditions);
    }

    public void addSelect(MetaDataSelect select) {
        MetaDataSelect[] selects = new MetaDataSelect[]{select};
        this.addSelects(selects);
    }

    public void addSelects(MetaDataSelect[] selects) {
        this.selectionPanel.addClauses(selects);
    }

    public MetaDataRecordList[] submitQuery() throws IOException, NullPointerException {
        if (this.fileSystem != null) {
            this.rl = this.fileSystem.query(this.getConditions(), this.getSelects());
            return this.rl;
        }
        throw new NullPointerException("FileSystem cannot be null");
    }

    void displayList() {
        if (this.rl == null) {
            this.panel.add((Component)new JLabel(NO_RESULT), this.gridBagConstraints);
            this.containingPanel.validate();
            this.containingPanel.repaint();
            return;
        }
        MetaDataDisplay display = new MetaDataDisplay(this.fileSystem, this.rl);
        Dimension d = display.getPreferredSize();
        this.panel.add((Component)display.getTableHeader(), this.gridBagConstraints);
        this.panel.add((Component)display, this.gridBagConstraints);
        if (!this.rl[this.rl.length - 1].isQueryComplete()) {
            this.moreButton = new JButton(MORE_BUTTON_TEXT);
            d = new Dimension(40, 20);
            this.moreButton.setPreferredSize(d);
            this.moreButton.setMaximumSize(d);
            this.moreButton.setMinimumSize(d);
            this.moreButton.addActionListener(this);
            this.containingPanel.add((Component)this.moreButton, this.gridBagConstraints);
        }
        this.containingPanel.validate();
        this.containingPanel.repaint();
    }

    JPanel getResultsPanel() {
        MetaDataDisplay display = new MetaDataDisplay(this.fileSystem, this.rl);
        Dimension d = display.getPreferredSize();
        JPanel container = new JPanel();
        if (this.rl == null) {
            JLabel label = new JLabel(NO_RESULT);
            container.add(label);
            return container;
        }
        this.jScrollPane = new JScrollPane(display);
        d.setSize(d.width + 4, d.height + MetaDataDisplay.fontPixelHeight + 40);
        this.jScrollPane.setPreferredSize(d);
        container.setLayout(new GridBagLayout());
        container.add((Component)this.jScrollPane, this.gridBagConstraints);
        if (this.rl != null && !this.rl[this.rl.length - 1].isQueryComplete()) {
            this.moreButton = new JButton(MORE_BUTTON_TEXT);
            d = new Dimension(40, 20);
            this.moreButton.setPreferredSize(d);
            this.moreButton.setMaximumSize(d);
            this.moreButton.setMinimumSize(d);
            this.moreButton.addActionListener(this);
            container.add((Component)this.moreButton, this.gridBagConstraints);
        }
        return container;
    }

    void displayList(boolean allResults) throws IOException {
        if (allResults) {
            this.rl = MetaDataRecordList.getAllResults(this.rl);
        }
        this.displayList();
    }

    void displayGraph() {
    }

    public void actionPerformed(ActionEvent e) {
        if (this.listButton.getActionCommand().equals(e.getActionCommand())) {
            try {
                this.submitQuery();
                this.displayList();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else if (this.graphButton.getActionCommand().equals(e.getActionCommand())) {
            try {
                this.submitQuery();
                this.displayGraph();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else if (this.clearButton.getActionCommand().equals(e.getActionCommand())) {
            try {
                this.panel.removeAll();
                this.panel.validate();
                this.panel.repaint();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else if (this.moreButton.getText().equals(e.getActionCommand())) {
            try {
                if (this.rl == null) {
                    return;
                }
                MetaDataRecordList[] rl2 = this.rl[this.rl.length - 1].getMoreResults();
                if (rl2 == null) {
                    return;
                }
                MetaDataRecordList[] totalRecordList = new MetaDataRecordList[this.rl.length + rl2.length];
                System.arraycopy(this.rl, 0, totalRecordList, 0, this.rl.length);
                System.arraycopy(rl2, 0, totalRecordList, this.rl.length, rl2.length);
                this.rl = totalRecordList;
                this.containingPanel.add((Component)new MetaDataDisplay(this.fileSystem, this.rl), this.gridBagConstraints);
                if (this.rl[this.rl.length - 1].isQueryComplete()) {
                    this.containingPanel.remove(this.containingPanel.getComponentCount() - 1);
                    this.moreButton.validate();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

