/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataGroup;
import edu.sdsc.grid.io.MetaDataSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class SelectionChooser
extends JPanel {
    protected MetaDataGroup[] groups;
    protected MetaDataField[] fields;
    protected JComboBox mainList;
    protected JComboBox subList;
    protected Object clause;

    public SelectionChooser() {
        this(MetaDataSet.getMetaDataGroups(true));
    }

    public SelectionChooser(MetaDataGroup[] groups) {
        this.groups = groups;
        this.mainList = new JComboBox<MetaDataGroup>(groups);
        this.add(this.mainList);
        this.changeSubList(0);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectionChooser.this.changeSubList(SelectionChooser.this.mainList.getSelectedIndex());
            }
        };
        this.mainList.addActionListener(actionListener);
        this.init();
    }

    public SelectionChooser(MetaDataField[] fields) {
        this.fields = fields;
        this.mainList = new JComboBox<MetaDataField>(fields);
        this.mainList.insertItemAt(this.makeObj("---"), 0);
        this.mainList.setSelectedIndex(0);
        this.add(this.mainList);
        this.init();
    }

    protected void finalize() throws Throwable {
        if (this.groups != null) {
            this.groups = null;
        }
        if (this.fields != null) {
            this.fields = null;
        }
        if (this.mainList != null) {
            this.mainList = null;
        }
        if (this.subList != null) {
            this.subList = null;
        }
        if (this.clause != null) {
            this.clause = null;
        }
        super.finalize();
    }

    private void init() {
        this.setBackground(Color.WHITE);
        this.mainList.setBackground(Color.WHITE);
    }

    void setClause(Object clause) {
        if (clause != null) {
            this.clause = clause;
        }
    }

    public Object getClause() {
        String field = null;
        if (this.subList != null) {
            Object temp = this.subList.getSelectedItem();
            if (temp == null) {
                return null;
            }
            field = temp.toString();
        } else {
            Object temp = this.mainList.getSelectedItem();
            if (temp == null) {
                return null;
            }
            field = temp.toString();
        }
        this.clause = MetaDataSet.newSelection(field);
        return this.clause;
    }

    protected void changeSubList(int index) {
        if (this.subList != null) {
            this.remove(this.subList);
        }
        this.subList = new JComboBox<MetaDataField>(this.groups[index].getFields(true));
        this.subList.insertItemAt(this.makeObj("---"), 0);
        this.subList.setSelectedIndex(0);
        this.subList.setBackground(Color.WHITE);
        this.add((Component)this.subList, 1);
        this.validate();
        this.repaint();
    }

    Object makeObj(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }
}

