/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.net.URI;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class TransferStatusPanel
extends JPanel
implements Runnable {
    private static final String SYMBOL_PERCENTAGE = "/";
    private static final String SYMBOL_DIVIDE = "\\";
    private static final int FILENAME_WIDTH = 20;
    private static final Font gridFont = new Font("courier", 0, 12);
    public static final int OVERWRITE = 2;
    private static final int APPEND = 1;
    public static final int SKIP = 0;
    private boolean toggleSymbol = true;
    private int bytesCopied = 0;
    private Thread drawSymbolThread = null;
    private long[] fileLengths;
    private int sourcesLength;
    private int index;
    protected GeneralFile[] sources;
    protected GeneralFile[] destinations;
    protected JProgressBar[] progressBars;
    protected JLabel[] fileNameLabel;
    protected int overwrite = 0;
    private static int sleepLength = 750;
    boolean skipFile = false;

    public TransferStatusPanel(GeneralFile source) {
        this.sources = new GeneralFile[1];
        this.sources[0] = source;
        this.destinations = new LocalFile[1];
        this.destinations[0] = new LocalFile(source.getName());
        this.initComponents();
    }

    public TransferStatusPanel(GeneralFile[] sources) {
        this.sources = sources;
        this.destinations = new LocalFile[sources.length];
        int i = 0;
        while (i < sources.length) {
            this.destinations[i] = new LocalFile(sources[i].getName());
            ++i;
        }
        this.initComponents();
    }

    public TransferStatusPanel(GeneralFile source, GeneralFile destination) {
        this.sources = new GeneralFile[1];
        this.sources[0] = source;
        this.destinations = new GeneralFile[1];
        this.destinations[0] = destination;
        this.initComponents();
    }

    public TransferStatusPanel(GeneralFile[] sources, GeneralFile[] destinations) {
        if (sources.length != destinations.length) {
            new IllegalArgumentException("Must have equal number of sources and destination.");
        }
        this.sources = sources;
        this.destinations = destinations;
        this.initComponents();
    }

    private void initComponents() {
        this.sourcesLength = this.sources.length;
        if (this.sourcesLength != this.destinations.length) {
            throw new IllegalArgumentException();
        }
        this.progressBars = new JProgressBar[this.sourcesLength];
        this.fileNameLabel = new JLabel[this.sourcesLength];
        this.fileLengths = new long[this.sourcesLength];
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        int i = 0;
        while (i < this.sourcesLength) {
            String fileName = this.sources[i].getAbsolutePath();
            this.fileLengths[i] = this.sources[i].length();
            this.bytesCopied = 0;
            this.progressBars[i] = new JProgressBar();
            this.progressBars[i].setString("Queued");
            this.progressBars[i].setStringPainted(true);
            this.progressBars[i].setMaximum((int)this.fileLengths[i]);
            this.progressBars[i].setValue(0);
            this.progressBars[i].setPreferredSize(new Dimension(150, 20));
            if (fileName.length() > 20) {
                int removeChars = fileName.length() - 20;
                fileName = fileName.substring(removeChars += 3, fileName.length());
                fileName = "..." + fileName;
            }
            this.fileNameLabel[i] = new JLabel(fileName, 2);
            gbc.insets = new Insets(0, 5, 0, 5);
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.gridy = i;
            this.add((Component)this.fileNameLabel[i], gbc);
            gbc.gridx = 1;
            gbc.gridy = i;
            this.add((Component)this.progressBars[i], gbc);
            ++i;
        }
    }

    public void setOverwrite(int overwrite) {
        if (overwrite <= 2 && overwrite >= 0) {
            this.overwrite = overwrite;
        }
    }

    public int getOverwrite() {
        return this.overwrite;
    }

    public GeneralFile[] getSources() {
        return this.sources;
    }

    public GeneralFile[] getDestinations() {
        return this.destinations;
    }

    public void setSleepLength(int sleepFor) {
        if (sleepFor > 100) {
            sleepLength = sleepFor;
        }
    }

    public int getSleepLength() {
        return sleepLength;
    }

    public void start() throws IOException {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TransferStatusPanel.this.startSymbolThread();
            }
        });
        this.copy(this.sources, this.destinations);
    }

    private void copy(final GeneralFile[] sources, final GeneralFile[] destinations) throws IOException {
        this.index = 0;
        while (this.index < this.sourcesLength) {
            if (this.overwrite == 2 || this.overwrite == 1 || !destinations[this.index].exists()) {
                Thread copyThread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            if (TransferStatusPanel.this.overwrite == 2) {
                                sources[TransferStatusPanel.this.index].copyTo(destinations[TransferStatusPanel.this.index], true);
                            } else if (TransferStatusPanel.this.overwrite == 1) {
                                sources[TransferStatusPanel.this.index].copyTo(destinations[TransferStatusPanel.this.index], false);
                            } else if (!destinations[TransferStatusPanel.this.index].exists()) {
                                sources[TransferStatusPanel.this.index].copyTo(destinations[TransferStatusPanel.this.index], false);
                            } else {
                                TransferStatusPanel.this.skipFile = true;
                            }
                        }
                        catch (SRBException e) {
                            JOptionPane.showMessageDialog(null, e + " " + e.getStandardMessage());
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(null, "" + e);
                        }
                    }
                }, "Copy");
                copyThread.start();
                this.progressBars[this.index].setString("     " + this.bytesCopied + " " + SYMBOL_PERCENTAGE + " " + this.fileLengths[this.index]);
                this.progressBars[this.index].setValue(this.bytesCopied);
                this.progressBars[this.index].paintImmediately(this.progressBars[this.index].getVisibleRect());
                if (sources[this.index] instanceof SRBFile) {
                    while ((long)((int)((SRBFile)sources[this.index]).fileCopyStatus()) < this.fileLengths[this.index] && copyThread.isAlive()) {
                        this.bytesCopied = (int)((SRBFile)sources[this.index]).fileCopyStatus();
                        this.progressBars[this.index].setString("     " + this.bytesCopied + " " + SYMBOL_PERCENTAGE + " " + this.fileLengths[this.index]);
                        this.progressBars[this.index].setValue(this.bytesCopied);
                        this.progressBars[this.index].paintImmediately(this.progressBars[this.index].getVisibleRect());
                        try {
                            Thread.sleep(sleepLength);
                        }
                        catch (InterruptedException e) {
                            JOptionPane.showMessageDialog(null, e);
                        }
                    }
                } else if (destinations[this.index] instanceof SRBFile) {
                    while ((long)((int)((SRBFile)destinations[this.index]).fileCopyStatus()) < this.fileLengths[this.index] && copyThread.isAlive()) {
                        this.bytesCopied = (int)((SRBFile)destinations[this.index]).fileCopyStatus();
                        this.progressBars[this.index].setString("     " + this.bytesCopied + " " + SYMBOL_PERCENTAGE + " " + this.fileLengths[this.index]);
                        this.progressBars[this.index].setValue(this.bytesCopied);
                        this.progressBars[this.index].paintImmediately(this.progressBars[this.index].getVisibleRect());
                        try {
                            Thread.sleep(sleepLength);
                        }
                        catch (InterruptedException e) {
                            JOptionPane.showMessageDialog(null, e);
                        }
                    }
                }
                this.bytesCopied = (int)((SRBFile)destinations[this.index]).fileCopyStatus();
                this.progressBars[this.index].setString("     " + this.bytesCopied + " " + SYMBOL_PERCENTAGE + " " + this.fileLengths[this.index]);
                this.progressBars[this.index].setValue(this.bytesCopied);
                this.progressBars[this.index].paintImmediately(this.progressBars[this.index].getVisibleRect());
                try {
                    copyThread.join();
                }
                catch (InterruptedException e) {
                    JOptionPane.showMessageDialog(null, "" + e);
                }
            } else if (destinations[this.index].isDirectory()) {
                GeneralFile[] subSources = new GeneralFile[]{sources[this.index]};
                GeneralFile[] subDestinations = new GeneralFile[]{FileFactory.newFile(destinations[this.index], sources[this.index].getName())};
                this.copy(subSources, subDestinations);
            } else {
                this.progressBars[this.index].setString("Skipped");
            }
            this.bytesCopied = 0;
            ++this.index;
        }
    }

    private void startSymbolThread() {
        if (this.drawSymbolThread == null) {
            this.drawSymbolThread = new Thread((Runnable)this, "ProgressBars");
            this.drawSymbolThread.setPriority(1);
            this.drawSymbolThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Thread.sleep(sleepLength);
            }
            catch (InterruptedException e) {
                JOptionPane.showMessageDialog(null, "" + e);
            }
            TransferStatusPanel transferStatusPanel = this;
            synchronized (transferStatusPanel) {
                if (this.index >= this.fileLengths.length) {
                    break;
                }
                if (this.toggleSymbol) {
                    this.progressBars[this.index].setString("     " + this.bytesCopied + " " + SYMBOL_DIVIDE + " " + this.fileLengths[this.index]);
                    this.toggleSymbol = false;
                } else {
                    this.progressBars[this.index].setString("     " + this.bytesCopied + " " + SYMBOL_PERCENTAGE + " " + this.fileLengths[this.index]);
                    this.toggleSymbol = true;
                }
                this.progressBars[this.index].setValue(this.bytesCopied);
                this.progressBars[this.index].paintImmediately(this.progressBars[this.index].getVisibleRect());
            }
        }
    }

    private static void showHelp() {
        System.out.println("Usage: java TransferStatusPanel sourceURI destinationURI");
        System.out.println("Usage: java TransferStatusPanel -srb-upload host port username password homeDirectory mdasDomainHome defaultStorageResource localPath srbPath");
        System.out.println("Usage: java TransferStatusPanel -srb-proxy-upload host port username password homeDirectory mdasDomainHome defaultStorageResource certificateAuthorityFilePath localPath srbPath");
        System.out.println("Usage: java TransferStatusPanel -srb-download host port username password homeDirectory mdasDomainHome defaultStorageResource srbPath localPath ");
        System.out.println("Usage: java TransferStatusPanel -srb-proxy-download host port username password homeDirectory mdasDomainHome defaultStorageResource certificateAuthorityFilePath srbPath localPath ");
        System.out.println("Usage: java TransferStatusPanel -help");
    }

    public static void main(String[] args) {
        GeneralFile[] destinations;
        GeneralFile[] sources;
        JFrame frame;
        block13: {
            frame = new JFrame("Test Panel");
            sources = new GeneralFile[1];
            destinations = new GeneralFile[1];
            SRBFileSystem fs = null;
            SRBAccount account = null;
            boolean uri = false;
            int i = 0;
            if (args.length < 2 || args[i].equals("-help")) {
                TransferStatusPanel.showHelp();
                System.exit(1);
            } else if (args[i].startsWith("-srb")) {
                if (args[i].startsWith("-srb-proxy")) {
                    account = new SRBAccount(args[i + 1], Integer.parseInt(args[i + 2]), args[i + 3], args[i + 4], args[i + 5], args[i + 6], args[i + 7]);
                    account.setCertificateAuthority(args[8]);
                    i += 10;
                } else {
                    account = new SRBAccount(args[i + 1], Integer.parseInt(args[i + 2]), args[i + 3], args[i + 4], args[i + 5], args[i + 6], args[i + 7]);
                    i += 8;
                }
                try {
                    fs = new SRBFileSystem(account);
                    if (args[0].indexOf("-upload") >= 0) {
                        sources[0] = new LocalFile(args[i]);
                        destinations[0] = FileFactory.newFile(fs, args[i + 1]);
                        break block13;
                    }
                    sources[0] = FileFactory.newFile(fs, args[i]);
                    destinations[0] = new LocalFile(args[i + 1]);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    sources[0] = FileFactory.newFile(new URI(args[i]));
                    destinations[0] = FileFactory.newFile(new URI(args[i + 1]));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        TransferStatusPanel self = new TransferStatusPanel(sources, destinations);
        frame.getContentPane().add("Center", self);
        frame.setResizable(true);
        frame.pack();
        frame.show();
        try {
            self.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

