/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileInputStream;
import edu.sdsc.grid.io.GeneralFileOutputStream;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.local.LocalAccount;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.local.LocalFileInputStream;
import edu.sdsc.grid.io.local.LocalFileOutputStream;
import edu.sdsc.grid.io.local.LocalFileSystem;
import edu.sdsc.grid.io.local.LocalRandomAccessFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileInputStream;
import edu.sdsc.grid.io.srb.SRBFileOutputStream;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBRandomAccessFile;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public final class FileFactory {
    static GeneralAccount newAccount(URI uri) {
        if (uri != null && uri.getScheme().equals("srb")) {
            String host = uri.getHost();
            int port = uri.getPort();
            String path = uri.getPath();
            String userInfo = uri.getUserInfo();
            Object userName = null;
            Object mdasDomain = null;
            Object password = null;
            Object var8_8 = null;
        }
        return new LocalAccount();
    }

    static GeneralAccount newAccount(URI uri, String password) {
        if (uri != null) {
            int index = -1;
            String userInfo = uri.getUserInfo();
            if (uri.getScheme().equals("srb")) {
                if (password.indexOf(":") >= 0 || password.indexOf("@") >= 0) {
                    throw new IllegalArgumentException("Password contains illegal charaters");
                }
                index = userInfo.indexOf(":");
                if (index >= 0) {
                    userInfo = userInfo.substring(0, index);
                }
                userInfo = String.valueOf(userInfo) + ":" + password;
                try {
                    uri = new URI(uri.getScheme(), userInfo, uri.getHost(), uri.getPort(), uri.getPath(), "", "");
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Password contains illegal charaters");
                }
                return FileFactory.newAccount(uri);
            }
        }
        return new LocalAccount();
    }

    static GeneralFile newAccount(URI uri, String proxyFilePath, String certificateAurthority) {
        int index = -1;
        String userInfo = uri.getUserInfo();
        if (uri.getScheme().equals("srb")) {
            Object var5_5 = null;
        }
        return new LocalFile(uri);
    }

    public static GeneralFileSystem newFileSystem(GeneralAccount account) throws IOException {
        if (account != null && account instanceof SRBAccount) {
            return new SRBFileSystem((SRBAccount)account);
        }
        return new LocalFileSystem();
    }

    public static GeneralFile newFile(URI uri) throws IOException {
        if (uri.getScheme().equals("srb")) {
            return new SRBFile(uri);
        }
        return new LocalFile(uri);
    }

    public static GeneralFile newFile(URI uri, String password) throws IOException {
        int index = -1;
        String userInfo = uri.getUserInfo();
        if (uri.getScheme().equals("srb")) {
            if (password.indexOf(":") >= 0 || password.indexOf("@") >= 0) {
                throw new IllegalArgumentException("Password contains illegal charaters");
            }
            index = userInfo.indexOf(":");
            if (index >= 0) {
                userInfo = userInfo.substring(0, index);
            }
            userInfo = String.valueOf(userInfo) + ":" + password;
            try {
                uri = new URI(uri.getScheme(), userInfo, uri.getHost(), uri.getPort(), uri.getPath(), "", "");
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Password contains illegal charaters");
            }
            return new SRBFile(uri);
        }
        return new LocalFile(uri);
    }

    static GeneralFile newFile(URI uri, String proxyFilePath, String certificateAurthority) throws IOException {
        int index = -1;
        String userInfo = uri.getUserInfo();
        uri.getScheme().equals("srb");
        return new LocalFile(uri);
    }

    public static GeneralFile newFile(GeneralFileSystem fs, String path) {
        if (fs != null && fs instanceof SRBFileSystem) {
            return new SRBFile((SRBFileSystem)fs, path);
        }
        return new LocalFile(path);
    }

    public static GeneralFile newFile(GeneralFileSystem fs, String parent, String child) {
        if (fs != null && fs instanceof SRBFileSystem) {
            return new SRBFile((SRBFileSystem)fs, parent, child);
        }
        return new LocalFile(parent, child);
    }

    public static GeneralFile newFile(GeneralFile parent, String child) {
        if (parent != null && parent instanceof SRBFile) {
            return new SRBFile((SRBFile)parent, child);
        }
        return new LocalFile((LocalFile)parent, child);
    }

    public static GeneralRandomAccessFile newRandomAccessFile(GeneralFile file, String mode) throws IOException {
        if (file instanceof SRBFile) {
            return new SRBRandomAccessFile((SRBFile)file, mode);
        }
        return new LocalRandomAccessFile((LocalFile)file, mode);
    }

    public static GeneralFileInputStream newFileInputStream(GeneralFile file) throws IOException {
        if (file instanceof SRBFile) {
            return new SRBFileInputStream((SRBFile)file);
        }
        return new LocalFileInputStream((LocalFile)file);
    }

    public static GeneralFileOutputStream newFileOutputStream(GeneralFile file) throws IOException {
        if (file instanceof SRBFile) {
            return new SRBFileOutputStream((SRBFile)file);
        }
        return new LocalFileOutputStream((LocalFile)file);
    }
}

