/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFileInputStream;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Vector;

public class GeneralFile
implements Comparable {
    public static final int BUFFER_MAX_SIZE = 65535;
    protected GeneralFileSystem fileSystem;
    protected Vector directory;
    protected String fileName;

    protected GeneralFile(GeneralFileSystem fileSystem, String dir, String fileName) throws NullPointerException {
        this.setFileSystem(fileSystem);
        this.setDirectory(dir);
        this.setFileName(fileName);
    }

    protected GeneralFile(URI uri) throws NullPointerException, IllegalArgumentException {
    }

    protected void finalize() throws Throwable {
        if (this.fileSystem != null) {
            this.fileSystem = null;
        }
        if (this.directory != null) {
            this.directory = null;
        }
        if (this.fileName != null) {
            this.fileName = null;
        }
    }

    protected void setFileSystem(GeneralFileSystem fileSystem) throws IllegalArgumentException, ClassCastException {
        if (fileSystem == null) {
            throw new IllegalArgumentException("Illegal fileSystem, cannot be null");
        }
        this.fileSystem = fileSystem;
    }

    protected void setDirectory(String dir) {
        throw new UnsupportedOperationException();
    }

    protected void setFileName(String fleName) {
        throw new UnsupportedOperationException();
    }

    public String getPathSeparator() {
        throw new UnsupportedOperationException();
    }

    public char getPathSeparatorChar() {
        throw new UnsupportedOperationException();
    }

    public GeneralFileSystem getFileSystem() throws NullPointerException {
        if (this.fileSystem != null) {
            return this.fileSystem;
        }
        throw new NullPointerException("fileSystem is null.");
    }

    public MetaDataRecordList[] query(MetaDataCondition[] conditionArray, MetaDataSelect[] selectArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public MetaDataRecordList[] query(MetaDataSelect[] selectArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public MetaDataRecordList[] query(String[] metaDataFieldNames) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void modifyMetaData(MetaDataRecordList metaDataRecordList) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void copyTo(GeneralFile file) throws IOException {
        this.copyTo(file, false);
    }

    public void copyTo(GeneralFile file, boolean forceOverwrite) throws IOException {
        byte[] buffer = null;
        GeneralRandomAccessFile in = null;
        GeneralRandomAccessFile out = null;
        if (file == null) {
            throw new NullPointerException();
        }
        if (this.isDirectory()) {
            GeneralFile[] fileList = this.listFiles();
            file.mkdir();
            if (fileList != null) {
                int i = 0;
                while (i < fileList.length) {
                    fileList[i].copyTo(FileFactory.newFile(file.getFileSystem(), file.getAbsolutePath(), fileList[i].getName()), forceOverwrite);
                    ++i;
                }
            }
        } else {
            if (file.isDirectory()) {
                file = FileFactory.newFile(file, this.getName());
            }
            long ilength = this.length();
            in = FileFactory.newRandomAccessFile(this, "r");
            out = FileFactory.newRandomAccessFile(file, "rw");
            if (forceOverwrite) {
                try {
                    out.setLength(this.length());
                }
                catch (UnsupportedOperationException e) {
                    file.delete();
                    out = FileFactory.newRandomAccessFile(file, "rw");
                }
            } else {
                out.seek(out.length());
            }
            if (ilength > 65535L) {
                buffer = new byte[65535];
                do {
                    in.read(buffer);
                    out.write(buffer);
                } while ((ilength -= 65535L) > 65535L);
            }
            buffer = new byte[(int)ilength];
            in.read(buffer);
            out.write(buffer);
            in.close();
            out.close();
        }
    }

    public void copyFrom(GeneralFile file) throws IOException {
        this.copyFrom(file, false);
    }

    public void copyFrom(GeneralFile file, boolean forceOverwrite) throws IOException {
        byte[] buffer = null;
        GeneralRandomAccessFile in = null;
        GeneralRandomAccessFile out = null;
        if (file == null) {
            throw new NullPointerException();
        }
        if (file.isDirectory()) {
            GeneralFile[] fileList = file.listFiles();
            this.mkdir();
            if (fileList != null) {
                int i = 0;
                while (i < fileList.length) {
                    FileFactory.newFile(this, fileList[i].getName()).copyFrom(fileList[i], forceOverwrite);
                    ++i;
                }
            }
        } else {
            if (this.isDirectory()) {
                GeneralFile subFile = FileFactory.newFile(this, file.getName());
                subFile.copyFrom(file);
                return;
            }
            long ilength = file.length();
            in = FileFactory.newRandomAccessFile(file, "r");
            out = FileFactory.newRandomAccessFile(this, "rw");
            if (forceOverwrite) {
                try {
                    out.setLength(this.length());
                }
                catch (UnsupportedOperationException e) {
                    this.delete();
                }
            } else {
                out.seek(out.length());
            }
            if (ilength > 65535L) {
                buffer = new byte[65535];
                do {
                    in.read(buffer);
                    out.write(buffer);
                } while ((ilength -= 65535L) > 65535L);
            }
            buffer = new byte[(int)ilength];
            in.read(buffer);
            out.write(buffer);
            in.close();
            out.close();
        }
    }

    public String checksum() throws IOException {
        if (this.isFile()) {
            long value = 0L;
            long length = 0L;
            GeneralFileInputStream in = null;
            try {
                in = FileFactory.newFileInputStream(this);
                int n = 0;
                byte[] buffer = new byte[65535];
                while ((n = in.read(buffer)) > -1) {
                    int i = 0;
                    while (i < n) {
                        value += (long)(buffer[i] & 0xFF);
                        ++length;
                        ++i;
                    }
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            this.length();
            long sigh = (value & 0xFFFFL) + ((value & 0xFFFFFFFFFFFFFFFFL) >> 16 & 0xFFFFL);
            value = (sigh & 0xFFFFL) + (sigh >> 16);
            return "" + value;
        }
        return null;
    }

    public boolean canRead() {
        throw new UnsupportedOperationException();
    }

    public boolean canWrite() {
        throw new UnsupportedOperationException();
    }

    public int compareTo(GeneralFile pathName) {
        throw new UnsupportedOperationException();
    }

    public int compareTo(Object o) throws ClassCastException {
        throw new UnsupportedOperationException();
    }

    public boolean createNewFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    public static GeneralFile createTempFile(String prefix, String suffix) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static GeneralFile createTempFile(String prefix, String suffix, GeneralFile directory) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public void deleteOnExit() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean exists() {
        throw new UnsupportedOperationException();
    }

    public GeneralFile getAbsoluteFile() {
        throw new UnsupportedOperationException();
    }

    public String getAbsolutePath() {
        throw new UnsupportedOperationException();
    }

    public GeneralFile getCanonicalFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getCanonicalPath() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.fileName;
    }

    public String getParent() {
        throw new UnsupportedOperationException();
    }

    public GeneralFile getParentFile() {
        throw new UnsupportedOperationException();
    }

    public String getPath() {
        throw new UnsupportedOperationException();
    }

    public boolean isAbsolute() {
        throw new UnsupportedOperationException();
    }

    public boolean isDirectory() {
        throw new UnsupportedOperationException();
    }

    public boolean isFile() {
        throw new UnsupportedOperationException();
    }

    public boolean isHidden() {
        throw new UnsupportedOperationException();
    }

    public long lastModified() {
        throw new UnsupportedOperationException();
    }

    public long length() {
        throw new UnsupportedOperationException();
    }

    public String[] list() {
        throw new UnsupportedOperationException();
    }

    public String[] list(MetaDataCondition[] conditions) {
        throw new UnsupportedOperationException();
    }

    public GeneralFile[] listFiles() {
        String[] list = this.list();
        if (list == null) {
            return null;
        }
        int length = list.length;
        GeneralFile[] files = new GeneralFile[length];
        int i = 0;
        while (i < length) {
            files[i] = FileFactory.newFile(this, list[i]);
            ++i;
        }
        return files;
    }

    public static GeneralFile[] listRoots() {
        throw new UnsupportedOperationException();
    }

    public boolean mkdir() {
        throw new UnsupportedOperationException();
    }

    public boolean mkdirs() {
        throw new UnsupportedOperationException();
    }

    public boolean renameTo(GeneralFile dest) throws IllegalArgumentException, NullPointerException {
        throw new UnsupportedOperationException();
    }

    public boolean setLastModified(long time) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public boolean setReadOnly() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getPath();
    }

    public URI toURI() {
        throw new UnsupportedOperationException();
    }

    public URL toURL() throws MalformedURLException {
        throw new UnsupportedOperationException();
    }
}

