/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import java.io.IOException;
import java.util.Vector;

public abstract class MetaDataRecordList {
    protected MetaDataField[] fields;
    protected Object[] records;

    protected MetaDataRecordList(MetaDataField[] fields, Object[] recordValues) {
        if (fields == null) {
            throw new NullPointerException("fields cannot be null");
        }
        int fieldsLength = fields.length;
        if (fieldsLength != recordValues.length) {
            throw new IllegalArgumentException();
        }
        this.fields = fields;
        this.records = new Object[fieldsLength];
        System.arraycopy(recordValues, 0, this.records, 0, recordValues.length);
    }

    public MetaDataRecordList(MetaDataField field, int recordValue) {
        if (field == null) {
            throw new NullPointerException("field cannot be null");
        }
        this.fields = new MetaDataField[1];
        this.fields[0] = field;
        this.records = new Object[1];
        this.records[0] = new Integer(recordValue);
    }

    public MetaDataRecordList(MetaDataField field, float recordValue) {
        if (field == null) {
            throw new NullPointerException("field cannot be null");
        }
        this.fields = new MetaDataField[1];
        this.fields[0] = field;
        this.records = new Object[1];
        this.records[0] = new Float(recordValue);
    }

    public MetaDataRecordList(MetaDataField field, String recordValue) {
        if (field == null) {
            throw new NullPointerException("field cannot be null");
        }
        this.fields = new MetaDataField[1];
        this.fields[0] = field;
        this.records = new Object[1];
        this.records[0] = recordValue;
    }

    public MetaDataRecordList(MetaDataField field, MetaDataTable recordValue) {
        if (field == null) {
            throw new NullPointerException("field cannot be null");
        }
        this.fields = new MetaDataField[1];
        this.fields[0] = field;
        this.records = new Object[1];
        this.records[0] = recordValue;
    }

    protected void finalize() {
        if (this.records != null) {
            this.records = null;
        }
        if (this.fields != null) {
            this.fields = null;
        }
    }

    public int getFieldCount() {
        if (this.fields != null) {
            return this.fields.length;
        }
        return -1;
    }

    public MetaDataField[] getFields() {
        return this.fields;
    }

    public MetaDataField getField(int index) {
        if (this.fields != null) {
            return this.fields[index];
        }
        return null;
    }

    public String getFieldName(int index) {
        if (this.fields != null && index < this.fields.length) {
            return this.fields[index].getName();
        }
        return null;
    }

    public int getFieldType(int index) {
        if (this.fields != null) {
            return this.fields[index].getType();
        }
        return -1;
    }

    public int getFieldIndex(String fieldName) {
        if (this.fields != null && fieldName != null) {
            int i = 0;
            while (i < this.fields.length) {
                if (this.fields[i].getName().equals(fieldName)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int getRecordCount() {
        if (this.records != null) {
            return this.records.length;
        }
        return -1;
    }

    public int getIntValue(int index) {
        if (this.records == null) {
            throw new NullPointerException();
        }
        if (this.records[index] == null) {
            throw new NullPointerException("Value at index is null.");
        }
        if (this.records[index] instanceof MetaDataTable) {
            throw new IllegalArgumentException("Value at this index is a table.");
        }
        if (this.records[index] instanceof Integer) {
            return (Integer)this.records[index];
        }
        if (this.records[index] instanceof Float) {
            return ((Float)this.records[index]).intValue();
        }
        return Integer.parseInt(this.records[index].toString());
    }

    public float getFloatValue(int index) {
        if (this.records == null) {
            throw new NullPointerException();
        }
        if (this.records[index] == null) {
            throw new NullPointerException("Value at index is null.");
        }
        if (this.records[index] instanceof MetaDataTable) {
            throw new IllegalArgumentException("Value at this index is a table.");
        }
        if (this.records[index] instanceof Integer) {
            return ((Integer)this.records[index]).floatValue();
        }
        if (this.records[index] instanceof Float) {
            return ((Float)this.records[index]).floatValue();
        }
        return Float.parseFloat(this.records[index].toString());
    }

    public String getStringValue(int index) {
        if (this.records == null) {
            throw new NullPointerException();
        }
        if (this.records[index] == null) {
            return null;
        }
        if (this.records[index] instanceof MetaDataTable) {
            throw new IllegalArgumentException("Value at this index is a table.");
        }
        if (this.records[index] instanceof Integer) {
            return this.records[index].toString();
        }
        if (this.records[index] instanceof Float) {
            return this.records[index].toString();
        }
        return this.records[index].toString();
    }

    public MetaDataTable getTableValue(int index) {
        if (this.records == null) {
            throw new NullPointerException();
        }
        if (this.records[index] == null) {
            return null;
        }
        if (this.records[index] instanceof MetaDataTable) {
            try {
                return (MetaDataTable)this.records[index];
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    Object[] getAllValues() {
        return this.records;
    }

    public Object getValue(int index) {
        return this.records[index];
    }

    public Object getValue(MetaDataField field) {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].equals(field)) {
                return this.records[i];
            }
            ++i;
        }
        return null;
    }

    public Object getValue(String field) {
        return this.getValue(MetaDataSet.getField(field));
    }

    public void setValue(int index, int value) throws ArrayIndexOutOfBoundsException {
        int fieldType = this.fields[index].getType();
        if (fieldType == 2) {
            this.records[index] = new Float(value);
        } else if (fieldType == 3) {
            this.records[index] = new Integer(value).toString();
        } else {
            if (fieldType == 14) {
                throw new IllegalArgumentException(this.fields[index] + " only accepts MetaDataTable values.");
            }
            this.records[index] = new Integer(value);
        }
    }

    public void setValue(int index, float value) throws ArrayIndexOutOfBoundsException {
        int fieldType = this.fields[index].getType();
        if (fieldType == 0) {
            this.records[index] = new Integer((int)value);
        } else if (fieldType == 3) {
            this.records[index] = new Float(value).toString();
        } else {
            if (fieldType == 14) {
                throw new IllegalArgumentException(this.fields[index] + " only accepts MetaDataTable values.");
            }
            this.records[index] = new Float(value);
        }
    }

    public void setValue(int index, String value) throws ArrayIndexOutOfBoundsException {
        int fieldType = this.fields[index].getType();
        if (fieldType == 0) {
            this.records[index] = new Integer(value);
        } else if (fieldType == 2) {
            this.records[index] = new String(value);
        } else {
            if (fieldType == 14) {
                throw new IllegalArgumentException(this.fields[index] + " only accepts MetaDataTable values.");
            }
            this.records[index] = value;
        }
    }

    public void setValue(int index, MetaDataTable value) throws ArrayIndexOutOfBoundsException {
        int fieldType = this.fields[index].getType();
        if (fieldType != 14) {
            throw new IllegalArgumentException(this.fields[index] + " does not accept MetaDataTable values.");
        }
        this.records[index] = value;
    }

    public boolean setValue(MetaDataField field, int value) throws ArrayIndexOutOfBoundsException {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].equals(field)) {
                this.setValue(i, value);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean setValue(MetaDataField field, float value) throws ArrayIndexOutOfBoundsException {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].equals(field)) {
                this.setValue(i, value);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean setValue(MetaDataField field, String value) throws ArrayIndexOutOfBoundsException {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].equals(field)) {
                this.setValue(i, value);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean setValue(MetaDataField field, MetaDataTable value) throws ArrayIndexOutOfBoundsException {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].equals(field)) {
                this.setValue(i, value);
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean addRecord(MetaDataField field, Object recordValue) {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].equals(field)) {
                this.records[i] = recordValue;
                return false;
            }
            ++i;
        }
        MetaDataField[] tempFields = this.fields;
        Object[] tempRecords = this.records;
        int tempLength = tempFields.length;
        this.fields = new MetaDataField[tempLength + 1];
        System.arraycopy(tempFields, 0, this.fields, 0, tempLength);
        this.fields[tempLength] = field;
        this.records = new Object[tempLength + 1];
        System.arraycopy(tempRecords, 0, this.records, 0, tempLength);
        this.records[tempLength] = recordValue;
        return true;
    }

    public void addRecord(MetaDataField field, int recordValue) {
        this.addRecord(field, new Integer(recordValue));
        this.setValue(field, recordValue);
    }

    public void addRecord(MetaDataField field, float recordValue) {
        this.addRecord(field, new Float(recordValue));
        this.setValue(field, recordValue);
    }

    public void addRecord(MetaDataField field, String recordValue) {
        this.addRecord(field, (Object)recordValue);
        this.setValue(field, recordValue);
    }

    public void addRecord(MetaDataField field, MetaDataTable recordValue) {
        if (field.getType() != 14) {
            throw new IllegalArgumentException(field + " only accepts MetaDataTable values.");
        }
        this.addRecord(field, (Object)recordValue);
    }

    public void removeRecord(int index) {
        MetaDataField[] tempFields = this.fields;
        Object[] tempRecords = this.records;
        this.fields = new MetaDataField[tempFields.length - 1];
        this.records = new Object[tempRecords.length - 1];
        if (index > 0) {
            System.arraycopy(tempFields, 0, this.fields, 0, index);
            System.arraycopy(tempRecords, 0, this.records, 0, index);
        }
        System.arraycopy(tempFields, index + 1, this.fields, index, tempFields.length - 1 - index);
        System.arraycopy(tempRecords, index + 1, this.records, index, tempRecords.length - 1 - index);
    }

    public void removeRecord(MetaDataField field) {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].equals(field)) {
                this.removeRecord(i);
            }
            ++i;
        }
    }

    public abstract boolean isQueryComplete();

    public abstract MetaDataRecordList[] getMoreResults() throws IOException;

    public abstract MetaDataRecordList[] getMoreResults(int var1) throws IOException;

    public static MetaDataRecordList[] getAllResults(MetaDataRecordList[] rl) throws IOException {
        int i;
        if (rl == null) {
            return null;
        }
        if (rl[rl.length - 1].isQueryComplete()) {
            return rl;
        }
        Vector<MetaDataRecordList> recordLists = new Vector<MetaDataRecordList>();
        while (!rl[rl.length - 1].isQueryComplete()) {
            i = 0;
            while (i < rl.length) {
                recordLists.add(rl[i]);
                ++i;
            }
            rl = rl[rl.length - 1].getMoreResults();
        }
        i = 0;
        while (i < rl.length) {
            recordLists.add(rl[i]);
            ++i;
        }
        return recordLists.toArray(rl);
    }

    public String toString() {
        int length = this.getRecordCount();
        String value = "Total records: " + length + "\n";
        int i = 0;
        while (i < length) {
            value = this.records[i] != null ? String.valueOf(value) + this.getFieldName(i) + ": " + this.records[i].toString() + "\n" : String.valueOf(value) + this.getFieldName(i) + ": null\n";
            ++i;
        }
        return value;
    }
}

