/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.MetaDataCondition;
import java.lang.reflect.Array;
import java.util.Vector;

public class MetaDataTable {
    private Vector values;
    private Vector operators;

    public MetaDataTable(int[] operators, String[][] values) {
        if (values == null || operators == null) {
            throw new NullPointerException("Values and operators cannot be null.");
        }
        if (operators.length != values.length) {
            throw new IllegalArgumentException("Values and operators must have equal length");
        }
        if (values.length <= 0) {
            throw new IllegalArgumentException("No values were given.");
        }
        this.values = new Vector(values.length);
        this.operators = new Vector(operators.length);
        int i = 0;
        while (i < values.length) {
            this.addRow(values[i], operators[i]);
            ++i;
        }
    }

    public void setStringValue(int i, int j, String value) {
        Object row = this.values.get(i);
        Array.set(row, j, value);
        this.values.set(i, row);
    }

    public int[] getOperators() {
        int[] temp = new int[this.operators.size()];
        int i = 0;
        while (i < temp.length) {
            temp[i] = (Integer)this.operators.get(i);
            ++i;
        }
        return temp;
    }

    public int getOperator(int index) {
        return (Integer)this.operators.get(index);
    }

    public int getIntValue(int row, int column) {
        String[] temp = (String[])this.values.get(row);
        String value = temp[column];
        if (row >= this.getRowCount() || column >= this.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        if (row < 0 || column < 0) {
            throw new IllegalArgumentException();
        }
        return Integer.parseInt(value.toString());
    }

    public float getFloatValue(int row, int column) {
        String[] temp = (String[])this.values.get(row);
        String value = temp[column];
        if (row >= this.getRowCount() || column >= this.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        if (row < 0 || column < 0) {
            throw new IllegalArgumentException();
        }
        return Float.parseFloat(value.toString());
    }

    public String getStringValue(int row, int column) {
        String[] temp = (String[])this.values.get(row);
        String value = temp[column];
        if (row >= this.getRowCount() || column >= this.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        if (row < 0 || column < 0) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    public int getRowCount() {
        return this.values.size();
    }

    public int getColumnCount() {
        return ((String[])this.values.get(0)).length;
    }

    private void setOperator(int operator, String[] values) {
        if (operator < 0 || operator > 13) {
            throw new IllegalArgumentException("Invalid operator.");
        }
        this.operators.add(new Integer(operator));
    }

    public void addRow(String[] values, int operator) {
        if (values == null) {
            throw new NullPointerException("Values array cannot be null");
        }
        this.setOperator(operator, values);
        this.values.add(values);
    }

    public void removeRow(int index) {
        this.values.remove(index);
        this.operators.remove(index);
    }

    public String toString() {
        String value = "";
        int i = 0;
        while (i < this.getRowCount()) {
            value = String.valueOf(value) + "\n";
            value = String.valueOf(value) + this.getStringValue(i, 0) + " " + MetaDataCondition.getOperatorString(this.getOperator(i)) + " ";
            int j = 1;
            while (j < this.getColumnCount()) {
                value = String.valueOf(value) + this.getStringValue(i, j) + "\t";
                ++j;
            }
            ++i;
        }
        return value;
    }

    public boolean equals(Object obj) {
        MetaDataTable table = null;
        if (obj == null) {
            return false;
        }
        try {
            table = (MetaDataTable)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (table.getRowCount() == this.getRowCount() && table.getColumnCount() == this.getColumnCount()) {
            int i = 0;
            while (i < this.getRowCount()) {
                int j = 0;
                while (j < this.getColumnCount()) {
                    if (!this.getStringValue(i, j).equals(table.getStringValue(i, j))) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

