/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.local;

import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.local.LocalAccount;
import edu.sdsc.grid.io.local.LocalFile;
import java.io.IOException;

public class LocalFileSystem
extends GeneralFileSystem {
    static final int DEFAULT_RECORDS_WANTED = 300;

    public LocalFileSystem() {
        this(new LocalAccount());
    }

    public LocalFileSystem(LocalAccount localAccount) {
        this.account = localAccount == null ? new LocalAccount() : (LocalAccount)localAccount.clone();
    }

    protected void setAccount(GeneralAccount account) {
        if (account == null) {
            account = new LocalAccount();
        } else {
            this.account = (LocalAccount)account.clone();
        }
    }

    public String[] getRootDirectories() {
        GeneralFile[] roots = LocalFile.listRoots();
        String[] rootStrings = new String[roots.length];
        int i = 0;
        while (i < roots.length) {
            rootStrings[i] = roots[i].toString();
            ++i;
        }
        return rootStrings;
    }

    public MetaDataRecordList[] query(MetaDataCondition[] conditions, MetaDataSelect[] selects) throws IOException {
        throw new UnsupportedOperationException();
    }

    public MetaDataRecordList[] query(MetaDataCondition[] conditions, MetaDataSelect[] selects, int recordsWanted) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            LocalFileSystem temp = (LocalFileSystem)obj;
            if (this.getAccount().equals(temp.getAccount())) {
                return true;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return false;
    }
}

