/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.Host;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.local.LocalRandomAccessFile;
import edu.sdsc.grid.io.srb.GSIAuth;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataCommands;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;

class SRBCommands {
    static int DEBUG = 0;
    static final char STATUS_OK = '\u0000';
    public static final int CHAR_LENGTH = 2;
    public static final int SHORT_LENGTH = 2;
    public static final int INT_LENGTH = 4;
    public static final int LONG_LENGTH = 8;
    private static final int ERROR_MSG_LENGTH = 4096;
    private static final String STARTUP_HEADER = "START SRB\u0000";
    static final int OUTPUT_BUFFER_LENGTH = 65535;
    private static final int ENCRYPT1_MESSAGE_SIZE = 64;
    private static final int OPR_COMMAND = 1;
    private static final int F_E_CREATE = 1000;
    private static final int F_E_OPEN = 1001;
    private static final int F_E_CLOSE = 1002;
    private static final int F_E_UNLINK = 1003;
    private static final int F_E_READ = 1004;
    private static final int F_E_WRITE = 1005;
    private static final int F_E_SEEK = 1006;
    private static final int F_E_SYNC = 1007;
    private static final int F_E_STAT = 1008;
    private static final int F_E_MKDIR = 1009;
    private static final int F_E_CHMOD = 1010;
    private static final int F_E_RMDIR = 1011;
    private static final int F_E_OPENDIR = 1012;
    private static final int F_E_READDIR = 1013;
    private static final int F_E_CLOSEDIR = 1014;
    private static final int F_E_SETSTORATTRI = 1015;
    private static final int F_E_MIGRATE = 1016;
    private static final int F_E_STAGE = 1017;
    private static final int F_E_PURGE = 1018;
    private static final int F_E_FSTAT = 1019;
    private static final int F_E_CHKSUM = 1020;
    private static final int F_E_GET_FS_FREESPACE = 1021;
    private static final int F_E_FSTAGE = 1022;
    private static final int F_E_LOCK_RANGE = 1023;
    private static final int F_E_CHOWN = 1024;
    private static final int F_E_VAULT_INFO = 1050;
    private static final int F_GET_SVR_VER = 1051;
    private static final int F_SRBO_CREATE = 2000;
    private static final int F_SRBO_OPEN = 2001;
    private static final int F_SRBO_CLOSE = 2002;
    private static final int F_SRBO_UNLINK = 2003;
    private static final int F_SRBO_READ = 2004;
    private static final int F_SRBO_WRITE = 2005;
    private static final int F_SRBO_SEEK = 2006;
    private static final int F_SRBO_SYNC = 2007;
    private static final int F_SRBO_STAT = 2008;
    private static final int F_SRBO_REPLICATE = 2009;
    private static final int F_SRBO_MOVE = 2010;
    private static final int F_SRBO_PROXY_OPR = 2011;
    private static final int F_SRBO_GET_DENTS = 2012;
    private static final int F_SRBO_GET_DENTS64 = 2013;
    private static final int F_SRBC_SEEK = 2014;
    private static final int F_SRBO_CHKSUM = 2015;
    private static final int F_SRBO_LOCK_RANGE = 2016;
    private static final int F_SRBO_PROC = 2017;
    private static final int F_SRBO_GET_LOID_INFO = 2100;
    static final int F_SRBO_GET_DATADIR_INFO = 2101;
    private static final int F_SRBO_REGISTER_FILE = 2102;
    private static final int F_SRBO_MODIFY_FILE = 2103;
    private static final int F_CHK_MDAS_AUTH = 2104;
    private static final int F_CREATE_DIRECTORY = 2105;
    private static final int F_LIST_DIRECTORY = 2106;
    private static final int F_MODIFY_DIRECTORY = 2107;
    private static final int F_CHK_MDAS_SYS_AUTH = 2108;
    private static final int F_REGISTER_USER_GROUP = 2109;
    private static final int F_REGISTER_USER = 2110;
    private static final int F_MODIFY_USER = 2111;
    private static final int F_SET_AUDIT_TRAIL = 2112;
    private static final int F_SRBO_AUDIT = 2113;
    private static final int F_REGISTER_REPLICA = 2114;
    private static final int F_GET_PRIV_USERS = 2115;
    private static final int F_GET_MORE_ROWS = 2116;
    private static final int F_ISSUE_TICKET = 2117;
    private static final int F_REMOVE_TICKET = 2118;
    private static final int F_UNREGISTER_FILE = 2119;
    private static final int F_CONTAINER_CREATE = 2120;
    private static final int F_REGISTER_CONTAINER = 2121;
    private static final int F_REGISTER_IN_CONTAINER = 2122;
    private static final int F_GET_CONTAINER_INFO = 2123;
    private static final int F_GET_RESC_ON_CHOICE = 2124;
    private static final int F_REMOVE_CONTAINER = 2125;
    private static final int F_SYNC_CONTAINER = 2126;
    private static final int F_REPLICATION_CONTAINER = 2127;
    private static final int F_CHK_ENCRYPT1_AUTH = 2128;
    private static final int F_SRBO_LOCK = 2129;
    private static final int F_CONTAINER_OPEN = 2130;
    private static final int F_CONTAINER_CLOSE = 2131;
    private static final int F_FILE_COPY = 2132;
    private static final int F_SRBO_COPY = 2133;
    private static final int F_FILE_PUT = 2134;
    private static final int F_SRBO_PUT = 2135;
    private static final int F_FILE_GET = 2136;
    private static final int F_SRBO_GET = 2137;
    private static final int F_BULK_REGISTER = 2138;
    private static final int F_SRBO_SYNC_DATA = 2139;
    private static final int F_MOD_RESC_INFO = 2140;
    private static final int F_SRBO_REG_FILE_INT = 2141;
    private static final int F_REGISTER_LOCATION = 2142;
    private static final int F_INGEST_TOKEN = 2143;
    private static final int F_REGISTER_RESOURCE = 2144;
    private static final int F_REGISTER_LOGICAL_RESOURCE = 2145;
    private static final int F_REGISTER_REPLICATE_RESOURCE_INFO = 2146;
    private static final int F_DELETE_VALUE = 2147;
    private static final int F_SETUP_SESSION = 2148;
    private static final int F_SETUP_SESSION_PUBLIC_KEY = 2149;
    private static final int F_BULK_LOAD = 2150;
    private static final int F_GET_MCAT_NAME = 2151;
    private static final int F_MODIFY_ZONE = 2152;
    private static final int F_BULK_QUERY_ANSWER = 2153;
    private static final int F_BULK_MCAT_INGEST = 2154;
    static final int F_GEN_QUERY = 2155;
    private static final int F_BULK_UNLOAD = 2156;
    private static final int F_GEN_GET_MORE_ROWS = 2157;
    private static final int F_BULK_UNLOAD_C = 2158;
    private static final int F_BACKUP_DATA = 2159;
    private static final int F_REMOVE_TICKET_WITH_ZONE = 2160;
    private static final int F_MODIFY_USER_NP = 2161;
    private static final int F_MODIFY_RESOURCE = 2162;
    private static final int F_SRBO_GET_C = 2163;
    private static final int F_DATA_GET_C = 2164;
    private static final int F_SRBO_PUT_C = 2165;
    private static final int F_DATA_PUT_C = 2166;
    private static final int F_SRBO_FSTAGE = 2167;
    private static final int F_MODIFY_EXT_META_DATA = 2168;
    private static final int F_GET_USER_BY_DN = 2169;
    private static final int F_GET_HOST_CONFIG = 2200;
    private static final int F_DB_LOBJ_CREATE = 3000;
    private static final int F_DB_LOBJ_OPEN = 3001;
    private static final int F_DB_LOBJ_CLOSE = 3002;
    private static final int F_DB_LOBJ_READ = 3004;
    private static final int F_DB_LOBJ_WRITE = 3005;
    private static final int F_DB_LOBJ_SEEK = 3006;
    private static final int F_DB_LOBJ_UNLINK = 3007;
    private static final int F_DB_TABLE_CREATE = 4000;
    private static final int F_DB_TABLE_OPEN = 4001;
    private static final int F_DB_TABLE_CLOSE = 4002;
    private static final int F_DB_TABLE_READ = 4004;
    private static final int F_DB_TABLE_WRITE = 4005;
    private static final int F_DB_TABLE_SEEK = 4006;
    private static final int F_DB_TABLE_UNLINK = 4007;
    private static final int F_TAPELIB_MNT_CART = 5000;
    private static final int F_TAPELIB_DISMNT_CART = 5001;
    private static final int F_TAPELIB_GET_CART_PRI = 5002;
    private static final int F_CMP_DUMP_FILE_LIST = 5100;
    private static final int F_CMP_STAGE_COMP_OBJ = 5101;
    private static final int F_CMP_REG_INT_COMP_OBJ = 5102;
    private static final int F_CMP_RM_INT_COMP_OBJ = 5103;
    private static final int F_CMP_RM_COMP_OBJ = 5104;
    private static final int F_CMP_MOD_INT_COMP_OBJ = 5105;
    private static final int F_MDRIVER_CREATE = 6000;
    private static final int F_MDRIVER_OPEN = 6001;
    private static final int F_MDRIVER_CLOSE = 6002;
    private static final int F_MDRIVER_READ = 6004;
    private static final int F_MDRIVER_WRITE = 6005;
    private static final int F_MDRIVER_SEEK = 6006;
    private static final int F_MDRIVER_UNLINK = 6007;
    private static final int F_MDRIVER_SYNC = 6008;
    private static final int F_MDRIVER_PROC = 6009;
    private static final int NEW_PORTLIST = 888888;
    private static final int F_DUMMY = 999999;
    static final int MSG_USE_SINGLE_PORT = -99999999;
    static boolean singleServerPort;
    private Socket srbConnection;
    private InputStream in = null;
    private OutputStream out = null;
    private byte[] outputBuffer = new byte[65535];
    private int outputOffset = 0;
    private String password;
    private int passwordOption;
    private String certAuth;
    private Object gssCredential;
    private String zone;
    float versionNumber;
    int srbGetDataDirInfoCount = 0;
    long totalBytesMoved = 0L;
    long bytesMoved = 0L;
    long srcLength;
    static final int MAX_THREADS = 32;
    static final int READ = 1;
    static final int WRITE = 2;
    static final int PUT = 3;
    static final int GET = 4;
    static final int DONE = 0;
    boolean singlePortBulkUnload = false;

    static {
        try {
            DEBUG = new Integer(System.getProperty("jargon.debug", "0"));
        }
        catch (NumberFormatException e) {
            DEBUG = 0;
        }
        singleServerPort = false;
    }

    SRBCommands() throws IOException {
    }

    protected void finalize() throws IOException {
        if (this.outputBuffer != null) {
            this.outputBuffer = null;
        }
        this.close();
        if (this.out != null) {
            this.out = null;
        }
        if (this.in != null) {
            this.in = null;
        }
        if (this.srbConnection != null) {
            this.srbConnection = null;
        }
    }

    int connect(SRBAccount account, byte[] userInfoBuffer) throws IOException {
        int status = -1;
        String host = account.getHost();
        int port = account.getPort();
        this.versionNumber = SRBAccount.getVersionNumber();
        this.zone = account.getMcatZone();
        if (DEBUG > 1) {
            System.out.println("Connecting to master server, " + host + ":" + port + " version: " + this.versionNumber);
        }
        this.openSocket(host, port);
        this.send(STARTUP_HEADER.getBytes());
        this.flush();
        if ((double)this.versionNumber >= 3.3) {
            byte[] temp = this.read(4);
            port = Host.castToInt(temp);
            if (port == 0) {
                temp = this.read(4);
                port = Host.castToInt(temp);
            }
        } else {
            byte[] temp = this.read(4);
            port = Host.castToInt(temp);
        }
        if (port < 0) {
            this.close();
            throw new ProtocolException("connect() -- couldn't read port number: " + port);
        }
        if (port > 0) {
            this.close();
            if (DEBUG > 1) {
                System.out.println("Connecting to srbServer:" + port);
            }
            this.openSocket(host, port);
        } else if (DEBUG > 1) {
            System.out.println("Connecting to srbServer through srbMaster server.");
        }
        return this.sendUserInfo(account, userInfoBuffer, port);
    }

    int sendUserInfo(SRBAccount account, byte[] userInfoBuffer, int port) throws IOException {
        int status = -1;
        this.send(userInfoBuffer);
        this.flush();
        byte[] temp = this.read(4);
        status = Host.castToInt(temp);
        if (status < 0) {
            this.close();
            return status;
        }
        this.outputBuffer = new byte[65535];
        if (DEBUG > 1) {
            System.out.println("Sending password...");
        }
        this.password = account.getPassword();
        this.passwordOption = account.getOptions();
        switch (this.passwordOption) {
            case 48: {
                this.send(this.password);
                break;
            }
            case 51: {
                this.certAuth = account.getCertificateAuthority();
                this.gssCredential = account.getGSSCredential();
                new GSIAuth(this.password, this.gssCredential, this.certAuth, this.srbConnection, this.out, this.in);
                break;
            }
            case 54: {
                this.certAuth = account.getCertificateAuthority();
                this.gssCredential = account.getGSSCredential();
                new GSIAuth(this.password, this.gssCredential, this.certAuth, this.srbConnection, this.out, this.in);
                break;
            }
            case 53: {
                this.sendEncrypt1Auth(this.password);
                break;
            }
            default: {
                this.send(this.password);
            }
        }
        this.flush();
        temp = this.read(4);
        status = Host.castToInt(temp);
        boolean versionChange = SRBAccount.internalSetVersion(this.srbGetSvrVersion());
        this.versionNumber = SRBAccount.getVersionNumber();
        if (status == -1004 || status == -1005 || status == -1006 || status == -1017) {
            SRBException e = new SRBException("connect() -- couldn't connect to SRB. ", status);
            throw new SecurityException(String.valueOf(e.getMessage()) + e.getStandardMessage());
        }
        if (status < 0) {
            this.close();
            throw new SRBException("connect() -- couldn't connect to SRB. ", status);
        }
        if (versionChange) {
            return -1118;
        }
        if (DEBUG > 1) {
            System.out.println("Successful connection.");
        }
        return port;
    }

    synchronized void close() throws IOException {
        if (this.isConnected()) {
            this.out.write(new String("X").getBytes());
            this.out.close();
            this.in.close();
            this.srbConnection.close();
        }
    }

    void sendEncrypt1Auth(String password) throws IOException {
        int status = -1;
        int readBytes = -1;
        int writeBytes = -1;
        long seed = 0L;
        long seed2 = 0L;
        long maxValue = 64L;
        double maxValueDouble = 2.6035084875658576;
        long[] hashPassword = new long[2];
        long[] hashInitialMessage = new long[2];
        byte[] encryptedMessage = new byte[64];
        int[] initialMessage = new int[63];
        int i = 0;
        while (i < initialMessage.length) {
            initialMessage[i] = this.in.read();
            ++i;
        }
        this.read(1);
        if (password != null) {
            int[] passwordInts = new int[password.length()];
            byte[] passwordBytes = password.getBytes();
            int i2 = 0;
            while (i2 < passwordInts.length) {
                passwordInts[i2] = passwordBytes[i2];
                ++i2;
            }
            SRBCommands.vHashString(hashPassword, passwordInts);
            SRBCommands.vHashString(hashInitialMessage, initialMessage);
            maxValue = 0x3FFFFFFFL;
            maxValueDouble = maxValue;
            seed = (hashPassword[0] ^ hashInitialMessage[0]) % maxValue;
            seed2 = (hashPassword[1] ^ hashInitialMessage[1]) % maxValue;
            i2 = 0;
            while (i2 < initialMessage.length) {
                seed = (seed * 3L + seed2) % maxValue;
                seed2 = (seed + seed2 + 33L) % maxValue;
                encryptedMessage[i2] = (byte)(Math.floor((double)seed / maxValueDouble * 31.0) + 64.0);
                ++i2;
            }
        }
        this.send(encryptedMessage, 0, encryptedMessage.length);
        if (writeBytes != 64 && DEBUG > 1) {
            System.out.println("bytes written," + writeBytes + " != ENCRYPT1_MESSAGE_SIZE," + 64);
        }
    }

    static void vHashString(long[] result, int[] password) {
        long nr = 1345345333L;
        long add = 7L;
        long nr2 = 305419889L;
        int i = 0;
        while (i < password.length) {
            int currentValue = password[i];
            long temp = nr << 8;
            long UNSIGNED_INT_MAX = 0x100000000L;
            if (temp > UNSIGNED_INT_MAX) {
                temp = (int)temp;
            }
            if (temp < -UNSIGNED_INT_MAX) {
                temp = UNSIGNED_INT_MAX + temp;
            }
            if ((nr ^= ((nr & 0x3FL) + add) * (long)currentValue + temp) < 0L) {
                nr = UNSIGNED_INT_MAX + nr;
            }
            if ((temp = nr2 << 8) > UNSIGNED_INT_MAX) {
                temp = (int)temp;
            }
            if (temp < 0L) {
                temp = UNSIGNED_INT_MAX + temp;
            }
            if ((nr2 += temp ^ nr) > UNSIGNED_INT_MAX) {
                nr2 = (int)nr2;
            }
            if (nr2 < 0L) {
                nr2 = UNSIGNED_INT_MAX + nr2;
            }
            add += (long)currentValue;
            ++i;
        }
        result[0] = nr & Integer.MAX_VALUE;
        result[1] = nr2 & Integer.MAX_VALUE;
    }

    String getZone() {
        return this.zone;
    }

    private void openSocket(String host, int port) throws IOException {
        try {
            this.srbConnection = new Socket(host, port);
            this.in = this.srbConnection.getInputStream();
            this.out = this.srbConnection.getOutputStream();
        }
        catch (ConnectException e) {
            ConnectException connException = new ConnectException("Connection cannot be made to: " + host + " at port: " + port);
            connException.initCause(e);
            throw connException;
        }
        catch (SocketException e) {
            SocketException socketException = new SocketException("A socket error occured when connecting to: " + host + " at port: " + port);
            socketException.initCause(e);
            throw socketException;
        }
    }

    boolean isConnected() {
        return this.srbConnection.isConnected() && !this.srbConnection.isClosed();
    }

    private void send(byte[] value) throws IOException {
        if (value.length + this.outputOffset >= 65535) {
            this.out.write(this.outputBuffer, 0, this.outputOffset);
            this.out.write(value);
            this.out.flush();
            this.outputOffset = 0;
        } else {
            System.arraycopy(value, 0, this.outputBuffer, this.outputOffset, value.length);
            this.outputOffset += value.length;
            if (DEBUG > 5) {
                System.out.print("Send: " + new String(value));
            }
        }
    }

    private void send(byte[] value, int offset, int length) throws IOException {
        byte[] temp = new byte[length];
        System.arraycopy(value, offset, temp, 0, length);
        this.send(temp);
    }

    private void send(String value) throws IOException {
        this.send(value.getBytes());
    }

    private void send(int value) throws IOException {
        byte[] bytes = new byte[4];
        Host.copyInt(value, bytes);
        Host.swap(bytes, 4);
        this.send(bytes);
    }

    private void send(long value) throws IOException {
        byte[] bytes = new byte[8];
        Host.copyLong(value, bytes);
        Host.swap(bytes, 8);
        this.send(bytes);
    }

    void flush() throws IOException {
        if (this.srbConnection.isClosed()) {
            throw new ClosedChannelException();
        }
        this.out.write(this.outputBuffer, 0, this.outputOffset);
        this.out.flush();
        this.outputOffset = 0;
    }

    private byte read() throws IOException {
        return (byte)this.in.read();
    }

    /*
     * Unable to fully structure code
     */
    private byte[] read(int length) throws ClosedChannelException, InterruptedIOException, IOException {
        if (length <= 0) {
            return null;
        }
        value = new byte[length];
        try {
            block8: {
                maxReadSize = 1448;
                temp = 0;
                if (length <= maxReadSize) ** GOTO lbl16
                while (length > temp + maxReadSize - 1 && temp >= 0) {
                    temp += this.in.read(value, temp, maxReadSize);
                }
                while (length - temp - 1 > 0 && temp >= 0) {
                    temp += this.in.read(value, temp, length - temp);
                }
                break block8;
lbl-1000:
                // 1 sources

                {
                    temp += this.in.read(value, temp, length - temp);
lbl16:
                    // 2 sources

                    ** while (length - temp > 0 && temp >= 0)
                }
            }
            if (temp < 0) {
                throw new SocketException("SRB socket connection is closed.");
            }
        }
        catch (IOException e) {
            ioException = new IOException("read() -- couldn't read complete packet");
            ioException.initCause(e);
            throw ioException;
        }
        if (SRBCommands.DEBUG > 5) {
            System.out.print("Read: " + new String(value));
        }
        return value;
    }

    private char readChar() throws IOException {
        byte[] b = this.read(2);
        Host.swap(b, 2);
        char value = (char)Host.castToShort(b);
        return value;
    }

    private short readShort() throws IOException {
        byte[] b = this.read(2);
        Host.swap(b, 2);
        short value = Host.castToShort(b);
        return value;
    }

    private int readInt() throws IOException {
        byte[] b = this.read(4);
        Host.swap(b, 4);
        int value = Host.castToInt(b);
        return value;
    }

    private long readUnsignedInt() throws IOException {
        long value = Host.castToUnsignedInt(this.read(4));
        return value;
    }

    private long readLong() throws IOException {
        byte[] b = this.read(8);
        Host.swap(b, 8);
        long value = Host.castToLong(b);
        return value;
    }

    private String readString() throws IOException {
        String value = "";
        byte b = this.read();
        while (b != 0) {
            value = String.valueOf(value) + (char)b;
            b = this.read();
        }
        return value;
    }

    private String readString(int length) throws IOException {
        String value = new String(this.read(length));
        return value;
    }

    private void status() throws IOException {
        byte[] status = this.read(1);
        if (status[0] < 0) {
            throw new SRBException("Unknown error received from server.");
        }
    }

    void startSRBCommand(int functionId, int nargs) throws IOException {
        String doFunction = "F \u0000";
        this.send(doFunction.getBytes());
        this.send(functionId);
        this.send(nargs);
    }

    void sendArg(int arg) throws IOException {
        this.send(4);
        this.send(arg);
    }

    void sendArg(long arg) throws IOException {
        this.send(8);
        this.send(arg);
    }

    void sendArg(String arg) throws IOException {
        if (arg == null) {
            this.send(new byte[4]);
        } else {
            this.send(arg.length());
            this.send(arg.getBytes());
        }
    }

    void sendArg(byte[] arg) throws IOException {
        if (arg == null) {
            this.send(new byte[4]);
        } else {
            this.send(arg.length);
            this.send(arg);
        }
    }

    void sendArg(byte[] arg, int length) throws IOException {
        if (arg == null) {
            this.send(new byte[4]);
        } else {
            this.send(length);
            this.send(arg, 0, length);
        }
    }

    void sendArg(byte[] arg, int offset, int length) throws IOException {
        if (arg == null) {
            this.send(new byte[4]);
        } else {
            this.send(length);
            this.send(arg, offset, length);
        }
    }

    void sendArg(int[] arg) throws IOException {
        this.send(arg.length * 4);
        int i = 0;
        while (i < arg.length) {
            this.send(arg[i]);
            ++i;
        }
    }

    void sendArg(char[][] arg) throws IOException {
        int argLength = arg.length * arg[0].length;
        byte[] byteArg = new byte[argLength];
        int k = 0;
        int i = 0;
        while (i < arg.length) {
            int j = 0;
            while (j < arg[i].length) {
                byteArg[k] = (byte)arg[i][j];
                ++k;
                ++j;
            }
            ++i;
        }
        this.send(argLength);
        this.send(byteArg);
    }

    void sendArg(SRBMetaDataRecordList[] rl) throws IOException {
        byte[] nullByte = new byte[1];
        String nll = new String(nullByte);
        boolean argLength = false;
        int result_count = rl[0].getFieldCount();
        byte[] result_count_bytes = new byte[4];
        Host.copyInt(result_count, result_count_bytes);
        int row_count = rl.length;
        byte[] row_count_bytes = new byte[4];
        Host.copyInt(row_count, row_count_bytes);
        String values = "";
        int continuation_index = 0;
        int i = 0;
        while (i < rl[0].getFieldCount()) {
            values = String.valueOf(values) + SRBMetaDataSet.getSRBTableName(rl[0].getFieldName(i)) + nll + SRBMetaDataSet.getSRBAttributeName(rl[0].getFieldName(i)) + nll;
            int j = 0;
            while (j < rl.length) {
                values = String.valueOf(values) + rl[j].getStringValue(i) + nll;
                ++j;
            }
            ++i;
        }
        byte[] extraRows = new byte[(100 - rl[0].getFieldCount()) * 2 * 3];
        extraRows[0] = 1;
        int i2 = 1;
        while (i2 < extraRows.length - 1) {
            extraRows[i2] = 0;
            extraRows[i2 + 1] = 1;
            i2 += 2;
        }
        this.send(12 + values.length() + extraRows.length + 4);
        this.send(0);
        this.send(result_count_bytes);
        this.send(row_count_bytes);
        this.send(values);
        this.send(extraRows);
        this.send(continuation_index);
        if (DEBUG > 2) {
            System.out.print("sendArg(rl): " + new String(result_count_bytes));
            System.out.println(new String(row_count_bytes));
            System.out.println(values);
            System.out.println(new String(extraRows));
            System.out.println(continuation_index);
        }
    }

    void commandStatus() throws IOException {
        byte[] resultBuffer = this.read(1);
        String exception = "\nThe SRB server returned an error: ";
        if ((char)resultBuffer[0] == 'A') {
            byte[] byArray = new byte[4];
            byArray[0] = (byte)this.passwordOption;
            byte[] asdf = byArray;
            this.out.write(asdf);
            switch (this.passwordOption) {
                case 48: {
                    this.send(this.password);
                    break;
                }
                case 51: {
                    new GSIAuth(this.password, this.gssCredential, this.certAuth, this.srbConnection, this.out, this.in);
                    break;
                }
                case 54: {
                    new GSIAuth(this.password, this.gssCredential, this.certAuth, this.srbConnection, this.out, this.in);
                    break;
                }
                case 53: {
                    this.sendEncrypt1Auth(this.password);
                    break;
                }
                default: {
                    this.send(this.password);
                }
            }
            this.commandStatus();
            return;
        }
        if ((char)resultBuffer[0] != 'V') {
            int exceptionType = -1;
            int bytesRead = 0;
            int maxErrorMsgs = 10;
            resultBuffer = new byte[4096 * maxErrorMsgs];
            boolean moreErrorMsg = true;
            block12: while (moreErrorMsg) {
                bytesRead = this.in.read(resultBuffer, 0, 4096 * maxErrorMsgs);
                if (bytesRead <= 0) break;
                int i = 0;
                while (i < bytesRead) {
                    if ((char)resultBuffer[i] == 'V') {
                        byte[] unsignedIntBuffer;
                        if (resultBuffer[i + 1] == 71) {
                            if (resultBuffer[i + 2] == 8) {
                                unsignedIntBuffer = new byte[]{resultBuffer[i + 6], resultBuffer[i + 7], resultBuffer[i + 8], resultBuffer[i + 9]};
                                Host.swap(unsignedIntBuffer, 4);
                                exceptionType = Host.castToInt(unsignedIntBuffer);
                                moreErrorMsg = false;
                                i = bytesRead;
                            } else {
                                unsignedIntBuffer = new byte[]{resultBuffer[i + 6], resultBuffer[i + 7], resultBuffer[i + 8], resultBuffer[i + 9]};
                                exceptionType = (int)Host.castToUnsignedInt(unsignedIntBuffer);
                                if (exceptionType > 0) {
                                    Host.swap(unsignedIntBuffer, 4);
                                    exceptionType = Host.castToInt(unsignedIntBuffer);
                                }
                                moreErrorMsg = false;
                                i = bytesRead;
                            }
                        } else {
                            if (resultBuffer[i - 1] == 0) {
                                unsignedIntBuffer = new byte[]{resultBuffer[i + 6], resultBuffer[i + 7], resultBuffer[i + 8], resultBuffer[i + 9]};
                                exceptionType = (int)Host.castToUnsignedInt(unsignedIntBuffer);
                                if (exceptionType > 0) {
                                    Host.swap(unsignedIntBuffer, 4);
                                    exceptionType = Host.castToInt(unsignedIntBuffer);
                                }
                                moreErrorMsg = false;
                                continue block12;
                            }
                            exception = String.valueOf(exception) + (char)resultBuffer[i];
                        }
                    } else {
                        exception = String.valueOf(exception) + (char)resultBuffer[i];
                    }
                    ++i;
                }
            }
            if (resultBuffer[bytesRead - 1] != 48) {
                this.status();
            }
            throw new SRBException(exception, exceptionType);
        }
        resultBuffer = this.read(1);
        switch ((char)resultBuffer[0]) {
            case 'G': {
                return;
            }
            case 'E': {
                throw new SRBException("SRB Server: returned an unknown error");
            }
            case 'N': {
                resultBuffer = new byte[4096];
                this.in.read(resultBuffer);
                if (resultBuffer.length == 1) {
                    throw new SRBException("Return detected, but error message cannot be read");
                }
                exception = new String(resultBuffer);
                throw new SRBException(exception);
            }
            case '0': {
                return;
            }
        }
        exception = "FATAL: SRB protocol error: ";
        exception = String.valueOf(exception) + new String(resultBuffer);
        throw new SRBException(exception);
    }

    private int returnInt() throws IOException {
        byte[] resultBuffer = this.read(1);
        int returnValue = -1;
        if (resultBuffer[0] > 4) {
            resultBuffer = this.read(resultBuffer[0] + 1);
            String exception = "The SRB server returned an error: ";
            exception = String.valueOf(exception) + new String(resultBuffer);
            throw new SRBException(exception);
        }
        resultBuffer = this.read(3);
        returnValue = this.readInt();
        this.status();
        return returnValue;
    }

    private long returnLong() throws IOException {
        byte[] resultBuffer = this.read(1);
        long returnValue = -1L;
        if (resultBuffer[0] > 8) {
            resultBuffer = this.read(resultBuffer[0] + 1);
            String exception = "The SRB server returned an error: ";
            exception = String.valueOf(exception) + new String(resultBuffer);
            throw new SRBException(exception);
        }
        resultBuffer = this.read(3);
        returnValue = this.readLong();
        this.status();
        return returnValue;
    }

    private byte[] returnBytes() throws IOException {
        byte[] resultBuffer = this.read(4);
        int resultLength = 0;
        int i = resultBuffer.length - 1;
        while (i >= 0) {
            resultLength = resultBuffer[i] < 0 ? (resultLength << 8) + 256 + resultBuffer[i] : (resultLength << 8) + resultBuffer[i];
            --i;
        }
        if (resultLength >= 4) {
            this.read(4);
            resultBuffer = this.read(resultLength -= 4);
            this.read(1);
            return resultBuffer;
        }
        String exception = "\nThe SRB server returned an error: ";
        exception = String.valueOf(exception) + (int)Host.castToUnsignedInt(this.read(4));
        this.read(1);
        throw new SRBException(exception);
    }

    SRBMetaDataRecordList[] returnSRBMetaDataRecordList(boolean newReturn) throws IOException {
        return this.returnSRBMetaDataRecordList(newReturn, false);
    }

    SRBMetaDataRecordList[] returnSRBMetaDataRecordList(boolean newReturn, boolean usePortalHeader) throws IOException {
        if (DEBUG > 2) {
            System.out.println("returnSRBMetaDataRecordList new");
        }
        if (!newReturn) {
            return this.returnSRBMetaDataRecordList();
        }
        int i = 0;
        int j = 0;
        int k = 0;
        boolean temp = false;
        if (this.singlePortBulkUnload) {
            this.read(4);
        }
        int bufferLength = usePortalHeader ? Host.castToInt(this.read(4)) : this.readInt();
        int status = (int)this.readUnsignedInt();
        if (usePortalHeader) {
            this.read(4);
        }
        if (status < 0) {
            if (DEBUG > 3) {
                System.out.println(status);
            }
            if (status == -3005) {
                this.read(1);
                return null;
            }
            String exception = "\nSRB server status: " + status;
            this.read(1);
            throw new SRBException(exception);
        }
        int fieldCount = (int)this.readUnsignedInt();
        int recordCount = (int)this.readUnsignedInt();
        int lengthVars = 16;
        if (usePortalHeader) {
            lengthVars += 7;
        }
        byte[] resultBuffer = this.read(bufferLength - lengthVars);
        if (usePortalHeader) {
            this.read(3);
        }
        byte[] b = this.read(4);
        short continuationIndex = (short)Host.castToInt(b);
        if (usePortalHeader) {
            this.read(7);
        }
        if (DEBUG > 2) {
            System.out.println("bufferLength " + bufferLength);
            System.out.println("status " + status);
            System.out.println("fieldCount " + fieldCount);
            System.out.println("recordCount " + recordCount);
            System.out.println("continuationIndex " + continuationIndex);
            System.out.println("resultBuffer " + resultBuffer.length);
            if (DEBUG > 4) {
                i = 0;
                while (i < resultBuffer.length) {
                    System.out.print(String.valueOf(i) + ":" + resultBuffer[i] + " " + (char)resultBuffer[i] + "   ");
                    if (resultBuffer[i] > 32) {
                        System.out.print((char)resultBuffer[i]);
                    } else if (resultBuffer[i] > 1) {
                        System.out.print(resultBuffer[i]);
                    } else if (i > 1 && resultBuffer[i - 1] != 1 && resultBuffer[i - 2] != 0 && resultBuffer[i] != 1) {
                        System.out.print(resultBuffer[i]);
                    }
                    ++i;
                }
                System.out.print("\n");
                i = 0;
                while (i < resultBuffer.length) {
                    System.out.print(" " + resultBuffer[i]);
                    ++i;
                }
            }
        }
        String[] tabName = new String[fieldCount];
        String[] attributeName = new String[fieldCount];
        String[][] returnValue = new String[fieldCount][recordCount];
        i = 0;
        while (i < fieldCount) {
            tabName[i] = "";
            while (resultBuffer[j] != 0 && j < resultBuffer.length - 1) {
                int n = i;
                tabName[n] = String.valueOf(tabName[n]) + (char)resultBuffer[j];
                ++j;
            }
            if (resultBuffer[j] == 0 && j < resultBuffer.length - 1) {
                ++j;
            }
            attributeName[i] = "";
            while (resultBuffer[j] != 0 && j < resultBuffer.length - 1) {
                int n = i;
                attributeName[n] = String.valueOf(attributeName[n]) + (char)resultBuffer[j];
                ++j;
            }
            if (resultBuffer[j] == 0 && j < resultBuffer.length - 1) {
                ++j;
            }
            k = 0;
            while (k < recordCount) {
                returnValue[i][k] = "";
                while (resultBuffer[j] != 0 && j < resultBuffer.length - 1) {
                    if (resultBuffer[j] > 0) {
                        String[] stringArray = returnValue[i];
                        int n = k;
                        stringArray[n] = String.valueOf(stringArray[n]) + (char)resultBuffer[j];
                    } else {
                        String[] stringArray = returnValue[i];
                        int n = k;
                        stringArray[n] = String.valueOf(stringArray[n]) + (char)(256 + resultBuffer[j]);
                    }
                    ++j;
                }
                if (resultBuffer[j] == 0 && j < resultBuffer.length - 1) {
                    ++j;
                }
                ++k;
            }
            if (resultBuffer[j] == 0) {
                ++j;
            }
            ++i;
        }
        return this.parseSRBMetaDataRecordList(fieldCount, recordCount, continuationIndex, tabName, attributeName, returnValue);
    }

    SRBMetaDataRecordList[] returnSRBMetaDataRecordList(boolean newReturn, boolean usePortalHeader, InputStream in) throws IOException {
        if (DEBUG > 2) {
            System.out.println("\n\nreturnSRBMetaDataRecordList new in\n\n");
        }
        InputStream tempIn = null;
        if (in != null) {
            tempIn = this.in;
            this.in = in;
            this.read(4);
        }
        if (!newReturn) {
            return this.returnSRBMetaDataRecordList();
        }
        int i = 0;
        int j = 0;
        int k = 0;
        boolean temp = false;
        if (this.singlePortBulkUnload) {
            this.read(4);
        }
        int bufferLength = usePortalHeader ? Host.castToInt(this.read(4)) : this.readInt();
        int status = (int)this.readUnsignedInt();
        if (bufferLength == 0) {
            if (status == 0) {
                if (in != null) {
                    this.read(4);
                    this.in = tempIn;
                    return null;
                }
            } else {
                if (status < 0) {
                    throw new SRBException("Protocol error in returnSRBMetaDataRecordList", status);
                }
                System.err.print("Protocol error in returnSRBMetaDataRecordList");
            }
        }
        if (usePortalHeader) {
            this.read(4);
        }
        if (status < 0) {
            if (DEBUG > 3) {
                System.out.println(status);
            }
            if (status == -3005) {
                this.read(1);
                return null;
            }
            String exception = "\nSRB server status: " + status;
            this.read(1);
            throw new SRBException(exception);
        }
        int fieldCount = (int)this.readUnsignedInt();
        int recordCount = (int)this.readUnsignedInt();
        int lengthVars = 16;
        if (usePortalHeader) {
            lengthVars += 7;
        }
        byte[] resultBuffer = this.read(bufferLength - lengthVars);
        if (usePortalHeader) {
            this.read(3);
        }
        byte[] b = this.read(4);
        short continuationIndex = (short)Host.castToInt(b);
        if (usePortalHeader) {
            this.read(7);
        }
        if (DEBUG > 2) {
            System.out.println("bufferLength " + bufferLength);
            System.out.println("status " + status);
            System.out.println("fieldCount " + fieldCount);
            System.out.println("recordCount " + recordCount);
            System.out.println("continuationIndex " + continuationIndex);
            System.out.println("resultBuffer " + resultBuffer.length);
            if (DEBUG > 4) {
                i = 0;
                while (i < resultBuffer.length) {
                    if (resultBuffer[i] > 32) {
                        System.out.print((char)resultBuffer[i]);
                    } else if (resultBuffer[i] > 1) {
                        System.out.print(resultBuffer[i]);
                    } else if (i > 1 && resultBuffer[i - 1] != 1 && resultBuffer[i - 2] != 0 && resultBuffer[i] != 1) {
                        System.out.print(resultBuffer[i]);
                    }
                    ++i;
                }
                System.out.print("\n");
                i = 0;
                while (i < resultBuffer.length) {
                    System.out.print(" " + resultBuffer[i]);
                    ++i;
                }
            }
        }
        if (in != null) {
            this.in = tempIn;
        } else {
            this.status();
        }
        String[] tabName = new String[fieldCount];
        String[] attributeName = new String[fieldCount];
        String[][] returnValue = new String[fieldCount][recordCount];
        i = 0;
        while (i < fieldCount) {
            if (j > 1 && resultBuffer[j - 1] == 0) {
                tabName[i] = "";
            }
            while (resultBuffer[j] != 0 && j < resultBuffer.length - 1) {
                int n = i;
                tabName[n] = String.valueOf(tabName[n]) + (char)resultBuffer[j];
                ++j;
            }
            if (resultBuffer[j] == 0 && j < resultBuffer.length - 1) {
                ++j;
            }
            attributeName[i] = "";
            while (resultBuffer[j] != 0 && j < resultBuffer.length - 1) {
                int n = i;
                attributeName[n] = String.valueOf(attributeName[n]) + (char)resultBuffer[j];
                ++j;
            }
            if (resultBuffer[j] == 0 && j < resultBuffer.length - 1) {
                ++j;
            }
            k = 0;
            while (k < recordCount) {
                returnValue[i][k] = "";
                while (resultBuffer[j] != 0 && j < resultBuffer.length - 1) {
                    String[] stringArray = returnValue[i];
                    int n = k;
                    stringArray[n] = String.valueOf(stringArray[n]) + (char)resultBuffer[j];
                    ++j;
                }
                if (resultBuffer[j] == 0 && j < resultBuffer.length - 1) {
                    ++j;
                }
                ++k;
            }
            if (resultBuffer[j] == 0) {
                ++j;
            }
            ++i;
        }
        return this.parseSRBMetaDataRecordList(fieldCount, recordCount, continuationIndex, tabName, attributeName, returnValue, true);
    }

    SRBMetaDataRecordList[] returnSRBMetaDataRecordList() throws IOException {
        if (DEBUG > 2) {
            System.out.println("returnSRBMetaDataRecordList old");
        }
        int i = 0;
        int j = 0;
        int k = 0;
        int temp = 0;
        int bufferLength = this.readInt();
        int status = (int)this.readUnsignedInt();
        if (status < 0) {
            if (DEBUG > 3) {
                System.out.println(status);
            }
            if (status == -3005) {
                this.read(1);
                return null;
            }
            String exception = "\nSRB server status: " + status;
            this.read(1);
            throw new SRBException(exception);
        }
        int fieldCount = (int)this.readUnsignedInt();
        int recordCount = (int)this.readUnsignedInt();
        int continuationIndex = (int)this.readUnsignedInt();
        byte[] resultBuffer = this.read(bufferLength - 19);
        this.read(3);
        this.status();
        if (DEBUG > 2) {
            System.out.println("bufferLength " + bufferLength);
            System.out.println("status " + status);
            System.out.println("fieldCount " + fieldCount);
            System.out.println("recordCount " + recordCount);
            System.out.println("continuationIndex " + continuationIndex);
            System.out.println("resultBuffer " + resultBuffer.length);
            if (DEBUG > 4) {
                i = 0;
                while (i < resultBuffer.length) {
                    if (resultBuffer[i] != 0) {
                        System.out.print((char)resultBuffer[i]);
                    }
                    ++i;
                }
                i = 0;
                while (i < resultBuffer.length) {
                    System.out.print(" " + resultBuffer[i]);
                    ++i;
                }
            }
        }
        String[] tabName = new String[fieldCount];
        String[] attributeName = new String[fieldCount];
        String[][] returnValue = new String[fieldCount][recordCount];
        i = 0;
        while (i < fieldCount) {
            tabName[i] = "";
            temp = j;
            while (resultBuffer[j] != 0 && j < resultBuffer.length - 1) {
                int n = i;
                tabName[n] = String.valueOf(tabName[n]) + (char)resultBuffer[j];
                ++j;
            }
            while (resultBuffer[j] == 0 && j < resultBuffer.length - 1) {
                ++j;
            }
            attributeName[i] = "";
            temp = j;
            while (resultBuffer[j] != 0 && j < resultBuffer.length - 1) {
                int n = i;
                attributeName[n] = String.valueOf(attributeName[n]) + (char)resultBuffer[j];
                ++j;
            }
            if (resultBuffer[j] == 0 && j < resultBuffer.length - 1) {
                ++j;
            }
            k = 0;
            while (k < recordCount) {
                temp = j;
                returnValue[i][k] = "";
                while (resultBuffer[j] != 0 && j < resultBuffer.length - 1) {
                    String[] stringArray = returnValue[i];
                    int n = k;
                    stringArray[n] = String.valueOf(stringArray[n]) + (char)resultBuffer[j];
                    ++j;
                }
                if (j < temp + SRBFileSystem.MAX_FILE_SIZE) {
                    j = temp + SRBFileSystem.MAX_FILE_SIZE;
                }
                ++k;
            }
            ++i;
        }
        return this.parseSRBMetaDataRecordList(fieldCount, recordCount, continuationIndex, tabName, attributeName, returnValue);
    }

    SRBMetaDataRecordList[] parseSRBMetaDataRecordList(int fieldCount, int recordCount, int continuationIndex, String[] tabName, String[] attributeName, String[][] returnValue) throws IOException {
        MetaDataField[] fields2 = null;
        Object[] singleReturnValue2 = null;
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        boolean temp = false;
        MetaDataField[] fields = new MetaDataField[fieldCount];
        i = 0;
        while (i < fieldCount) {
            fields[i] = SRBMetaDataSet.getGeneralMetaData(tabName[i], attributeName[i]);
            ++i;
        }
        if (DEBUG > 3) {
            i = 0;
            while (i < fieldCount) {
                System.out.println("fields " + fields[i]);
                ++i;
            }
        }
        SRBMetaDataRecordList[] rl = new SRBMetaDataRecordList[recordCount];
        Object[] singleReturnValue = new Object[fieldCount];
        int metaDataRows = 0;
        int fakeRows = 0;
        String fieldName = null;
        i = 0;
        while (i < recordCount) {
            j = 0;
            while (j < fieldCount) {
                int[] operators;
                int[] operators2;
                String[][] tableValues;
                String directory;
                String fileName;
                String nextFieldName;
                fieldName = fields[j].getName();
                if (fieldName == "definable metadata file0") {
                    nextFieldName = null;
                    if (j + 1 < fieldCount) {
                        nextFieldName = fields[j + 1].getName();
                    }
                    if (nextFieldName == "definable metadata file1") {
                        fileName = null;
                        directory = null;
                        int fileIndex = -1;
                        int dirIndex = -1;
                        k = 0;
                        l = 0;
                        while (k < fieldCount) {
                            if (fields[k].getName() == "file name") {
                                fileName = returnValue[k][i];
                                fileIndex = k;
                            }
                            if (fields[k].getName() == "directory name") {
                                directory = returnValue[k][i];
                                dirIndex = k;
                            }
                            ++k;
                            ++l;
                        }
                        if (fileIndex >= 0 && dirIndex >= 0) {
                            l = 0;
                            while (l < recordCount) {
                                if (returnValue[fileIndex][l].equals(fileName) && returnValue[dirIndex][l].equals(directory)) {
                                    ++metaDataRows;
                                }
                                ++l;
                            }
                            tableValues = new String[metaDataRows][10];
                            operators2 = new int[metaDataRows];
                            k = 0;
                            while (k < metaDataRows) {
                                l = 0;
                                while (l < tableValues[0].length) {
                                    tableValues[k][l] = returnValue[j + l][k + i];
                                    ++l;
                                }
                                operators2[k] = 0;
                                ++k;
                            }
                            singleReturnValue[j] = new MetaDataTable(operators2, tableValues);
                            fakeRows += metaDataRows - 1;
                            if (fields2 == null) {
                                fields2 = new MetaDataField[fieldCount - 9];
                            }
                            i += metaDataRows - 1;
                            j += 9;
                            metaDataRows = 0;
                        }
                    } else {
                        singleReturnValue[j] = returnValue[j][i];
                    }
                } else if (fieldName == "definable metadata directory0") {
                    nextFieldName = null;
                    if (j + 1 < fieldCount) {
                        nextFieldName = fields[j + 1].getName();
                    }
                    if (nextFieldName == "definable metadata directory1") {
                        fileName = null;
                        directory = null;
                        int dirIndex = -1;
                        k = 0;
                        l = 0;
                        while (k < fieldCount) {
                            if (fields[k].getName() == "directory name") {
                                directory = returnValue[k][i];
                                dirIndex = k;
                            }
                            ++k;
                            ++l;
                        }
                        if (dirIndex >= 0) {
                            l = 0;
                            while (l < recordCount) {
                                if (returnValue[dirIndex][l].equals(directory)) {
                                    ++metaDataRows;
                                }
                                ++l;
                            }
                            String[][] tableValues2 = new String[metaDataRows][10];
                            operators = new int[metaDataRows];
                            k = 0;
                            while (k < metaDataRows) {
                                l = 0;
                                while (l < tableValues2[0].length) {
                                    tableValues2[k][l] = returnValue[j + l][k + i];
                                    ++l;
                                }
                                operators[k] = 0;
                                ++k;
                            }
                            singleReturnValue[j] = new MetaDataTable(operators, tableValues2);
                            fakeRows += metaDataRows - 1;
                            if (fields2 == null) {
                                fields2 = new MetaDataField[fieldCount - 9];
                            }
                            i += metaDataRows - 1;
                            j += 9;
                            metaDataRows = 0;
                        }
                    } else {
                        singleReturnValue[j] = returnValue[j][i];
                    }
                } else if (fieldName == "definable metadata user0") {
                    nextFieldName = null;
                    if (j + 1 < fieldCount) {
                        nextFieldName = fields[j + 1].getName();
                    }
                    if (nextFieldName == "definable metadata user1") {
                        String userName = null;
                        String userDomain = null;
                        int userNameIndex = -1;
                        int userDomainIndex = -1;
                        k = 0;
                        l = 0;
                        while (k < fieldCount) {
                            if (fields[k].getName() == "user name") {
                                userName = returnValue[k][i];
                                userNameIndex = k;
                            }
                            if (fields[k].getName() == "user domain") {
                                userDomain = returnValue[k][i];
                                userDomainIndex = k;
                            }
                            ++k;
                            ++l;
                        }
                        if (userNameIndex >= 0 && userDomainIndex >= 0) {
                            l = 0;
                            while (l < recordCount) {
                                if (returnValue[userNameIndex][l].equals(userName) && returnValue[userDomainIndex][l].equals(userDomain)) {
                                    ++metaDataRows;
                                }
                                ++l;
                            }
                            tableValues = new String[metaDataRows][10];
                            operators2 = new int[metaDataRows];
                            k = 0;
                            while (k < metaDataRows) {
                                l = 0;
                                while (l < tableValues[0].length) {
                                    tableValues[k][l] = returnValue[j + l][k + i];
                                    ++l;
                                }
                                operators2[k] = 0;
                                ++k;
                            }
                            singleReturnValue[j] = new MetaDataTable(operators2, tableValues);
                            fakeRows += metaDataRows - 1;
                            if (fields2 == null) {
                                fields2 = new MetaDataField[fieldCount - 9];
                            }
                            i += metaDataRows - 1;
                            j += 9;
                            metaDataRows = 0;
                        }
                    } else {
                        singleReturnValue[j] = returnValue[j][i];
                    }
                } else if (fieldName == "definable metadata resource0") {
                    nextFieldName = null;
                    if (j + 1 < fieldCount) {
                        nextFieldName = fields[j + 1].getName();
                    }
                    if (nextFieldName == "definable metadata resource1") {
                        fileName = null;
                        String resource = null;
                        int resourceIndex = -1;
                        k = 0;
                        l = 0;
                        while (k < fieldCount) {
                            if (fields[k].getName() == "resource name") {
                                resource = returnValue[k][i];
                                resourceIndex = k;
                            }
                            ++k;
                            ++l;
                        }
                        if (resourceIndex >= 0) {
                            l = 0;
                            while (l < recordCount) {
                                if (returnValue[resourceIndex][l].equals(resource)) {
                                    ++metaDataRows;
                                }
                                ++l;
                            }
                            String[][] tableValues3 = new String[metaDataRows][10];
                            operators = new int[metaDataRows];
                            k = 0;
                            while (k < metaDataRows) {
                                l = 0;
                                while (l < tableValues3[0].length) {
                                    tableValues3[k][l] = returnValue[j + l][k + i];
                                    ++l;
                                }
                                operators[k] = 0;
                                ++k;
                            }
                            singleReturnValue[j] = new MetaDataTable(operators, tableValues3);
                            fakeRows += metaDataRows - 1;
                            if (fields2 == null) {
                                fields2 = new MetaDataField[fieldCount - 9];
                            }
                            i += metaDataRows - 1;
                            j += 9;
                            metaDataRows = 0;
                        }
                    } else {
                        singleReturnValue[j] = returnValue[j][i];
                    }
                } else {
                    singleReturnValue[j] = returnValue[j][i];
                }
                ++j;
            }
            if (fields2 != null) {
                singleReturnValue2 = new Object[fieldCount - 9];
                k = 0;
                l = 0;
                while (k < singleReturnValue.length) {
                    if (singleReturnValue[k] != null) {
                        singleReturnValue2[l] = singleReturnValue[k];
                        fields2[l] = fields[k].getName() == "definable metadata file0" ? MetaDataSet.getField("definable metadata for files") : (fields[k].getName() == "definable metadata directory0" ? MetaDataSet.getField("definable metadata for directories") : (fields[k].getName() == "definable metadata user0" ? MetaDataSet.getField("definable metadata for users") : (fields[k].getName() == "definable metadata resource0" ? MetaDataSet.getField("definable metadata for resources") : fields[k])));
                        ++l;
                    }
                    ++k;
                }
                rl[i] = new SRBMetaDataRecordList(fields2, singleReturnValue2, continuationIndex, this);
                fields2 = null;
            } else {
                rl[i] = new SRBMetaDataRecordList(fields, singleReturnValue, continuationIndex, this);
            }
            ++i;
        }
        if (DEBUG > 3) {
            i = 0;
            while (i < rl.length) {
                if (rl[i] != null) {
                    j = 0;
                    while (j < rl[i].getFieldCount()) {
                        System.out.println("rl[" + i + "]." + j + " " + rl[i].getValue(j));
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.status();
        SRBMetaDataRecordList[] rl2 = new SRBMetaDataRecordList[recordCount - fakeRows];
        i = 0;
        j = 0;
        while (i < rl.length) {
            if (rl[i] != null) {
                rl2[j] = rl[i];
                ++j;
            }
            ++i;
        }
        return rl2;
    }

    SRBMetaDataRecordList[] parseSRBMetaDataRecordList(int fieldCount, int recordCount, int continuationIndex, String[] tabName, String[] attributeName, String[][] returnValue, boolean newSRB3_3_1_Way) throws IOException {
        if (DEBUG > 2) {
            System.out.println("parseSRBMetaDataRecordList");
        }
        MetaDataField[] fields2 = null;
        Object[] singleReturnValue2 = null;
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        boolean temp = false;
        MetaDataField[] fields = new MetaDataField[fieldCount];
        i = 0;
        while (i < fieldCount) {
            fields[i] = SRBMetaDataSet.getGeneralMetaData(tabName[i], attributeName[i]);
            ++i;
        }
        if (DEBUG > 3) {
            i = 0;
            while (i < fieldCount) {
                System.out.println("fields " + fields[i] + " tabName " + tabName[i] + "  attributeName " + attributeName[i]);
                ++i;
            }
        }
        i = 0;
        while (i < returnValue.length) {
            j = 0;
            while (j < returnValue[i].length) {
                ++j;
            }
            ++i;
        }
        SRBMetaDataRecordList[] rl = new SRBMetaDataRecordList[recordCount];
        Object[] singleReturnValue = new Object[fieldCount];
        int metaDataRows = 0;
        int fakeRows = 0;
        String fieldName = null;
        i = 0;
        while (i < recordCount) {
            j = 0;
            while (j < fieldCount) {
                int[] operators;
                int[] operators2;
                String[][] tableValues;
                String directory;
                String fileName;
                String nextFieldName;
                fieldName = fields[j].getName();
                if (fieldName == "definable metadata file0") {
                    nextFieldName = null;
                    if (j + 1 < fieldCount) {
                        nextFieldName = fields[j + 1].getName();
                    }
                    if (nextFieldName == "definable metadata file1") {
                        fileName = null;
                        directory = null;
                        int fileIndex = -1;
                        int dirIndex = -1;
                        k = 0;
                        l = 0;
                        while (k < fieldCount) {
                            if (fields[k].getName() == "file name") {
                                fileName = returnValue[k][i];
                                fileIndex = k;
                            }
                            if (fields[k].getName() == "directory name") {
                                directory = returnValue[k][i];
                                dirIndex = k;
                            }
                            ++k;
                            ++l;
                        }
                        if (fileIndex >= 0 && dirIndex >= 0) {
                            l = 0;
                            while (l < recordCount) {
                                if (returnValue[fileIndex][l].equals(fileName) && returnValue[dirIndex][l].equals(directory)) {
                                    ++metaDataRows;
                                }
                                ++l;
                            }
                            tableValues = new String[metaDataRows][10];
                            operators2 = new int[metaDataRows];
                            k = 0;
                            while (k < metaDataRows) {
                                l = 0;
                                while (l < tableValues[0].length) {
                                    tableValues[k][l] = returnValue[j + l][i];
                                    ++l;
                                }
                                operators2[k] = 0;
                                ++k;
                            }
                            singleReturnValue[j] = new MetaDataTable(operators2, tableValues);
                            fakeRows += metaDataRows - 1;
                            if (fields2 == null) {
                                fields2 = new MetaDataField[fieldCount - 9];
                            }
                            j += 9;
                            metaDataRows = 0;
                        }
                    } else {
                        singleReturnValue[j] = returnValue[j][i];
                    }
                } else if (fieldName == "definable metadata directory0") {
                    nextFieldName = null;
                    if (j + 1 < fieldCount) {
                        nextFieldName = fields[j + 1].getName();
                    }
                    if (nextFieldName == "definable metadata directory1") {
                        fileName = null;
                        directory = null;
                        int dirIndex = -1;
                        k = 0;
                        l = 0;
                        while (k < fieldCount) {
                            if (fields[k].getName() == "directory name") {
                                directory = returnValue[k][i];
                                dirIndex = k;
                            }
                            ++k;
                            ++l;
                        }
                        if (dirIndex >= 0) {
                            l = 0;
                            while (l < recordCount) {
                                if (returnValue[dirIndex][l].equals(directory)) {
                                    ++metaDataRows;
                                }
                                ++l;
                            }
                            String[][] tableValues2 = new String[metaDataRows][10];
                            operators = new int[metaDataRows];
                            k = 0;
                            while (k < metaDataRows) {
                                l = 0;
                                while (l < tableValues2[0].length) {
                                    tableValues2[k][l] = returnValue[j + l][i];
                                    ++l;
                                }
                                operators[k] = 0;
                                ++k;
                            }
                            singleReturnValue[j] = new MetaDataTable(operators, tableValues2);
                            fakeRows += metaDataRows - 1;
                            if (fields2 == null) {
                                fields2 = new MetaDataField[fieldCount - 9];
                            }
                            j += 9;
                            metaDataRows = 0;
                        }
                    } else {
                        singleReturnValue[j] = returnValue[j][i];
                    }
                } else if (fieldName == "definable metadata user0") {
                    nextFieldName = null;
                    if (j + 1 < fieldCount) {
                        nextFieldName = fields[j + 1].getName();
                    }
                    if (nextFieldName == "definable metadata user1") {
                        String userName = null;
                        String userDomain = null;
                        int userNameIndex = -1;
                        int userDomainIndex = -1;
                        k = 0;
                        l = 0;
                        while (k < fieldCount) {
                            if (fields[k].getName() == "user name") {
                                userName = returnValue[k][i];
                                userNameIndex = k;
                            }
                            if (fields[k].getName() == "user domain") {
                                userDomain = returnValue[k][i];
                                userDomainIndex = k;
                            }
                            ++k;
                            ++l;
                        }
                        if (userNameIndex >= 0 && userDomainIndex >= 0) {
                            l = 0;
                            while (l < recordCount) {
                                if (returnValue[userNameIndex][l].equals(userName) && returnValue[userDomainIndex][l].equals(userDomain)) {
                                    ++metaDataRows;
                                }
                                ++l;
                            }
                            tableValues = new String[metaDataRows][10];
                            operators2 = new int[metaDataRows];
                            k = 0;
                            while (k < metaDataRows) {
                                l = 0;
                                while (l < tableValues[0].length) {
                                    tableValues[k][l] = returnValue[j + l][i];
                                    ++l;
                                }
                                operators2[k] = 0;
                                ++k;
                            }
                            singleReturnValue[j] = new MetaDataTable(operators2, tableValues);
                            fakeRows += metaDataRows - 1;
                            if (fields2 == null) {
                                fields2 = new MetaDataField[fieldCount - 9];
                            }
                            j += 9;
                            metaDataRows = 0;
                        }
                    } else {
                        singleReturnValue[j] = returnValue[j][i];
                    }
                } else if (fieldName == "definable metadata resource0") {
                    nextFieldName = null;
                    if (j + 1 < fieldCount) {
                        nextFieldName = fields[j + 1].getName();
                    }
                    if (nextFieldName == "definable metadata resource1") {
                        fileName = null;
                        String resource = null;
                        int resourceIndex = -1;
                        k = 0;
                        l = 0;
                        while (k < fieldCount) {
                            if (fields[k].getName() == "resource name") {
                                resource = returnValue[k][i];
                                resourceIndex = k;
                            }
                            ++k;
                            ++l;
                        }
                        if (resourceIndex >= 0) {
                            l = 0;
                            while (l < recordCount) {
                                if (returnValue[resourceIndex][l].equals(resource)) {
                                    ++metaDataRows;
                                }
                                ++l;
                            }
                            String[][] tableValues3 = new String[metaDataRows][10];
                            operators = new int[metaDataRows];
                            k = 0;
                            while (k < metaDataRows) {
                                l = 0;
                                while (l < tableValues3[0].length) {
                                    tableValues3[k][l] = returnValue[j + l][i];
                                    ++l;
                                }
                                operators[k] = 0;
                                ++k;
                            }
                            singleReturnValue[j] = new MetaDataTable(operators, tableValues3);
                            fakeRows += metaDataRows - 1;
                            if (fields2 == null) {
                                fields2 = new MetaDataField[fieldCount - 9];
                            }
                            j += 9;
                            metaDataRows = 0;
                        }
                    } else {
                        singleReturnValue[j] = returnValue[j][i];
                    }
                } else {
                    singleReturnValue[j] = returnValue[j][i];
                }
                ++j;
            }
            if (fields2 != null) {
                singleReturnValue2 = new Object[fieldCount - 9];
                k = 0;
                l = 0;
                while (k < singleReturnValue.length) {
                    if (singleReturnValue[k] != null) {
                        singleReturnValue2[l] = singleReturnValue[k];
                        fields2[l] = fields[k].getName() == "definable metadata file0" ? MetaDataSet.getField("definable metadata for files") : (fields[k].getName() == "definable metadata directory0" ? MetaDataSet.getField("definable metadata for directories") : (fields[k].getName() == "definable metadata user0" ? MetaDataSet.getField("definable metadata for users") : (fields[k].getName() == "definable metadata resource0" ? MetaDataSet.getField("definable metadata for resources") : fields[k])));
                        ++l;
                    }
                    ++k;
                }
                rl[i] = new SRBMetaDataRecordList(fields2, singleReturnValue2, continuationIndex, this);
                fields2 = null;
            } else {
                rl[i] = new SRBMetaDataRecordList(fields, singleReturnValue, continuationIndex, this);
            }
            ++i;
        }
        if (DEBUG > 3) {
            i = 0;
            while (i < rl.length) {
                j = 0;
                while (j < rl[i].getFieldCount()) {
                    System.out.println("rl[" + i + "]." + j + " " + rl[i].getValue(j));
                    ++j;
                }
                ++i;
            }
        }
        SRBMetaDataRecordList[] rl2 = new SRBMetaDataRecordList[recordCount];
        i = 0;
        j = 0;
        while (i < rl.length) {
            if (rl[i] != null) {
                rl2[j] = rl[i];
                ++j;
            }
            ++i;
        }
        return rl2;
    }

    synchronized int srbObjCreate(int catType, String objID, String dataTypeName, String resourceName, String collectionName, String localPathName, long dataSize) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjCreate " + objID + " " + collectionName + " " + resourceName);
        }
        this.startSRBCommand(2000, 7);
        this.sendArg(catType);
        this.sendArg(objID);
        this.sendArg(dataTypeName);
        this.sendArg(resourceName);
        this.sendArg(collectionName);
        this.sendArg(localPathName);
        this.sendArg(dataSize);
        this.flush();
        this.commandStatus();
        int fd = this.returnInt();
        if (fd < 0) {
            throw new SRBException(fd);
        }
        return fd;
    }

    synchronized int srbObjOpen(String objID, int openFlag, String collectionName) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjOpen");
        }
        this.startSRBCommand(2001, 3);
        this.sendArg(objID);
        this.sendArg(openFlag);
        this.sendArg(collectionName);
        this.flush();
        this.commandStatus();
        int fd = this.returnInt();
        if (fd < 0) {
            throw new SRBException(fd);
        }
        return fd;
    }

    synchronized void srbObjClose(int srbFD) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjClose");
        }
        this.startSRBCommand(2002, 1);
        this.sendArg(srbFD);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbObjUnlink(String objID, String collectionName) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjUnlink");
        }
        this.startSRBCommand(2003, 2);
        this.sendArg(objID);
        this.sendArg(collectionName);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized byte[] srbObjRead(int srbFD, int length) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjRead");
        }
        this.startSRBCommand(2004, 2);
        this.sendArg(srbFD);
        this.sendArg(length);
        this.flush();
        this.commandStatus();
        return this.returnBytes();
    }

    synchronized int srbObjWrite(int srbFD, byte[] output, int length) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjWrite");
        }
        this.startSRBCommand(2005, 2);
        this.sendArg(srbFD);
        this.sendArg(output, length);
        this.flush();
        this.commandStatus();
        int result = this.returnInt();
        if (result < 0) {
            throw new SRBException("Write failed", result);
        }
        return result;
    }

    synchronized void srbObjSeek(int desc, long offset, int whence) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjSeek");
        }
        this.startSRBCommand(2006, 3);
        this.sendArg(desc);
        this.sendArg(offset);
        this.sendArg(whence);
        this.flush();
        this.commandStatus();
        int status = (int)this.returnLong();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbObjSync(int desc) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjSync");
        }
        this.startSRBCommand(2007, 1);
        this.sendArg(desc);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized long[] srbObjStat(int catType, String filePath, int myType) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjStat");
        }
        long[] statBuffer = new long[30];
        long temp = 0L;
        int i = 0;
        int j = 0;
        int endLoop = 0;
        boolean resultLength = false;
        this.startSRBCommand(2008, 3);
        this.sendArg(catType);
        this.sendArg(filePath);
        this.sendArg(myType);
        this.flush();
        this.commandStatus();
        byte[] resultBuffer = this.returnBytes();
        if (resultBuffer != null) {
            j = 0;
            while (j < 8) {
                temp = resultBuffer[j] < 0 ? (temp << 8) + 256L + (long)resultBuffer[j] : (temp << 8) + (long)resultBuffer[j];
                ++j;
            }
            statBuffer[0] = temp;
            ++i;
            while (i < statBuffer.length - 7) {
                temp = 0L;
                endLoop = j + 4;
                while (j < endLoop) {
                    temp = resultBuffer[j] < 0 ? (temp << 8) + 256L + (long)resultBuffer[j] : (temp << 8) + (long)resultBuffer[j];
                    ++j;
                }
                statBuffer[i] = temp;
                ++i;
            }
            while (i < statBuffer.length - 5) {
                temp = 0L;
                endLoop = j + 2;
                while (j < endLoop) {
                    temp = resultBuffer[j] < 0 ? (temp << 8) + 256L + (long)resultBuffer[j] : (temp << 8) + (long)resultBuffer[j];
                    ++j;
                }
                statBuffer[i] = temp;
                ++i;
            }
            while (i < statBuffer.length) {
                temp = 0L;
                endLoop = j + 4;
                while (j < endLoop) {
                    temp = resultBuffer[j] < 0 ? (temp << 8) + 256L + (long)resultBuffer[j] : (temp << 8) + (long)resultBuffer[j];
                    ++j;
                }
                statBuffer[i] = temp;
                ++i;
            }
        }
        return statBuffer;
    }

    long[] srbObjStat64(int catType, String path) throws IOException {
        return this.srbObjStat(catType, path, 0);
    }

    synchronized void srbObjReplicate(int catType, String objID, String collectionName, String newResourceName, String newPathName) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjReplicate");
        }
        this.startSRBCommand(2009, 5);
        this.sendArg(catType);
        this.sendArg(objID);
        this.sendArg(collectionName);
        this.sendArg(newResourceName);
        this.sendArg(newPathName);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbObjMove(int catType, String objID, String collectionName, String srcResource, String newResourceName, String newPathName, String container) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjMove");
        }
        this.startSRBCommand(2010, 7);
        this.sendArg(catType);
        this.sendArg(objID);
        this.sendArg(String.valueOf(collectionName) + "/bye");
        this.sendArg(srcResource);
        this.sendArg("corn");
        this.sendArg(newPathName);
        this.sendArg("hi");
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized byte[] srbObjProxyOpr(int operation, int inputInt1, int inputInt2, int inputInt3, int inputInt4, String inputStr1, String inputStr2, String inputStr3, String inputStr4, byte[] inputBStrm1, byte[] inputBStrm2, byte[] inputBStrm3) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjProxyOpr");
        }
        this.startSRBCommand(2011, 12);
        this.sendArg(operation);
        this.sendArg(inputInt1);
        this.sendArg(inputInt2);
        this.sendArg(inputInt3);
        this.sendArg(inputInt4);
        this.sendArg(inputStr1);
        this.sendArg(inputStr2);
        this.sendArg(inputStr2);
        this.sendArg(inputStr4);
        this.sendArg(inputBStrm1);
        this.sendArg(inputBStrm2);
        this.sendArg(inputBStrm3);
        this.flush();
        this.commandStatus();
        byte[] resultBuffer = this.read(4);
        int resultLength = 0;
        int i = resultBuffer.length - 1;
        while (i >= 0) {
            resultLength = resultBuffer[i] < 0 ? (resultLength << 8) + 256 + resultBuffer[i] : (resultLength << 8) + resultBuffer[i];
            --i;
        }
        if (resultLength > 4) {
            this.read(4);
            resultBuffer = this.read(resultLength -= 4);
            this.read(1);
            return resultBuffer;
        }
        resultBuffer = this.read(4);
        this.status();
        return resultBuffer;
    }

    synchronized byte[] srbObjGetdents(int catType, int srbFD, long nbyte) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjGetdents");
        }
        this.startSRBCommand(2012, 3);
        this.sendArg(catType);
        this.sendArg(srbFD);
        this.sendArg(nbyte);
        this.flush();
        this.commandStatus();
        return this.returnBytes();
    }

    synchronized byte[] srbObjGetdents64(int catType, int srbFD, long nbyte) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjGetdents64");
        }
        this.startSRBCommand(2013, 3);
        this.sendArg(catType);
        this.sendArg(srbFD);
        this.sendArg(nbyte);
        this.flush();
        this.commandStatus();
        return this.returnBytes();
    }

    synchronized void srbCollSeek(int desc, int offset, int whence, int is64Flag) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbCollSeek");
        }
        this.startSRBCommand(2014, 4);
        this.sendArg(desc);
        this.sendArg(offset);
        this.sendArg(whence);
        this.sendArg(is64Flag);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized SRBMetaDataRecordList[] srbGetDatasetInfo(int catType, String objID, String collectionName, int rowsWanted) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGetDatasetInfo");
        }
        this.startSRBCommand(2100, 4);
        this.sendArg(catType);
        this.sendArg(objID);
        this.sendArg(collectionName);
        this.sendArg(rowsWanted);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList();
    }

    synchronized SRBMetaDataRecordList[] srbGetDataDirInfo(int catType, MetaDataCondition[] metaDataConditions, MetaDataSelect[] metaDataSelects, int rowsWanted, boolean orderBy, boolean nonDistinct) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGetDataDirInfo " + this.srbGetDataDirInfoCount);
        }
        ++this.srbGetDataDirInfoCount;
        SRBMetaDataCommands mdc = new SRBMetaDataCommands(this);
        return mdc.srbGetDataDirInfo(catType, metaDataConditions, metaDataSelects, rowsWanted, orderBy, nonDistinct);
    }

    SRBMetaDataRecordList[] srbGenQuery(int catType, String myMcatZone, MetaDataCondition[] metaDataConditions, MetaDataSelect[] metaDataSelects, int rowsWanted, boolean orderBy, boolean nonDistinct) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGenQuery");
        }
        SRBMetaDataCommands mdc = new SRBMetaDataCommands(this);
        return mdc.srbGenQuery(catType, myMcatZone, metaDataConditions, metaDataSelects, rowsWanted, orderBy, nonDistinct);
    }

    synchronized void srbRegisterDataset(int catType, String objID, String dataTypeName, String resourceName, String collectionName, String pathName, long dataSize) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterDataset");
        }
        this.startSRBCommand(2102, 7);
        this.sendArg(catType);
        this.sendArg(objID);
        this.sendArg(dataTypeName);
        this.sendArg(resourceName);
        this.sendArg(collectionName);
        this.sendArg(pathName);
        this.sendArg(dataSize);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized int srbModifyDataset(int catType, String objID, String collectionName, String resourceName, String pathName, String dataValue1, String dataValue2, int actionType) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModifyDataset " + catType + " " + objID + " " + collectionName + " " + resourceName + " " + pathName + " " + dataValue1 + " " + dataValue2 + " " + actionType);
        }
        this.startSRBCommand(2103, 8);
        this.sendArg(catType);
        this.sendArg(objID);
        this.sendArg(collectionName);
        this.sendArg(resourceName);
        this.sendArg(pathName);
        this.sendArg(dataValue1);
        this.sendArg(dataValue2);
        this.sendArg(actionType);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
        return status;
    }

    synchronized void srbChkMdasAuth(String userName, String srbAuth, String mdasDomain) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbChkMdasAuth");
        }
        this.startSRBCommand(2104, 3);
        this.sendArg(userName);
        this.sendArg(srbAuth);
        this.sendArg(mdasDomain);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbCreateCollect(int catType, String parentCollect, String newCollect) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbCreateCollect");
        }
        this.startSRBCommand(2105, 3);
        this.sendArg(catType);
        this.sendArg(parentCollect);
        this.sendArg(newCollect);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized SRBMetaDataRecordList[] srbListCollect(int catType, String collectionName, String flag, int rowsWanted) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbListCollect");
        }
        this.startSRBCommand(2106, 4);
        this.sendArg(catType);
        this.sendArg(collectionName);
        this.sendArg(flag);
        this.sendArg(rowsWanted);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList();
    }

    synchronized void srbModifyCollect(int catType, String collectionName, String dataValue1, String dataValue2, String dataValue3, int actionType) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModifyCollect " + catType + " " + collectionName + " " + dataValue1 + " " + dataValue2 + " " + dataValue3 + " " + actionType);
        }
        this.startSRBCommand(2107, 6);
        this.sendArg(catType);
        this.sendArg(collectionName);
        this.sendArg(dataValue1);
        this.sendArg(dataValue2);
        this.sendArg(dataValue3);
        this.sendArg(actionType);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbChkMdasSysAuth(String userName, String srbAuth, String mdasDomain) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbChkMdasSysAuth");
        }
        this.startSRBCommand(2108, 3);
        this.sendArg(userName);
        this.sendArg(srbAuth);
        this.sendArg(mdasDomain);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbRegisterUserGrp(int catType, String userGrpName, String userGrpPasswd, String userGrpType, String userGrpAddress, String userGrpPhone, String userGrpEmail) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterUserGrp");
        }
        this.startSRBCommand(2109, 7);
        this.sendArg(catType);
        this.sendArg(userGrpName);
        this.sendArg(userGrpPasswd);
        this.sendArg(userGrpType);
        this.sendArg(userGrpAddress);
        this.sendArg(userGrpPhone);
        this.sendArg(userGrpEmail);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbRegisterUser(int catType, String userName, String userDomain, String userPasswd, String userType, String userAddress, String userPhone, String userEmail) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterUser");
        }
        this.startSRBCommand(2110, 8);
        this.sendArg(catType);
        this.sendArg(userName);
        this.sendArg(userDomain);
        this.sendArg(userPasswd);
        this.sendArg(userType);
        this.sendArg(userAddress);
        this.sendArg(userPhone);
        this.sendArg(userEmail);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbModifyUser(int catType, String dataValue1, String dataValue2, int actionType) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModifyUser");
        }
        this.startSRBCommand(2111, 4);
        this.sendArg(catType);
        this.sendArg(dataValue1);
        this.sendArg(dataValue2);
        this.sendArg(actionType);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized int srbSetAuditTrail(int set_value) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbSetAuditTrail");
        }
        this.startSRBCommand(2112, 1);
        this.sendArg(set_value);
        this.flush();
        this.commandStatus();
        return this.returnInt();
    }

    synchronized void srbObjAudit(int catType, String userName, String objID, String collectionName, String dataPath, String resourceName, String accessMode, String comment, int success, String domainName) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjAudit");
        }
        this.startSRBCommand(2113, 10);
        this.sendArg(catType);
        this.sendArg(userName);
        this.sendArg(objID);
        this.sendArg(collectionName);
        this.sendArg(dataPath);
        this.sendArg(resourceName);
        this.sendArg(accessMode);
        this.sendArg(comment);
        this.sendArg(success);
        this.sendArg(domainName);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbRegisterReplica(int catType, String objID, String collectionName, String origResourceName, String origPathName, String newResourceName, String newPathName, String userName, String domainName) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterReplica");
        }
        this.startSRBCommand(2114, 9);
        this.sendArg(catType);
        this.sendArg(objID);
        this.sendArg(collectionName);
        this.sendArg(origResourceName);
        this.sendArg(origPathName);
        this.sendArg(newResourceName);
        this.sendArg(newPathName);
        this.sendArg(userName);
        this.sendArg(domainName);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized SRBMetaDataRecordList[] srbGetPrivUsers(int catalog, int rowsWanted) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGetPrivUsers");
        }
        this.startSRBCommand(2115, 2);
        this.sendArg(catalog);
        this.sendArg(rowsWanted);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList();
    }

    synchronized SRBMetaDataRecordList[] srbGetMoreRows(int catalog, int contDesc, int rowsWanted) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGetMoreRows " + catalog + " " + contDesc + " " + rowsWanted);
        }
        if (contDesc < 0) {
            return null;
        }
        if (this.versionNumber >= 3.0f) {
            return this.srbGenGetMoreRows(catalog, contDesc, rowsWanted);
        }
        try {
            this.startSRBCommand(2116, 3);
            this.sendArg(catalog);
            this.sendArg(contDesc);
            this.sendArg(rowsWanted);
            this.flush();
            this.commandStatus();
            return this.returnSRBMetaDataRecordList();
        }
        catch (SRBException e) {
            if (e.getType() == -3005) {
                return null;
            }
            throw e;
        }
    }

    SRBMetaDataRecordList[] srbGenGetMoreRows(int catalog, int contDesc, int rowsWanted) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGenGetMoreRows " + catalog + " " + contDesc + " " + rowsWanted);
        }
        if (contDesc < 0) {
            return null;
        }
        try {
            this.startSRBCommand(2157, 3);
            this.sendArg(catalog);
            this.sendArg(contDesc);
            this.sendArg(rowsWanted);
            this.flush();
            this.commandStatus();
            return this.returnSRBMetaDataRecordList(true);
        }
        catch (SRBException e) {
            if (e.getType() == -3005) {
                return null;
            }
            throw e;
        }
    }

    synchronized void srbIssueTicket(String objID, String collectionName, String collectionFlag, String beginTime, String endTime, int accessCnt, String ticketUser) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbIssueTicket");
        }
        this.startSRBCommand(2117, 7);
        this.sendArg(objID);
        this.sendArg(collectionName);
        this.sendArg(collectionFlag);
        this.sendArg(beginTime);
        this.sendArg(endTime);
        this.sendArg(accessCnt);
        this.sendArg(ticketUser);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbRemoveTicket(String ticket) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRemoveTicket");
        }
        this.startSRBCommand(2118, 1);
        this.sendArg(ticket);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbUnregisterDataset(String objID, String collectionName) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbUnregisterDataset");
        }
        this.startSRBCommand(2119, 2);
        this.sendArg(objID);
        this.sendArg(collectionName);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbContainerCreate(int catType, String containerName, String containerType, String resourceName, long containerSize) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbContainerCreate");
        }
        this.startSRBCommand(2120, 5);
        this.sendArg(catType);
        this.sendArg(containerName);
        this.sendArg(containerType);
        this.sendArg(resourceName);
        this.sendArg(containerSize);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbRegisterContainer(int catType, String containerName, String resourceName, long containerSize) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterContainer");
        }
        this.startSRBCommand(2000, 4);
        this.sendArg(catType);
        this.sendArg(containerName);
        this.sendArg(resourceName);
        this.sendArg(containerSize);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbRegisterInContDataset(int catType, String objID, String collectionName, String containerName, String dataTypeName, long dataSize, long baseOffset) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterInContDataset");
        }
        this.startSRBCommand(2122, 7);
        this.sendArg(catType);
        this.sendArg(objID);
        this.sendArg(collectionName);
        this.sendArg(containerName);
        this.sendArg(dataTypeName);
        this.sendArg(dataSize);
        this.sendArg(baseOffset);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized SRBMetaDataRecordList[] srbGetContainerInfo(int catType, String containerName, int rowsWanted) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGetContainerInfo");
        }
        this.startSRBCommand(2123, 3);
        this.sendArg(catType);
        this.sendArg(containerName);
        this.sendArg(rowsWanted);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList();
    }

    synchronized String srbGetResOnChoice(int catType, String logResName, String phyResName, String inputFlag) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjProxyOpr");
        }
        this.startSRBCommand(2124, 3);
        this.sendArg(catType);
        this.sendArg(logResName);
        this.sendArg(inputFlag);
        this.flush();
        this.commandStatus();
        return new String(this.returnBytes());
    }

    synchronized void srbRmContainer(int catType, String containerName, boolean force) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRmContainer");
        }
        if (this.versionNumber <= 3.0f) {
            this.startSRBCommand(2125, 2);
            this.sendArg(catType);
            this.sendArg(containerName);
        } else if (force) {
            this.startSRBCommand(2125, 3);
            this.sendArg(catType);
            this.sendArg(containerName);
            this.sendArg(1);
        } else {
            this.startSRBCommand(2125, 3);
            this.sendArg(catType);
            this.sendArg(containerName);
            this.sendArg(1006);
        }
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbSyncContainer(int catType, String containerName, int syncFlag) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbSyncContainer");
        }
        this.startSRBCommand(2126, 3);
        this.sendArg(catType);
        this.sendArg(containerName);
        this.sendArg(syncFlag);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbReplContainer(int catType, String containerName, String newResourceName) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbReplContainer");
        }
        this.startSRBCommand(2127, 3);
        this.sendArg(catType);
        this.sendArg(containerName);
        this.sendArg(newResourceName);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized String[] srbTapelibMntCart(String tapeNum, int priority) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbTapelibMntCart");
        }
        this.startSRBCommand(5000, 3);
        this.sendArg(tapeNum);
        this.sendArg(priority);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
        return null;
    }

    synchronized void srbTapelibDismntCart(String tapeNum) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbTapelibDismntCart");
        }
        this.startSRBCommand(5001, 2);
        this.sendArg(tapeNum);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbRegInternalCompObj(String objName, String objCollName, int objReplNum, int objSegNum, String intObjRescName, String dataPathName, long dataSize, long offset, int inpIntReplNum, int intSegNum, int objTypeInx, String phyResLoc) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegInternalCompObj");
        }
        this.startSRBCommand(5102, 12);
        this.sendArg(objName);
        this.sendArg(objCollName);
        this.sendArg(objReplNum);
        this.sendArg(objSegNum);
        this.sendArg(intObjRescName);
        this.sendArg(dataPathName);
        this.sendArg(dataSize);
        this.sendArg(offset);
        this.sendArg(inpIntReplNum);
        this.sendArg(intSegNum);
        this.sendArg(objTypeInx);
        this.sendArg(phyResLoc);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbRmIntCompObj(String objName, String objCollName, int objReplNum, int objSegNum, int inpIntReplNum, int intSegNum) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRmIntCompObj");
        }
        this.startSRBCommand(5101, 6);
        this.sendArg(objName);
        this.sendArg(objCollName);
        this.sendArg(objReplNum);
        this.sendArg(objSegNum);
        this.sendArg(inpIntReplNum);
        this.sendArg(intSegNum);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbRmCompObj(String objName, String objCollName, int objReplNum, int objSegNum) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRmCompObj");
        }
        this.startSRBCommand(5104, 4);
        this.sendArg(objName);
        this.sendArg(objCollName);
        this.sendArg(objReplNum);
        this.sendArg(objSegNum);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbModInternalCompObj(String objID, String collectionName, int objReplNum, int objSegNum, int inpIntReplNum, int intSegNum, String data_value_1, String data_value_2, String data_value_3, String data_value_4, int retraction_type) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModInternalCompObj");
        }
        this.startSRBCommand(5105, 11);
        this.sendArg(objID);
        this.sendArg(collectionName);
        this.sendArg(objReplNum);
        this.sendArg(objSegNum);
        this.sendArg(inpIntReplNum);
        this.sendArg(intSegNum);
        this.sendArg(data_value_1);
        this.sendArg(data_value_2);
        this.sendArg(data_value_3);
        this.sendArg(data_value_4);
        this.sendArg(retraction_type);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbModifyRescInfo(int catType, String resourceName, int actionType, String dataValue1, String dataValue2, String dataValue3, String dataValue4) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModifyRescInfo");
        }
        this.startSRBCommand(2140, 7);
        this.sendArg(catType);
        this.sendArg(resourceName);
        this.sendArg(actionType);
        this.sendArg(dataValue1);
        this.sendArg(dataValue2);
        this.sendArg(dataValue3);
        this.sendArg(dataValue4);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbRegisterLocation(String locName, String fullAddr, String parentLoc, String serverUser, String serverUserDomain) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterLocation");
        }
        this.startSRBCommand(2142, 5);
        this.sendArg(locName);
        this.sendArg(fullAddr);
        this.sendArg(parentLoc);
        this.sendArg(serverUser);
        this.sendArg(serverUserDomain);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbIngestToken(String typeName, String newValue, String parentValue) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbIngestToken");
        }
        this.startSRBCommand(2143, 3);
        this.sendArg(typeName);
        this.sendArg(newValue);
        this.sendArg(parentValue);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbRegisterResource(String rescName, String rescType, String location, String phyPath, String className, int size) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterResource");
        }
        this.startSRBCommand(2144, 6);
        this.sendArg(rescName);
        this.sendArg(rescType);
        this.sendArg(location);
        this.sendArg(phyPath);
        this.sendArg(className);
        this.sendArg(size);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbRegisterLogicalResource(String rescName, String rescType, String phyResc, String phyPath) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterLogicalResource");
        }
        this.startSRBCommand(2145, 4);
        this.sendArg(rescName);
        this.sendArg(rescType);
        this.sendArg(phyResc);
        this.sendArg(phyPath);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbRegisterReplicateResourceInfo(String physicalRescName, String rescType, String oldLogicalRescName, String indefaultPath) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterReplicateResourceInfo");
        }
        this.startSRBCommand(2146, 4);
        this.sendArg(physicalRescName);
        this.sendArg(rescType);
        this.sendArg(oldLogicalRescName);
        this.sendArg(indefaultPath);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbDeleteValue(int valueType, String deleteValue) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbDeleteValue");
        }
        this.startSRBCommand(2147, 2);
        this.sendArg(valueType);
        this.sendArg(deleteValue);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbBulkRegister(int catType, String containerName, SRBMetaDataRecordList[] rl) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbBulkRegister");
        }
        this.startSRBCommand(2138, 3);
        this.sendArg(catType);
        this.sendArg(containerName);
        this.sendArg(rl);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
        this.status();
    }

    synchronized InputStream srbExecCommand(String command, String commandArgs, String hostAddress, int portalFlag, int fireWallMinPort, int fireWallMaxPort) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbExecCommand");
        }
        ServerSocket serverSocket = new ServerSocket();
        if (fireWallMinPort >= 0) {
            do {
                block7: {
                    if (fireWallMinPort > fireWallMaxPort) {
                        throw new IOException("The bind operation failed, all ports already bound.");
                    }
                    try {
                        serverSocket = new ServerSocket(fireWallMinPort);
                    }
                    catch (IOException e) {
                        if (DEBUG <= 0) break block7;
                        e.printStackTrace();
                    }
                }
                ++fireWallMinPort;
            } while (!serverSocket.isBound());
        } else {
            serverSocket = new ServerSocket(0);
        }
        int localPort = serverSocket.getLocalPort();
        String localAddress = this.srbConnection.getLocalAddress().getHostAddress();
        Socket receiveSocket = null;
        DataInputStream receiveIn = null;
        this.startSRBCommand(2011, 12);
        this.sendArg(1);
        this.sendArg(portalFlag);
        this.sendArg(localPort);
        this.sendArg(0);
        this.sendArg(0);
        this.sendArg(command);
        this.sendArg(commandArgs);
        this.sendArg(hostAddress);
        this.sendArg(localAddress);
        this.sendArg("");
        this.sendArg("");
        this.sendArg("");
        this.flush();
        receiveSocket = serverSocket.accept();
        receiveIn = new DataInputStream(receiveSocket.getInputStream());
        this.commandStatus();
        this.returnInt();
        return receiveIn;
    }

    synchronized InputStream srbExecCommand(String command, String commandArgs, String hostAddress, String fileName, int portalFlag, int fireWallMinPort, int fireWallMaxPort) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbExecCommand");
        }
        ServerSocket serverSocket = new ServerSocket();
        if (fireWallMinPort >= 0) {
            do {
                block7: {
                    if (fireWallMinPort > fireWallMaxPort) {
                        throw new IOException("The bind operation failed, all ports already bound.");
                    }
                    try {
                        serverSocket = new ServerSocket(fireWallMinPort);
                    }
                    catch (IOException e) {
                        if (DEBUG <= 0) break block7;
                        e.printStackTrace();
                    }
                }
                ++fireWallMinPort;
            } while (!serverSocket.isBound());
        } else {
            serverSocket = new ServerSocket(0);
        }
        int localPort = serverSocket.getLocalPort();
        int resolvePath = 1;
        String localAddress = this.srbConnection.getLocalAddress().getHostAddress();
        Socket receiveSocket = null;
        DataInputStream receiveIn = null;
        this.startSRBCommand(2011, 12);
        this.sendArg(1);
        this.sendArg(portalFlag);
        this.sendArg(localPort);
        this.sendArg(resolvePath);
        this.sendArg(0);
        this.sendArg(command);
        this.sendArg(commandArgs);
        this.sendArg(hostAddress);
        this.sendArg(localAddress);
        this.sendArg(fileName);
        this.sendArg("");
        this.sendArg("");
        this.flush();
        receiveSocket = serverSocket.accept();
        receiveIn = new DataInputStream(receiveSocket.getInputStream());
        this.commandStatus();
        this.returnInt();
        return receiveIn;
    }

    synchronized void srbSyncData(int catType, String objID, String collectionName, String resource) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbSyncData");
        }
        this.startSRBCommand(2139, 4);
        this.sendArg(catType);
        this.sendArg(objID);
        this.sendArg(collectionName);
        this.sendArg(resource);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized int srbContainerOpen(int catType, String containerName, int openFlag) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbContainerOpen");
        }
        this.startSRBCommand(2130, 3);
        this.sendArg(catType);
        this.sendArg(containerName);
        this.sendArg(openFlag);
        this.flush();
        this.commandStatus();
        return this.returnInt();
    }

    synchronized void srbContainerClose(int confFd) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbContainerClose");
        }
        this.startSRBCommand(2131, 1);
        this.sendArg(confFd);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized long srbObjCopy(String srcObjID, String srcCollection, String destObjID, String destCollection, String destResource) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjCopy");
        }
        this.startSRBCommand(2133, 5);
        this.sendArg(srcObjID);
        this.sendArg(srcCollection);
        this.sendArg(destObjID);
        this.sendArg(destCollection);
        this.sendArg(destResource);
        this.flush();
        this.commandStatus();
        return this.returnLong();
    }

    synchronized long srbObjPut(String destObjID, String destCollection, String destResLoc, String dataType, String destPath, String localFilePath, long srcSize, int fireWallMinPort, int fireWallMaxPort) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjPut " + destObjID + " " + destCollection);
        }
        this.totalBytesMoved = 0L;
        this.bytesMoved = 0L;
        if (srcSize <= 0L) {
            this.srbObjCreate(0, destObjID, dataType, destResLoc, destCollection, "", 0L);
            return 0L;
        }
        short cookie = (short)(Math.random() * 32767.0);
        String mode = "r";
        LocalRandomAccessFile localRAF = new LocalRandomAccessFile(localFilePath, mode);
        ServerSocket sSocket = new ServerSocket();
        if (fireWallMinPort >= 0) {
            do {
                block17: {
                    if (fireWallMinPort > fireWallMaxPort) {
                        throw new IOException("The bind operation failed, all ports already bound.");
                    }
                    try {
                        sSocket = new ServerSocket(fireWallMinPort);
                    }
                    catch (IOException e) {
                        if (DEBUG <= 0) break block17;
                        e.printStackTrace();
                    }
                }
                ++fireWallMinPort;
            } while (!sSocket.isBound());
        } else {
            sSocket = new ServerSocket(0);
        }
        int port = sSocket.getLocalPort();
        ParallelManager manager = new ParallelManager(sSocket, cookie, localRAF, srcSize, mode);
        Thread managerThread = new Thread(manager);
        managerThread.start();
        if (this.versionNumber < 3.0f) {
            this.startSRBCommand(2135, 8);
            this.sendArg(destObjID);
            this.sendArg(destCollection);
            this.sendArg(destResLoc);
            this.sendArg(this.srbConnection.getLocalAddress().getHostAddress());
            this.sendArg(cookie << 16 & 0x7FFF0000 | port);
            this.sendArg(dataType);
            this.sendArg(destPath);
            this.sendArg(srcSize);
        } else {
            this.startSRBCommand(2135, 9);
            this.sendArg(destObjID);
            this.sendArg(destCollection);
            this.sendArg(destResLoc);
            this.sendArg(this.srbConnection.getLocalAddress().getHostAddress());
            this.sendArg(cookie << 16 & 0x7FFF0000 | port);
            this.sendArg(dataType);
            this.sendArg(destPath);
            this.sendArg(srcSize);
            this.sendArg(1);
        }
        this.flush();
        this.commandStatus();
        long value = this.returnLong();
        if (value >= 0L) {
            try {
                if (managerThread.isAlive()) {
                    managerThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        localRAF.close();
        if (value < 0L) {
            block18: {
                try {
                    byte[] bytes = new byte[8];
                    Host.copyInt(value, bytes);
                    value = Host.castToUnsignedInt(bytes);
                }
                catch (NullPointerException e) {
                    if (DEBUG <= 0) break block18;
                    e.printStackTrace();
                }
            }
            throw new SRBException("", (int)value);
        }
        return value;
    }

    synchronized long srbObjPutClientInitiated(String destObjID, String destCollection, String destResLoc, String dataType, String destPath, String localFilePath, long srcSize, int forceFlag, int numThreads) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjPutClientInitiated");
        }
        int x = -1;
        this.totalBytesMoved = 0L;
        this.bytesMoved = 0L;
        if (srcSize <= 0L) {
            this.srbObjCreate(0, destObjID, dataType, destResLoc, destCollection, "", 0L);
            return 0L;
        }
        LocalFile lll = new LocalFile("lkjh");
        System.out.println(lll);
        LocalRandomAccessFile raf = new LocalRandomAccessFile(lll, "rw");
        this.startSRBCommand(2165, 8);
        this.sendArg(destObjID);
        this.sendArg(destCollection);
        this.sendArg(destResLoc);
        this.sendArg(dataType);
        this.sendArg(destPath);
        this.sendArg(srcSize);
        this.sendArg(forceFlag);
        this.sendArg(1);
        this.flush();
        this.commandStatus();
        int returnedByteCount = this.readInt();
        System.out.println("returnedByteCount " + returnedByteCount);
        if (returnedByteCount < 0) {
            throw new SRBException(returnedByteCount);
        }
        long newPortList = this.readUnsignedInt();
        System.out.println("newPortList " + newPortList);
        if (newPortList == 888888L) {
            int numberOfAddresses = (int)this.readUnsignedInt();
            System.out.println("numberOfAddresses " + numberOfAddresses);
            int[] portNum = new int[numberOfAddresses];
            int[] cookie = new int[numberOfAddresses];
            String[] hostAddr = new String[numberOfAddresses];
            byte[] cookiePort = null;
            int i = 0;
            while (i < numberOfAddresses) {
                cookiePort = this.read(4);
                cookie[i] = ((cookiePort[0] & 0xFF) << 8) + (cookiePort[1] & 0xFF);
                portNum[i] = ((cookiePort[2] & 0xFF) << 8) + (cookiePort[3] & 0xFF);
                ++i;
            }
            i = 0;
            while (i < numberOfAddresses) {
                hostAddr[i] = this.readString();
                System.out.println("hostAddr " + hostAddr[i]);
                ++i;
            }
            System.out.println("cookie " + cookie[0]);
            System.out.println("portNum " + portNum[0]);
            this.status();
            byte[] byArray = new byte[4];
            byArray[2] = cookiePort[0];
            byArray[3] = cookiePort[1];
            byte[] ddd = byArray;
            this.out.write(ddd);
            System.out.println("after cookie check main");
            Socket[] transferSocket = new Socket[4];
            int i2 = 0;
            while (i2 < 1) {
                transferSocket[i2] = new Socket(hostAddr[0], portNum[0]);
                InputStream inny = transferSocket[i2].getInputStream();
                OutputStream outy = transferSocket[i2].getOutputStream();
                outy.write(ddd);
                ++i2;
            }
            System.out.println("after cookie second");
            System.out.println("\nafter spawn2 cookie");
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(0);
            this.out.write(3);
            this.out.write((int)srcSize);
            byte[] buffer = new byte[(int)((GeneralRandomAccessFile)raf).length()];
            this.out.write(raf.read(buffer));
            int asdf = transferSocket[0].getInputStream().read();
            System.out.println("transferSocket asdf " + asdf);
            System.out.println("transferSocket " + transferSocket[0].isConnected());
            while (x < 16) {
                System.out.println(String.valueOf(asdf) + "-" + (char)asdf);
                asdf = transferSocket[0].getInputStream().read();
                ++x;
            }
            TransferThread transfer = new TransferThread(new Object(), transferSocket[0], raf, srcSize, new Object(), 0);
            transfer.run();
        }
        return 0L;
    }

    synchronized long srbObjGet(String srcObjID, String srcCollection, long srcSize, GeneralFile file, int fireWallMinPort, int fireWallMaxPort, boolean forceOverwrite) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjGet");
        }
        this.totalBytesMoved = 0L;
        this.bytesMoved = 0L;
        short cookie = (short)(Math.random() * 32767.0);
        String mode = "rw";
        GeneralRandomAccessFile raf = FileFactory.newRandomAccessFile(file, mode);
        if (forceOverwrite && file.length() > srcSize) {
            try {
                raf.setLength(srcSize);
            }
            catch (UnsupportedOperationException e) {
                if (DEBUG > 0) {
                    e.printStackTrace();
                }
                file.delete();
                raf = FileFactory.newRandomAccessFile(file, "rw");
            }
            catch (IOException e) {
                if (DEBUG > 0) {
                    e.printStackTrace();
                }
                file.delete();
                raf = FileFactory.newRandomAccessFile(file, "rw");
            }
        } else if (!forceOverwrite) {
            raf.seek(raf.length());
        }
        ServerSocket sSocket = null;
        if (fireWallMinPort >= 0) {
            do {
                block21: {
                    if (fireWallMinPort > fireWallMaxPort) {
                        throw new IOException("The bind operation failed, all ports already bound.");
                    }
                    try {
                        sSocket = new ServerSocket(fireWallMinPort);
                    }
                    catch (IOException e) {
                        if (DEBUG <= 0) break block21;
                        e.printStackTrace();
                    }
                }
                ++fireWallMinPort;
            } while (!sSocket.isBound());
        } else {
            sSocket = new ServerSocket(0);
        }
        int port = sSocket.getLocalPort();
        ParallelManager manager = new ParallelManager(sSocket, cookie, raf, srcSize, mode);
        Thread managerThread = new Thread(manager);
        managerThread.start();
        this.startSRBCommand(2137, 4);
        this.sendArg(srcObjID);
        this.sendArg(srcCollection);
        this.sendArg(this.srbConnection.getLocalAddress().getHostAddress());
        this.sendArg(cookie << 16 & 0x7FFF0000 | port);
        this.flush();
        this.commandStatus();
        long value = this.returnLong();
        if (value > 0L) {
            try {
                if (managerThread.isAlive()) {
                    managerThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            raf.close();
        } else if (value < 0L) {
            throw new SRBException("", (int)value);
        }
        return value;
    }

    synchronized long srbObjGetClientInitiated(String srcObjID, String srcCollection, GeneralFile destination, int flag, int numThreads) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjGetClientInitiated");
        }
        this.totalBytesMoved = 0L;
        this.bytesMoved = 0L;
        this.startSRBCommand(2163, 4);
        this.sendArg(srcObjID);
        this.sendArg(srcCollection);
        this.sendArg(flag);
        this.sendArg(numThreads);
        this.flush();
        this.commandStatus();
        long srcSize = 1L;
        int returnedByteCount = this.readInt();
        if (returnedByteCount < 0) {
            throw new SRBException(returnedByteCount);
        }
        long newPortList = this.readUnsignedInt();
        while (newPortList == 888888L) {
            int numberOfAddresses = (int)this.readUnsignedInt();
            int[] portNum = new int[numberOfAddresses];
            int[] cookie = new int[numberOfAddresses];
            String[] hostAddr = new String[numberOfAddresses];
            byte[] cookiePort = null;
            Socket[] transferSocket = new Socket[numThreads];
            GeneralRandomAccessFile raf = FileFactory.newRandomAccessFile(destination, "rw");
            Thread[] transferThreads = new Thread[numThreads];
            TransferThread[] transfer = new TransferThread[numThreads];
            int i = 0;
            while (i < numberOfAddresses) {
                cookiePort = this.read(4);
                cookie[i] = ((cookiePort[0] & 0xFF) << 8) + (cookiePort[1] & 0xFF);
                portNum[i] = ((cookiePort[2] & 0xFF) << 8) + (cookiePort[3] & 0xFF);
                ++i;
            }
            i = 0;
            while (i < numberOfAddresses) {
                hostAddr[i] = this.readString();
                ++i;
            }
            this.status();
            byte[] byArray = new byte[4];
            byArray[2] = cookiePort[0];
            byArray[3] = cookiePort[1];
            byte[] cookieBytes = byArray;
            int i2 = 0;
            while (i2 < numThreads) {
                transferSocket[i2] = new Socket(hostAddr[0], portNum[0]);
                OutputStream outy = transferSocket[i2].getOutputStream();
                outy.write(cookieBytes);
                if (i2 == 0) {
                    DataInputStream inny = new DataInputStream(transferSocket[i2].getInputStream());
                    inny.readInt();
                    inny.readInt();
                    srcSize = inny.readLong();
                }
                transfer[i2] = new TransferThread(raf, transferSocket[i2], raf, srcSize, new Object(), i2);
                transferThreads[i2] = new Thread(transfer[i2]);
                transferThreads[i2].start();
                ++i2;
            }
            try {
                i2 = 0;
                while (i2 < numThreads) {
                    if (transferThreads[i2].isAlive()) {
                        transferThreads[i2].join();
                    }
                    ++i2;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            raf.close();
            this.commandStatus();
            newPortList = this.readUnsignedInt();
        }
        if (newPortList < 0L) {
            throw new SRBException((int)newPortList);
        }
        this.read(4);
        this.status();
        return srcSize;
    }

    long getBytesMoved() {
        return this.bytesMoved;
    }

    synchronized void srbGetMcatZone(String userName, String domainName, String mcatName) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGetMcatZone");
        }
        this.startSRBCommand(2151, 2);
        this.sendArg(userName);
        this.sendArg(domainName);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbSetupSessionPublicKey(String publicKey) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbSetupSessionPublicKey");
        }
        this.startSRBCommand(2149, 1);
        this.sendArg(0);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbSetupSession(String sessionKey) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbSetupSession");
        }
        this.startSRBCommand(2148, 1);
        this.sendArg(sessionKey);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbBulkLoad(int catType, String bulkLoadFilePath, SRBMetaDataRecordList[] rl) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbBulkLoad");
        }
        this.startSRBCommand(2150, 3);
        this.sendArg(catType);
        this.sendArg(bulkLoadFilePath);
        this.sendArg(rl);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbBulkUnload(int catType, int flag, String srbUnloadDirPath, String localDirPath) throws IOException {
        block18: {
            int i;
            if (DEBUG > 0) {
                System.out.println("\n srbBulkUnload");
            }
            this.totalBytesMoved = 0L;
            this.bytesMoved = 0L;
            int status = 0;
            Socket[] bulkConn = null;
            InputStream[] bulkIn = null;
            OutputStream[] bulkOut = null;
            SRBMetaDataRecordList[] rl = null;
            int numAddr = 1;
            int[] cookie = null;
            int[] portNum = null;
            byte[] temp = null;
            byte[] temp2 = null;
            String hostAddress = null;
            InputStream tempIn = this.in;
            TransferThread[] transfer = null;
            Thread[] transferThread = null;
            this.startSRBCommand(2158, 3);
            this.sendArg(catType);
            this.sendArg(flag);
            this.sendArg(srbUnloadDirPath);
            this.flush();
            this.commandStatus();
            status = this.readInt();
            temp = this.read(4);
            status = Host.castToInt(temp);
            if (status == -99999999) {
                this.singlePortBulkUnload = true;
                numAddr = 1;
                this.status();
            } else {
                if (status < 0) {
                    throw new SRBException(status);
                }
                numAddr = Host.castToInt(this.read(4));
                cookie = new int[numAddr];
                portNum = new int[numAddr];
                temp = new byte[4];
                temp2 = new byte[4];
                i = 0;
                while (i < numAddr) {
                    temp[2] = this.read();
                    temp[3] = this.read();
                    cookie[i] = Host.castToInt(temp);
                    temp2[2] = this.read();
                    temp2[3] = this.read();
                    portNum[i] = Host.castToInt(temp2);
                    ++i;
                }
                hostAddress = this.readString();
                this.status();
                bulkConn = new Socket[numAddr];
                bulkIn = new InputStream[numAddr];
                bulkOut = new OutputStream[numAddr];
                i = 0;
                while (i < numAddr) {
                    try {
                        bulkConn[i] = new Socket(hostAddress, portNum[i]);
                        bulkIn[i] = bulkConn[i].getInputStream();
                        bulkOut[i] = bulkConn[i].getOutputStream();
                    }
                    catch (ConnectException e) {
                        ConnectException connException = new ConnectException("Bulk download connection cannot be made to: " + hostAddress + " at port: " + portNum[i]);
                        connException.initCause(e);
                        throw connException;
                    }
                    catch (SocketException e) {
                        SocketException socketException = new SocketException("A bulk download socket error occured when connecting to: " + hostAddress + " at port: " + portNum[i]);
                        socketException.initCause(e);
                        throw socketException;
                    }
                    ++i;
                }
            }
            transfer = new TransferThread[numAddr];
            transferThread = new Thread[numAddr];
            if (status == -99999999) {
                rl = this.returnSRBMetaDataRecordList(true, true);
                if (rl != null) {
                    transfer[0] = new TransferThread(this.srbConnection, rl, localDirPath, srbUnloadDirPath);
                    transferThread[0] = new Thread(transfer[0]);
                    transferThread[0].start();
                }
            } else {
                tempIn = this.in;
                i = 0;
                while (i < numAddr) {
                    bulkOut[i].write(temp);
                    this.in = bulkIn[i];
                    this.read(4);
                    rl = this.returnSRBMetaDataRecordList(true, true);
                    this.in = tempIn;
                    transfer[i] = new TransferThread(bulkConn[i], rl, localDirPath, srbUnloadDirPath);
                    transferThread[i] = new Thread(transfer[i]);
                    transferThread[i].start();
                    ++i;
                }
            }
            try {
                i = 0;
                while (i < transferThread.length) {
                    if (transferThread[i] != null && transferThread[i].isAlive()) {
                        transferThread[i].join();
                    }
                    ++i;
                }
            }
            catch (InterruptedException e) {
                if (DEBUG <= 0) break block18;
                e.printStackTrace();
            }
        }
        if (this.singlePortBulkUnload) {
            this.singlePortBulkUnload = false;
        }
    }

    synchronized void srbModifyZone(int catType, String zoneName, String dataValue1, String dataValue2, String dataValue3, String dataValue4, String dataValue5, int actionType) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModifyZone");
        }
        this.startSRBCommand(2152, 8);
        this.sendArg(catType);
        this.sendArg(zoneName);
        this.sendArg(dataValue1);
        this.sendArg(dataValue2);
        this.sendArg(dataValue3);
        this.sendArg(dataValue4);
        this.sendArg(dataValue5);
        this.sendArg(actionType);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized MetaDataRecordList[] srbBulkQueryAnswer(int catType, String queryInfo, MetaDataRecordList myresult, int rowsWanted) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbBulkQueryAnswer");
        }
        this.startSRBCommand(2153, 3);
        this.sendArg(catType);
        this.sendArg(queryInfo);
        this.sendArg(rowsWanted);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList();
    }

    synchronized void srbBulkMcatIngest(int catType, String ingestInfo, SRBMetaDataRecordList[] rl) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbBulkMcatIngest");
        }
        this.startSRBCommand(2154, 3);
        this.sendArg(catType);
        this.sendArg(ingestInfo);
        this.sendArg(rl);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbBackupData(int catType, String objID, String collectionName, String backupResource, int flag) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbBackupData");
        }
        this.startSRBCommand(2159, 5);
        this.sendArg(catType);
        this.sendArg(objID);
        this.sendArg(collectionName);
        this.sendArg(backupResource);
        this.sendArg(flag);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized byte[] srbObjChksum(String objID, String collectionName, int chksumFlag, String inpChksum) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjChksum");
        }
        this.startSRBCommand(2015, 4);
        this.sendArg(objID);
        this.sendArg(collectionName);
        this.sendArg(chksumFlag);
        this.sendArg(inpChksum);
        this.flush();
        this.commandStatus();
        int length = this.readInt();
        if (length < 0) {
            throw new SRBException(length);
        }
        byte[] checksum = null;
        byte[] temp = this.read(length);
        this.status();
        int i = 4;
        while (i < length) {
            if (temp[i] == 0) {
                checksum = new byte[i - 4];
                System.arraycopy(temp, 4, checksum, 0, i - 4);
                i = length;
            }
            ++i;
        }
        return checksum;
    }

    synchronized void srbModifyUserNonPriv(int catType, String userNameDomain, String dataValue1, String dataValue2, String dataValue3, String dataValue4, String dataValue5, int actionType) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModifyUserNonPriv");
        }
        this.startSRBCommand(2161, 8);
        this.sendArg(catType);
        this.sendArg(userNameDomain);
        this.sendArg(dataValue1);
        this.sendArg(dataValue2);
        this.sendArg(dataValue3);
        this.sendArg(dataValue4);
        this.sendArg(dataValue5);
        this.sendArg(actionType);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    synchronized void srbModifyResource(int catType, String resourceName, String dataValue1, String dataValue2, String dataValue3, String dataValue4, int actionType) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModifyResource");
        }
        this.startSRBCommand(2162, 7);
        this.sendArg(catType);
        this.sendArg(resourceName);
        this.sendArg(dataValue1);
        this.sendArg(dataValue2);
        this.sendArg(dataValue3);
        this.sendArg(dataValue4);
        this.sendArg(actionType);
        this.flush();
        this.commandStatus();
        int status = this.returnInt();
        if (status < 0) {
            throw new SRBException(status);
        }
    }

    String srbGetSvrVersion() throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGetSvrVersion");
        }
        int STRING_LEN1 = 512;
        byte[] buffer = new byte[1];
        String version = "";
        this.startSRBCommand(1051, 0);
        this.flush();
        this.commandStatus();
        this.read(8);
        buffer = this.read(1);
        while (buffer[0] != 0) {
            version = String.valueOf(version) + (char)buffer[0];
            buffer = this.read(1);
        }
        this.status();
        return version;
    }

    static /* synthetic */ OutputStream access$0(SRBCommands sRBCommands) {
        return sRBCommands.out;
    }

    static /* synthetic */ void access$1(SRBCommands sRBCommands, OutputStream outputStream) {
        sRBCommands.out = outputStream;
    }

    static /* synthetic */ InputStream access$2(SRBCommands sRBCommands) {
        return sRBCommands.in;
    }

    static /* synthetic */ void access$3(SRBCommands sRBCommands, InputStream inputStream) {
        sRBCommands.in = inputStream;
    }

    class ParallelManager
    implements Runnable {
        private ServerSocket listener;
        private short cookie;
        private GeneralRandomAccessFile raf;
        private long srcSize;
        boolean parallelComplete = false;
        private boolean[] threads = new boolean[33];
        private String mode;

        ParallelManager(ServerSocket listener, short cookie, GeneralRandomAccessFile raf, long srcSize, String mode) {
            this.listener = listener;
            this.cookie = cookie;
            this.raf = raf;
            this.srcSize = srcSize;
            this.mode = mode;
            SRBCommands.this.bytesMoved = 0L;
        }

        void threadComplete(int i) {
            this.threads[i] = false;
            int j = 0;
            while (j < this.threads.length) {
                if (this.threads[j]) {
                    return;
                }
                ++j;
            }
            this.parallelComplete = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            int i = 0;
            boolean n = false;
            Socket transferSocket = null;
            Object transferThread = null;
            Thread[] transferThreads = new Thread[33];
            try {
                while (!this.parallelComplete) {
                    transferSocket = this.listener.accept();
                    DataInputStream in = new DataInputStream(transferSocket.getInputStream());
                    int myCookie = in.readInt();
                    if (myCookie != this.cookie) continue;
                    this.raf = FileFactory.newRandomAccessFile(this.raf.getFile(), this.mode);
                    this.threads[i] = true;
                    TransferThread transfer = new TransferThread(this, transferSocket, this.raf, this.srcSize, this.listener, i);
                    transferThreads[i] = new Thread(transfer);
                    transferThreads[i].start();
                    ++i;
                }
            }
            catch (SocketException e) {
                if (DEBUG > 1) {
                    e.printStackTrace();
                }
                try {
                    i = 0;
                    while (true) {
                        if (i >= transferThreads.length) {
                            return;
                        }
                        if (transferThreads[i] != null && transferThreads[i].isAlive()) {
                            transferThreads[i].join();
                        }
                        ++i;
                    }
                }
                catch (InterruptedException inE) {
                    if (DEBUG <= 0) return;
                    inE.printStackTrace();
                    return;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("IOException in thread.");
            }
            try {
                i = 0;
                while (true) {
                    if (i >= transferThreads.length) {
                        return;
                    }
                    if (transferThreads[i] != null && transferThreads[i].isAlive()) {
                        transferThreads[i].join();
                    }
                    ++i;
                }
            }
            catch (InterruptedException inE) {
                if (DEBUG <= 0) return;
                inE.printStackTrace();
            }
        }
    }

    class TransferThread
    implements Runnable {
        private Socket transferSocket;
        private GeneralRandomAccessFile raf;
        private long srcSize;
        private Object listener;
        private SRBMetaDataRecordList[] rl;
        private String directoryPath;
        private String sourcePath;
        private Object syncObject;
        long length;
        int whichThread;

        TransferThread(Object syncObject, Socket transferSocket, GeneralRandomAccessFile raf, long srcSize, Object listener, int threadID) {
            this.whichThread = threadID;
            this.transferSocket = transferSocket;
            this.raf = raf;
            this.srcSize = srcSize;
            this.listener = listener;
            this.syncObject = syncObject;
        }

        TransferThread(Socket transferSocket, SRBMetaDataRecordList[] rl, String targetDirectoryPath, String sourcePath) throws IOException {
            this.transferSocket = transferSocket;
            this.rl = rl;
            this.directoryPath = targetDirectoryPath;
            this.sourcePath = sourcePath;
            this.srcSize = -1L;
            this.listener = null;
            this.raf = this.correctedRAFPath(0);
            this.length = Long.parseLong(rl[0].getValue(rl[0].getFieldIndex("size")).toString());
        }

        protected void finalize() throws Throwable {
            if (this.transferSocket != null) {
                this.transferSocket = null;
            }
            super.finalize();
        }

        private GeneralRandomAccessFile correctedRAFPath(int i) throws IOException {
            LocalFile subDir;
            String dir = this.rl[i].getValue("directory name").toString();
            if (!dir.equals(this.sourcePath)) {
                dir = dir.substring(this.sourcePath.length() + 1);
                subDir = new LocalFile(this.directoryPath, dir);
            } else {
                subDir = new LocalFile(this.directoryPath);
            }
            subDir.mkdirs();
            return FileFactory.newRandomAccessFile(new LocalFile(subDir, this.rl[i].getValue("file name").toString()), "rw");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            try {
                in = new DataInputStream(this.transferSocket.getInputStream());
                out = this.transferSocket.getOutputStream();
                buffer = null;
                i = 0;
                temp = 0;
                maxReadSize = 1448;
                operation = in.readInt();
                if (operation < 0 || operation > 4) {
                    throw new ProtocolException("Unknown transfer operation");
                }
                transferLength = in.readInt();
                buffer = new byte[8];
                in.read(buffer);
                offset = Host.castToUnsignedLong(buffer);
                if (offset < 0L) {
                    return;
                }
                if (transferLength <= 0L) {
                    return;
                }
                buffer = new byte[(int)transferLength];
                block10: while (transferLength > 0L) {
                    block3 : switch (operation) {
                        case 4: {
                            if (this.listener != null) ** GOTO lbl82
                            continueFlag = 1;
                            BUF_SIZE = 0x800000;
                            buffer = new byte[BUF_SIZE];
                            while (continueFlag > 0) {
                                bytesInBuf = 0;
                                i = 0;
                                ** GOTO lbl61
                                {
                                    if (transferLength <= 0L) {
                                        operation = in.readInt();
                                        transferLength = in.readInt();
                                        mybuffer = new byte[8];
                                        in.read(mybuffer);
                                    }
                                    toRead = this.length > (long)BUF_SIZE ? ((long)BUF_SIZE > transferLength ? transferLength : (long)BUF_SIZE) : (this.length > transferLength ? transferLength : this.length);
                                    bytesInBuf = 0;
                                    while (toRead > 0L) {
                                        readSz = toRead > (long)maxReadSize ? maxReadSize : (int)toRead;
                                        len = in.read(buffer, bytesInBuf, readSz);
                                        if (len <= 0) {
                                            System.out.print("BulkUnload sock read error." + readSz + "bytes more to read" + "\n");
                                            break;
                                        }
                                        toRead -= (long)len;
                                        bytesInBuf += len;
                                    }
                                    this.raf.write(buffer, (int)offset, bytesInBuf);
                                    this.length -= (long)bytesInBuf;
                                    transferLength -= (long)bytesInBuf;
                                    SRBCommands.this.bytesMoved += (long)bytesInBuf;
                                    bytesInBuf = 0;
                                    do {
                                        if (this.length > 0L) continue block12;
                                        this.raf.close();
                                        if (i + 1 < this.rl.length) {
                                            this.length = Long.parseLong(this.rl[i + 1].getValue(this.rl[i + 1].getFieldIndex("size")).toString());
                                            this.raf = this.correctedRAFPath(i + 1);
                                        }
                                        ++i;
lbl61:
                                        // 2 sources

                                    } while (i < this.rl.length);
                                }
                                if (!this.rl[this.rl.length - 1].isQueryComplete()) {
                                    this.rl = SRBCommands.this.returnSRBMetaDataRecordList(true, true, in);
                                    if (this.rl != null) {
                                        this.length = Long.parseLong(this.rl[0].getValue(this.rl[0].getFieldIndex("size")).toString());
                                        if (this.rl == null) {
                                            continueFlag = 0;
                                            transferLength = 0L;
                                            break block3;
                                        }
                                        this.raf = this.correctedRAFPath(0);
                                        in.read();
                                        continueFlag = 1;
                                    } else {
                                        continueFlag = 0;
                                    }
                                    transferLength = 0L;
                                    continue;
                                }
                                continueFlag = 0;
                                transferLength = 0L;
                                break block3;
                            }
                            continue block10;
lbl82:
                            // 1 sources

                            var12_13 = this.syncObject;
                            synchronized (var12_13) {
                                temp = 0;
                                if (transferLength <= (long)maxReadSize) ** GOTO lbl95
                                while (transferLength > (long)(temp + maxReadSize - 1)) {
                                    temp += in.read(buffer, temp, maxReadSize);
                                }
                                while (transferLength - (long)temp - 1L > 0L) {
                                    temp += in.read(buffer, temp, (int)transferLength - temp);
                                }
                                ** GOTO lbl96
lbl-1000:
                                // 1 sources

                                {
                                    temp += in.read(buffer, temp, (int)transferLength - temp);
lbl95:
                                    // 2 sources

                                    ** while (transferLength - (long)temp > 0L)
                                }
lbl96:
                                // 2 sources

                                SRBCommands.this.bytesMoved += (long)temp;
                                temp = 0;
                                if (this.raf.getFilePointer() != offset) {
                                    this.raf.seek(offset);
                                }
                                if (transferLength > 0L) {
                                    this.raf.write(buffer);
                                }
                                if ((operation = in.readInt()) < 0 || operation > 4) {
                                    throw new ProtocolException("Unknown transfer operation");
                                }
                                transferLength = in.readInt();
                                buffer = new byte[8];
                                in.read(buffer);
                                offset = Host.castToUnsignedLong(buffer);
                                if (offset < 0L) {
                                    break;
                                }
                                if (transferLength <= 0L) {
                                    break;
                                }
                                buffer = transferLength >= 0x7FFFFFFFL ? new byte[0x7FFFFFFE] : new byte[(int)transferLength];
                                break;
                            }
                        }
                        case 3: {
                            this.raf.seek(offset);
                            SRBCommands.this.bytesMoved += (long)this.raf.read(buffer);
                            out.write(buffer);
                            operation = in.readInt();
                            if (operation < 0 || operation > 4) {
                                throw new ProtocolException("Unknown transfer operation");
                            }
                            transferLength = in.readInt();
                            buffer = new byte[8];
                            in.read(buffer);
                            offset = Host.castToUnsignedLong(buffer);
                            if (offset < 0L || transferLength <= 0L || transferLength == (long)buffer.length) continue block10;
                            if (transferLength >= 0x7FFFFFFFL) {
                                buffer = new byte[0x7FFFFFFE];
                                break;
                            }
                            buffer = new byte[(int)transferLength];
                            break;
                        }
                        default: {
                            transferLength = 0L;
                        }
                    }
                }
                SRBCommands.this.totalBytesMoved += SRBCommands.this.bytesMoved;
                if (SRBCommands.this.totalBytesMoved >= this.srcSize && this.listener != null && this.listener instanceof ServerSocket) {
                    ((ServerSocket)this.listener).close();
                }
                if (this.syncObject != null && this.syncObject instanceof ParallelManager) {
                    ((ParallelManager)this.syncObject).threadComplete(this.whichThread);
                }
            }
            catch (SocketException e) {
                if (SRBCommands.access$0(SRBCommands.this) == null) {
                    SRBCommands.access$1(SRBCommands.this, null);
                }
                if (SRBCommands.access$2(SRBCommands.this) == null) {
                    SRBCommands.access$3(SRBCommands.this, null);
                }
                if (this.transferSocket != null) {
                    this.transferSocket = null;
                }
                if (SRBCommands.DEBUG > 0) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("IOException in thread.", e);
            }
        }
    }
}

