/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.RemoteFile;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import edu.sdsc.grid.io.srb.SRBRandomAccessFile;
import java.io.IOException;
import java.net.URI;
import java.util.Vector;

public class SRBContainer
extends SRBFile {
    static final int DEFAULT_CONTAINER_SIZE = 0xC800000;
    public static final String PURGE_SYNC = "synchronize then purge cache";
    public static final String PRIMARY_SYNC = "synchronize primary copy";
    long containerMaxSize = 0xC800000L;
    int bufferPos = 0;
    int useBuffer = 0;
    int numRegistrationThreads = 0;
    int registeredFiles = 0;
    int filesReadyToRegister = 0;
    int registrationOffset = 0;

    public SRBContainer(SRBFileSystem fileSystem, String filePath) {
        super(fileSystem, filePath);
    }

    public SRBContainer(SRBFileSystem fileSystem, String filePath, long containerMaxSize) {
        super(fileSystem, filePath);
        this.setContainerMaxSize(containerMaxSize);
    }

    public SRBContainer(SRBFile parent, String child) {
        super(parent, child);
    }

    public SRBContainer(SRBFile parent, String child, long containerMaxSize) {
        super(parent, child);
        this.setContainerMaxSize(containerMaxSize);
    }

    public SRBContainer(SRBFileSystem fileSystem, String parent, String child) {
        super(fileSystem, parent, child);
    }

    public SRBContainer(SRBFileSystem fileSystem, String parent, String child, long containerMaxSize) {
        super(fileSystem, parent, child);
        this.setContainerMaxSize(containerMaxSize);
    }

    public SRBContainer(URI uri) throws IOException {
        super(uri);
        this.setContainerMaxSize(this.containerMaxSize);
    }

    public void setContainerMaxSize(long containerMaxSize) {
        if (containerMaxSize < 0L) {
            throw new IllegalArgumentException();
        }
        this.containerMaxSize = containerMaxSize;
    }

    public long getContainerMaxSize() {
        try {
            MetaDataRecordList[] rl = this.query("container max size");
            if (rl != null) {
                return Long.parseLong(rl[0].getValue("container max size").toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0L;
    }

    public String getResource() throws IOException {
        MetaDataRecordList[] rl = this.query("resource name");
        if (rl != null) {
            return rl[0].getValue("resource name").toString();
        }
        return null;
    }

    public String getDataType() throws IOException {
        MetaDataRecordList[] rl = this.query("file type name");
        if (rl != null) {
            return rl[0].getValue("file type name").toString();
        }
        return null;
    }

    public void include(GeneralFile file) throws IOException {
        if (!this.exists()) {
            this.createNewFile();
        }
        int fd = this.srbFileSystem.srbObjCreate(this.catalogType, String.valueOf(file.getName()) + "&CONTAINER=" + this.getAbsolutePath(), this.dataType, this.resource, file.getParent(), "", file.length());
        byte[] inputBuffer = new byte[65535];
        long length = file.length();
        GeneralRandomAccessFile in = FileFactory.newRandomAccessFile(file, "r");
        if (length > 65535L) {
            do {
                in.read(inputBuffer);
                this.srbFileSystem.srbObjWrite(fd, inputBuffer, inputBuffer.length);
            } while ((length -= 65535L) > 65535L);
        }
        inputBuffer = new byte[(int)length];
        in.read(inputBuffer);
        this.srbFileSystem.srbObjWrite(fd, inputBuffer, inputBuffer.length);
        in.close();
        this.srbFileSystem.srbObjClose(fd);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] selects) throws IOException {
        return this.query(selects, SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] selects, int recordsWanted) throws IOException {
        MetaDataCondition[] iConditions = new MetaDataCondition[]{MetaDataSet.newCondition("container name", 0, this.getAbsolutePath())};
        return this.srbFileSystem.query(iConditions, selects, recordsWanted);
    }

    public void copyTo(GeneralFile file, boolean forceOverwrite, boolean bulkCopy) throws IOException {
        String[] list = this.list();
        if (!file.exists()) {
            file.mkdir();
        } else if (file.isFile()) {
            throw new IllegalArgumentException("The destination cannot be a file.");
        }
        if (file instanceof SRBContainer) {
            int i = 0;
            while (i < list.length) {
                ((SRBContainer)file).include(new SRBFile(this.srbFileSystem, list[i]));
                ++i;
            }
        } else {
            int i = 0;
            while (i < list.length) {
                GeneralFile temp = FileFactory.newFile(this, list[i]);
                temp.copyTo(FileFactory.newFile(file, temp.getName()));
                ++i;
            }
        }
    }

    public void copyFrom(GeneralFile file, boolean forceOverwrite, boolean bulkCopy) throws IOException {
        String[] list = file.list();
        if (!this.exists()) {
            this.createNewFile();
        }
        if (file.isFile()) {
            this.include(file);
        } else {
            int i = 0;
            while (i < list.length) {
                this.include(FileFactory.newFile(file, list[i]));
                ++i;
            }
        }
    }

    public void copyFromLocal(LocalFile localFile) throws IOException {
        if (localFile.isDirectory()) {
            this.copyFrom(localFile, false, false);
        }
        throw new UnsupportedOperationException("Cannot use copyFromLocal for containers");
    }

    public void copyFromLocal(String localFilePath) throws IOException {
        LocalFile localFile = new LocalFile(localFilePath);
        if (localFile.isDirectory()) {
            this.copyFrom(localFile, false, false);
        }
        throw new UnsupportedOperationException("Cannot use copyFromLocal for containers");
    }

    public void copyToLocal(LocalFile localFile) throws IOException {
        this.copyTo(localFile, false, false);
    }

    public void copyToLocal(String localFilePath) throws IOException {
        this.copyTo(new LocalFile(localFilePath), false, false);
    }

    public void copyToRemote(RemoteFile remoteFile) throws IOException, ClassCastException {
        this.copyTo(remoteFile);
    }

    public String getPermissions() throws IOException {
        MetaDataSelect[] selects;
        MetaDataRecordList[] rl = null;
        String userName = this.srbFileSystem.getUserName();
        String userDomain = this.srbFileSystem.getDomainName();
        MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("user name", 0, userName), MetaDataSet.newCondition("user domain", 0, userDomain)};
        rl = this.query(conditions, selects = new MetaDataSelect[]{MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain"), MetaDataSet.newSelection("access constraint")});
        if (rl != null) {
            int i = 0;
            while (i < rl.length) {
                if (rl[i].getValue("user name").equals(userName) && rl[i].getValue("user domain").equals(userDomain)) {
                    return rl[i].getValue("access constraint").toString();
                }
                ++i;
            }
        }
        return null;
    }

    public MetaDataRecordList[] getPermissions(boolean allUsers) throws IOException {
        return this.query("access constraint");
    }

    public void replicate(String newResource) throws IOException {
        this.srbFileSystem.srbReplContainer(this.catalogType, this.getPath(), newResource);
    }

    public void backup(String syncType) throws IOException {
        int syncFlag = 0;
        String path = this.getAbsolutePath();
        if (syncType == PURGE_SYNC) {
            syncFlag = 1;
        } else if (syncType == PRIMARY_SYNC) {
            syncFlag = 2;
        } else {
            path = String.valueOf(path) + ".*";
        }
        this.srbFileSystem.srbSyncContainer(this.catalogType, path, syncFlag);
    }

    void bulkLoad(LocalFile[] files) throws IOException {
        int MAX_REGISTRATION_THREADS = 4;
        long maxSize = -1L;
        long containerOffset = 0L;
        byte[] buffer1 = new byte[0x800000];
        byte[] buffer2 = new byte[0x800000];
        SRBRandomAccessFile raf = new SRBRandomAccessFile(this, "rw");
        Thread loadThread = null;
        LoadThread load = null;
        this.mkdir();
        RegistrationThread[] registration = new RegistrationThread[MAX_REGISTRATION_THREADS];
        int i = 0;
        while (i < MAX_REGISTRATION_THREADS) {
            registration[i] = new RegistrationThread(this.srbFileSystem, this.catalogType, this.getAbsolutePath());
            ++i;
        }
        Thread[] registrationThreads = new Thread[MAX_REGISTRATION_THREADS];
        int i2 = 0;
        while (i2 < MAX_REGISTRATION_THREADS) {
            registrationThreads[i2] = new Thread(registration[i2]);
            ++i2;
        }
        load = new LoadThread(raf, buffer1, buffer2);
        loadThread = new Thread(load);
        loadThread.start();
        i2 = 0;
        while (i2 < files.length) {
            this.loadBuffer(files[i2], load, this, registrationThreads, registration, null);
            ++i2;
        }
        if (this.useBuffer == 0 || this.useBuffer == 1) {
            load.buffer1Length = this.bufferPos;
        } else if (this.useBuffer == 2) {
            load.buffer2Length = this.bufferPos;
        }
        load.writeBuffer1 = true;
        while (load.writeBuffer1) {
        }
        load.writeBuffer2 = true;
        load.keepLoading = false;
        ((GeneralRandomAccessFile)raf).close();
        try {
            if (loadThread.isAlive()) {
                loadThread.join();
            }
            i2 = 0;
            while (i2 < MAX_REGISTRATION_THREADS) {
                registration[i2].forceRegister();
                ++i2;
            }
            i2 = 0;
            while (i2 < MAX_REGISTRATION_THREADS) {
                Thread cfr_ignored_0 = registrationThreads[i2];
                ++i2;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void loadBuffer(GeneralFile file, LoadThread load, SRBFile tempFile, Thread[] registrationThreads, RegistrationThread[] registration, String topLevelFile) throws IOException {
        System.out.println(file);
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            topLevelFile = topLevelFile == null ? file.getName() : String.valueOf(topLevelFile) + "/" + file.getName();
            GeneralFile[] files = file.listFiles();
            if (files == null) {
                return;
            }
            int i = 0;
            while (i < files.length) {
                this.loadBuffer(files[i], load, tempFile, registrationThreads, registration, topLevelFile);
                ++i;
            }
        } else {
            GeneralRandomAccessFile readFile = null;
            try {
                readFile = FileFactory.newRandomAccessFile(file, "r");
            }
            catch (SecurityException e) {
                return;
            }
            long toRead = file.length();
            int temp = 0;
            while (toRead > 0L) {
                while (load.writeBuffer1 && load.writeBuffer2 || load.writeBuffer1 && this.useBuffer == 1 || load.writeBuffer2 && this.useBuffer == 2) {
                }
                if (this.useBuffer == 0 || this.useBuffer == 1) {
                    if (toRead + (long)this.bufferPos < 0x800000L) {
                        temp = readFile.read(load.buffer1, this.bufferPos, (int)toRead);
                        this.bufferPos += temp;
                        toRead -= (long)temp;
                    } else if (this.bufferPos < 0x800000) {
                        temp = readFile.read(load.buffer1, this.bufferPos, 0x800000 - this.bufferPos);
                        this.bufferPos += temp;
                        load.buffer1Length = this.bufferPos;
                        load.writeBuffer1 = true;
                        this.useBuffer = 2;
                        this.bufferPos = 0;
                        if ((toRead -= (long)temp) < 0x800000L) {
                            temp = readFile.read(load.buffer2, this.bufferPos, (int)toRead);
                            this.bufferPos += temp;
                            toRead -= (long)temp;
                        }
                    } else {
                        load.buffer1Length = this.bufferPos;
                        load.writeBuffer1 = true;
                        this.useBuffer = 2;
                        this.bufferPos = 0;
                        if (toRead < 0x800000L) {
                            temp = readFile.read(load.buffer2, this.bufferPos, (int)toRead);
                            this.bufferPos += temp;
                            toRead -= (long)temp;
                        }
                    }
                }
                if (this.useBuffer != 2) continue;
                if (toRead + (long)this.bufferPos < 0x800000L) {
                    temp = readFile.read(load.buffer2, this.bufferPos, (int)toRead);
                    this.bufferPos += temp;
                    toRead -= (long)temp;
                    continue;
                }
                if (this.bufferPos < 0x800000) {
                    temp = readFile.read(load.buffer2, this.bufferPos, 0x800000 - this.bufferPos);
                    this.bufferPos += temp;
                    load.buffer2Length = this.bufferPos;
                    load.writeBuffer2 = true;
                    this.useBuffer = 1;
                    this.bufferPos = 0;
                    if ((toRead -= (long)temp) >= 0x800000L) continue;
                    temp = readFile.read(load.buffer1, this.bufferPos, (int)toRead);
                    this.bufferPos += temp;
                    toRead -= (long)temp;
                    continue;
                }
                load.buffer2Length = this.bufferPos;
                load.writeBuffer2 = true;
                this.useBuffer = 1;
                this.bufferPos = 0;
                if (toRead >= 0x800000L) continue;
                temp = readFile.read(load.buffer1, this.bufferPos, (int)toRead);
                this.bufferPos += temp;
                toRead -= (long)temp;
            }
            readFile.close();
            ++this.filesReadyToRegister;
            if (topLevelFile == null) {
                registration[this.numRegistrationThreads % 4].addFile(file, "");
            } else {
                registration[this.numRegistrationThreads % 4].addFile(file, topLevelFile);
            }
            if (this.filesReadyToRegister % 10 == 0 && this.numRegistrationThreads < 4) {
                System.out.println("register.start " + this.numRegistrationThreads);
                System.out.println("filesReadyToRegister " + this.filesReadyToRegister % 10);
                if (!registrationThreads[this.numRegistrationThreads].isAlive()) {
                    registrationThreads[this.numRegistrationThreads].start();
                }
                ++this.numRegistrationThreads;
            }
        }
    }

    public boolean canRead() {
        try {
            MetaDataRecordList[] rl;
            if (this.exists() && (rl = this.query("access constraint")) != null && (rl[0].getStringValue(0).equals("all") || rl[0].getStringValue(0).equals("read"))) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean canWrite() {
        try {
            MetaDataRecordList[] rl;
            if (this.exists() && (rl = this.query("access constraint")) != null && (rl[0].getStringValue(0).equals("all") || rl[0].getStringValue(0).equals("write"))) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public int compareTo(GeneralFile pathname) {
        return this.getAbsolutePath().compareTo(((SRBContainer)pathname).getAbsolutePath());
    }

    public int compareTo(Object o) throws ClassCastException {
        return this.compareTo((SRBContainer)o);
    }

    public boolean createNewFile() {
        try {
            if (!this.exists()) {
                this.srbFileSystem.srbContainerCreate(this.catalogType, this.getAbsolutePath(), this.dataType, this.resource, this.containerMaxSize);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static GeneralFile createTempFile(String prefix, String suffix) throws IOException, IllegalArgumentException {
        return SRBContainer.createTempFile(prefix, suffix, null);
    }

    public static GeneralFile createTempFile(String prefix, String suffix, GeneralFile directory) throws IOException, IllegalArgumentException {
        SRBContainer temp;
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (directory == null) {
            SRBFileSystem fs = new SRBFileSystem();
            directory = new SRBContainer(fs, "");
        }
        if ((temp = new SRBContainer((SRBFile)directory, String.valueOf(prefix) + suffix)).exists()) {
            throw new IOException();
        }
        temp.createNewFile();
        return temp;
    }

    public boolean delete() {
        return this.delete(false);
    }

    public boolean delete(boolean force) {
        try {
            if (this.exists()) {
                this.srbFileSystem.srbRmContainer(this.catalogType, this.getAbsolutePath(), true);
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    public boolean equals(Object obj) {
        try {
            SRBContainer temp = (SRBContainer)obj;
            return this.getAbsolutePath().equals(temp.getAbsolutePath());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean exists() {
        try {
            MetaDataRecordList[] rl = null;
            int operator = 0;
            MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("container name", operator, this.getAbsolutePath())};
            MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("container name")};
            rl = this.srbFileSystem.query(conditions, selects, 3);
            if (rl != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public GeneralFile getAbsoluteFile() {
        return new SRBContainer(this.srbFileSystem, this.getAbsolutePath());
    }

    public GeneralFile getCanonicalFile() {
        return new SRBContainer(this.srbFileSystem, this.getAbsolutePath());
    }

    public GeneralFile getParentFile() {
        return new SRBContainer(this.srbFileSystem, this.getParent());
    }

    public boolean isContainer() {
        return this.exists();
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        try {
            MetaDataRecordList[] rl = this.query("modification date");
            if (rl != null) {
                return Long.parseLong(rl[0].getValue("modification date").toString());
            }
        }
        catch (IOException e) {
            return 0L;
        }
        return 0L;
    }

    public long length() {
        try {
            MetaDataRecordList[] rl = this.query("container size");
            if (rl != null) {
                return Long.parseLong(rl[0].getValue("container size").toString());
            }
        }
        catch (IOException e) {
            return 0L;
        }
        return 0L;
    }

    public String[] list() {
        String[] list = new String[]{};
        String containerName = this.getName();
        try {
            MetaDataRecordList[] rl = this.query("file name");
            if (rl != null) {
                list = new String[rl.length - 1];
                int i = 0;
                int j = 0;
                while (i < rl.length) {
                    String fileName = rl[i].getStringValue(0);
                    if (!fileName.equals(containerName)) {
                        list[j] = fileName;
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        return list;
    }

    public boolean mkdir() {
        return this.createNewFile();
    }

    public boolean renameTo(GeneralFile dest) {
        try {
            if (this.exists()) {
                this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), this.resource, null, dest.getName(), null, 29);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    class LoadThread
    implements Runnable {
        GeneralRandomAccessFile out;
        byte[] buffer1;
        byte[] buffer2;
        boolean writeBuffer1 = false;
        boolean writeBuffer2 = false;
        int buffer1Length = 0;
        int buffer2Length = 0;
        boolean keepLoading = true;

        LoadThread(GeneralRandomAccessFile out, byte[] buffer1, byte[] buffer2) {
            this.out = out;
            this.buffer1 = buffer1;
            this.buffer2 = buffer2;
        }

        public void run() {
            while (this.keepLoading) {
                this.sendBuffer();
            }
        }

        void sendBuffer() {
            try {
                if (this.writeBuffer1) {
                    this.out.write(this.buffer1, 0, this.buffer1Length);
                    this.writeBuffer1 = false;
                }
                if (this.writeBuffer2) {
                    this.out.write(this.buffer2, 0, this.buffer2Length);
                    this.writeBuffer2 = false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class RegistrationThread
    implements Runnable {
        SRBFileSystem fileSystem;
        int catalogType;
        String bloadFilePath;
        boolean keepLoading = false;
        boolean newFiles = false;
        Vector files = new Vector();
        Vector paths = new Vector();

        RegistrationThread(SRBFileSystem fileSystem, int catType, String bloadFilePath) throws IOException {
            this.fileSystem = fileSystem;
            this.bloadFilePath = bloadFilePath;
        }

        void addFile(GeneralFile file, String relativePath) {
            this.files.add(file);
            this.paths.add(relativePath);
            this.newFiles = true;
        }

        public void run() {
            this.keepLoading = true;
            while (this.keepLoading) {
                this.register();
            }
        }

        SRBMetaDataRecordList[] getFileRegistry() throws IOException {
            SRBMetaDataRecordList rl = null;
            SRBMetaDataRecordList[] recordLists = new SRBMetaDataRecordList[this.files.size()];
            GeneralFile tempFile = null;
            Object tempFile2 = null;
            Object tempName = null;
            Object tempName2 = null;
            String fileName = null;
            String dirName = null;
            long size = 0L;
            int i = 0;
            while (i < recordLists.length) {
                tempFile = (GeneralFile)this.files.get(i);
                fileName = tempFile.getName();
                SRBContainer.this.registrationOffset = (int)((long)SRBContainer.this.registrationOffset + size);
                size = tempFile.length();
                dirName = (String)this.paths.get(i);
                dirName = dirName != "" ? String.valueOf(SRBContainer.this.getAbsolutePath()) + "/" + dirName : SRBContainer.this.getAbsolutePath();
                rl = new SRBMetaDataRecordList(SRBMetaDataSet.getField("file name"), fileName);
                rl.addRecord(SRBMetaDataSet.getField("directory name"), dirName);
                rl.addRecord(SRBMetaDataSet.getField("size"), size);
                rl.addRecord(SRBMetaDataSet.getField("offset"), SRBContainer.this.registrationOffset);
                recordLists[i - SRBContainer.this.registeredFiles] = rl;
                ++i;
            }
            i = 0;
            while (i < recordLists.length) {
                try {
                    this.files.remove(0);
                    this.paths.remove(0);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    break;
                }
                ++i;
            }
            return recordLists;
        }

        void register() {
            try {
                if (!this.newFiles) {
                    return;
                }
                if (this.files.size() < 5) {
                    return;
                }
                this.fileSystem.srbBulkLoad(this.catalogType, this.bloadFilePath, this.getFileRegistry());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void forceRegister() {
            if (!this.newFiles) {
                return;
            }
            try {
                this.fileSystem.srbBulkLoad(this.catalogType, this.bloadFilePath, this.getFileRegistry());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

