/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.RemoteFile;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBCommands;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import edu.sdsc.grid.io.srb.SRBRandomAccessFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;

public class SRBFile
extends RemoteFile {
    public static final int MDAS_CATALOG = 0;
    public static final int LDAP_CATALOG = 1;
    public static final int FILE_CATALOG = 2;
    public static final String PATH_SEPARATOR = "/";
    public static final char PATH_SEPARATOR_CHAR = '/';
    static final int OPR_COPY = 0;
    static int MAX_NUMBER_OF_THREADS = 4;
    static int MIN_THREAD_SIZE = 30000000;
    static final int BULK_LOAD_BUFFER_SIZE = 0x800000;
    static final int MAX_BULK_FILE_SIZE = 0x200000;
    static final int MAX_REGISTRATION_FILES = 300;
    static final int LIST_CHECKSUM = 16;
    static final int COMPUTE_CHECKSUM = 128;
    static final int FORCE_CHECKSUM = 32;
    static String ZONE_AUTHORITY = "http://www.sdsc.edu/srb/cgi-bin/zoneList.cgi?zone=";
    static boolean USE_BULKCOPY = true;
    private static String MODIFY_DEFINABLE_METADATA_SEPERATOR = "|";
    static final int PATH_IS_UNKNOWN = 0;
    static final int PATH_IS_FILE = 1;
    static final int PATH_IS_DIRECTORY = 2;
    protected SRBFileSystem srbFileSystem;
    int catalogType = 0;
    String resource;
    String dataType = "generic";
    boolean deleteOnExit = false;
    static Vector uriFileSystems = new Vector();
    String originalFilePath;
    private int replicaNumber = -1;
    public boolean completeDirectoryList = true;
    int pathNameType = 0;
    String serverLocalPath;
    IOException bulkLoadException = null;
    Vector parallelSourceFiles;
    Vector parallelDestination;
    private volatile int loadBuffer1 = 0;
    int activeRegistrationThread = 0;
    int filesReadyToRegister = 0;

    public SRBFile(SRBFileSystem srbFileSystem, String filePath) throws NullPointerException {
        this(srbFileSystem, "", filePath);
        this.originalFilePath = filePath;
    }

    public SRBFile(SRBFileSystem srbFileSystem, String parent, String child) throws NullPointerException, IllegalArgumentException {
        super(srbFileSystem, parent, child);
        this.makePathCanonical(parent);
        this.resource = srbFileSystem.getDefaultStorageResource();
        this.originalFilePath = parent != null ? (!parent.equals("") ? String.valueOf(parent) + PATH_SEPARATOR + child : child) : child;
    }

    public SRBFile(SRBFile parent, String child) throws NullPointerException {
        this((SRBFileSystem)parent.getFileSystem(), parent.getPath(), child);
    }

    public SRBFile(URI uri) throws NullPointerException, IOException {
        super(uri);
        String path;
        if (!uri.getScheme().equals("srb")) {
            throw new IllegalArgumentException();
        }
        SRBAccount account = SRBFile.uriInitialAccount(uri);
        String zone = null;
        this.originalFilePath = path = uri.getPath();
        this.setFileSystem(new SRBFileSystem(account));
        zone = SRBFile.getProperZone(this.srbFileSystem);
        this.srbFileSystem.setProxyMcatZone(zone);
        this.srbFileSystem.setMcatZone(zone);
        this.srbFileSystem.setDefaultStorageResource(SRBFile.getAvailableResource(this.srbFileSystem));
        if (path == null || path == "") {
            this.setFileName(PATH_SEPARATOR);
        } else {
            this.setFileName(path);
        }
        this.setFileSystem(SRBFile.uriTest(this.srbFileSystem));
    }

    protected void finalize() throws Throwable {
        if (this.deleteOnExit) {
            this.delete();
        }
        super.finalize();
        if (this.resource != null) {
            this.resource = null;
        }
        if (this.dataType != null) {
            this.dataType = null;
        }
    }

    static SRBAccount uriInitialAccount(URI uri) throws IOException {
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        String userInfo = uri.getUserInfo();
        String userName = null;
        String mdasDomain = null;
        String password = null;
        String homeDirectory = null;
        int index = -1;
        if (userInfo == null || userInfo == "") {
            userName = "public";
            mdasDomain = "npaci";
            password = "CANDO";
            homeDirectory = "/home/public.npaci/";
        } else {
            index = userInfo.indexOf(".");
            if (index < 0) {
                throw new MalformedURLException();
            }
            userName = userInfo.substring(0, index);
            if (index < 0) {
                throw new MalformedURLException();
            }
            if ((index = (userInfo = userInfo.substring(index + 1)).indexOf(":")) > 0) {
                mdasDomain = userInfo.substring(0, index);
                password = userInfo.substring(index + 1);
            } else {
                mdasDomain = userInfo;
            }
            homeDirectory = "/home/" + userName + "." + mdasDomain;
        }
        index = host.indexOf(".");
        if (index < 0) {
            URL url = new URL(String.valueOf(ZONE_AUTHORITY) + host);
            InputStream in = url.openConnection().getInputStream();
            int index2 = -1;
            String result = null;
            byte[] data = new byte[1000];
            in.read(data);
            result = new String(data);
            in.read(data);
            result = String.valueOf(result) + new String(data);
            index = result.indexOf("ns1:server");
            index2 = result.indexOf("/ns1:server", index + 11);
            if (index < 0 || index2 < 0) {
                throw new ConnectException("Invalid zone name.");
            }
            host = result.substring(index + 11, index2 - 1);
            index = result.indexOf("ns1:port");
            if ((result = result.substring(index + 9, (index2 = result.indexOf("/ns1:port", index + 9)) - 1)) != null && result.length() > 0) {
                port = Integer.parseInt(result);
            }
        }
        if (port < 0) {
            port = 5544;
        }
        return new SRBAccount(host, port, userName, password, homeDirectory, mdasDomain, "");
    }

    static String getProperZone(SRBFileSystem fs) throws IOException {
        if (fs.getVersionNumber() >= 3.0f) {
            String userName = fs.getUserName();
            String mdasDomain = fs.getDomainName();
            MetaDataRecordList[] rl = fs.query("zone name");
            if (rl == null) {
                MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("user name", 10, userName), MetaDataSet.newCondition("user domain", 0, mdasDomain)};
                MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("zone name")};
                rl = fs.query(conditions, selects);
            }
            return rl[0].getValue("zone name").toString();
        }
        return null;
    }

    static String getAvailableResource(SRBFileSystem fs) throws IOException {
        MetaDataRecordList[] rl = null;
        if (fs.getVersionNumber() >= 3.0f) {
            String userName = fs.getUserName();
            String mdasDomain = fs.getDomainName();
            String zone = fs.getMcatZone();
            rl = fs.query("resource name");
            if (rl == null) {
                MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("resource access privilege", 10, "%write%"), MetaDataSet.newCondition("user name used for resource access", 0, userName), MetaDataSet.newCondition("user domn used for resource access", 0, mdasDomain), MetaDataSet.newCondition("user zone used for resource access", 0, zone)};
                MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("resource name")};
                rl = fs.query(conditions, selects);
            }
        } else {
            rl = fs.query("resource name");
            if (rl == null) {
                throw new FileNotFoundException("Unknown resource");
            }
        }
        return rl[0].getValue("resource name").toString();
    }

    static synchronized SRBFileSystem uriTest(SRBFileSystem fs) {
        SRBFileSystem uriTest = null;
        int i = 0;
        while (i < uriFileSystems.size()) {
            uriTest = (SRBFileSystem)uriFileSystems.get(i);
            if (fs.equals(uriTest)) {
                fs = uriTest;
                return fs;
            }
            if (!uriTest.isConnected()) {
                uriFileSystems.remove(i);
            }
            ++i;
        }
        uriFileSystems.add(fs);
        return fs;
    }

    protected void setFileName(String filePath) {
        int index;
        String localSeparator = System.getProperty("file.separator");
        if (filePath == null) {
            throw new NullPointerException("The file name cannot be null");
        }
        if (!localSeparator.equals(PATH_SEPARATOR)) {
            index = filePath.lastIndexOf(localSeparator);
            while (index >= 0 && filePath.substring(index + 1).length() > 0) {
                filePath = String.valueOf(filePath.substring(0, index)) + PATH_SEPARATOR + filePath.substring(index + 1);
                index = filePath.lastIndexOf(localSeparator);
            }
        }
        this.fileName = filePath;
        if (this.fileName.length() > 1) {
            index = this.fileName.lastIndexOf(PATH_SEPARATOR);
            while (index == this.fileName.length() - 1 && index >= 0) {
                this.fileName = this.fileName.substring(0, index);
                index = this.fileName.lastIndexOf(PATH_SEPARATOR);
            }
            if (index >= 0 && this.fileName.substring(index + 1).length() > 0) {
                this.setDirectory(this.fileName.substring(0, index + 1));
                this.fileName = this.fileName.substring(index + 1);
            }
        }
    }

    protected void setDirectory(String dir) {
        if (this.directory == null) {
            this.directory = new Vector();
        }
        if (dir == null) {
            return;
        }
        String localSeparator = System.getProperty("file.separator");
        int index = dir.lastIndexOf(localSeparator);
        if (index >= 0 && dir.substring(index + 1).length() > 0) {
            dir = String.valueOf(dir.substring(0, index)) + PATH_SEPARATOR + dir.substring(index + 1);
            index = dir.lastIndexOf(localSeparator);
        }
        while (this.directory.size() > 0 && dir.startsWith(PATH_SEPARATOR)) {
            dir = dir.substring(1);
        }
        index = dir.indexOf(PATH_SEPARATOR);
        if (index >= 0) {
            do {
                this.directory.add(dir.substring(0, index));
                while ((index = (dir = dir.substring(index + 1)).indexOf(PATH_SEPARATOR)) == 0) {
                }
            } while (index >= 0);
        }
        if (!dir.equals("") && dir != null) {
            this.directory.add(dir);
        }
    }

    void makePathCanonical(String dir) {
        int i = 0;
        boolean absolutePath = false;
        String canonicalTest = null;
        if (dir == null) {
            dir = "";
        }
        if (this.fileName.equals(PATH_SEPARATOR) && dir == "") {
            return;
        }
        if (this.fileName.equals("") && dir.equals("")) {
            String home = this.srbFileSystem.getHomeDirectory();
            int index = home.lastIndexOf(PATH_SEPARATOR);
            this.setDirectory(home.substring(0, index));
            this.setFileName(home.substring(index + 1));
            return;
        }
        if (dir.startsWith(PATH_SEPARATOR)) {
            absolutePath = true;
        }
        if (this.directory.size() > 0 && this.directory.get(0).toString().length() == 0) {
            absolutePath = true;
        }
        if (!absolutePath) {
            String home = this.srbFileSystem.getHomeDirectory();
            int index = home.indexOf(PATH_SEPARATOR);
            if (index >= 0) {
                do {
                    this.directory.add(i, home.substring(0, index));
                    home = home.substring(index + 1);
                    index = home.indexOf(PATH_SEPARATOR);
                    ++i;
                } while (index > 0);
            }
            if (!home.equals("") && home != null) {
                this.directory.add(i, home);
            }
        }
        i = 0;
        while (i < this.directory.size()) {
            canonicalTest = this.directory.get(i).toString();
            if (canonicalTest.equals(".")) {
                this.directory.remove(i);
                --i;
            } else if (canonicalTest.equals("..") && i >= 2) {
                this.directory.remove(i);
                this.directory.remove(i - 1);
                if (--i > 0) {
                    --i;
                }
            } else if (canonicalTest.equals("..")) {
                this.directory.remove(i);
                --i;
            } else if (canonicalTest.startsWith(PATH_SEPARATOR)) {
                while ((canonicalTest = canonicalTest.substring(1)).startsWith(PATH_SEPARATOR)) {
                }
                this.directory.remove(i);
                this.directory.add(i, canonicalTest);
            }
            ++i;
        }
        if (this.fileName.equals(".")) {
            this.fileName = this.directory.get(this.directory.size() - 1).toString();
            this.directory.remove(this.directory.size() - 1);
        } else if (this.fileName.equals("..")) {
            if (this.directory.size() > 1) {
                this.fileName = this.directory.get(this.directory.size() - 2).toString();
                this.directory.remove(this.directory.size() - 1);
                this.directory.remove(this.directory.size() - 1);
            } else {
                this.fileName = PATH_SEPARATOR;
                this.directory.remove(this.directory.size() - 1);
            }
        }
        this.getReplicaNumber();
    }

    protected void setFileSystem(GeneralFileSystem srbFileSystem) throws IllegalArgumentException {
        if (srbFileSystem == null) {
            throw new IllegalArgumentException("Illegal fileSystem, cannot be null");
        }
        this.fileSystem = srbFileSystem;
        this.srbFileSystem = (SRBFileSystem)this.fileSystem;
    }

    public void setResource(String resourceName) throws IOException, NullPointerException, IllegalArgumentException {
        if (resourceName != null) {
            MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("resource name", 0, resourceName)};
            MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("resource name")};
            MetaDataRecordList[] resources = this.srbFileSystem.query(conditions, selects);
            if (resources == null) {
                throw new IllegalArgumentException("Resource not found");
            }
            this.resource = resourceName;
            if (this.isFile()) {
                boolean move = true;
                conditions = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.getParent()), MetaDataSet.newCondition("file name", 0, this.fileName)};
                resources = this.srbFileSystem.query(conditions, selects);
                if (resources != null) {
                    int i = 0;
                    while (i < resources.length) {
                        if (resources[i].getStringValue(0) == resourceName) {
                            move = false;
                            i = resources.length;
                        }
                        ++i;
                    }
                }
                if (move) {
                    this.srbFileSystem.srbObjMove(this.catalogType, this.fileName, this.getParent(), null, this.resource, "", null);
                }
            }
        } else {
            throw new NullPointerException();
        }
    }

    public void setDataType(String dataTypeName) throws IOException {
        if (dataTypeName == null) {
            dataTypeName = "generic";
        }
        if (this.isFile()) {
            if (this.getReplicaNumber() >= 0) {
                this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), null, null, dataTypeName, null, 5);
            } else {
                this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), null, null, dataTypeName, null, 5);
            }
        }
        this.dataType = dataTypeName;
    }

    public void setReplicaNumber(int replicaNumber) {
        if (replicaNumber >= 0) {
            this.fileName = String.valueOf(this.getName()) + "&COPY=" + replicaNumber;
            this.replicaNumber = replicaNumber;
        } else {
            this.fileName = this.getName();
            this.replicaNumber = -1;
        }
    }

    public void setServerLocalPath(String serverLocalPath) {
        this.serverLocalPath = serverLocalPath;
    }

    public int getReplicaNumber() {
        if (this.replicaNumber >= 0) {
            return this.replicaNumber;
        }
        int index = this.fileName.indexOf("&COPY=");
        if (index >= 0) {
            this.replicaNumber = new Integer(this.fileName.substring(index + 6));
            return this.replicaNumber;
        }
        return -1;
    }

    public String getResource() throws IOException {
        if (this.isDirectory()) {
            return null;
        }
        if (this.resource != null) {
            return this.resource;
        }
        MetaDataRecordList[] rl = this.query("physical resource name");
        if (rl != null) {
            this.resource = rl[0].getValue("physical resource name").toString();
            return this.resource;
        }
        return null;
    }

    String getPhysicalPath() throws IOException {
        MetaDataRecordList[] rl = this.query("path name");
        rl = MetaDataRecordList.getAllResults(rl);
        return rl[0].getValue("path name").toString();
    }

    public String getDataType() throws IOException {
        if (this.isDirectory()) {
            return this.dataType;
        }
        MetaDataRecordList[] rl = this.query("file type name");
        if (rl == null) {
            return null;
        }
        return rl[0].getValue("file type name").toString();
    }

    public int getCatalogType() {
        return this.catalogType;
    }

    public final String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public final char getPathSeparatorChar() {
        return '/';
    }

    public GeneralFileSystem getFileSystem() throws NullPointerException {
        if (this.srbFileSystem != null) {
            return this.srbFileSystem;
        }
        throw new NullPointerException("fileSystem is null.");
    }

    public String getServerLocalPath(String serverLocalPath) {
        return serverLocalPath;
    }

    public MetaDataRecordList[] query(String fieldName) throws IOException {
        MetaDataSelect[] temp = new MetaDataSelect[]{MetaDataSet.newSelection(fieldName)};
        return this.query(temp, SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(String[] fieldNames) throws IOException {
        return this.query(MetaDataSet.newSelection(fieldNames), SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataSelect select) throws IOException {
        MetaDataSelect[] temp = new MetaDataSelect[]{select};
        return this.query(temp, SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] selects) throws IOException {
        return this.query(selects, SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] selects, int recordsWanted) throws IOException {
        MetaDataCondition[] iConditions = null;
        String fieldName = null;
        int operator = 0;
        String value = null;
        if (this.isDirectory()) {
            iConditions = new MetaDataCondition[1];
            fieldName = "directory name";
            operator = 0;
            value = this.getAbsolutePath();
            iConditions[0] = MetaDataSet.newCondition(fieldName, operator, value);
        } else {
            iConditions = new MetaDataCondition[3];
            fieldName = "directory name";
            operator = 0;
            value = this.getParent();
            iConditions[0] = MetaDataSet.newCondition(fieldName, operator, value);
            fieldName = "file name";
            value = this.getName();
            iConditions[1] = MetaDataSet.newCondition(fieldName, operator, value);
            if (this.getReplicaNumber() >= 0) {
                fieldName = "file replication enum";
                value = "" + this.replicaNumber;
                iConditions[2] = MetaDataSet.newCondition(fieldName, operator, value);
            }
        }
        return this.srbFileSystem.query(iConditions, selects, recordsWanted);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] conditions, MetaDataSelect[] selects) throws IOException {
        return this.query(conditions, selects, SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] conditions, MetaDataSelect[] selects, int recordsWanted) throws IOException {
        MetaDataCondition[] iConditions = null;
        String fieldName = null;
        int operator = 0;
        String value = null;
        if (this.isDirectory()) {
            iConditions = new MetaDataCondition[conditions.length + 1];
            System.arraycopy(conditions, 0, iConditions, 0, conditions.length);
            fieldName = "directory name";
            operator = 0;
            value = this.getAbsolutePath();
            iConditions[conditions.length] = MetaDataSet.newCondition(fieldName, operator, value);
        } else {
            iConditions = new MetaDataCondition[conditions.length + 3];
            System.arraycopy(conditions, 0, iConditions, 0, conditions.length);
            fieldName = "directory name";
            operator = 0;
            value = this.getParent();
            iConditions[conditions.length] = MetaDataSet.newCondition(fieldName, operator, value);
            fieldName = "file name";
            value = this.fileName;
            iConditions[conditions.length + 1] = MetaDataSet.newCondition(fieldName, operator, value);
            if (this.getReplicaNumber() >= 0) {
                fieldName = "file replication enum";
                value = "" + this.replicaNumber;
                iConditions[2] = MetaDataSet.newCondition(fieldName, operator, value);
            }
        }
        return this.srbFileSystem.query(iConditions, selects, recordsWanted);
    }

    public void modifyMetaData(MetaDataRecordList record) throws IOException {
        String dataValue1 = null;
        String dataValue2 = null;
        String dataValue3 = null;
        boolean filesOnly = false;
        boolean dirsOnly = false;
        boolean isFile = this.isFile();
        String vaultPathName = null;
        if (this.getReplicaNumber() < 0 && isFile) {
            MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("path name"), MetaDataSet.newSelection("resource name")};
            MetaDataRecordList[] rl = this.query(selects);
            if (rl != null) {
                vaultPathName = rl[0].getValue("path name").toString();
                this.resource = rl[0].getValue("resource name").toString();
            } else {
                throw new FileNotFoundException("Vault path/resource not found.");
            }
        }
        int retractionType = -1;
        boolean delete = false;
        int i = 0;
        while (i < record.getFieldCount()) {
            int k;
            int columns;
            int j;
            MetaDataTable table;
            delete = record.getValue(i) == null;
            if (record.getFieldName(i) == "file comments") {
                if (delete) {
                    retractionType = 12;
                } else {
                    retractionType = 13;
                    dataValue1 = record.getStringValue(i);
                }
            } else if (record.getFieldName(i) == "size") {
                retractionType = 4;
                dataValue1 = record.getStringValue(i);
                filesOnly = true;
            } else if (record.getFieldName(i) == "file type name") {
                retractionType = 5;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "directory name") {
                retractionType = 6;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "offset") {
                retractionType = 35;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "is dirty") {
                retractionType = 36;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "file replication enum") {
                retractionType = 132;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "file lock num") {
                retractionType = 85;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "file checksum") {
                retractionType = 137;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "file hide") {
                retractionType = 138;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "file auditflag") {
                retractionType = 139;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "file pin val") {
                retractionType = 140;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "file expiry date") {
                retractionType = 141;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "file expire date 2") {
                retractionType = 142;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "file is compressed") {
                retractionType = 143;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "file is encrypted") {
                retractionType = 144;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "file name") {
                retractionType = 29;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "file annotation timestamp") {
                if (delete) {
                    retractionType = 39;
                } else {
                    retractionType = 40;
                    dataValue1 = record.getStringValue(i);
                }
            } else if (record.getFieldName(i) == "file annotation") {
                retractionType = 41;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "owner") {
                retractionType = 15;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "path name") {
                retractionType = 126;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "modification date") {
                retractionType = 42;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "file last access timestamp") {
                retractionType = 76;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "file class name") {
                if (delete) {
                    retractionType = 43;
                } else {
                    retractionType = 44;
                    dataValue1 = record.getStringValue(i);
                }
            } else if (record.getFieldName(i) == "index name for file") {
                if (delete) {
                    retractionType = 45;
                } else {
                    retractionType = 46;
                    dataValue1 = record.getStringValue(i);
                }
            } else if (record.getFieldName(i) == "index name for datatype") {
                if (delete) {
                    retractionType = 47;
                } else {
                    retractionType = 48;
                    dataValue1 = record.getStringValue(i);
                }
            } else if (record.getFieldName(i) == "index name for directory") {
                if (delete) {
                    retractionType = 49;
                } else {
                    retractionType = 50;
                    dataValue1 = record.getStringValue(i);
                }
            } else if (record.getFieldName(i) == "method name for file") {
                if (delete) {
                    retractionType = 51;
                } else {
                    retractionType = 52;
                    dataValue1 = record.getStringValue(i);
                }
            } else if (record.getFieldName(i) == "method name for datatype") {
                if (delete) {
                    retractionType = 53;
                } else {
                    retractionType = 54;
                    dataValue1 = record.getStringValue(i);
                }
            } else if (record.getFieldName(i) == "method name for directory") {
                if (delete) {
                    retractionType = 55;
                } else {
                    retractionType = 56;
                    dataValue1 = record.getStringValue(i);
                }
            } else if (record.getFieldName(i) == "definable metadata for files") {
                if (delete) {
                    if (vaultPathName == null) {
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), null, null, "-1", "", 63);
                    } else {
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), this.resource, vaultPathName, "-1", "", 63);
                    }
                } else {
                    table = record.getTableValue(i);
                    dataValue2 = MODIFY_DEFINABLE_METADATA_SEPERATOR;
                    j = 0;
                    while (j < table.getRowCount()) {
                        dataValue1 = "";
                        columns = table.getColumnCount();
                        k = 0;
                        while (k < columns) {
                            dataValue1 = k == columns - 1 ? String.valueOf(dataValue1) + table.getStringValue(j, k) : String.valueOf(dataValue1) + table.getStringValue(j, k) + dataValue2;
                            ++k;
                        }
                        if (vaultPathName == null) {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), null, null, dataValue1, dataValue2, 147);
                        } else {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), this.resource, vaultPathName, dataValue1, dataValue2, 147);
                        }
                        ++j;
                    }
                }
            } else if (record.getFieldName(i) == "definable metadata for directories") {
                if (delete) {
                    this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), "-1", dataValue2, dataValue3, 72);
                } else {
                    table = record.getTableValue(i);
                    dataValue2 = MODIFY_DEFINABLE_METADATA_SEPERATOR;
                    j = 0;
                    while (j < table.getRowCount()) {
                        dataValue1 = "";
                        columns = table.getColumnCount();
                        k = 0;
                        while (k < columns) {
                            dataValue1 = k == columns - 1 ? String.valueOf(dataValue1) + table.getStringValue(j, k) : String.valueOf(dataValue1) + table.getStringValue(j, k) + dataValue2;
                            ++k;
                        }
                        this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), dataValue1, dataValue2, dataValue3, 148);
                        ++j;
                    }
                }
            } else if (record.getFieldName(i) == "directory annotation") {
                retractionType = 95;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "container for directory") {
                retractionType = 146;
                dataValue1 = record.getStringValue(i);
            } else if (record.getFieldName(i) == "guid") {
                if (delete) {
                    retractionType = 169;
                } else {
                    if (vaultPathName == null) {
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), null, null, dataValue1, dataValue2, 169);
                    } else {
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), this.resource, vaultPathName, dataValue1, dataValue2, 169);
                    }
                    retractionType = 168;
                    dataValue1 = record.getStringValue(i);
                    dataValue2 = "1";
                }
            } else if (record.getFieldName(i) == "directory link number") {
                if (delete) {
                    retractionType = 3212;
                    dataValue1 = "0";
                } else {
                    retractionType = 3212;
                    dataValue1 = record.getStringValue(i) == "0" ? "0" : "1";
                }
            }
            if (retractionType >= 0) {
                if (vaultPathName == null) {
                    this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), null, null, dataValue1, dataValue2, retractionType);
                } else {
                    this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), this.resource, vaultPathName, dataValue1, dataValue2, retractionType);
                }
            }
            ++i;
        }
    }

    public String toString() {
        return new String("srb://" + this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName() + "@" + this.srbFileSystem.getHost() + ":" + this.srbFileSystem.getPort() + this.getAbsolutePath());
    }

    public void copyTo(GeneralFile file) throws IOException {
        this.copyTo(file, false);
    }

    public void copyTo(GeneralFile file, boolean forceOverwrite) throws IOException {
        this.copyTo(file, forceOverwrite, USE_BULKCOPY);
    }

    public void copyTo(GeneralFile file, boolean forceOverwrite, boolean bulkCopy) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        FileFactory.newFile(file.getFileSystem(), file.getAbsolutePath()).getParentFile().mkdirs();
        if (this.srbFileSystem.getVersionNumber() < 2.0f) {
            super.copyTo(file, forceOverwrite);
            return;
        }
        if (this.isDirectory()) {
            if (file instanceof LocalFile && this.srbFileSystem.getVersionNumber() >= 3.0f && bulkCopy && (USE_BULKCOPY || bulkCopy)) {
                MetaDataSelect[] selects;
                if (bulkCopy) {
                    if (forceOverwrite) {
                        file.delete();
                    }
                    this.bulkUnload((LocalFile)file);
                    return;
                }
                MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 10, String.valueOf(this.getAbsolutePath()) + "*")};
                MetaDataRecordList[] rl = this.query(conditions, selects = new MetaDataSelect[]{MetaDataSet.newSelection("size")});
                if (rl != null) {
                    block0: do {
                        int i = 0;
                        while (i < rl.length) {
                            if (rl[i].getIntValue(0) > 0x200000) {
                                bulkCopy = false;
                                continue block0;
                            }
                            ++i;
                        }
                    } while ((rl = rl[0].getMoreResults()) != null && bulkCopy && !rl[0].isQueryComplete());
                }
                if (bulkCopy) {
                    this.bulkUnload((LocalFile)file);
                    return;
                }
            }
            GeneralFile[] fileList = this.listFiles();
            file.mkdir();
            if (fileList != null) {
                int i = 0;
                while (i < fileList.length) {
                    fileList[i].copyTo(FileFactory.newFile(file.getFileSystem(), file.getAbsolutePath(), fileList[i].getName()), forceOverwrite);
                    ++i;
                }
            }
        } else if (this.isFile()) {
            if (file.isDirectory()) {
                file = FileFactory.newFile(file, this.getName());
            }
            if (!forceOverwrite && file.exists()) {
                super.copyTo(file, forceOverwrite);
                return;
            }
            if (file instanceof LocalFile) {
                int numThreads = (int)this.length() / MIN_THREAD_SIZE;
                if (numThreads > MAX_NUMBER_OF_THREADS) {
                    numThreads = MAX_NUMBER_OF_THREADS;
                }
                if (this.srbFileSystem.getVersionNumber() >= 3.0f) {
                    this.srbFileSystem.srbObjGetClientInitiated(this.fileName, this.getParent(), file, 0, numThreads);
                } else {
                    this.srbFileSystem.srbObjGet(this.fileName, this.getParent(), this.length(), file, forceOverwrite);
                }
            } else if (file instanceof SRBFile) {
                if (forceOverwrite) {
                    file.delete();
                }
                SRBRandomAccessFile in = new SRBRandomAccessFile(new SRBFile(this.srbFileSystem, this.getAbsolutePath()), "r");
                SRBRandomAccessFile out = new SRBRandomAccessFile(new SRBFile(this.srbFileSystem, ((SRBFile)file).getAbsolutePath()), "rw");
                this.srbFileSystem.srbObjProxyOpr(0, in.getFD(), out.getFD(), 0, 0, null, null, null, null, null, null, null);
                in.close();
                out.close();
            } else {
                super.copyTo(file, forceOverwrite);
            }
        } else {
            throw new FileNotFoundException("Source file is not valid: " + this);
        }
    }

    public void copyFrom(GeneralFile file) throws IOException {
        this.copyFrom(file, false);
    }

    public void copyFrom(GeneralFile file, boolean forceOverwrite) throws IOException {
        this.copyFrom(file, forceOverwrite, USE_BULKCOPY);
    }

    public void copyFrom(GeneralFile file, boolean forceOverwrite, boolean bulkCopy) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        this.getParentFile().mkdirs();
        if (this.srbFileSystem.getVersionNumber() < 2.0f) {
            super.copyFrom(file, forceOverwrite);
            return;
        }
        if (file.isDirectory()) {
            if (file instanceof LocalFile && this.srbFileSystem.getVersionNumber() >= 3.0f && bulkCopy && (USE_BULKCOPY || bulkCopy)) {
                LocalFile[] files = null;
                files = this.isDirectory() ? new LocalFile[]{(LocalFile)file} : (LocalFile[])file.listFiles();
                this.bulkLoad(files, forceOverwrite);
            } else {
                GeneralFile[] fileList = file.listFiles();
                this.mkdir();
                if (fileList != null) {
                    int i = 0;
                    while (i < fileList.length) {
                        FileFactory.newFile(this, fileList[i].getName()).copyFrom(fileList[i], forceOverwrite);
                        ++i;
                    }
                }
            }
        } else if (file.isFile()) {
            if (this.isDirectory()) {
                GeneralFile subFile = FileFactory.newFile(this, file.getName());
                subFile.copyFrom(file, forceOverwrite);
                return;
            }
            if (!forceOverwrite && this.exists()) {
                super.copyFrom(file, forceOverwrite);
                return;
            }
            if (file instanceof LocalFile) {
                long value;
                if (forceOverwrite) {
                    this.delete();
                }
                if ((value = this.srbFileSystem.srbObjPut(this.getName(), this.getParent(), this.resource, null, null, file.getAbsolutePath(), file.length())) == -99999999L) {
                    super.copyFrom(file, forceOverwrite);
                } else if (value < 0L) {
                    throw new SRBException("", (int)value);
                }
            } else if (file instanceof SRBFile) {
                if (forceOverwrite) {
                    this.delete();
                }
                SRBRandomAccessFile in = new SRBRandomAccessFile(new SRBFile(this.srbFileSystem, ((SRBFile)file).getAbsolutePath()), "r");
                SRBRandomAccessFile out = new SRBRandomAccessFile(new SRBFile(this.srbFileSystem, this.getAbsolutePath()), "rw");
                this.srbFileSystem.srbObjProxyOpr(0, in.getFD(), out.getFD(), 0, 0, null, null, null, null, null, null, null);
                in.close();
                out.close();
            } else {
                super.copyFrom(file, forceOverwrite);
            }
        } else {
            throw new FileNotFoundException("Source File is not valid: " + file);
        }
    }

    public void copyFromLocal(String localFilePath) throws IOException {
        this.copyFrom(new LocalFile(localFilePath));
    }

    public void copyFromLocal(LocalFile localFile) throws IOException {
        this.copyFrom(localFile);
    }

    public void copyToLocal(String localFilePath) throws IOException {
        this.copyTo(new LocalFile(localFilePath));
    }

    public void copyToLocal(LocalFile localFile) throws IOException {
        this.copyTo(localFile);
    }

    public void copyToRemote(RemoteFile remoteFile) throws IOException {
        this.copyTo(remoteFile);
    }

    public long fileCopyStatus() {
        return this.srbFileSystem.fileCopyStatus();
    }

    public long[] getStat() throws IOException {
        long[] stat = null;
        if (!this.exists()) {
            return null;
        }
        stat = this.isDirectory() ? this.srbFileSystem.srbObjStat(0, this.getAbsolutePath(), 3) : this.srbFileSystem.srbObjStat(0, this.getAbsolutePath(), 0);
        if (stat != null) {
            return stat;
        }
        throw new IOException("Unable to obtain file stat");
    }

    void bulkLoad(LocalFile[] files, boolean forceOverwrite) throws IOException {
        block15: {
            long maxSize = -1L;
            long containerOffset = 0L;
            byte[] buffer1 = new byte[0x800000];
            byte[] buffer2 = new byte[0x800000];
            GeneralFile[] tempFile = new GeneralFile[MAX_NUMBER_OF_THREADS];
            GeneralRandomAccessFile[] raf = new GeneralRandomAccessFile[MAX_NUMBER_OF_THREADS];
            Thread loadThread = null;
            LoadThread load = null;
            this.parallelSourceFiles = new Vector();
            this.parallelDestination = new Vector();
            this.mkdir();
            int i = 0;
            while (i < MAX_NUMBER_OF_THREADS) {
                tempFile[i] = FileFactory.newFile(this, "placeholder");
                ++i;
            }
            tempFile[0] = SRBFile.createTempFile("BLoad", ".tmp", this);
            raf[0] = FileFactory.newRandomAccessFile(tempFile[0], "rw");
            RegistrationThread[] registration = new RegistrationThread[MAX_NUMBER_OF_THREADS];
            Thread[] registrationThreads = new Thread[MAX_NUMBER_OF_THREADS];
            int i2 = 0;
            while (i2 < MAX_NUMBER_OF_THREADS) {
                registration[i2] = new RegistrationThread(tempFile[i2].getAbsolutePath(), this);
                ++i2;
            }
            registrationThreads[0] = new Thread(registration[0]);
            load = new LoadThread(raf, buffer1, buffer2, this);
            i2 = 0;
            while (i2 < files.length) {
                this.loadBuffer(files[i2], load, loadThread, tempFile, registrationThreads, registration, null);
                ++i2;
            }
            load.keepLoading = false;
            load.sendBuffer(0);
            try {
                i2 = 0;
                while (i2 < MAX_NUMBER_OF_THREADS) {
                    if (raf[i2] != null) {
                        raf[i2].close();
                    }
                    if (registration[i2] != null) {
                        if (new SRBFile(this.srbFileSystem, registration[i2].bloadFilePath).exists()) {
                            registration[i2].register();
                        } else {
                            registration[i2].bloadFilePath = tempFile[i2].getAbsolutePath();
                            registration[i2].register();
                        }
                    }
                    if (tempFile[i2] != null) {
                        ((SRBFile)tempFile[i2]).delete(true);
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < MAX_NUMBER_OF_THREADS) {
                    if (registrationThreads[i2] != null && registrationThreads[i2].isAlive()) {
                        registrationThreads[i2].join();
                    }
                    ++i2;
                }
            }
            catch (InterruptedException e) {
                if (SRBCommands.DEBUG <= 0) break block15;
                e.printStackTrace();
            }
        }
        if (this.parallelSourceFiles.size() > 0) {
            int i = 0;
            while (i < this.parallelSourceFiles.size()) {
                ((SRBFile)this.parallelDestination.get(i)).copyFrom((GeneralFile)this.parallelSourceFiles.get(i), forceOverwrite, false);
                ++i;
            }
        }
        this.parallelSourceFiles = null;
        this.parallelDestination = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void loadBuffer(GeneralFile file, LoadThread load, Thread loadThread, GeneralFile[] tempFile, Thread[] registrationThreads, RegistrationThread[] registration, String relativePath) throws IOException {
        block25: {
            block26: {
                block24: {
                    length = file.length();
                    exist = file.exists();
                    isDirectory = file.isDirectory();
                    name = file.getName();
                    if (file == null || !exist) {
                        return;
                    }
                    if (this.bulkLoadException != null) {
                        throw this.bulkLoadException;
                    }
                    if (!isDirectory) break block24;
                    if (relativePath == null || relativePath.equals("")) {
                        relativePath = name;
                        new SRBFile(this.srbFileSystem, this.getAbsolutePath(), relativePath).mkdir();
                    } else {
                        relativePath = String.valueOf(relativePath) + "/" + name;
                        new SRBFile(this.srbFileSystem, this.getAbsolutePath(), relativePath).mkdir();
                    }
                    files = file.listFiles();
                    if (files == null) {
                        return;
                    }
                    i = 0;
                    while (i < files.length) {
                        this.loadBuffer(files[i], load, loadThread, tempFile, registrationThreads, registration, relativePath);
                        ++i;
                    }
                    break block25;
                }
                if (length <= 0x200000L) break block26;
                relativePath = relativePath == null || relativePath.equals("") != false ? name : String.valueOf(relativePath) + "/" + name;
                this.parallelSourceFiles.add(file);
                this.parallelDestination.add(FileFactory.newFile(this, relativePath));
                break block25;
            }
            tempBuffer = new byte[(int)length];
            zxcv = 0;
            ++this.filesReadyToRegister;
            if (relativePath == null) {
                registration[this.activeRegistrationThread].addFile(file, "");
            } else {
                registration[this.activeRegistrationThread].addFile(file, relativePath);
            }
            toRead = length;
            temp = 0;
            readFile = null;
            try {
                readFile = FileFactory.newFileInputStream(file);
                if (true) ** GOTO lbl75
            }
            catch (SecurityException e) {
                if (SRBCommands.DEBUG > 0) {
                    e.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                if (SRBCommands.DEBUG > 0) {
                    e.printStackTrace();
                }
                return;
            }
            do {
                if (toRead + (long)load.buffer1Length < 0x800000L) {
                    var19_21 = this;
                    synchronized (var19_21) {
                        this.loadBuffer1 = -1;
                    }
                    temp = readFile.read(tempBuffer, 0, (int)toRead);
                    if (temp > 0) {
                        toRead -= (long)temp;
                        zxcv += temp;
                        System.arraycopy(tempBuffer, 0, load.buffer1, load.buffer1Length, temp);
                        load.buffer1Length += temp;
                    }
                }
                if ((long)load.buffer1Length + toRead < 0x800000L) continue;
                load.sendBuffer(0);
lbl75:
                // 3 sources

            } while (toRead > 0L);
            readFile.close();
            if (this.filesReadyToRegister % 300 == 0) {
                load.sendBuffer(0);
                load.out[load.randomIndex].close();
                registrationThreads[this.activeRegistrationThread].start();
                ++this.activeRegistrationThread;
                if (this.activeRegistrationThread >= SRBFile.MAX_NUMBER_OF_THREADS) {
                    this.activeRegistrationThread = 0;
                }
                if (registrationThreads[this.activeRegistrationThread] == null) {
                    registrationThreads[this.activeRegistrationThread] = new Thread(registration[this.activeRegistrationThread]);
                } else {
                    while (registrationThreads[this.activeRegistrationThread].isAlive()) {
                    }
                    registrationThreads[this.activeRegistrationThread] = new Thread(registration[this.activeRegistrationThread]);
                }
                tempFile[this.activeRegistrationThread] = SRBFile.createTempFile("BLoad", ".tmp", tempFile[this.activeRegistrationThread].getParentFile());
                registration[this.activeRegistrationThread].setBloadFilePath(tempFile[this.activeRegistrationThread].getAbsolutePath());
                load.restartRandom = true;
                load.newRandom = tempFile[this.activeRegistrationThread];
                load.randomIndex = this.activeRegistrationThread;
            }
        }
    }

    void bulkUnload(LocalFile dir) throws IOException {
        int flag = 0x8000000;
        if (this.exists()) {
            if (dir.exists()) {
                dir = new LocalFile(dir, this.getName());
            } else {
                dir.mkdir();
            }
            this.srbFileSystem.srbBulkUnload(this.catalogType, flag, this.getAbsolutePath(), dir.getAbsolutePath());
        }
    }

    public String getPermissions() throws IOException {
        block6: {
            MetaDataSelect[] selects;
            String userDomain;
            String userName;
            MetaDataRecordList[] rl;
            block5: {
                MetaDataSelect[] selects2;
                rl = null;
                userName = this.srbFileSystem.getUserName();
                userDomain = this.srbFileSystem.getDomainName();
                if (!this.isDirectory()) break block5;
                MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("access directory name", 0, this.getAbsolutePath()), MetaDataSet.newCondition("user name", 0, userName), MetaDataSet.newCondition("user domain", 0, userDomain)};
                rl = this.srbFileSystem.query(conditions, selects2 = new MetaDataSelect[]{MetaDataSet.newSelection("access directory name"), MetaDataSet.newSelection("directory access constraint"), MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain")});
                if (rl == null) break block6;
                int i = 0;
                while (i < rl.length) {
                    if (rl[i].getValue("user name").equals(userName) && rl[i].getValue("user domain").equals(userDomain)) {
                        return rl[i].getValue("directory access constraint").toString();
                    }
                    ++i;
                }
                break block6;
            }
            MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("user name", 0, userName), MetaDataSet.newCondition("user domain", 0, userDomain)};
            rl = this.query(conditions, selects = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint"), MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain")});
            if (rl != null) {
                int i = 0;
                while (i < rl.length) {
                    if (rl[i].getValue("user name").equals(userName) && rl[i].getValue("user domain").equals(userDomain)) {
                        return rl[i].getValue("access constraint").toString();
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public MetaDataRecordList[] getPermissions(boolean allUsers) throws IOException {
        if (this.isDirectory()) {
            MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("access directory name", 0, this.getAbsolutePath())};
            MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint"), MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain")};
            return this.srbFileSystem.query(conditions, selects);
        }
        MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint"), MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain")};
        return this.query(selects);
    }

    public void changePermissions(String permission, String newUserName, String userMdasDomain) throws IOException {
        int retractionType = -1;
        if (permission == null) {
            permission = "";
        }
        if ((permission = permission.toLowerCase()).equals("n") || permission.equals("null")) {
            permission = "";
        } else if (permission.equals("r") || permission.equals("read")) {
            permission = "read";
        } else if (permission.equals("w") || permission.equals("write")) {
            permission = "write";
        } else if (permission.equals("rw")) {
            permission = "all";
        } else if (permission.equals("all") || permission.equals("ownership")) {
            permission = "all";
        } else if (permission.equals("t") || permission.equals("annotate")) {
            permission = "annotate";
        } else {
            throw new IllegalArgumentException("Permission type not valid: " + permission);
        }
        if (this.isDirectory()) {
            retractionType = permission == "" ? 28 : 27;
            this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), newUserName, userMdasDomain, permission, retractionType);
        } else {
            retractionType = permission == "" ? 9 : 8;
            this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", "", String.valueOf(newUserName) + "@" + userMdasDomain, permission, retractionType);
        }
    }

    public void replicate(String newResource) throws IOException {
        if (this.isDirectory()) {
            SRBFile[] list = (SRBFile[])this.listFiles();
            int i = 0;
            while (i < list.length) {
                if (list[i].isFile(false)) {
                    this.srbFileSystem.srbObjReplicate(this.catalogType, this.fileName, this.getParent(), newResource, null);
                } else {
                    list[i].replicate(newResource, false);
                }
                ++i;
            }
        } else {
            this.srbFileSystem.srbObjReplicate(this.catalogType, this.fileName, this.getParent(), newResource, null);
        }
    }

    private void replicate(String newResource, boolean update) throws IOException {
        if (this.isDirectory(false)) {
            SRBFile[] list = (SRBFile[])this.listFiles();
            int i = 0;
            while (i < list.length) {
                if (list[i].isFile(false)) {
                    this.srbFileSystem.srbObjReplicate(this.catalogType, this.fileName, this.getParent(), newResource, null);
                } else {
                    list[i].replicate(newResource, false);
                }
                ++i;
            }
        } else {
            this.srbFileSystem.srbObjReplicate(this.catalogType, this.fileName, this.getParent(), newResource, null);
        }
    }

    public void backup(String backupResource) throws IOException {
        if (this.isDirectory()) {
            String[] list = this.list();
            int i = 0;
            while (i < list.length) {
                if (list[i].startsWith(PATH_SEPARATOR)) {
                    new SRBFile(this.srbFileSystem, list[i]).backup(backupResource);
                } else {
                    new SRBFile(this.srbFileSystem, String.valueOf(this.getAbsolutePath()) + PATH_SEPARATOR + list[i]).backup(backupResource);
                }
                ++i;
            }
        } else {
            this.srbFileSystem.srbBackupData(this.catalogType, this.fileName, this.getParent(), backupResource, 0);
        }
    }

    public String checksum() throws IOException {
        if (this.isFile()) {
            byte[] checksum = this.srbFileSystem.srbObjChksum(this.getName(), this.getParent(), 16, null);
            if (checksum == null) {
                return this.checksum(false);
            }
            return new String(checksum);
        }
        return null;
    }

    public String checksum(boolean force) throws IOException {
        if (this.isFile()) {
            if (force) {
                return new String(this.srbFileSystem.srbObjChksum(this.getName(), this.getParent(), 32, null));
            }
            return new String(this.srbFileSystem.srbObjChksum(this.getName(), this.getParent(), 128, null));
        }
        return null;
    }

    public void register(String registeringObjectPath, long dataSize) throws IOException {
        if (dataSize < 0L) {
            dataSize = 0L;
        }
        this.srbFileSystem.srbRegisterDataset(this.catalogType, this.getName(), this.dataType, this.resource, this.getParent(), registeringObjectPath, dataSize);
    }

    public InputStream executeProxyCommand(String command, String commandArgs) throws IOException {
        return this.srbFileSystem.executeProxyCommand(command, commandArgs, null, this.getPath(), -1);
    }

    public void link(SRBFile newLink) throws IOException {
        if (this.isDirectory()) {
            GeneralFile[] fileList = this.listFiles();
            newLink.mkdir();
            int i = 0;
            while (i < fileList.length) {
                SRBFile temp = new SRBFile(newLink, fileList[i].getName());
                ((SRBFile)fileList[i]).link(temp);
                ++i;
            }
        } else {
            this.srbFileSystem.srbModifyDataset(0, this.fileName, this.getParent(), "", "", newLink.getName(), newLink.getParent(), 83);
        }
    }

    public boolean canRead() {
        block10: {
            MetaDataRecordList[] canRead = null;
            String readable = null;
            String userName = this.srbFileSystem.getUserName();
            int operator = 0;
            try {
                if (this.isDirectory()) {
                    MetaDataSelect[] selects;
                    MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("user name", operator, userName), MetaDataSet.newCondition("access directory name", operator, this.getAbsolutePath())};
                    canRead = this.srbFileSystem.query(conditions, selects = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (canRead == null) {
                        return false;
                    }
                    int i = 0;
                    while (i < canRead.length) {
                        if (canRead[i].getValue("directory access constraint") != null && ((readable = canRead[i].getValue("directory access constraint").toString()).equals("all") || readable.equals("read"))) {
                            return true;
                        }
                        ++i;
                    }
                } else if (this.isFile()) {
                    MetaDataSelect[] selects;
                    MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("user name", operator, userName), MetaDataSet.newCondition("directory name", operator, this.getParent()), MetaDataSet.newCondition("file name", operator, this.getName())};
                    canRead = this.srbFileSystem.query(conditions, selects = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint")}, 3);
                    if (canRead == null) {
                        return false;
                    }
                    readable = canRead[0].getValue("access constraint").toString();
                    if (readable.equals("all") || readable.equals("read")) {
                        return true;
                    }
                }
            }
            catch (IOException e) {
                if (SRBCommands.DEBUG <= 0) break block10;
                e.printStackTrace();
            }
        }
        return false;
    }

    boolean canRead(String kindOfFile) {
        block9: {
            MetaDataRecordList[] canRead = null;
            String readable = null;
            String userName = this.srbFileSystem.getUserName();
            int operator = 0;
            try {
                if (kindOfFile.equals("isDir")) {
                    MetaDataSelect[] selects;
                    MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("user name", operator, userName), MetaDataSet.newCondition("access directory name", operator, this.getAbsolutePath())};
                    canRead = this.srbFileSystem.query(conditions, selects = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (canRead == null) {
                        return false;
                    }
                    int i = 0;
                    while (i < canRead.length) {
                        if (canRead[i].getValue("directory access constraint") != null && ((readable = canRead[i].getValue("directory access constraint").toString()).equals("all") || readable.equals("read"))) {
                            return true;
                        }
                        ++i;
                    }
                    break block9;
                }
                if (kindOfFile.equals("isFile")) {
                    MetaDataSelect[] selects;
                    MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("user name", operator, userName), MetaDataSet.newCondition("directory name", operator, this.getParent()), MetaDataSet.newCondition("file name", operator, this.getName())};
                    canRead = this.srbFileSystem.query(conditions, selects = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint")}, 3);
                    if (canRead == null) {
                        return false;
                    }
                    readable = canRead[0].getValue("access constraint").toString();
                    if (readable.equals("all") || readable.equals("read")) {
                        return true;
                    }
                    break block9;
                }
                return this.canRead();
            }
            catch (IOException e) {
                if (SRBCommands.DEBUG <= 0) break block9;
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean canWrite() {
        block10: {
            MetaDataRecordList[] canWrite = null;
            String writeable = null;
            String userName = this.srbFileSystem.getUserName();
            int operator = 0;
            try {
                if (this.isDirectory()) {
                    MetaDataSelect[] selects;
                    MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("user name", operator, userName), MetaDataSet.newCondition("access directory name", operator, this.getAbsolutePath())};
                    canWrite = this.srbFileSystem.query(conditions, selects = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (canWrite == null) {
                        return false;
                    }
                    int i = 0;
                    while (i < canWrite.length) {
                        if (canWrite[i].getValue("directory access constraint") != null && ((writeable = canWrite[i].getValue("directory access constraint").toString()).equals("all") || writeable.equals("write"))) {
                            return true;
                        }
                        ++i;
                    }
                } else if (this.isFile()) {
                    MetaDataSelect[] selects;
                    MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("user name", operator, userName), MetaDataSet.newCondition("directory name", operator, this.getParent()), MetaDataSet.newCondition("file name", operator, this.getName())};
                    canWrite = this.srbFileSystem.query(conditions, selects = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint")}, 3);
                    if (canWrite == null) {
                        return false;
                    }
                    writeable = canWrite[0].getValue("access constraint").toString();
                    if (writeable.equals("all") || writeable.equals("write")) {
                        return true;
                    }
                }
            }
            catch (IOException e) {
                if (SRBCommands.DEBUG <= 0) break block10;
                e.printStackTrace();
            }
        }
        return false;
    }

    boolean canWrite(String kindOfFile) {
        block9: {
            MetaDataRecordList[] canWrite = null;
            String writeable = null;
            String userName = this.srbFileSystem.getUserName();
            int operator = 0;
            try {
                if (kindOfFile.equals("isDir")) {
                    MetaDataSelect[] selects;
                    MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("user name", operator, userName), MetaDataSet.newCondition("access directory name", operator, this.getAbsolutePath())};
                    canWrite = this.srbFileSystem.query(conditions, selects = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (canWrite == null) {
                        return false;
                    }
                    int i = 0;
                    while (i < canWrite.length) {
                        if (canWrite[i].getValue("directory access constraint") != null && ((writeable = canWrite[i].getValue("directory access constraint").toString()).equals("all") || writeable.equals("write"))) {
                            return true;
                        }
                        ++i;
                    }
                    break block9;
                }
                if (kindOfFile.equals("isFile")) {
                    MetaDataSelect[] selects;
                    MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("user name", operator, userName), MetaDataSet.newCondition("directory name", operator, this.getParent()), MetaDataSet.newCondition("file name", operator, this.getName())};
                    canWrite = this.srbFileSystem.query(conditions, selects = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint")}, 3);
                    if (canWrite == null) {
                        return false;
                    }
                    writeable = canWrite[0].getValue("access constraint").toString();
                    if (writeable.equals("all") || writeable.equals("write")) {
                        return true;
                    }
                    break block9;
                }
                return this.canWrite();
            }
            catch (IOException e) {
                if (SRBCommands.DEBUG <= 0) break block9;
                e.printStackTrace();
            }
        }
        return false;
    }

    public int compareTo(GeneralFile pathName) {
        return pathName.getAbsolutePath().compareTo(this.getAbsolutePath());
    }

    public int compareTo(Object o) throws ClassCastException {
        return this.compareTo((SRBFile)o);
    }

    public boolean createNewFile() throws IOException {
        block4: {
            try {
                if (!this.isFile()) {
                    this.getParentFile().mkdirs();
                    int fd = this.srbFileSystem.srbObjCreate(this.catalogType, this.getName(), this.dataType, this.resource, this.getParent(), this.serverLocalPath, -1L);
                    this.srbFileSystem.srbObjClose(fd);
                    return true;
                }
            }
            catch (SRBException e) {
                if (SRBCommands.DEBUG > 0) {
                    e.printStackTrace();
                }
                if (e.getType() == -3210) break block4;
                throw e;
            }
        }
        return false;
    }

    public static GeneralFile createTempFile(String prefix, String suffix) throws IOException, IllegalArgumentException {
        return SRBFile.createTempFile(prefix, suffix, null);
    }

    public static GeneralFile createTempFile(String prefix, String suffix, GeneralFile directory) throws IOException, IllegalArgumentException {
        SRBFile temp;
        String randomChars = "";
        int i = 0;
        while (i < 8) {
            randomChars = String.valueOf(randomChars) + (char)(65.0 + Math.random() * 25.0);
            ++i;
        }
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (directory == null) {
            SRBFileSystem fs = new SRBFileSystem();
            directory = new SRBFile(fs, fs.getHomeDirectory(), "temp");
            directory.mkdir();
        }
        if ((temp = new SRBFile((SRBFile)directory, String.valueOf(prefix) + randomChars + suffix)).createNewFile()) {
            return temp;
        }
        throw new IOException("The temp file already exists.");
    }

    public boolean delete() {
        return this.delete(false);
    }

    public boolean delete(boolean force) {
        try {
            if (!force && this.srbFileSystem.getVersionNumber() >= 3.0f) {
                if (this.isDirectory()) {
                    this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), "", "", "", 31);
                    return true;
                }
                if (this.isFile() && this.getReplicaNumber() < 0) {
                    this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", "", "", "", 174);
                    return true;
                }
                this.srbFileSystem.srbObjUnlink(this.fileName, this.getParent());
                return true;
            }
            if (this.isDirectory()) {
                this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), "", "", "", 31);
                return true;
            }
            if (this.isFile()) {
                this.srbFileSystem.srbObjUnlink(this.fileName, this.getParent());
                return true;
            }
        }
        catch (IOException e) {
            if (SRBCommands.DEBUG > 0) {
                e.printStackTrace();
            }
            return false;
        }
        return false;
    }

    public void deleteOnExit() {
        this.deleteOnExit = true;
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            SRBFile temp = (SRBFile)obj;
            return this.getAbsolutePath().equals(temp.getAbsolutePath());
        }
        catch (ClassCastException e) {
            if (SRBCommands.DEBUG > 0) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public boolean exists() {
        block6: {
            try {
                MetaDataRecordList[] rl = null;
                int operator = 0;
                MetaDataCondition[] conditions = null;
                if (this.getReplicaNumber() >= 0) {
                    conditions = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", operator, this.getParent()), MetaDataSet.newCondition("file name", operator, this.getName())};
                    conditions[1] = MetaDataSet.newCondition("file replication enum", operator, this.replicaNumber);
                } else {
                    conditions = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", operator, this.getParent()), MetaDataSet.newCondition("file name", operator, this.getName())};
                }
                MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
                rl = this.srbFileSystem.query(conditions, selects, 3);
                if (rl != null) {
                    return true;
                }
                conditions = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", operator, this.getAbsolutePath())};
                selects[0] = MetaDataSet.newSelection("directory name");
                rl = this.srbFileSystem.query(conditions, selects, 3);
                if (rl != null) {
                    return true;
                }
            }
            catch (IOException e) {
                if (SRBCommands.DEBUG <= 0) break block6;
                e.printStackTrace();
            }
        }
        return false;
    }

    public GeneralFile getAbsoluteFile() {
        return new SRBFile(this.srbFileSystem, this.getAbsolutePath());
    }

    public String getAbsolutePath() {
        if (this.directory != null && !this.directory.isEmpty()) {
            int size = this.directory.size();
            String path = (String)this.directory.firstElement();
            int i = 1;
            while (i < size) {
                path = String.valueOf(path) + this.getPathSeparator() + this.directory.get(i);
                ++i;
            }
            return String.valueOf(path) + this.getPathSeparator() + this.getName();
        }
        return this.getName();
    }

    public GeneralFile getCanonicalFile() throws IOException {
        return new SRBFile(this.srbFileSystem, this.getCanonicalPath());
    }

    public String getCanonicalPath() throws IOException {
        if (this.directory != null && !this.directory.isEmpty()) {
            int size = this.directory.size();
            String path = (String)this.directory.firstElement();
            int i = 1;
            while (i < size) {
                path = String.valueOf(path) + this.getPathSeparator() + this.directory.get(i);
                ++i;
            }
            return String.valueOf(path) + this.getPathSeparator() + this.fileName;
        }
        return this.fileName;
    }

    public String getName() {
        int index = this.fileName.indexOf("&COPY=");
        if (index >= 0) {
            return this.fileName.substring(0, index);
        }
        return this.fileName;
    }

    public String getParent() {
        if (this.directory != null && !this.directory.isEmpty()) {
            int size = this.directory.size();
            String path = (String)this.directory.firstElement();
            int i = 1;
            while (i < size) {
                path = String.valueOf(path) + this.getPathSeparator() + this.directory.get(i);
                ++i;
            }
            return path;
        }
        return null;
    }

    public GeneralFile getParentFile() {
        return new SRBFile(this.srbFileSystem, this.getParent());
    }

    public String getPath() {
        return this.originalFilePath;
    }

    public int hashCode() {
        return this.getAbsolutePath().toLowerCase().hashCode() ^ 0x12D591;
    }

    public boolean isAbsolute() {
        return true;
    }

    public boolean isDirectory() {
        block3: {
            MetaDataRecordList[] rl = null;
            MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.getAbsolutePath())};
            MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("directory name")};
            try {
                rl = this.srbFileSystem.query(conditions, selects, 3);
                if (rl != null) {
                    this.pathNameType = 2;
                    return true;
                }
            }
            catch (IOException e) {
                if (SRBCommands.DEBUG <= 0) break block3;
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean isDirectory(boolean update) {
        if (update || this.pathNameType == 0) {
            return this.isDirectory();
        }
        if (this.pathNameType == 1) {
            return false;
        }
        if (this.pathNameType == 2) {
            return true;
        }
        return this.isDirectory();
    }

    public boolean isFile() {
        block3: {
            MetaDataRecordList[] rl = null;
            MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.getParent()), MetaDataSet.newCondition("file name", 0, this.getName())};
            MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
            try {
                rl = this.srbFileSystem.query(conditions, selects, 3);
                if (rl != null) {
                    this.pathNameType = 1;
                    return true;
                }
            }
            catch (IOException e) {
                if (SRBCommands.DEBUG <= 0) break block3;
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean isFile(boolean update) {
        if (update || this.pathNameType == 0) {
            return this.isDirectory();
        }
        if (this.pathNameType == 1) {
            return true;
        }
        if (this.pathNameType == 2) {
            return false;
        }
        return this.isFile();
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        long[] stat;
        long lastModified = 0L;
        try {
            stat = this.getStat();
        }
        catch (IOException e) {
            if (SRBCommands.DEBUG > 0) {
                e.printStackTrace();
            }
            return 0L;
        }
        if (stat != null) {
            lastModified = stat[10] * 1000L;
        }
        return lastModified;
    }

    public long length() {
        long[] stat;
        long length = 0L;
        try {
            stat = this.getStat();
        }
        catch (IOException e) {
            if (SRBCommands.DEBUG > 0) {
                e.printStackTrace();
            }
            return 0L;
        }
        if (stat != null) {
            length = stat[0];
        }
        return length;
    }

    public String[] list() {
        MetaDataCondition[] conditions = new MetaDataCondition[1];
        MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
        MetaDataRecordList[] rl1 = null;
        MetaDataRecordList[] rl2 = null;
        MetaDataRecordList[] temp = null;
        Vector<String> list = null;
        String path = null;
        try {
            path = this.isDirectory() ? this.getAbsolutePath() : this.getParent();
            conditions[0] = MetaDataSet.newCondition("directory name", 0, path);
            rl1 = this.srbFileSystem.query(conditions, selects, SRBFileSystem.DEFAULT_RECORDS_WANTED);
            if (this.completeDirectoryList) {
                rl1 = MetaDataRecordList.getAllResults(rl1);
            }
            selects[0] = MetaDataSet.newSelection("directory name");
            conditions[0] = MetaDataSet.newCondition("parent directory name", 0, path);
            rl2 = this.srbFileSystem.query(conditions, selects, SRBFileSystem.DEFAULT_RECORDS_WANTED);
            if (this.completeDirectoryList) {
                rl2 = MetaDataRecordList.getAllResults(rl2);
            }
            if (rl2 != null) {
                String absolutePath = null;
                String relativePath = null;
                int i = 0;
                while (i < rl2.length) {
                    absolutePath = rl2[i].getStringValue(0);
                    relativePath = absolutePath.substring(absolutePath.lastIndexOf(PATH_SEPARATOR) + 1);
                    rl2[i].setValue(0, relativePath);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            if (SRBCommands.DEBUG > 0) {
                e.printStackTrace();
            }
            return null;
        }
        if (rl1 != null && rl2 != null) {
            temp = new SRBMetaDataRecordList[rl1.length + rl2.length];
            System.arraycopy(rl1, 0, temp, 0, rl1.length);
            System.arraycopy(rl2, 0, temp, rl1.length, rl2.length);
        } else if (rl1 != null) {
            temp = rl1;
        } else if (rl2 != null) {
            temp = rl2;
        } else {
            return new String[0];
        }
        list = new Vector<String>();
        int i = 0;
        while (i < temp.length) {
            if (temp[i].getStringValue(0) != null) {
                list.add(temp[i].getStringValue(0));
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    public String[] list(MetaDataCondition[] conditions) {
        if (conditions == null) {
            return this.list();
        }
        MetaDataCondition[] tempConditions = null;
        MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
        MetaDataRecordList[] rl1 = null;
        MetaDataRecordList[] rl2 = null;
        MetaDataRecordList[] temp = null;
        Vector<String> list = null;
        String path = null;
        try {
            path = this.isDirectory() ? this.getAbsolutePath() : this.getParent();
            tempConditions = MetaDataSet.mergeConditions(MetaDataSet.newCondition("directory name", 0, path), conditions);
            rl1 = this.srbFileSystem.query(tempConditions, selects, SRBFileSystem.DEFAULT_RECORDS_WANTED);
            if (this.completeDirectoryList) {
                rl1 = MetaDataRecordList.getAllResults(rl1);
            }
            selects[0] = MetaDataSet.newSelection("directory name");
            tempConditions = MetaDataSet.mergeConditions(MetaDataSet.newCondition("parent directory name", 0, path), null);
            rl2 = this.srbFileSystem.query(tempConditions, selects, SRBFileSystem.DEFAULT_RECORDS_WANTED);
            if (this.completeDirectoryList) {
                rl2 = MetaDataRecordList.getAllResults(rl2);
            }
            if (rl2 != null) {
                String absolutePath = null;
                String relativePath = null;
                int i = 0;
                while (i < rl2.length) {
                    absolutePath = rl2[i].getStringValue(0);
                    relativePath = absolutePath.substring(absolutePath.lastIndexOf(PATH_SEPARATOR) + 1);
                    rl2[i].setValue(0, relativePath);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            if (SRBCommands.DEBUG > 0) {
                e.printStackTrace();
            }
            return null;
        }
        if (rl1 != null && rl2 != null) {
            temp = new SRBMetaDataRecordList[rl1.length + rl2.length];
            System.arraycopy(rl1, 0, temp, 0, rl1.length);
            System.arraycopy(rl2, 0, temp, rl1.length, rl2.length);
        } else if (rl1 != null) {
            temp = rl1;
        } else if (rl2 != null) {
            temp = rl2;
        } else {
            return new String[0];
        }
        list = new Vector<String>();
        int i = 0;
        while (i < temp.length) {
            if (temp[i].getStringValue(0) != null) {
                list.add(temp[i].getStringValue(0));
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    public static GeneralFile[] listRoots() {
        GeneralFile[] list;
        block2: {
            list = new GeneralFile[1];
            try {
                list[0] = new SRBFile(new SRBFileSystem(), PATH_SEPARATOR);
            }
            catch (IOException e) {
                if (SRBCommands.DEBUG <= 0) break block2;
                e.printStackTrace();
            }
        }
        return list;
    }

    public boolean mkdir() {
        block3: {
            try {
                if (!this.isDirectory()) {
                    this.srbFileSystem.srbCreateCollect(this.catalogType, this.getParent(), this.getName());
                    return true;
                }
            }
            catch (IOException e) {
                if (SRBCommands.DEBUG <= 0) break block3;
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean mkdirs() {
        if (!this.isDirectory()) {
            int dirNum = this.directory.size();
            SRBFile dir = new SRBFile(this.srbFileSystem, this.directory.get(0).toString());
            int i = 0;
            while (i < dirNum) {
                if (!dir.exists()) {
                    dir.mkdir();
                    dir = new SRBFile(dir, this.directory.get(i).toString());
                }
                ++i;
            }
            this.mkdir();
            return true;
        }
        return false;
    }

    public boolean renameTo(GeneralFile dest) throws IllegalArgumentException {
        block20: {
            if (dest instanceof SRBFile) {
                try {
                    if (this.isFile()) {
                        if (this.getParent().equals(dest.getParent())) {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", "", dest.getName(), "", 29);
                        } else if (this.getName().equals(dest.getName())) {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", "", dest.getParent(), "", 6);
                        } else {
                            String tempName = String.valueOf(dest.getName()) + (long)Math.random();
                            this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", "", tempName, "", 29);
                            try {
                                this.srbFileSystem.srbModifyDataset(this.catalogType, tempName, this.getParent(), "", "", dest.getParent(), "", 6);
                            }
                            catch (IOException e) {
                                if (SRBCommands.DEBUG > 0) {
                                    e.printStackTrace();
                                }
                                this.srbFileSystem.srbModifyDataset(this.catalogType, tempName, this.getParent(), "", "", this.fileName, "", 29);
                            }
                            try {
                                this.srbFileSystem.srbModifyDataset(this.catalogType, tempName, dest.getParent(), "", "", dest.getName(), "", 29);
                            }
                            catch (IOException e) {
                                if (SRBCommands.DEBUG > 0) {
                                    e.printStackTrace();
                                }
                                this.srbFileSystem.srbModifyDataset(this.catalogType, tempName, dest.getParent(), "", "", this.getParent(), "", 6);
                                this.srbFileSystem.srbModifyDataset(this.catalogType, tempName, this.getParent(), "", "", this.fileName, "", 29);
                            }
                        }
                        this.directory = new Vector();
                        this.setFileName(dest.getAbsolutePath());
                        return true;
                    }
                    if (this.isDirectory()) {
                        this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), dest.getAbsolutePath(), null, null, 30);
                        this.directory = new Vector();
                        this.setFileName(dest.getAbsolutePath());
                        return true;
                    }
                    if (!this.exists()) {
                        this.directory = new Vector();
                        this.setFileName(dest.getAbsolutePath());
                        return true;
                    }
                    break block20;
                }
                catch (IOException e) {
                    if (SRBCommands.DEBUG > 0) {
                        e.printStackTrace();
                    }
                    break block20;
                }
            }
            try {
                this.copyTo(dest, false);
                this.delete();
                this.directory = new Vector();
                this.setFileName(dest.getAbsolutePath());
                return true;
            }
            catch (IOException e) {
                if (SRBCommands.DEBUG > 0) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return false;
    }

    public boolean setLastModified(long time) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public boolean setReadOnly() {
        throw new UnsupportedOperationException();
    }

    public URI toURI() {
        URI uri;
        block2: {
            uri = null;
            try {
                uri = this.isDirectory() ? new URI("srb", String.valueOf(this.srbFileSystem.getUserName()) + "." + this.srbFileSystem.getDomainName(), this.srbFileSystem.getHost(), this.srbFileSystem.getPort(), String.valueOf(this.getAbsolutePath()) + PATH_SEPARATOR, "", "") : new URI("srb", String.valueOf(this.srbFileSystem.getUserName()) + "." + this.srbFileSystem.getDomainName(), this.srbFileSystem.getHost(), this.srbFileSystem.getPort(), this.getAbsolutePath(), "", "");
            }
            catch (URISyntaxException e) {
                if (SRBCommands.DEBUG <= 0) break block2;
                e.printStackTrace();
            }
        }
        return uri;
    }

    public URL toURL() throws MalformedURLException {
        URL url = null;
        url = this.isDirectory() ? new URL("srb://" + this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName() + "@" + this.srbFileSystem.getHost() + ":" + this.srbFileSystem.getPort() + this.getAbsolutePath() + PATH_SEPARATOR) : new URL("srb://" + this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName() + "@" + this.srbFileSystem.getHost() + ":" + this.srbFileSystem.getPort() + this.getAbsolutePath());
        return url;
    }

    class LoadThread
    implements Runnable {
        GeneralRandomAccessFile[] out;
        byte[] buffer1;
        byte[] buffer2;
        boolean writeBuffer1 = false;
        boolean writeBuffer2 = false;
        int buffer1Length = 0;
        int buffer2Length = 0;
        boolean keepLoading = true;
        boolean restartRandom = false;
        GeneralFile newRandom;
        int randomIndex;
        Object mainThread;

        LoadThread(GeneralRandomAccessFile[] out, byte[] buffer1, byte[] buffer2, Object mainThread) {
            this.out = out;
            this.buffer1 = buffer1;
            this.buffer2 = buffer2;
            this.mainThread = mainThread;
        }

        public void run() {
            int oldBuf = Integer.MIN_VALUE;
        }

        void restartRandomAccessFile() throws IOException {
            this.out[this.randomIndex] = FileFactory.newRandomAccessFile(this.newRandom, "rw");
            this.restartRandom = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int sendBuffer(int oldBuf) throws IOException {
            if (this.buffer1Length <= 0) {
                return oldBuf;
            }
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.restartRandom) {
                    this.restartRandomAccessFile();
                }
            }
            this.out[SRBFile.this.activeRegistrationThread].write(this.buffer1, 0, this.buffer1Length);
            this.buffer1Length = 0;
            SRBFile.this.loadBuffer1 = 0;
            return oldBuf;
        }
    }

    class RegistrationThread
    implements Runnable {
        String bloadFilePath;
        Object mainThread;
        Vector files = new Vector();
        Vector paths = new Vector();

        RegistrationThread(String bloadFilePath, Object mainThread) throws IOException {
            this.bloadFilePath = bloadFilePath;
            this.mainThread = mainThread;
        }

        void setBloadFilePath(String bloadFilePath) {
            this.bloadFilePath = bloadFilePath;
        }

        void addFile(GeneralFile file, String relativePath) {
            this.files.add(file);
            this.paths.add(relativePath);
        }

        public void run() {
            try {
                this.register();
            }
            catch (IOException e) {
                if (SRBCommands.DEBUG > 0) {
                    e.printStackTrace();
                }
                SRBFile.this.bulkLoadException = e;
            }
        }

        SRBMetaDataRecordList[] getFileRegistry(int numFiles) throws IOException {
            SRBMetaDataRecordList rl = null;
            SRBMetaDataRecordList[] recordLists = new SRBMetaDataRecordList[numFiles];
            GeneralFile tempFile = null;
            Object tempFile2 = null;
            Object tempName = null;
            Object tempName2 = null;
            String dirName = null;
            long size = 0L;
            int offset = 0;
            int i = 0;
            while (i < numFiles) {
                tempFile = (GeneralFile)this.files.get(i);
                offset = (int)((long)offset + size);
                size = tempFile.length();
                dirName = (String)this.paths.get(i);
                dirName = dirName == null || dirName.equals("") ? SRBFile.this.getAbsolutePath() : String.valueOf(SRBFile.this.getAbsolutePath()) + SRBFile.PATH_SEPARATOR + dirName;
                rl = new SRBMetaDataRecordList(SRBMetaDataSet.getField("file name"), tempFile.getName());
                rl.addRecord(SRBMetaDataSet.getField("directory name"), dirName);
                rl.addRecord(SRBMetaDataSet.getField("size"), size);
                rl.addRecord(SRBMetaDataSet.getField("offset"), offset);
                recordLists[i] = rl;
                ++i;
            }
            i = 0;
            while (i < numFiles) {
                try {
                    this.files.remove(0);
                    this.paths.remove(0);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    if (SRBCommands.DEBUG <= 0) break;
                    e.printStackTrace();
                    break;
                }
                ++i;
            }
            return recordLists;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register() throws IOException {
            Object object;
            int numFiles = this.files.size();
            if (numFiles > 0) {
                object = this.mainThread;
                synchronized (object) {
                    this.mainThread.notify();
                }
                SRBFile.this.srbFileSystem.srbBulkLoad(SRBFile.this.catalogType, this.bloadFilePath, this.getFileRegistry(numFiles));
            }
            object = this.mainThread;
            synchronized (object) {
                this.mainThread.notify();
            }
        }
    }
}

