/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.RemoteFileInputStream;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.IOException;

public class SRBFileInputStream
extends RemoteFileInputStream {
    long filePointer = 0L;
    protected SRBFileSystem fileSystem;
    SRBFile file;

    public SRBFileInputStream(SRBFileSystem fileSystem, String name) throws IOException {
        super(fileSystem, name);
        this.fileSystem = fileSystem;
    }

    public SRBFileInputStream(SRBFile file) throws IOException {
        super(file);
        this.fileSystem = (SRBFileSystem)file.getFileSystem();
    }

    protected void setFileSystem(GeneralFileSystem fileSystem) throws IllegalArgumentException, ClassCastException {
        if (fileSystem == null) {
            throw new IllegalArgumentException("Illegal fileSystem, cannot be null");
        }
        this.fileSystem = (SRBFileSystem)fileSystem;
    }

    public GeneralFileSystem getFileSystem() {
        if (this.fileSystem != null) {
            return this.fileSystem;
        }
        throw new NullPointerException();
    }

    protected void open(GeneralFile file) throws IOException {
        this.file = (SRBFile)file;
        this.fd = ((SRBFileSystem)file.getFileSystem()).srbObjOpen(file.getName(), 0, file.getParent());
    }

    public int read() throws IOException {
        byte[] buffer = this.fileSystem.srbObjRead(this.fd, 1);
        if (buffer != null) {
            this.filePointer += (long)buffer.length;
            return buffer[0];
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        byte[] buffer = null;
        buffer = this.fileSystem.srbObjRead(this.fd, len);
        if (buffer != null) {
            System.arraycopy(buffer, 0, b, off, buffer.length);
            this.filePointer += (long)buffer.length;
            return buffer.length;
        }
        return -1;
    }

    public long skip(long n) throws IOException {
        long length = this.available();
        if (this.filePointer + n < length) {
            this.fileSystem.srbObjSeek(this.fd, n, 1);
            this.filePointer += n;
            return n;
        }
        this.fileSystem.srbObjSeek(this.fd, length, 1);
        this.filePointer += length;
        return length;
    }

    public int available() throws IOException {
        MetaDataRecordList[] rl = null;
        MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.file.getParent()), MetaDataSet.newCondition("file name", 0, this.file.getName())};
        MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("size")};
        try {
            rl = this.fileSystem.query(conditions, selects, 3);
            if (rl != null) {
                return (int)(Long.parseLong(rl[0].getValue("size").toString()) - this.filePointer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.srbObjClose(this.fd);
            this.fileSystem = null;
        }
        if (this.file != null) {
            this.file = null;
        }
    }

    public String toString() {
        return "Input: " + this.file;
    }
}

