/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.RemoteFileOutputStream;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.IOException;

public class SRBFileOutputStream
extends RemoteFileOutputStream {
    protected SRBFileSystem fileSystem;

    public SRBFileOutputStream(SRBFileSystem fileSystem, String name) throws IOException {
        super(fileSystem, name);
        this.fileSystem = fileSystem;
    }

    public SRBFileOutputStream(SRBFile file) throws IOException {
        super(file);
        this.fileSystem = (SRBFileSystem)file.getFileSystem();
    }

    protected void open(GeneralFile file) throws IOException {
        this.fd = ((SRBFileSystem)file.getFileSystem()).srbObjOpen(file.getName(), 2, file.getParent());
    }

    public void write(byte[] b, int off, int len) throws IOException {
        byte[] buffer = new byte[len];
        System.arraycopy(b, off, buffer, 0, len);
        this.fileSystem.srbObjWrite(this.fd, buffer, len);
    }

    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.srbObjClose(this.fd);
            this.fileSystem = null;
        }
    }
}

