/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.RemoteFileSystem;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBCommands;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URL;

public class SRBFileSystem
extends RemoteFileSystem {
    public static final String SRB_ROOT = "/";
    public static final int DELETE_TYPE_LOCATION = 1;
    public static final int DELETE_TYPE_USER = 2;
    public static final int DELETE_TYPE_RESOURCE = 3;
    static final int USER_INFO_BUFFER_LENGTH = 400;
    static final int USER_INFO_BUFFER_LENGTH_3_0 = 464;
    static final int MDAS_PASSWORD_LENGTH = 32;
    static int DEFAULT_RECORDS_WANTED = 300;
    public static final int PORTAL_OFF = 0;
    public static final int PORTAL_ON = 1;
    public static final int PORTAL_STD_IN_OUT = 2;
    static int TOTAL_METADATA_ATTRIBUTES;
    static int MAX_TOKEN;
    static int MAX_FILE_SIZE;
    private SRBCommands commands;
    private SRBAccount srbAccount;
    private String version;
    private float versionNumber;
    int MIN_PORT = -1;
    int MAX_PORT = -1;

    public SRBFileSystem() throws FileNotFoundException, IOException {
        this(new SRBAccount());
    }

    public SRBFileSystem(SRBAccount srbAccount) throws IOException, NullPointerException {
        this.setAccount(srbAccount);
        this.commands = new SRBCommands();
        int error = 0;
        try {
            error = this.commands.connect(srbAccount, this.createUserInfoBuffer());
        }
        catch (ProtocolException e) {
            error = this.commands.connect(srbAccount, this.createUserInfoBuffer());
        }
        if (error == -1118) {
            System.out.println("SRB client/server version mismatch. Trying alternate handshake. error: " + error);
            this.setVersion(SRBAccount.getVersion());
            this.commands = new SRBCommands();
            error = this.commands.connect(srbAccount, this.createUserInfoBuffer());
        }
        if (error < 0) {
            throw new SRBException("Connection Failed", error);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.commands != null) {
            this.commands = null;
        }
        if (this.account != null) {
            this.account = null;
        }
    }

    protected void setAccount(GeneralAccount account) throws IOException {
        if (account == null) {
            account = new SRBAccount();
        }
        this.srbAccount = (SRBAccount)account.clone();
        this.account = this.srbAccount;
        SRBFileSystem sRBFileSystem = this;
        this.setVersion(sRBFileSystem.srbAccount.getVersion());
    }

    private void setVersion(String version) {
        if (version == null) {
            return;
        }
        this.version = version;
        SRBFileSystem sRBFileSystem = this;
        this.versionNumber = sRBFileSystem.srbAccount.getVersionNumber();
        if ((double)this.versionNumber >= 3.3) {
            TOTAL_METADATA_ATTRIBUTES = 500;
            MAX_TOKEN = 500;
            MAX_FILE_SIZE = 2700;
        } else if ((double)this.versionNumber >= 3.02) {
            TOTAL_METADATA_ATTRIBUTES = 500;
            MAX_TOKEN = 500;
            MAX_FILE_SIZE = 2700;
        } else if (this.versionNumber >= 3.0f) {
            TOTAL_METADATA_ATTRIBUTES = 500;
            MAX_TOKEN = 500;
            MAX_FILE_SIZE = 500;
        } else if (this.versionNumber >= 2.0f) {
            TOTAL_METADATA_ATTRIBUTES = 300;
            MAX_TOKEN = 200;
            MAX_FILE_SIZE = 400;
        } else if (this.versionNumber >= 1.0f) {
            TOTAL_METADATA_ATTRIBUTES = 180;
            MAX_TOKEN = 200;
            MAX_FILE_SIZE = 400;
        } else {
            throw new IllegalArgumentException("Invalid version");
        }
    }

    public GeneralAccount getAccount() throws NullPointerException {
        if (this.srbAccount != null) {
            return (SRBAccount)this.srbAccount.clone();
        }
        throw new NullPointerException();
    }

    public String[] getRootDirectories() {
        String[] root = new String[]{SRB_ROOT};
        return root;
    }

    void setDefaultStorageResource(String resource) {
        this.srbAccount.setDefaultStorageResource(resource);
    }

    void setProxyMcatZone(String zone) {
        this.srbAccount.setProxyMcatZone(zone);
    }

    void setMcatZone(String zone) {
        this.srbAccount.setMcatZone(zone);
    }

    public void setFirewallPorts(int minPort, int maxPort) {
        if (minPort >= 0 && maxPort >= 0) {
            this.MIN_PORT = minPort;
            this.MAX_PORT = maxPort;
        }
    }

    public void setQueryRecordsWanted(int num) {
        if (num > 0) {
            DEFAULT_RECORDS_WANTED = num;
        }
    }

    public int getQueryRecordsWanted() {
        return DEFAULT_RECORDS_WANTED;
    }

    public String getPassword() {
        return this.srbAccount.getPassword();
    }

    byte[] getPasswordBytes() {
        byte[] password = new byte[32];
        System.arraycopy(this.srbAccount.getPassword().getBytes(), 0, password, 0, this.srbAccount.getPassword().length());
        return password;
    }

    public String getProxyUserName() {
        return this.srbAccount.getProxyUserName();
    }

    public String getProxyDomainName() {
        return this.srbAccount.getProxyDomainName();
    }

    public int getOptions() {
        return this.srbAccount.getOptions();
    }

    public String getDomainName() {
        return this.srbAccount.getDomainName();
    }

    public String getVersion() {
        return this.version;
    }

    public String getDefaultStorageResource() {
        return this.srbAccount.getDefaultStorageResource();
    }

    public String getProxyMcatZone() {
        return this.srbAccount.getProxyMcatZone();
    }

    public String getMcatZone() {
        return this.srbAccount.getMcatZone();
    }

    public String getExecFile() {
        return this.srbAccount.getExecFile();
    }

    public float getVersionNumber() {
        return this.versionNumber;
    }

    long fileCopyStatus() {
        return this.commands.getBytesMoved();
    }

    public MetaDataRecordList[] query(String fieldName) throws IOException {
        MetaDataSelect[] temp = new MetaDataSelect[]{MetaDataSet.newSelection(fieldName)};
        return this.query(temp, DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(String[] fieldNames) throws IOException {
        return this.query(MetaDataSet.newSelection(fieldNames), DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataSelect select) throws IOException {
        MetaDataSelect[] temp = new MetaDataSelect[]{select};
        return this.query(temp, DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] selects) throws IOException {
        return this.query(selects, DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] selects, int recordsWanted) throws IOException {
        String fieldName = "zone name";
        int operator = 1;
        String value = null;
        MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition(fieldName, operator, value)};
        return this.query(conditions, selects, recordsWanted);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] conditions, MetaDataSelect[] selects) throws IOException {
        return this.query(conditions, selects, DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] conditions, MetaDataSelect[] selects, int recordsWanted) throws IOException {
        return this.query(conditions, selects, recordsWanted, false, false);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] conditions, MetaDataSelect[] selects, int recordsWanted, boolean orderBy) throws IOException {
        return this.query(conditions, selects, recordsWanted, orderBy, false);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] conditions, MetaDataSelect[] selects, int recordsWanted, boolean orderBy, boolean nonDistinct) throws IOException {
        int catalogType = 0;
        return this.srbGetDataDirInfo(catalogType, conditions, selects, recordsWanted, orderBy, nonDistinct);
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            SRBFileSystem temp = (SRBFileSystem)obj;
            if (this.getAccount().equals(temp.getAccount()) && this.isConnected() == temp.isConnected()) {
                return true;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return false;
    }

    public boolean isConnected() {
        return this.commands.isConnected();
    }

    public String toString() {
        return new String("srb://" + this.getUserName() + "." + this.getDomainName() + "@" + this.getHost() + ":" + this.getPort());
    }

    public void close() throws IOException {
        this.commands.close();
    }

    private byte[] createUserInfoBuffer() {
        byte[] userInfoBuffer = null;
        byte[] byArray = new byte[4];
        byArray[2] = 1;
        byArray[3] = -112;
        byte[] bufferLength = byArray;
        int messageType = 7;
        String temp = null;
        if (this.getVersion().equals("SRB2.0.0jargon&D") || this.getVersion().equals("SRB1.1.8jargon&C")) {
            userInfoBuffer = new byte[400];
            System.arraycopy(bufferLength, 0, userInfoBuffer, 0, bufferLength.length);
            userInfoBuffer[4] = messageType;
            System.arraycopy(this.getProxyUserName().getBytes(), 0, userInfoBuffer, 8, this.getProxyUserName().length());
            System.arraycopy(this.getProxyDomainName().getBytes(), 0, userInfoBuffer, 40, this.getProxyDomainName().length());
            System.arraycopy(this.getUserName().getBytes(), 0, userInfoBuffer, 72, this.getUserName().length());
            System.arraycopy(this.getDomainName().getBytes(), 0, userInfoBuffer, 104, this.getDomainName().length());
            userInfoBuffer[136] = (byte)this.getOptions();
            System.arraycopy(this.getVersion().getBytes(), 0, userInfoBuffer, 264, this.getVersion().length());
        } else {
            userInfoBuffer = new byte[464];
            bufferLength[3] = -48;
            System.arraycopy(bufferLength, 0, userInfoBuffer, 0, bufferLength.length);
            userInfoBuffer[4] = messageType;
            System.arraycopy(this.getProxyUserName().getBytes(), 0, userInfoBuffer, 8, this.getProxyUserName().length());
            System.arraycopy(this.getProxyDomainName().getBytes(), 0, userInfoBuffer, 40, this.getProxyDomainName().length());
            temp = this.getProxyMcatZone();
            if (temp != null) {
                System.arraycopy(this.getProxyMcatZone().getBytes(), 0, userInfoBuffer, 72, this.getProxyMcatZone().length());
            }
            System.arraycopy(this.getUserName().getBytes(), 0, userInfoBuffer, 104, this.getUserName().length());
            System.arraycopy(this.getDomainName().getBytes(), 0, userInfoBuffer, 136, this.getDomainName().length());
            temp = this.getMcatZone();
            if (temp != null) {
                System.arraycopy(this.getMcatZone().getBytes(), 0, userInfoBuffer, 168, this.getMcatZone().length());
            }
            System.arraycopy(this.getVersion().getBytes(), 0, userInfoBuffer, 200, this.getVersion().length());
            userInfoBuffer[264] = (byte)this.getOptions();
            if (this.getExecFile() != null) {
                System.arraycopy(this.getExecFile().getBytes(), 0, userInfoBuffer, 328, this.getExecFile().length());
            }
        }
        return userInfoBuffer;
    }

    public InputStream executeProxyCommand(String command, String commandArgs) throws IOException {
        return this.srbExecCommand(command, commandArgs, null, -1);
    }

    public InputStream executeProxyCommand(String command, String commandArgs, String hostAddress, int portalFlag) throws IOException {
        return this.srbExecCommand(command, commandArgs, hostAddress, portalFlag);
    }

    public InputStream executeProxyCommand(String command, String commandArgs, String hostAddress, String fileName, int portalFlag) throws IOException {
        return this.srbExecCommand(command, commandArgs, hostAddress, fileName, portalFlag);
    }

    public void registerURL(SRBFile file, URL url) throws IOException {
        this.srbRegisterDataset(0, file.getName(), "URL", file.getResource(), file.getParent(), url.toString(), 0L);
    }

    int srbObjCreate(int catType, String fileName, String dataTypeName, String resourceName, String collectionName, String serverLocalPath, long dataSize) throws IOException {
        if (dataTypeName == null) {
            dataTypeName = "generic";
        }
        if (resourceName == null) {
            resourceName = this.getDefaultStorageResource();
        }
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + collectionName;
        }
        if (serverLocalPath == null) {
            serverLocalPath = "";
        }
        return this.commands.srbObjCreate(catType, fileName, dataTypeName, resourceName, collectionName, serverLocalPath, dataSize);
    }

    int srbObjOpen(String objID, int openFlag, String collectionName) throws IOException {
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + collectionName;
        }
        return this.commands.srbObjOpen(objID, openFlag, collectionName);
    }

    void srbObjClose(int srbFD) throws IOException {
        this.commands.srbObjClose(srbFD);
    }

    void srbObjUnlink(String objID, String collectionName) throws IOException {
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + collectionName;
        }
        this.commands.srbObjUnlink(objID, collectionName);
    }

    byte[] srbObjRead(int srbFD, int length) throws IOException {
        return this.commands.srbObjRead(srbFD, length);
    }

    int srbObjWrite(int srbFD, byte[] outputBuffer, int length) throws IOException {
        if (length <= 0) {
            return 0;
        }
        return this.commands.srbObjWrite(srbFD, outputBuffer, length);
    }

    void srbObjSeek(int srbFD, long offset, int whence) throws IOException {
        this.commands.srbObjSeek(srbFD, offset, whence);
    }

    void srbObjSync(int srbFD) throws IOException {
        this.commands.srbObjSync(srbFD);
    }

    long[] srbObjStat(int catType, String pathName, int myType) throws IOException {
        if (pathName == null) {
            pathName = this.getHomeDirectory();
        } else if (!pathName.startsWith(SRB_ROOT)) {
            pathName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + pathName;
        }
        if (myType > 4 || myType < -1) {
            myType = -1;
        }
        return this.commands.srbObjStat(catType, pathName, myType);
    }

    long[] srbObjStat64(int catType, String collectionName, String fileName) throws IOException {
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + collectionName;
        }
        if (collectionName.substring(collectionName.length() - 1) != SRB_ROOT) {
            collectionName = collectionName.substring(collectionName.length() - 1) == System.getProperty("file.separator") ? String.valueOf(collectionName.substring(0, collectionName.length() - 2)) + SRB_ROOT : String.valueOf(collectionName) + SRB_ROOT;
        }
        return this.commands.srbObjStat64(catType, String.valueOf(collectionName) + fileName);
    }

    void srbObjReplicate(int catType, String objID, String collectionName, String newResourceName, String newPathName) throws IOException {
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + collectionName;
        }
        if (newResourceName == null) {
            newResourceName = this.getDefaultStorageResource();
        }
        this.commands.srbObjReplicate(catType, objID, collectionName, newResourceName, newPathName);
    }

    void srbObjMove(int catType, String objID, String collectionName, String srcResource, String newResourceName, String newPathName, String container) throws IOException {
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + collectionName;
        }
        if (srcResource == null) {
            srcResource = "";
        }
        if (newResourceName == null) {
            newResourceName = this.getDefaultStorageResource();
        }
        if (container == null) {
            container = "";
        }
        this.commands.srbObjMove(catType, objID, collectionName, srcResource, newResourceName, newPathName, container);
    }

    byte[] srbObjProxyOpr(int operation, int inputInt1, int inputInt2, int inputInt3, int inputInt4, String inputStr1, String inputStr2, String inputStr3, String inputStr4, byte[] inputBStrm1, byte[] inputBStrm2, byte[] inputBStrm3) throws IOException {
        return this.commands.srbObjProxyOpr(operation, inputInt1, inputInt2, inputInt3, inputInt4, inputStr1, inputStr2, inputStr3, inputStr4, inputBStrm1, inputBStrm2, inputBStrm3);
    }

    byte[] srbObjGetdents(int catType, int srbFD, long nbyte) throws IOException {
        return this.commands.srbObjGetdents(catType, srbFD, nbyte);
    }

    byte[] srbObjGetdents64(int catType, int srbFD, long nbyte) throws IOException {
        return this.commands.srbObjGetdents64(catType, srbFD, nbyte);
    }

    void srbCollSeek(int srbFD, int offset, int whence, int is64Flag) throws IOException {
        this.commands.srbCollSeek(srbFD, offset, whence, is64Flag);
    }

    SRBMetaDataRecordList[] srbGetDatasetInfo(int catType, String objID, String collectionName, int recordsWanted) throws IOException {
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + collectionName;
        }
        if (recordsWanted < 1) {
            recordsWanted = DEFAULT_RECORDS_WANTED;
        }
        return this.commands.srbGetDatasetInfo(catType, objID, collectionName, recordsWanted);
    }

    SRBMetaDataRecordList[] srbGetDataDirInfo(int catType, MetaDataCondition[] conditions, MetaDataSelect[] selects, int recordsWanted, boolean orderBy, boolean nonDistinct) throws IOException {
        if (recordsWanted < 1) {
            recordsWanted = DEFAULT_RECORDS_WANTED;
        }
        return this.commands.srbGetDataDirInfo(catType, conditions, selects, recordsWanted, orderBy, nonDistinct);
    }

    SRBMetaDataRecordList[] srbGenQuery(int catType, String myMcatZone, MetaDataCondition[] conditions, MetaDataSelect[] selects, int recordsWanted, boolean orderBy, boolean nonDistinct) throws IOException {
        if (recordsWanted < 1) {
            recordsWanted = DEFAULT_RECORDS_WANTED;
        }
        SRBMetaDataRecordList[] rl = this.commands.srbGenQuery(catType, myMcatZone, conditions, selects, recordsWanted, orderBy, nonDistinct);
        return rl;
    }

    void srbRegisterDataset(int catType, String objID, String dataTypeName, String resourceName, String collectionName, String pathName, long dataSize) throws IOException {
        if (dataTypeName == null) {
            dataTypeName = "generic";
        }
        if (resourceName == null) {
            resourceName = this.getDefaultStorageResource();
        }
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + collectionName;
        }
        this.commands.srbRegisterDataset(catType, objID, dataTypeName, resourceName, collectionName, pathName, dataSize);
    }

    int srbModifyDataset(int catType, String objID, String collectionName, String resourceName, String pathName, String dataValue1, String dataValue2, int actionType) throws IOException {
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + collectionName;
        }
        if (pathName != null || resourceName != null) {
            if (resourceName == null) {
                resourceName = this.getDefaultStorageResource();
            } else if (pathName == null) {
                MetaDataCondition[] conditions = new MetaDataCondition[]{MetaDataSet.newCondition("file name", 0, objID), MetaDataSet.newCondition("directory name", 0, collectionName)};
                MetaDataSelect[] selects = new MetaDataSelect[]{MetaDataSet.newSelection("path name")};
                MetaDataRecordList[] rl = this.query(conditions, selects, 3);
                pathName = rl[0].getValue("path name").toString();
            }
        }
        return this.commands.srbModifyDataset(catType, objID, collectionName, resourceName, pathName, dataValue1, dataValue2, actionType);
    }

    void srbChkMdasAuth(String userName, String srbAuth, String mdasDomain) throws IOException {
        if (userName == null || srbAuth == null) {
            throw new NullPointerException("Null value entered for Mdas authorization");
        }
        if (mdasDomain == null) {
            mdasDomain = this.getDomainName();
        }
        this.commands.srbChkMdasAuth(userName, srbAuth, mdasDomain);
    }

    void srbCreateCollect(int catType, String parentCollection, String newCollection) throws IOException {
        if (parentCollection == null) {
            parentCollection = this.getHomeDirectory();
        } else if (!parentCollection.startsWith(SRB_ROOT)) {
            parentCollection = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + parentCollection;
        }
        this.commands.srbCreateCollect(catType, parentCollection, newCollection);
    }

    SRBMetaDataRecordList[] srbListCollect(int catType, String collectionName, String flag, int recordsWanted) throws IOException {
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + collectionName;
        }
        if (recordsWanted < 1) {
            recordsWanted = DEFAULT_RECORDS_WANTED;
        }
        return this.commands.srbListCollect(catType, collectionName, flag, recordsWanted);
    }

    void srbModifyCollect(int catType, String collectionName, String dataValue1, String dataValue2, String dataValue3, int actionType) throws IOException {
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + collectionName;
        }
        this.commands.srbModifyCollect(catType, collectionName, dataValue1, dataValue2, dataValue3, actionType);
    }

    void srbChkMdasSysAuth(String userName, String srbAuth, String mdasDomain) throws IOException {
        this.commands.srbChkMdasSysAuth(userName, srbAuth, mdasDomain);
    }

    public void srbRegisterUserGrp(int catType, String userGrpName, String userGrpPasswd, String userGrpType, String userGrpAddress, String userGrpPhone, String userGrpEmail) throws IOException {
        this.commands.srbRegisterUserGrp(catType, userGrpName, userGrpPasswd, userGrpType, userGrpAddress, userGrpPhone, userGrpEmail);
    }

    public void srbRegisterUser(int catType, String userName, String userDomain, String userPasswd, String userType, String userAddress, String userPhone, String userEmail) throws IOException {
        this.commands.srbRegisterUser(catType, userName, userDomain, userPasswd, userType, userAddress, userPhone, userEmail);
    }

    public void srbModifyUser(int catType, String dataValue1, String dataValue2, int actionType) throws IOException {
        if (catType < 0) {
            catType = 0;
        }
        this.commands.srbModifyUser(catType, dataValue1, dataValue2, actionType);
    }

    int srbSetAuditTrail(int set_value) throws IOException {
        return this.commands.srbSetAuditTrail(set_value);
    }

    void srbObjAudit(int catType, String userName, String objID, String collectionName, String dataPath, String resourceName, String accessMode, String comment, int success, String domainName) throws IOException {
        if (resourceName == null) {
            resourceName = this.getDefaultStorageResource();
        }
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + collectionName;
        }
        this.commands.srbObjAudit(catType, userName, objID, collectionName, dataPath, resourceName, accessMode, comment, success, domainName);
    }

    void srbRegisterReplica(int catType, String objID, String collectionName, String origResourceName, String origPathName, String newResourceName, String newPathName, String userName, String domainName) throws IOException {
        if (origResourceName == null) {
            origResourceName = this.getDefaultStorageResource();
        }
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + collectionName;
        }
        this.commands.srbRegisterReplica(catType, objID, collectionName, origResourceName, origPathName, newResourceName, newPathName, userName, domainName);
    }

    SRBMetaDataRecordList[] srbGetPrivUsers(int catalog, int recordsWanted) throws IOException {
        if (recordsWanted < 1) {
            recordsWanted = DEFAULT_RECORDS_WANTED;
        }
        return this.commands.srbGetPrivUsers(catalog, recordsWanted);
    }

    SRBMetaDataRecordList[] srbGetMoreRows(int catalog, int contDesc, int recordsWanted) throws IOException {
        if (recordsWanted < 1) {
            recordsWanted = DEFAULT_RECORDS_WANTED;
        }
        return this.commands.srbGetMoreRows(catalog, contDesc, recordsWanted);
    }

    void srbIssueTicket(String objID, String collectionName, String collectionFlag, String beginTime, String endTime, int accessCnt, String ticketUser) throws IOException {
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + collectionName;
        }
        this.commands.srbIssueTicket(objID, collectionName, collectionFlag, beginTime, endTime, accessCnt, ticketUser);
    }

    void srbRemoveTicket(String ticket) throws IOException {
        this.commands.srbRemoveTicket(ticket);
    }

    void srbUnregisterDataset(String objID, String collectionName) throws IOException {
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + collectionName;
        }
        this.commands.srbUnregisterDataset(objID, collectionName);
    }

    void srbContainerCreate(int catType, String containerName, String containerType, String resourceName, long containerSize) throws IOException {
        if (resourceName == null) {
            resourceName = this.getDefaultStorageResource();
        }
        this.commands.srbContainerCreate(catType, containerName, containerType, resourceName, containerSize);
    }

    void srbRegisterContainer(int catType, String containerName, String resourceName, long containerSize) throws IOException {
        if (resourceName == null) {
            resourceName = this.getDefaultStorageResource();
        }
        this.commands.srbRegisterContainer(catType, containerName, resourceName, containerSize);
    }

    void srbRegisterInContDataset(int catType, String objID, String collectionName, String containerName, String dataTypeName, long dataSize, long baseOffset) throws IOException {
        if (dataTypeName == null) {
            dataTypeName = "generic";
        }
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + collectionName;
        }
        this.commands.srbRegisterInContDataset(catType, objID, collectionName, containerName, dataTypeName, dataSize, baseOffset);
    }

    SRBMetaDataRecordList[] srbGetContainerInfo(int catType, String containerName, int recordsWanted) throws IOException {
        if (recordsWanted < 1) {
            recordsWanted = DEFAULT_RECORDS_WANTED;
        }
        return this.commands.srbGetContainerInfo(catType, containerName, recordsWanted);
    }

    String srbGetResOnChoice(int catType, String logResName, String phyResName, String inputFlag) throws IOException {
        return this.commands.srbGetResOnChoice(catType, logResName, phyResName, inputFlag);
    }

    void srbRmContainer(int catType, String containerName, boolean force) throws IOException {
        this.commands.srbRmContainer(catType, containerName, force);
    }

    void srbSyncContainer(int catType, String containerName, int syncFlag) throws IOException {
        this.commands.srbSyncContainer(catType, containerName, syncFlag);
    }

    void srbReplContainer(int catType, String containerName, String newResourceName) throws IOException {
        if (newResourceName == null) {
            newResourceName = this.getDefaultStorageResource();
        }
        this.commands.srbReplContainer(catType, containerName, newResourceName);
    }

    int srbObjOpenWithTicket(String objID, int oflag, String collectionName, String ticket) throws IOException {
        return 0;
    }

    String[] srbTapelibMntCart(String tapeNum, int priority) throws IOException {
        return this.commands.srbTapelibMntCart(tapeNum, priority);
    }

    void srbTapelibDismntCart(String tapeNum) throws IOException {
        this.commands.srbTapelibDismntCart(tapeNum);
    }

    void srbRegInternalCompObj(String objName, String objCollName, int objReplNum, int objSegNum, String intObjRescName, String dataPathName, long dataSize, long offset, int inpIntReplNum, int intSegNum, int objTypeInx, String phyResLoc) throws IOException {
        this.commands.srbRegInternalCompObj(objName, objCollName, objReplNum, objSegNum, intObjRescName, dataPathName, dataSize, offset, inpIntReplNum, intSegNum, objTypeInx, phyResLoc);
    }

    void srbRmIntCompObj(String objName, String objCollName, int objReplNum, int objSegNum, int inpIntReplNum, int intSegNum) throws IOException {
        this.commands.srbRmIntCompObj(objName, objCollName, objReplNum, objSegNum, inpIntReplNum, intSegNum);
    }

    void srbRmCompObj(String objName, String objCollName, int objReplNum, int objSegNum) throws IOException {
        this.commands.srbRmCompObj(objName, objCollName, objReplNum, objSegNum);
    }

    void srbModInternalCompObj(String objID, String collectionName, int objReplNum, int objSegNum, int inpIntReplNum, int intSegNum, String data_value_1, String data_value_2, String data_value_3, String data_value_4, int retraction_type) throws IOException {
        this.commands.srbModInternalCompObj(objID, collectionName, objReplNum, objSegNum, inpIntReplNum, intSegNum, data_value_1, data_value_2, data_value_3, data_value_4, retraction_type);
    }

    public void srbModifyRescInfo(int catType, String resourceName, int actionType, String dataValue1, String dataValue2, String dataValue3, String dataValue4) throws IOException {
        this.commands.srbModifyRescInfo(catType, resourceName, actionType, dataValue1, dataValue2, dataValue3, dataValue4);
    }

    public void srbRegisterLocation(String locName, String fullAddr, String parentLoc, String serverUser, String serverUserDomain) throws IOException {
        this.commands.srbRegisterLocation(locName, fullAddr, parentLoc, serverUser, serverUserDomain);
    }

    public void srbIngestToken(String typeName, String newValue, String parentValue) throws IOException {
        this.commands.srbIngestToken(typeName, newValue, parentValue);
    }

    public void srbRegisterResource(String rescName, String rescType, String location, String phyPath, String className, int size) throws IOException {
        this.commands.srbRegisterResource(rescName, rescType, location, phyPath, className, size);
    }

    public void srbRegisterLogicalResource(String rescName, String rescType, String phyResc, String phyPath) throws IOException {
        this.commands.srbRegisterLogicalResource(rescName, rescType, phyResc, phyPath);
    }

    public void srbRegisterReplicateResourceInfo(String physicalRescName, String rescType, String oldLogicalRescName, String inDefaultPath) throws IOException {
        this.commands.srbRegisterReplicateResourceInfo(physicalRescName, rescType, oldLogicalRescName, inDefaultPath);
    }

    public void srbDeleteValue(int valueType, String deleteValue) throws IOException {
        this.commands.srbDeleteValue(valueType, deleteValue);
    }

    InputStream srbExecCommand(String command, String commandArgs, String hostAddress, int portalFlag) throws IOException {
        if (command == null) {
            throw new NullPointerException("No command given");
        }
        if (portalFlag < 0 || portalFlag > 2) {
            portalFlag = 2;
        }
        return this.commands.srbExecCommand(command, commandArgs, hostAddress, portalFlag, this.MIN_PORT, this.MAX_PORT);
    }

    InputStream srbExecCommand(String command, String commandArgs, String hostAddress, String fileName, int portalFlag) throws IOException {
        if (command == null) {
            throw new NullPointerException("No command given");
        }
        if (fileName != null && hostAddress != null) {
            hostAddress = null;
        }
        if (portalFlag < 0 || portalFlag > 2) {
            portalFlag = 2;
        }
        return this.commands.srbExecCommand(command, commandArgs, hostAddress, fileName, portalFlag, this.MIN_PORT, this.MAX_PORT);
    }

    long srbObjPut(String destObjID, String destCollection, String destResLoc, String dataType, String destPath, String locFilePath, long size) throws IOException {
        if (destResLoc == null) {
            destResLoc = this.getDefaultStorageResource();
        }
        if (dataType == null) {
            dataType = "generic";
        }
        if (destPath == null) {
            destPath = "";
        }
        return this.commands.srbObjPut(destObjID, destCollection, destResLoc, dataType, destPath, locFilePath, size, this.MIN_PORT, this.MAX_PORT);
    }

    long srbObjPutClientInitiated(String destObjID, String destCollection, String destResLoc, String dataType, String destPath, String localFilePath, long srcSize, int forceFlag, int numThreads) throws IOException {
        if (destResLoc == null) {
            destResLoc = this.getDefaultStorageResource();
        }
        if (dataType == null) {
            dataType = "generic";
        }
        if (destPath == null) {
            destPath = "";
        }
        return this.commands.srbObjPutClientInitiated(destObjID, destCollection, destResLoc, dataType, destPath, localFilePath, srcSize, forceFlag, numThreads);
    }

    long srbObjGet(String srcObjID, String srcCollection, long srcSize, GeneralFile file, boolean forceOverwrite) throws IOException {
        if (srcObjID == null || srcCollection == null || file == null) {
            throw new NullPointerException();
        }
        return this.commands.srbObjGet(srcObjID, srcCollection, srcSize, file, this.MIN_PORT, this.MAX_PORT, forceOverwrite);
    }

    synchronized long srbObjGetClientInitiated(String srcObjID, String srcCollection, GeneralFile file, int flag, int numThreads) throws IOException {
        if (srcObjID == null || srcCollection == null || file == null) {
            throw new NullPointerException();
        }
        if (numThreads < 1) {
            numThreads = 1;
        }
        return this.commands.srbObjGetClientInitiated(srcObjID, srcCollection, file, flag, numThreads);
    }

    void srbBulkRegister(int catType, String bulkLoadFilePath, SRBMetaDataRecordList[] rl) throws IOException {
        if (bulkLoadFilePath == null) {
            throw new NullPointerException();
        }
        if (rl == null) {
            throw new NullPointerException();
        }
        this.commands.srbBulkRegister(catType, bulkLoadFilePath, rl);
    }

    void srbGetMcatZone(String userName, String domainName, String mcatName) throws IOException {
        this.commands.srbGetMcatZone(userName, domainName, mcatName);
    }

    void srbSetupSessionPublicKey(String publicKey) throws IOException {
        this.commands.srbSetupSessionPublicKey(publicKey);
    }

    void srbSetupSession(String sessionKey) throws IOException {
        this.commands.srbSetupSession(sessionKey);
    }

    void srbBulkLoad(int catType, String bulkLoadFilePath, SRBMetaDataRecordList[] rl) throws IOException {
        if (bulkLoadFilePath == null) {
            throw new NullPointerException();
        }
        if (rl == null) {
            throw new NullPointerException();
        }
        if (rl.length == 0) {
            return;
        }
        this.commands.srbBulkLoad(catType, bulkLoadFilePath, rl);
    }

    void srbBulkUnload(int catType, int flag, String srbUnloadDirPath, String localDirPath) throws IOException {
        if (srbUnloadDirPath == null) {
            throw new NullPointerException();
        }
        if (localDirPath == null) {
            throw new NullPointerException();
        }
        this.commands.srbBulkUnload(catType, flag, srbUnloadDirPath, localDirPath);
    }

    public void srbModifyZone(int catType, String zoneName, String dataValue1, String dataValue2, String dataValue3, String dataValue4, String dataValue5, int actionType) throws IOException {
        this.commands.srbModifyZone(catType, zoneName, dataValue1, dataValue2, dataValue3, dataValue4, dataValue5, actionType);
    }

    MetaDataRecordList[] srbBulkQueryAnswer(int catType, String queryInfo, MetaDataRecordList myresult, int rowsWanted) throws IOException {
        return this.commands.srbBulkQueryAnswer(catType, queryInfo, myresult, rowsWanted);
    }

    void srbBulkMcatIngest(int catType, String ingestInfo, SRBMetaDataRecordList[] rl) throws IOException {
        this.commands.srbBulkMcatIngest(catType, ingestInfo, rl);
    }

    synchronized void srbBackupData(int catType, String objID, String collectionName, String backupResource, int flag) throws IOException {
        if (collectionName == null) {
            collectionName = this.getHomeDirectory();
        } else if (!collectionName.startsWith(SRB_ROOT)) {
            collectionName = String.valueOf(this.getHomeDirectory()) + SRB_ROOT + collectionName;
        }
        if (backupResource == null) {
            backupResource = this.getDefaultStorageResource();
        }
        this.commands.srbBackupData(catType, objID, collectionName, backupResource, flag);
    }

    byte[] srbObjChksum(String objID, String collectionName, int chksumFlag, String inpChksum) throws IOException {
        return this.commands.srbObjChksum(objID, collectionName, chksumFlag, inpChksum);
    }

    void srbModifyUserNonPriv(int catType, String userNameDomain, String dataValue1, String dataValue2, String dataValue3, String dataValue4, String dataValue5, int actionType) throws IOException {
        this.commands.srbModifyUserNonPriv(catType, userNameDomain, dataValue1, dataValue2, dataValue3, dataValue4, dataValue5, actionType);
    }

    void srbModifyResource(int catType, String resourceName, String dataValue1, String dataValue2, String dataValue3, String dataValue4, int actionType) throws IOException {
        if (resourceName == null) {
            resourceName = this.getDefaultStorageResource();
        }
        this.commands.srbModifyResource(catType, resourceName, dataValue1, dataValue2, dataValue3, dataValue4, actionType);
    }
}

