/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.srb.SRBCommands;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.IOException;

public class SRBMetaDataRecordList
extends MetaDataRecordList {
    private int continuationIndex = -1;
    private SRBCommands fileSystem;

    SRBMetaDataRecordList(MetaDataField[] fields, Object[] recordValues, int continuationIndex, SRBCommands fileSystem) {
        super(fields, recordValues);
        this.continuationIndex = continuationIndex;
        this.fileSystem = fileSystem;
    }

    public SRBMetaDataRecordList(MetaDataField field, int recordValue) {
        super(field, recordValue);
    }

    public SRBMetaDataRecordList(MetaDataField field, float recordValue) {
        super(field, recordValue);
    }

    public SRBMetaDataRecordList(MetaDataField field, String recordValue) {
        super(field, recordValue);
    }

    public SRBMetaDataRecordList(MetaDataField field, MetaDataTable recordValue) {
        super(field, recordValue);
    }

    protected void finalize() {
    }

    boolean combineRecordLists(MetaDataRecordList recordList) {
        if (recordList != null) {
            SRBMetaDataRecordList rl = (SRBMetaDataRecordList)recordList;
            int i = 0;
            while (i < this.fields.length) {
                int j = 0;
                while (j < rl.getFieldCount()) {
                    if (this.fields[i].equals(rl.getField(j)) && (this.records[i] == null || rl.getValue(j) == null ? this.records[i] != rl.getValue(j) : !this.records[i].equals(rl.getValue(j)))) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            int j = 0;
            while (j < rl.getFieldCount()) {
                this.addRecord(rl.getField(j), rl.getValue(j));
                ++j;
            }
            return true;
        }
        return false;
    }

    void setContinuationIndex(int contIndex) {
        this.continuationIndex = contIndex;
    }

    int getContinuationIndex() {
        return this.continuationIndex;
    }

    public boolean isQueryComplete() {
        return this.continuationIndex < 0;
    }

    public MetaDataRecordList[] getMoreResults() throws IOException {
        return this.getMoreResults(SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] getMoreResults(int numOfResults) throws IOException {
        if (this.continuationIndex < 0) {
            return null;
        }
        return this.fileSystem.srbGetMoreRows(0, this.continuationIndex, numOfResults);
    }
}

