/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBCommands;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBRandomAccessFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class SRBShadowFile
extends SRBRandomAccessFile {
    private String shadowPath;
    private int fileType = 0;

    public SRBShadowFile(SRBFile file, String shadowPath) throws IllegalArgumentException, FileNotFoundException, SecurityException, IOException {
        super(file, "r");
        if (shadowPath == null) {
            shadowPath = "";
        }
        this.shadowPath = shadowPath;
        this.open(file);
    }

    public SRBShadowFile(SRBShadowFile parent, String child) throws IllegalArgumentException, FileNotFoundException, SecurityException, IOException {
        super(parent.getSRBFile(), "r");
        if (child == null) {
            parent.getShadowPath();
        } else {
            this.shadowPath = String.valueOf(parent.getShadowPath()) + "/" + child;
        }
        this.open(parent.getSRBFile());
    }

    protected void open(GeneralFile file) throws IOException {
        if (this.shadowPath == null) {
            return;
        }
        this.file = file;
        this.fd = this.fileSystem.srbObjOpen(String.valueOf(file.getName()) + "&SHADOW=" + this.shadowPath, 0, file.getParent());
        this.fileType = 1;
    }

    public SRBFile getSRBFile() {
        if (this.file != null) {
            return (SRBFile)this.file;
        }
        throw new NullPointerException();
    }

    public String getShadowPath() {
        return this.shadowPath;
    }

    public long length() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setLength(long newLength) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        switch (this.rw) {
            case 0: {
                return String.valueOf(this.file.getAbsolutePath()) + "/" + this.shadowPath + " : r";
            }
            case 1: {
                return String.valueOf(this.file.getAbsolutePath()) + "/" + this.shadowPath + " : rw";
            }
            case 2: {
                return String.valueOf(this.file.getAbsolutePath()) + "/" + this.shadowPath + " : rws";
            }
            case 3: {
                return String.valueOf(this.file.getAbsolutePath()) + "/" + this.shadowPath + " : rwd";
            }
        }
        return String.valueOf(this.file.getAbsolutePath()) + "/" + this.shadowPath;
    }

    boolean exists() {
        MetaDataRecordList[] rl = null;
        boolean operator = false;
        if (this.fileType == 2) {
            return true;
        }
        return this.fileType == 1;
    }

    boolean isDirectory() {
        return this.fileType == 2;
    }

    boolean isFile() {
        return this.fileType == 1;
    }

    public String[] list() {
        Vector<String> list;
        block9: {
            list = new Vector<String>();
            String temp = "";
            int index = 0;
            try {
                String physicalPath = ((SRBFile)this.file).getPhysicalPath();
                index = physicalPath.indexOf("/?SHADOW");
                if (index >= 0) {
                    physicalPath = physicalPath.substring(0, index);
                }
                InputStream in = this.fileSystem.executeProxyCommand("ls", String.valueOf(physicalPath) + "/" + this.shadowPath);
                int result = in.read();
                while (result != -1) {
                    if ((char)result == '\n') {
                        index = temp.lastIndexOf("/");
                        if (index >= 0) {
                            temp = temp.substring(index);
                        }
                        list.add(temp);
                        temp = "";
                    } else {
                        temp = String.valueOf(temp) + (char)result;
                    }
                    result = in.read();
                }
            }
            catch (SRBException e) {
                if (SRBCommands.DEBUG > 0) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                if (SRBCommands.DEBUG <= 0) break block9;
                e.printStackTrace();
            }
        }
        return list.toArray(new String[0]);
    }

    public SRBShadowFile[] listFiles() {
        String[] list = this.list();
        int length = list.length;
        SRBShadowFile[] shadows = new SRBShadowFile[length];
        try {
            int i = 0;
            while (i < length) {
                shadows[i] = new SRBShadowFile(this, list[i]);
                ++i;
            }
        }
        catch (IOException e) {
            if (SRBCommands.DEBUG > 0) {
                e.printStackTrace();
            }
            return null;
        }
        return shadows;
    }
}

