/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.config.BeanHandler;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.util.ClassLoaderUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.helpers.DefaultHandler;

public final class ConfigurationFactory {
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$config$ConfigurationFactory == null ? (class$net$sf$ehcache$config$ConfigurationFactory = ConfigurationFactory.class$("net.sf.ehcache.config.ConfigurationFactory")) : class$net$sf$ehcache$config$ConfigurationFactory).getName());
    private static final String DEFAULT_CLASSPATH_CONFIGURATION_FILE = "/ehcache.xml";
    private static final String FAILSAFE_CLASSPATH_CONFIGURATION_FILE = "/ehcache-failsafe.xml";
    static /* synthetic */ Class class$net$sf$ehcache$config$ConfigurationFactory;

    private ConfigurationFactory() {
    }

    public static Configuration parseConfiguration(File file) throws CacheException {
        if (file == null) {
            throw new CacheException("Attempt to configure ehcache from null file.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring ehcache from file: " + file.toString());
        }
        Configuration configuration = null;
        InputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            configuration = ConfigurationFactory.parseConfiguration(input);
        }
        catch (Exception e) {
            throw new CacheException("Error configuring from " + file + ". Initial cause was " + e.getMessage(), e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                LOG.error("IOException while closing configuration input stream. Error was " + e.getMessage());
            }
        }
        return configuration;
    }

    public static Configuration parseConfiguration(URL url) throws CacheException {
        Configuration configuration;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring ehcache from URL: " + url);
        }
        InputStream input = null;
        try {
            input = url.openStream();
            configuration = ConfigurationFactory.parseConfiguration(input);
        }
        catch (Exception e) {
            throw new CacheException("Error configuring from " + url + ". Initial cause was " + e.getMessage(), e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                LOG.error("IOException while closing configuration input stream. Error was " + e.getMessage());
            }
        }
        return configuration;
    }

    public static Configuration parseConfiguration() throws CacheException {
        ClassLoader standardClassloader = ClassLoaderUtil.getStandardClassLoader();
        URL url = null;
        if (standardClassloader != null) {
            url = standardClassloader.getResource(DEFAULT_CLASSPATH_CONFIGURATION_FILE);
        }
        if (url == null) {
            url = (class$net$sf$ehcache$config$ConfigurationFactory == null ? (class$net$sf$ehcache$config$ConfigurationFactory = ConfigurationFactory.class$("net.sf.ehcache.config.ConfigurationFactory")) : class$net$sf$ehcache$config$ConfigurationFactory).getResource(DEFAULT_CLASSPATH_CONFIGURATION_FILE);
        }
        if (url != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Configuring ehcache from ehcache.xml found in the classpath: " + url);
            }
        } else {
            url = (class$net$sf$ehcache$config$ConfigurationFactory == null ? (class$net$sf$ehcache$config$ConfigurationFactory = ConfigurationFactory.class$("net.sf.ehcache.config.ConfigurationFactory")) : class$net$sf$ehcache$config$ConfigurationFactory).getResource(FAILSAFE_CLASSPATH_CONFIGURATION_FILE);
            if (LOG.isWarnEnabled()) {
                LOG.warn("No configuration found. Configuring ehcache from ehcache-failsafe.xml  found in the classpath: " + url);
            }
        }
        return ConfigurationFactory.parseConfiguration(url);
    }

    public static Configuration parseConfiguration(InputStream inputStream) throws CacheException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring ehcache from InputStream");
        }
        Configuration configuration = new Configuration();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            BeanHandler handler = new BeanHandler(configuration);
            parser.parse(inputStream, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new CacheException("Error configuring from input stream. Initial cause was " + e.getMessage(), e);
        }
        return configuration;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

