/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;

public class VFS {
    private static Boolean URI_STYLE = null;
    private static FileSystemManager instance;

    private VFS() {
    }

    public static synchronized FileSystemManager getManager() throws FileSystemException {
        if (instance == null) {
            instance = VFS.createManager("org.apache.commons.vfs.impl.StandardFileSystemManager");
        }
        return instance;
    }

    private static FileSystemManager createManager(String managerClassName) throws FileSystemException {
        try {
            Class<?> mgrClass = Class.forName(managerClassName);
            FileSystemManager mgr = (FileSystemManager)mgrClass.newInstance();
            try {
                Method initMethod = mgrClass.getMethod("init", null);
                initMethod.invoke((Object)mgr, (Object[])null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return mgr;
        }
        catch (InvocationTargetException e) {
            throw new FileSystemException("vfs/create-manager.error", managerClassName, e.getTargetException());
        }
        catch (Exception e) {
            throw new FileSystemException("vfs/create-manager.error", managerClassName, (Throwable)e);
        }
    }

    public static boolean isUriStyle() {
        if (URI_STYLE == null) {
            URI_STYLE = Boolean.FALSE;
        }
        return URI_STYLE;
    }

    public static void setUriStyle(boolean uriStyle) {
        if (URI_STYLE != null && URI_STYLE != uriStyle) {
            throw new IllegalStateException("URI STYLE ALREADY SET TO");
        }
        URI_STYLE = uriStyle ? Boolean.TRUE : Boolean.FALSE;
    }
}

