/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.cache;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.cache.AbstractFilesCache;

public class DefaultFilesCache
extends AbstractFilesCache {
    private final Map filesystemCache = new HashMap(10);

    public void putFile(FileObject file) {
        Map files = this.getOrCreateFilesystemCache(file.getFileSystem());
        files.put(file.getName(), file);
    }

    public FileObject getFile(FileSystem filesystem, FileName name) {
        Map files = this.getOrCreateFilesystemCache(filesystem);
        return (FileObject)files.get(name);
    }

    public void clear(FileSystem filesystem) {
        Map files = this.getOrCreateFilesystemCache(filesystem);
        files.clear();
    }

    protected Map getOrCreateFilesystemCache(FileSystem filesystem) {
        HashMap files = (HashMap)this.filesystemCache.get(filesystem);
        if (files == null) {
            files = new HashMap();
            this.filesystemCache.put(filesystem, files);
        }
        return files;
    }

    public void close() {
        super.close();
        this.filesystemCache.clear();
    }

    public void removeFile(FileSystem filesystem, FileName name) {
        Map files = this.getOrCreateFilesystemCache(filesystem);
        files.remove(name);
    }

    public void touchFile(FileObject file) {
    }
}

