/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;

public class ThreadLocalHttpConnectionManager
implements HttpConnectionManager {
    protected ThreadLocal localHttpConnection = new ThreadLocal(){

        protected Object initialValue() {
            return new Entry();
        }
    };
    private ConnectionParameters params = new ConnectionParameters();

    static void finishLastResponse(HttpConnection conn) {
        InputStream lastResponse = conn.getLastResponseInputStream();
        if (lastResponse != null) {
            conn.setLastResponseInputStream(null);
            try {
                lastResponse.close();
            }
            catch (IOException ioe) {
                conn.close();
            }
        }
    }

    public void releaseLocalConnection() {
        if (this.getLocalHttpConnection() != null) {
            this.releaseConnection(this.getLocalHttpConnection());
        }
    }

    protected HttpConnection getLocalHttpConnection() {
        return ((Entry)this.localHttpConnection.get()).conn;
    }

    protected void setLocalHttpConnection(HttpConnection conn) {
        ((Entry)this.localHttpConnection.get()).conn = conn;
    }

    protected long getIdleStartTime() {
        return ((Entry)this.localHttpConnection.get()).idleStartTime;
    }

    protected void setIdleStartTime(long idleStartTime) {
        ((Entry)this.localHttpConnection.get()).idleStartTime = idleStartTime;
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration) {
        return this.getConnection(hostConfiguration, 0L);
    }

    public boolean isConnectionStaleCheckingEnabled() {
        return this.params.isStaleCheckingEnabled();
    }

    public void setConnectionStaleCheckingEnabled(boolean connectionStaleCheckingEnabled) {
        this.params.setStaleCheckingEnabled(connectionStaleCheckingEnabled);
    }

    public HttpConnection getConnectionWithTimeout(HostConfiguration hostConfiguration, long timeout) {
        HttpConnection httpConnection = this.getLocalHttpConnection();
        if (httpConnection == null) {
            httpConnection = new HttpConnection(hostConfiguration);
            this.setLocalHttpConnection(httpConnection);
            httpConnection.setHttpConnectionManager(this);
            this.params.populateParameters(httpConnection);
        } else if (!hostConfiguration.hostEquals(httpConnection) || !hostConfiguration.proxyEquals(httpConnection)) {
            if (httpConnection.isOpen()) {
                httpConnection.close();
            }
            httpConnection.setHost(hostConfiguration.getHost());
            httpConnection.setPort(hostConfiguration.getPort());
            httpConnection.setProtocol(hostConfiguration.getProtocol());
            httpConnection.setLocalAddress(hostConfiguration.getLocalAddress());
            httpConnection.setProxyHost(hostConfiguration.getProxyHost());
            httpConnection.setProxyPort(hostConfiguration.getProxyPort());
        } else {
            ThreadLocalHttpConnectionManager.finishLastResponse(httpConnection);
        }
        this.setIdleStartTime(Long.MAX_VALUE);
        return httpConnection;
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration, long timeout) {
        return this.getConnectionWithTimeout(hostConfiguration, timeout);
    }

    public void releaseConnection(HttpConnection conn) {
        if (conn != this.getLocalHttpConnection()) {
            throw new IllegalStateException("Unexpected release of an unknown connection.");
        }
        ThreadLocalHttpConnectionManager.finishLastResponse(this.getLocalHttpConnection());
        this.setIdleStartTime(System.currentTimeMillis());
    }

    public void closeIdleConnections(long idleTimeout) {
        long maxIdleTime = System.currentTimeMillis() - idleTimeout;
        if (this.getIdleStartTime() <= maxIdleTime) {
            this.getLocalHttpConnection().close();
        }
    }

    private static class Entry {
        private HttpConnection conn = null;
        private long idleStartTime = Long.MAX_VALUE;

        private Entry() {
        }
    }

    private static class ConnectionParameters {
        private boolean staleCheck;

        private ConnectionParameters() {
        }

        public boolean isStaleCheckingEnabled() {
            return this.staleCheck;
        }

        public void setStaleCheckingEnabled(boolean b) {
            this.staleCheck = b;
        }

        public void populateParameters(HttpConnection connection) {
            connection.setStaleCheckingEnabled(this.staleCheck);
        }
    }
}

