/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.ShExLockable;
import org.apache.derby.iapi.services.locks.ShExQual;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubCheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.ScanQualifier;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.catalog.DD_Version;
import org.apache.derby.impl.sql.catalog.DropDependencyFilter;
import org.apache.derby.impl.sql.catalog.NameTDCacheable;
import org.apache.derby.impl.sql.catalog.OIDTDCacheable;
import org.apache.derby.impl.sql.catalog.PermissionsCacheable;
import org.apache.derby.impl.sql.catalog.PermissionsCatalogRowFactory;
import org.apache.derby.impl.sql.catalog.SPSNameCacheable;
import org.apache.derby.impl.sql.catalog.SYSALIASESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCHECKSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCOLPERMSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCOLUMNSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCONGLOMERATESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCONSTRAINTSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSDEPENDSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSDUMMY1RowFactory;
import org.apache.derby.impl.sql.catalog.SYSFILESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSFOREIGNKEYSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSKEYSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSROUTINEPERMSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSSCHEMASRowFactory;
import org.apache.derby.impl.sql.catalog.SYSSTATEMENTSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSSTATISTICSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSTABLEPERMSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSTABLESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSTRIGGERSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSVIEWSRowFactory;
import org.apache.derby.impl.sql.catalog.TDCacheable;
import org.apache.derby.impl.sql.catalog.TabInfoImpl;
import org.apache.derby.impl.sql.catalog.TableKey;
import org.apache.derby.impl.sql.depend.BasicDependencyManager;

public final class DataDictionaryImpl
implements DataDictionary,
CacheableFactory,
ModuleControl,
ModuleSupportable,
PrivilegedAction {
    private static final String CFG_SYSTABLES_ID = "SystablesIdentifier";
    private static final String CFG_SYSTABLES_INDEX1_ID = "SystablesIndex1Identifier";
    private static final String CFG_SYSTABLES_INDEX2_ID = "SystablesIndex2Identifier";
    private static final String CFG_SYSCOLUMNS_ID = "SyscolumnsIdentifier";
    private static final String CFG_SYSCOLUMNS_INDEX1_ID = "SyscolumnsIndex1Identifier";
    private static final String CFG_SYSCOLUMNS_INDEX2_ID = "SyscolumnsIndex2Identifier";
    private static final String CFG_SYSCONGLOMERATES_ID = "SysconglomeratesIdentifier";
    private static final String CFG_SYSCONGLOMERATES_INDEX1_ID = "SysconglomeratesIndex1Identifier";
    private static final String CFG_SYSCONGLOMERATES_INDEX2_ID = "SysconglomeratesIndex2Identifier";
    private static final String CFG_SYSCONGLOMERATES_INDEX3_ID = "SysconglomeratesIndex3Identifier";
    private static final String CFG_SYSSCHEMAS_ID = "SysschemasIdentifier";
    private static final String CFG_SYSSCHEMAS_INDEX1_ID = "SysschemasIndex1Identifier";
    private static final String CFG_SYSSCHEMAS_INDEX2_ID = "SysschemasIndex2Identifier";
    private static final int SYSCONGLOMERATES_CORE_NUM = 0;
    private static final int SYSTABLES_CORE_NUM = 1;
    private static final int SYSCOLUMNS_CORE_NUM = 2;
    private static final int SYSSCHEMAS_CORE_NUM = 3;
    private static final int NUM_CORE = 4;
    private static final String[][] SYSFUN_FUNCTIONS = new String[][]{{"ACOS", "DOUBLE", "java.lang.StrictMath", "acos(double)", "DOUBLE"}, {"ASIN", "DOUBLE", "java.lang.StrictMath", "asin(double)", "DOUBLE"}, {"ATAN", "DOUBLE", "java.lang.StrictMath", "atan(double)", "DOUBLE"}, {"COS", "DOUBLE", "java.lang.StrictMath", "cos(double)", "DOUBLE"}, {"SIN", "DOUBLE", "java.lang.StrictMath", "sin(double)", "DOUBLE"}, {"TAN", "DOUBLE", "java.lang.StrictMath", "tan(double)", "DOUBLE"}, {"PI", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "PI()", null}, {"DEGREES", "DOUBLE", "java.lang.StrictMath", "toDegrees(double)", "DOUBLE"}, {"RADIANS", "DOUBLE", "java.lang.StrictMath", "toRadians(double)", "DOUBLE"}, {"LN", "DOUBLE", "java.lang.StrictMath", "log(double)", "DOUBLE"}, {"LOG", "DOUBLE", "java.lang.StrictMath", "log(double)", "DOUBLE"}, {"LOG10", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "LOG10(double)", "DOUBLE"}, {"EXP", "DOUBLE", "java.lang.StrictMath", "exp(double)", "DOUBLE"}, {"CEIL", "DOUBLE", "java.lang.StrictMath", "ceil(double)", "DOUBLE"}, {"CEILING", "DOUBLE", "java.lang.StrictMath", "ceil(double)", "DOUBLE"}, {"FLOOR", "DOUBLE", "java.lang.StrictMath", "floor(double)", "DOUBLE"}, {"SIGN", "INTEGER", "org.apache.derby.catalog.SystemProcedures", "SIGN(double)", "DOUBLE"}, {"RANDOM", "DOUBLE", "java.lang.StrictMath", "random()", null}, {"RAND", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "RAND(int)", "INTEGER"}, {"COT", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "COT(double)", "DOUBLE"}, {"COSH", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "COSH(double)", "DOUBLE"}, {"SINH", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "SINH(double)", "DOUBLE"}, {"TANH", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "TANH(double)", "DOUBLE"}};
    private static final AliasDescriptor[] SYSFUN_AD = new AliasDescriptor[SYSFUN_FUNCTIONS.length];
    private static final String[] SYSFUN_PNAME = new String[]{"P1"};
    private static final int[] SYSFUN_PMODE = new int[]{1};
    private TabInfoImpl[] coreInfo;
    private SchemaDescriptor systemSchemaDesc;
    private SchemaDescriptor sysIBMSchemaDesc;
    private SchemaDescriptor declaredGlobalTemporaryTablesSchemaDesc;
    private SchemaDescriptor systemUtilSchemaDesc;
    protected boolean convertIdToLower;
    private static final String[] nonCoreNames = new String[]{"SYSCONSTRAINTS", "SYSKEYS", "SYSDEPENDS", "SYSALIASES", "SYSVIEWS", "SYSCHECKS", "SYSFOREIGNKEYS", "SYSSTATEMENTS", "SYSFILES", "SYSTRIGGERS", "SYSSTATISTICS", "SYSDUMMY1", "SYSTABLEPERMS", "SYSCOLPERMS", "SYSROUTINEPERMS"};
    private static final int NUM_NONCORE = nonCoreNames.length;
    private static final String[] systemSchemaNames = new String[]{"SYSCAT", "SYSFUN", "SYSPROC", "SYSSTAT", "NULLID", "SYSCS_DIAG", "SYSCS_UTIL", "SYSIBM", "SQLJ", "SYS"};
    private DD_Version dictionaryVersion;
    private DD_Version softwareVersion;
    private String authorizationDatabaseOwner;
    private boolean usesSqlAuthorization;
    private TabInfoImpl[] noncoreInfo;
    public DataDescriptorGenerator dataDescriptorGenerator;
    private DataValueFactory dvf;
    AccessFactory af;
    private ExecutionFactory exFactory;
    protected UUIDFactory uuidFactory;
    Properties startupParameters;
    int engineType;
    protected boolean booting;
    private TransactionController bootingTC;
    protected DependencyManager dmgr;
    CacheManager OIDTdCache;
    CacheManager nameTdCache;
    private CacheManager spsNameCache;
    private Hashtable spsIdHash;
    int tdCacheSize;
    int stmtCacheSize;
    CacheManager permissionsCache;
    int permissionsCacheSize;
    ShExLockable cacheCoordinator;
    public LockFactory lockFactory;
    volatile int cacheMode = 0;
    volatile int ddlUsers;
    volatile int readersInDDLMode;
    public boolean readOnlyUpgrade;
    private int systemSQLNameNumber;
    private GregorianCalendar calendarForLastSystemSQLName = new GregorianCalendar();
    private long timeForLastSystemSQLName;
    private static final String[] sysUtilProceduresWithPublicAccess = new String[]{"SYSCS_SET_RUNTIMESTATISTICS", "SYSCS_SET_STATISTICS_TIMING", "SYSCS_INPLACE_COMPRESS_TABLE", "SYSCS_COMPRESS_TABLE"};
    private static final String[] sysUtilFunctionsWithPublicAccess = new String[]{"SYSCS_GET_RUNTIMESTATISTICS"};
    private int collationTypeOfSystemSchemas;
    private int collationTypeOfUserSchemas;
    private String spsSet;
    private static final String[] colPrivTypeMap = new String[7];
    private static final String[] colPrivTypeMapForGrant = new String[7];
    private String[][] DIAG_VTI_TABLE_CLASSES = new String[][]{{"LOCK_TABLE", "org.apache.derby.diag.LockTable"}, {"STATEMENT_CACHE", "org.apache.derby.diag.StatementCache"}, {"TRANSACTION_TABLE", "org.apache.derby.diag.TransactionTable"}, {"ERROR_MESSAGES", "org.apache.derby.diag.ErrorMessages"}};
    private String[][] DIAG_VTI_TABLE_FUNCTION_CLASSES = new String[][]{{"SPACE_TABLE", "org.apache.derby.diag.SpaceTable"}, {"ERROR_LOG_READER", "org.apache.derby.diag.ErrorLogReader"}, {"STATEMENT_DURATION", "org.apache.derby.diag.StatementDuration"}};

    public boolean canSupport(Properties properties) {
        return Monitor.isDesiredType(properties, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot(boolean bl, Properties properties) throws StandardException {
        this.softwareVersion = new DD_Version(this, 150);
        this.convertIdToLower = false;
        this.startupParameters = properties;
        this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.engineType = Monitor.getEngineType(properties);
        this.collationTypeOfSystemSchemas = 0;
        this.getBuiltinSystemSchemas();
        LanguageConnectionFactory languageConnectionFactory = (LanguageConnectionFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.conn.LanguageConnectionFactory", properties);
        this.dvf = languageConnectionFactory.getDataValueFactory();
        this.exFactory = (ExecutionFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.execute.ExecutionFactory", properties);
        this.initializeCatalogInfo();
        this.booting = true;
        if (this.dataDescriptorGenerator == null) {
            this.dataDescriptorGenerator = new DataDescriptorGenerator(this);
        }
        if (!bl) {
            this.coreInfo[1].setHeapConglomerate(this.getBootParameter(properties, CFG_SYSTABLES_ID, true));
            this.coreInfo[1].setIndexConglomerate(0, this.getBootParameter(properties, CFG_SYSTABLES_INDEX1_ID, true));
            this.coreInfo[1].setIndexConglomerate(1, this.getBootParameter(properties, CFG_SYSTABLES_INDEX2_ID, true));
            this.coreInfo[2].setHeapConglomerate(this.getBootParameter(properties, CFG_SYSCOLUMNS_ID, true));
            this.coreInfo[2].setIndexConglomerate(0, this.getBootParameter(properties, CFG_SYSCOLUMNS_INDEX1_ID, true));
            this.coreInfo[2].setIndexConglomerate(1, this.getBootParameter(properties, CFG_SYSCOLUMNS_INDEX2_ID, false));
            this.coreInfo[0].setHeapConglomerate(this.getBootParameter(properties, CFG_SYSCONGLOMERATES_ID, true));
            this.coreInfo[0].setIndexConglomerate(0, this.getBootParameter(properties, CFG_SYSCONGLOMERATES_INDEX1_ID, true));
            this.coreInfo[0].setIndexConglomerate(1, this.getBootParameter(properties, CFG_SYSCONGLOMERATES_INDEX2_ID, true));
            this.coreInfo[0].setIndexConglomerate(2, this.getBootParameter(properties, CFG_SYSCONGLOMERATES_INDEX3_ID, true));
            this.coreInfo[3].setHeapConglomerate(this.getBootParameter(properties, CFG_SYSSCHEMAS_ID, true));
            this.coreInfo[3].setIndexConglomerate(0, this.getBootParameter(properties, CFG_SYSSCHEMAS_INDEX1_ID, true));
            this.coreInfo[3].setIndexConglomerate(1, this.getBootParameter(properties, CFG_SYSSCHEMAS_INDEX2_ID, true));
        }
        String string = properties.getProperty("derby.language.tableDescriptorCacheSize");
        this.tdCacheSize = PropertyUtil.intPropertyValue("derby.language.tableDescriptorCacheSize", (Serializable)((Object)string), 0, Integer.MAX_VALUE, 64);
        string = properties.getProperty("derby.language.spsCacheSize");
        this.stmtCacheSize = PropertyUtil.intPropertyValue("derby.language.spsCacheSize", (Serializable)((Object)string), 0, Integer.MAX_VALUE, 32);
        string = properties.getProperty("derby.language.permissionsCacheSize");
        this.permissionsCacheSize = PropertyUtil.intPropertyValue("derby.language.permissionsCacheSize", (Serializable)((Object)string), 0, Integer.MAX_VALUE, 64);
        CacheFactory cacheFactory = (CacheFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
        this.OIDTdCache = cacheFactory.newCacheManager(this, "TableDescriptorOIDCache", this.tdCacheSize, this.tdCacheSize);
        this.nameTdCache = cacheFactory.newCacheManager(this, "TableDescriptorNameCache", this.tdCacheSize, this.tdCacheSize);
        if (this.stmtCacheSize > 0) {
            this.spsNameCache = cacheFactory.newCacheManager(this, "SPSNameDescriptorCache", this.stmtCacheSize, this.stmtCacheSize);
            this.spsIdHash = new Hashtable(this.stmtCacheSize);
        }
        this.cacheCoordinator = new ShExLockable();
        this.af = (AccessFactory)Monitor.findServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        this.lockFactory = this.af.getLockFactory();
        ContextService contextService = ContextService.getFactory();
        ContextManager contextManager = contextService.getCurrentContextManager();
        this.bootingTC = null;
        try {
            String string2;
            this.bootingTC = this.af.getTransaction(contextManager);
            this.exFactory.newExecutionContext(contextManager);
            DataDescriptorGenerator dataDescriptorGenerator = this.getDataDescriptorGenerator();
            if (bl) {
                string2 = properties.getProperty("collation");
                if (string2 == null) {
                    string2 = "UCS_BASIC";
                } else if (!string2.equalsIgnoreCase("UCS_BASIC") && !string2.equalsIgnoreCase("TERRITORY_BASED")) {
                    throw StandardException.newException("XBM03.D", string2);
                }
                this.bootingTC.setProperty("derby.database.collation", (Serializable)((Object)string2), true);
            } else {
                string2 = properties.getProperty("derby.database.collation");
                if (string2 == null) {
                    string2 = "UCS_BASIC";
                }
            }
            this.collationTypeOfUserSchemas = string2.equalsIgnoreCase("UCS_BASIC") ? 0 : 1;
            this.declaredGlobalTemporaryTablesSchemaDesc = this.newDeclaredGlobalTemporaryTablesSchemaDesc("SESSION");
            if (bl) {
                String string3 = IdUtil.getUserNameFromURLProps(properties);
                this.authorizationDatabaseOwner = IdUtil.getUserAuthorizationId(string3);
                this.createDictionaryTables(properties, this.bootingTC, dataDescriptorGenerator);
                this.create_SYSIBM_procedures(this.bootingTC);
                this.createSystemSps(this.bootingTC);
                this.create_SYSCS_procedures(this.bootingTC);
                this.dictionaryVersion = this.softwareVersion;
                this.bootingTC.setProperty("DataDictionaryVersion", this.dictionaryVersion, true);
                this.bootingTC.setProperty("CreateDataDictionaryVersion", this.dictionaryVersion, true);
                if (PropertyUtil.getSystemBoolean("derby.database.sqlAuthorization")) {
                    this.bootingTC.setProperty("derby.database.sqlAuthorization", (Serializable)((Object)"true"), true);
                    this.usesSqlAuthorization = true;
                }
            } else {
                this.loadDictionaryTables(this.bootingTC, dataDescriptorGenerator, properties);
                SchemaDescriptor schemaDescriptor = this.locateSchemaRow("SYSIBM", this.bootingTC);
                this.authorizationDatabaseOwner = schemaDescriptor.getAuthorizationId();
                String string4 = PropertyUtil.getDatabaseProperty(this.bootingTC, "derby.database.sqlAuthorization");
                if (Boolean.valueOf(properties.getProperty("softUpgradeNoFeatureCheck")).booleanValue()) {
                    if (this.dictionaryVersion.majorVersionNumber >= 140) {
                        this.usesSqlAuthorization = Boolean.valueOf(string4);
                    }
                } else if (Boolean.valueOf(string4).booleanValue()) {
                    this.checkVersion(140, "sqlAuthorization");
                    this.usesSqlAuthorization = true;
                }
            }
            this.bootingTC.commit();
            contextManager.getContext("ExecutionContext").popMe();
            Object var13_13 = null;
            if (this.bootingTC != null) {
                this.bootingTC.destroy();
                this.bootingTC = null;
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (this.bootingTC != null) {
                this.bootingTC.destroy();
                this.bootingTC = null;
            }
            throw throwable;
        }
        this.setDependencyManager();
        this.booting = false;
    }

    private CacheManager getPermissionsCache() throws StandardException {
        if (this.permissionsCache == null) {
            CacheFactory cacheFactory = (CacheFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
            LanguageConnectionContext languageConnectionContext = DataDictionaryImpl.getLCC();
            TransactionController transactionController = languageConnectionContext.getTransactionExecute();
            this.permissionsCacheSize = PropertyUtil.getServiceInt(transactionController, "derby.language.permissionsCacheSize", 40, Integer.MAX_VALUE, this.permissionsCacheSize);
            this.permissionsCache = cacheFactory.newCacheManager(this, "PermissionsCache", this.permissionsCacheSize, this.permissionsCacheSize);
        }
        return this.permissionsCache;
    }

    protected void setDependencyManager() {
        this.dmgr = new BasicDependencyManager(this);
    }

    public DependencyManager getDependencyManager() {
        return this.dmgr;
    }

    public void stop() {
    }

    public Cacheable newCacheable(CacheManager cacheManager) {
        if (cacheManager == this.OIDTdCache) {
            return new OIDTDCacheable(this);
        }
        if (cacheManager == this.nameTdCache) {
            return new NameTDCacheable(this);
        }
        if (cacheManager == this.permissionsCache) {
            return new PermissionsCacheable(this);
        }
        return new SPSNameCacheable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startReading(LanguageConnectionContext languageConnectionContext) throws StandardException {
        int n;
        int n2 = languageConnectionContext.incrementBindCount();
        boolean bl = false;
        do {
            if (bl) {
                try {
                    this.lockFactory.zeroDurationlockObject(languageConnectionContext.getTransactionExecute().getLockSpace(), this.cacheCoordinator, ShExQual.SH, -1);
                }
                catch (StandardException standardException) {
                    languageConnectionContext.decrementBindCount();
                    throw standardException;
                }
                bl = false;
            }
            DataDictionaryImpl dataDictionaryImpl = this;
            synchronized (dataDictionaryImpl) {
                n = this.getCacheMode();
                if (n2 == 1) {
                    if (n == 0) {
                        boolean bl2 = false;
                        try {
                            CompatibilitySpace compatibilitySpace = languageConnectionContext.getTransactionExecute().getLockSpace();
                            bl2 = this.lockFactory.lockObject(compatibilitySpace, compatibilitySpace.getOwner(), this.cacheCoordinator, ShExQual.SH, 0);
                        }
                        catch (StandardException standardException) {
                            languageConnectionContext.decrementBindCount();
                            throw standardException;
                        }
                        if (!bl2) {
                            bl = true;
                        }
                    } else {
                        ++this.readersInDDLMode;
                    }
                }
            }
        } while (bl);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneReading(int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        int n2 = languageConnectionContext.decrementBindCount();
        DataDictionaryImpl dataDictionaryImpl = this;
        synchronized (dataDictionaryImpl) {
            if (n2 == 0) {
                if (n == 0) {
                    if (languageConnectionContext.getStatementContext() != null && languageConnectionContext.getStatementContext().inUse()) {
                        CompatibilitySpace compatibilitySpace = languageConnectionContext.getTransactionExecute().getLockSpace();
                        int n3 = this.lockFactory.unlock(compatibilitySpace, compatibilitySpace.getOwner(), this.cacheCoordinator, ShExQual.SH);
                    }
                } else {
                    --this.readersInDDLMode;
                    if (this.ddlUsers == 0 && this.readersInDDLMode == 0) {
                        this.clearCaches();
                        this.setCacheMode(0);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWriting(LanguageConnectionContext languageConnectionContext) throws StandardException {
        boolean bl = true;
        if (languageConnectionContext.getBindCount() != 0) {
            throw StandardException.newException("XCL21.S");
        }
        if (!languageConnectionContext.dataDictionaryInWriteMode()) {
            int n = 0;
            while (bl) {
                block12: {
                    if (n > 4 && this.getCacheMode() == 0) {
                        this.lockFactory.zeroDurationlockObject(languageConnectionContext.getTransactionExecute().getLockSpace(), this.cacheCoordinator, ShExQual.EX, -2);
                        n = 1;
                    }
                    if (n > 0) {
                        try {
                            Thread.sleep((long)(Math.random() * 1131.0 % 20.0));
                        }
                        catch (InterruptedException interruptedException) {
                            throw StandardException.interrupt(interruptedException);
                        }
                    }
                    DataDictionaryImpl dataDictionaryImpl = this;
                    synchronized (dataDictionaryImpl) {
                        if (this.getCacheMode() == 0) {
                            boolean bl2 = this.lockFactory.zeroDurationlockObject(languageConnectionContext.getTransactionExecute().getLockSpace(), this.cacheCoordinator, ShExQual.EX, 0);
                            if (!bl2) {
                                break block12;
                            }
                            this.setCacheMode(1);
                            this.clearCaches();
                        }
                        ++this.ddlUsers;
                    }
                    languageConnectionContext.setDataDictionaryWriteMode();
                    bl = false;
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionFinished() throws StandardException {
        DataDictionaryImpl dataDictionaryImpl = this;
        synchronized (dataDictionaryImpl) {
            --this.ddlUsers;
            if (this.ddlUsers == 0 && this.readersInDDLMode == 0) {
                this.clearCaches();
                this.setCacheMode(0);
            }
        }
    }

    public int getCacheMode() {
        return this.cacheMode;
    }

    private void setCacheMode(int n) {
        this.cacheMode = n;
    }

    public DataDescriptorGenerator getDataDescriptorGenerator() {
        return this.dataDescriptorGenerator;
    }

    public String getAuthorizationDatabaseOwner() {
        return this.authorizationDatabaseOwner;
    }

    public boolean usesSqlAuthorization() {
        return this.usesSqlAuthorization;
    }

    public int getCollationTypeOfSystemSchemas() {
        return this.collationTypeOfSystemSchemas;
    }

    public int getCollationTypeOfUserSchemas() {
        return this.collationTypeOfUserSchemas;
    }

    public DataValueFactory getDataValueFactory() {
        return this.dvf;
    }

    public ExecutionFactory getExecutionFactory() {
        return this.exFactory;
    }

    private void getBuiltinSystemSchemas() {
        if (this.systemSchemaDesc != null) {
            return;
        }
        this.systemSchemaDesc = this.newSystemSchemaDesc("SYS", "8000000d-00d0-fd77-3ed8-000a0a0b1900");
        this.sysIBMSchemaDesc = this.newSystemSchemaDesc("SYSIBM", "c013800d-00f8-5b53-28a9-00000019ed88");
        this.systemUtilSchemaDesc = this.newSystemSchemaDesc("SYSCS_UTIL", "c013800d-00fb-2649-07ec-000000134f30");
    }

    public SchemaDescriptor getSystemSchemaDescriptor() throws StandardException {
        return this.systemSchemaDesc;
    }

    public SchemaDescriptor getSystemUtilSchemaDescriptor() throws StandardException {
        return this.systemUtilSchemaDesc;
    }

    public SchemaDescriptor getSysIBMSchemaDescriptor() throws StandardException {
        return this.sysIBMSchemaDesc;
    }

    public SchemaDescriptor getDeclaredGlobalTemporaryTablesSchemaDescriptor() throws StandardException {
        return this.declaredGlobalTemporaryTablesSchemaDesc;
    }

    public boolean isSystemSchemaName(String string) throws StandardException {
        boolean bl = false;
        int n = systemSchemaNames.length - 1;
        while (n >= 0 && !(bl = systemSchemaNames[n--].equals(string))) {
        }
        return bl;
    }

    public SchemaDescriptor getSchemaDescriptor(String string, TransactionController transactionController, boolean bl) throws StandardException {
        if (transactionController == null) {
            transactionController = this.getTransactionCompile();
        }
        if (this.getSystemSchemaDescriptor().getSchemaName().equals(string)) {
            return this.getSystemSchemaDescriptor();
        }
        if (this.getSysIBMSchemaDescriptor().getSchemaName().equals(string) && this.dictionaryVersion.checkVersion(100, null)) {
            return this.getSysIBMSchemaDescriptor();
        }
        SchemaDescriptor schemaDescriptor = this.locateSchemaRow(string, transactionController);
        if (schemaDescriptor == null && this.getDeclaredGlobalTemporaryTablesSchemaDescriptor().getSchemaName().equals(string)) {
            return this.getDeclaredGlobalTemporaryTablesSchemaDescriptor();
        }
        if (schemaDescriptor == null && bl) {
            throw StandardException.newException("42Y07", string);
        }
        return schemaDescriptor;
    }

    private SchemaDescriptor locateSchemaRow(UUID uUID, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[3];
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return (SchemaDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, false);
    }

    private SchemaDescriptor locateSchemaRow(String string, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[3];
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLVarchar);
        return (SchemaDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, false);
    }

    public SchemaDescriptor getSchemaDescriptor(UUID uUID, TransactionController transactionController) throws StandardException {
        LanguageConnectionContext languageConnectionContext;
        SchemaDescriptor schemaDescriptor = null;
        if (transactionController == null) {
            transactionController = this.getTransactionCompile();
        }
        if (uUID != null) {
            if (this.getSystemSchemaDescriptor().getUUID().equals(uUID)) {
                return this.getSystemSchemaDescriptor();
            }
            if (this.getSysIBMSchemaDescriptor().getUUID().equals(uUID)) {
                return this.getSysIBMSchemaDescriptor();
            }
        }
        if (!this.booting && (languageConnectionContext = DataDictionaryImpl.getLCC()) != null && (schemaDescriptor = languageConnectionContext.getDefaultSchema()) != null && (uUID == null || uUID.equals(schemaDescriptor.getUUID()))) {
            return schemaDescriptor;
        }
        return this.locateSchemaRow(uUID, transactionController);
    }

    public void addDescriptor(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2, int n, boolean bl, TransactionController transactionController) throws StandardException {
        this.addDescriptor(tupleDescriptor, tupleDescriptor2, n, bl, transactionController, true);
    }

    public void addDescriptor(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2, int n, boolean bl, TransactionController transactionController, boolean bl2) throws StandardException {
        TabInfoImpl tabInfoImpl = n < 4 ? this.coreInfo[n] : this.getNonCoreTI(n);
        ExecRow execRow = tabInfoImpl.getCatalogRowFactory().makeRow(tupleDescriptor, tupleDescriptor2);
        int n2 = tabInfoImpl.insertRow(execRow, transactionController, bl2);
        if (!bl && n2 != -1) {
            throw this.duplicateDescriptorException(tupleDescriptor, tupleDescriptor2);
        }
    }

    private StandardException duplicateDescriptorException(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) {
        if (tupleDescriptor2 != null) {
            return StandardException.newException("X0Y32.S", tupleDescriptor.getDescriptorType(), (Object)tupleDescriptor.getDescriptorName(), (Object)tupleDescriptor2.getDescriptorType(), (Object)tupleDescriptor2.getDescriptorName());
        }
        return StandardException.newException("X0Y68.S", (Object)tupleDescriptor.getDescriptorType(), (Object)tupleDescriptor.getDescriptorName());
    }

    public void addDescriptorArray(TupleDescriptor[] tupleDescriptorArray, TupleDescriptor tupleDescriptor, int n, boolean bl, TransactionController transactionController) throws StandardException {
        int n2;
        TabInfoImpl tabInfoImpl = n < 4 ? this.coreInfo[n] : this.getNonCoreTI(n);
        CatalogRowFactory catalogRowFactory = tabInfoImpl.getCatalogRowFactory();
        ExecRow[] execRowArray = new ExecRow[tupleDescriptorArray.length];
        for (n2 = 0; n2 < tupleDescriptorArray.length; ++n2) {
            ExecRow execRow;
            execRowArray[n2] = execRow = catalogRowFactory.makeRow(tupleDescriptorArray[n2], tupleDescriptor);
        }
        n2 = tabInfoImpl.insertRowList(execRowArray, transactionController);
        if (!bl && n2 != -1) {
            throw this.duplicateDescriptorException(tupleDescriptorArray[n2], tupleDescriptor);
        }
    }

    public void dropSchemaDescriptor(String string, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[3];
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLVarchar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    public TableDescriptor getTableDescriptor(String string, SchemaDescriptor schemaDescriptor) throws StandardException {
        Object object;
        TableDescriptor tableDescriptor = null;
        SchemaDescriptor schemaDescriptor2 = schemaDescriptor == null ? this.getSystemSchemaDescriptor() : schemaDescriptor;
        UUID uUID = schemaDescriptor2.getUUID();
        if ("SYSCS_DIAG".equals(schemaDescriptor2.getSchemaName()) && this.getVTIClass((TableDescriptor)(object = new TableDescriptor(this, string, schemaDescriptor2, 5, 'R')), false) != null) {
            return object;
        }
        object = new TableKey(uUID, string);
        if (this.getCacheMode() == 0) {
            NameTDCacheable nameTDCacheable = (NameTDCacheable)this.nameTdCache.find(object);
            if (nameTDCacheable != null) {
                tableDescriptor = nameTDCacheable.getTableDescriptor();
                tableDescriptor.setReferencedColumnMap(null);
                this.nameTdCache.release(nameTDCacheable);
            }
            return tableDescriptor;
        }
        return this.getTableDescriptorIndex1Scan(string, uUID.toString());
    }

    private TableDescriptor getTableDescriptorIndex1Scan(String string, String string2) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[1];
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLChar sQLChar = new SQLChar(string2);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        TableDescriptor tableDescriptor = (TableDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, false);
        return this.finishTableDescriptor(tableDescriptor);
    }

    TableDescriptor getUncachedTableDescriptor(TableKey tableKey) throws StandardException {
        return this.getTableDescriptorIndex1Scan(tableKey.getTableName(), tableKey.getSchemaId().toString());
    }

    public TableDescriptor getTableDescriptor(UUID uUID) throws StandardException {
        TableDescriptor tableDescriptor = null;
        if (this.getCacheMode() == 0) {
            OIDTDCacheable oIDTDCacheable = (OIDTDCacheable)this.OIDTdCache.find(uUID);
            if (oIDTDCacheable != null) {
                tableDescriptor = oIDTDCacheable.getTableDescriptor();
                tableDescriptor.setReferencedColumnMap(null);
                this.OIDTdCache.release(oIDTDCacheable);
            }
            return tableDescriptor;
        }
        return this.getTableDescriptorIndex2Scan(uUID.toString());
    }

    protected TableDescriptor getUncachedTableDescriptor(UUID uUID) throws StandardException {
        return this.getTableDescriptorIndex2Scan(uUID.toString());
    }

    private TableDescriptor getTableDescriptorIndex2Scan(String string) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[1];
        SQLChar sQLChar = new SQLChar(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        TableDescriptor tableDescriptor = (TableDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, false);
        return this.finishTableDescriptor(tableDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableDescriptor finishTableDescriptor(TableDescriptor tableDescriptor) throws StandardException {
        if (tableDescriptor != null) {
            TableDescriptor tableDescriptor2 = tableDescriptor;
            synchronized (tableDescriptor2) {
                this.getColumnDescriptorsScan(tableDescriptor);
                this.getConglomerateDescriptorsScan(tableDescriptor);
            }
        }
        return tableDescriptor;
    }

    public boolean isSchemaEmpty(SchemaDescriptor schemaDescriptor) throws StandardException {
        SQLChar sQLChar;
        TransactionController transactionController = this.getTransactionCompile();
        if (this.isSchemaReferenced(transactionController, this.coreInfo[1], 0, 2, sQLChar = DataDictionaryImpl.getIDValueAsCHAR(schemaDescriptor.getUUID()))) {
            return false;
        }
        if (this.isSchemaReferenced(transactionController, this.getNonCoreTI(4), 1, 2, sQLChar)) {
            return false;
        }
        if (this.isSchemaReferenced(transactionController, this.getNonCoreTI(11), 1, 2, sQLChar)) {
            return false;
        }
        return !this.isSchemaReferenced(transactionController, this.getNonCoreTI(13), 1, 2, sQLChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSchemaReferenced(TransactionController transactionController, TabInfoImpl tabInfoImpl, int n, int n2, DataValueDescriptor dataValueDescriptor) throws StandardException {
        boolean bl;
        ConglomerateController conglomerateController;
        block5: {
            conglomerateController = null;
            GenericScanController genericScanController = null;
            FormatableBitSet formatableBitSet = new FormatableBitSet(n2);
            CatalogRowFactory catalogRowFactory = tabInfoImpl.getCatalogRowFactory();
            formatableBitSet.set(n2 - 1);
            Qualifier[][] qualifierArray = this.exFactory.getScanQualifier(1);
            qualifierArray[0][0].setQualifier(n2 - 1, dataValueDescriptor, 2, false, false, false);
            ExecRow execRow = catalogRowFactory.makeEmptyRow();
            try {
                conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4);
                genericScanController = transactionController.openScan(tabInfoImpl.getIndexConglomerate(n), false, 0, 6, 4, formatableBitSet, null, 1, qualifierArray, null, -1);
                bl = genericScanController.next();
                Object var16_13 = null;
                if (genericScanController == null) break block5;
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                if (genericScanController != null) {
                    genericScanController.close();
                }
                if (conglomerateController != null) {
                    conglomerateController.close();
                }
                throw throwable;
            }
            genericScanController.close();
        }
        if (conglomerateController != null) {
            conglomerateController.close();
        }
        return bl;
    }

    public void dropTableDescriptor(TableDescriptor tableDescriptor, SchemaDescriptor schemaDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[1];
        SQLVarchar sQLVarchar = new SQLVarchar(tableDescriptor.getName());
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(schemaDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    public void updateLockGranularity(TableDescriptor tableDescriptor, SchemaDescriptor schemaDescriptor, char c, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[1];
        SYSTABLESRowFactory sYSTABLESRowFactory = (SYSTABLESRowFactory)tabInfoImpl.getCatalogRowFactory();
        SQLVarchar sQLVarchar = new SQLVarchar(tableDescriptor.getName());
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(schemaDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        ExecRow execRow = sYSTABLESRowFactory.makeRow(tableDescriptor, schemaDescriptor);
        boolean[] blArray = new boolean[2];
        for (int i = 0; i < 2; ++i) {
            blArray[i] = false;
        }
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, (int[])null, transactionController);
    }

    public ColumnDescriptor getColumnDescriptorByDefaultId(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[2];
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return (ColumnDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, false);
    }

    private void getColumnDescriptorsScan(TableDescriptor tableDescriptor) throws StandardException {
        this.getColumnDescriptorsScan(tableDescriptor.getUUID(), tableDescriptor.getColumnDescriptorList(), tableDescriptor);
    }

    private void getColumnDescriptorsScan(UUID uUID, ColumnDescriptorList columnDescriptorList, TupleDescriptor tupleDescriptor) throws StandardException {
        int n;
        ColumnDescriptorList columnDescriptorList2 = new ColumnDescriptorList();
        SQLChar sQLChar = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[2];
        sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, tupleDescriptor, columnDescriptorList, false);
        int n2 = columnDescriptorList.size();
        for (n = 0; n < n2; ++n) {
            columnDescriptorList2.add(columnDescriptorList.get(n));
        }
        for (n = 0; n < n2; ++n) {
            ColumnDescriptor columnDescriptor = columnDescriptorList2.elementAt(n);
            columnDescriptorList.set(columnDescriptor.getPosition() - 1, columnDescriptor);
        }
    }

    public void dropColumnDescriptor(UUID uUID, String string, TransactionController transactionController) throws StandardException {
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLChar);
        execIndexRow.setColumn(2, sQLVarchar);
        this.dropColumnDescriptorCore(transactionController, execIndexRow);
    }

    public void dropAllColumnDescriptors(UUID uUID, TransactionController transactionController) throws StandardException {
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.dropColumnDescriptorCore(transactionController, execIndexRow);
    }

    public void dropAllTableAndColPermDescriptors(UUID uUID, TransactionController transactionController) throws StandardException {
        if (!this.usesSqlAuthorization) {
            return;
        }
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.dropTablePermDescriptor(transactionController, execIndexRow);
        this.dropColumnPermDescriptor(transactionController, execIndexRow);
    }

    public void updateSYSCOLPERMSforAddColumnToUserTable(UUID uUID, TransactionController transactionController) throws StandardException {
        this.rewriteSYSCOLPERMSforAlterTable(uUID, transactionController, null);
    }

    public void updateSYSCOLPERMSforDropColumn(UUID uUID, TransactionController transactionController, ColumnDescriptor columnDescriptor) throws StandardException {
        this.rewriteSYSCOLPERMSforAlterTable(uUID, transactionController, columnDescriptor);
    }

    private void rewriteSYSCOLPERMSforAlterTable(UUID uUID, TransactionController transactionController, ColumnDescriptor columnDescriptor) throws StandardException {
        if (!this.usesSqlAuthorization) {
            return;
        }
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(17);
        SYSCOLPERMSRowFactory sYSCOLPERMSRowFactory = (SYSCOLPERMSRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        List list = DataDictionaryImpl.newSList();
        this.getDescriptorViaIndex(2, execIndexRow, null, tabInfoImpl, null, list, false);
        boolean[] blArray = new boolean[3];
        int[] nArray = new int[]{6};
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ColPermsDescriptor colPermsDescriptor = (ColPermsDescriptor)iterator.next();
            this.removePermEntryInCache(colPermsDescriptor);
            ExecIndexRow execIndexRow2 = sYSCOLPERMSRowFactory.buildIndexKeyRow(1, colPermsDescriptor);
            ExecRow execRow = tabInfoImpl.getRow(transactionController, execIndexRow2, 1);
            FormatableBitSet formatableBitSet = (FormatableBitSet)execRow.getColumn(6).getObject();
            if (columnDescriptor == null) {
                int n = formatableBitSet.getLength();
                formatableBitSet.grow(n + 1);
            } else {
                FormatableBitSet formatableBitSet2 = new FormatableBitSet(formatableBitSet);
                formatableBitSet2.shrink(formatableBitSet.getLength() - 1);
                for (int i = columnDescriptor.getPosition() - 1; i < formatableBitSet2.getLength(); ++i) {
                    if (formatableBitSet.isSet(i + 1)) {
                        formatableBitSet2.set(i);
                        continue;
                    }
                    formatableBitSet2.clear(i);
                }
                formatableBitSet = formatableBitSet2;
            }
            execRow.setColumn(6, this.dvf.getDataValue(formatableBitSet));
            tabInfoImpl.updateRow(execIndexRow2, execRow, 1, blArray, nArray, transactionController);
        }
    }

    private void removePermEntryInCache(PermissionsDescriptor permissionsDescriptor) throws StandardException {
        Cacheable cacheable = this.getPermissionsCache().findCached(permissionsDescriptor);
        if (cacheable != null) {
            this.getPermissionsCache().remove(cacheable);
        }
    }

    public void dropAllRoutinePermDescriptors(UUID uUID, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(18);
        SYSROUTINEPERMSRowFactory sYSROUTINEPERMSRowFactory = (SYSROUTINEPERMSRowFactory)tabInfoImpl.getCatalogRowFactory();
        if (!this.usesSqlAuthorization) {
            return;
        }
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        while (true) {
            ExecRow execRow = tabInfoImpl.getRow(transactionController, execIndexRow, 2);
            if (execRow == null) break;
            PermissionsDescriptor permissionsDescriptor = (PermissionsDescriptor)sYSROUTINEPERMSRowFactory.buildDescriptor(execRow, null, this);
            this.removePermEntryInCache(permissionsDescriptor);
            ExecIndexRow execIndexRow2 = sYSROUTINEPERMSRowFactory.buildIndexKeyRow(1, permissionsDescriptor);
            tabInfoImpl.deleteRow(transactionController, execIndexRow2, 1);
        }
    }

    private void dropColumnDescriptorCore(TransactionController transactionController, ExecIndexRow execIndexRow) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[2];
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    private void dropTablePermDescriptor(TransactionController transactionController, ExecIndexRow execIndexRow) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(16);
        SYSTABLEPERMSRowFactory sYSTABLEPERMSRowFactory = (SYSTABLEPERMSRowFactory)tabInfoImpl.getCatalogRowFactory();
        while (true) {
            ExecRow execRow = tabInfoImpl.getRow(transactionController, execIndexRow, 2);
            if (execRow == null) break;
            PermissionsDescriptor permissionsDescriptor = (PermissionsDescriptor)sYSTABLEPERMSRowFactory.buildDescriptor(execRow, null, this);
            this.removePermEntryInCache(permissionsDescriptor);
            ExecIndexRow execIndexRow2 = sYSTABLEPERMSRowFactory.buildIndexKeyRow(1, permissionsDescriptor);
            tabInfoImpl.deleteRow(transactionController, execIndexRow2, 1);
        }
    }

    private void dropColumnPermDescriptor(TransactionController transactionController, ExecIndexRow execIndexRow) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(17);
        SYSCOLPERMSRowFactory sYSCOLPERMSRowFactory = (SYSCOLPERMSRowFactory)tabInfoImpl.getCatalogRowFactory();
        while (true) {
            ExecRow execRow = tabInfoImpl.getRow(transactionController, execIndexRow, 2);
            if (execRow == null) break;
            PermissionsDescriptor permissionsDescriptor = (PermissionsDescriptor)sYSCOLPERMSRowFactory.buildDescriptor(execRow, null, this);
            this.removePermEntryInCache(permissionsDescriptor);
            ExecIndexRow execIndexRow2 = sYSCOLPERMSRowFactory.buildIndexKeyRow(1, permissionsDescriptor);
            tabInfoImpl.deleteRow(transactionController, execIndexRow2, 1);
        }
    }

    private void updateColumnDescriptor(ColumnDescriptor columnDescriptor, UUID uUID, String string, int[] nArray, TransactionController transactionController, boolean bl) throws StandardException {
        boolean[] blArray;
        ExecRow execRow;
        TabInfoImpl tabInfoImpl;
        ExecIndexRow execIndexRow;
        block4: {
            block3: {
                execIndexRow = null;
                tabInfoImpl = this.coreInfo[2];
                SYSCOLUMNSRowFactory sYSCOLUMNSRowFactory = (SYSCOLUMNSRowFactory)tabInfoImpl.getCatalogRowFactory();
                SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
                SQLVarchar sQLVarchar = new SQLVarchar(string);
                execIndexRow = this.exFactory.getIndexableRow(2);
                execIndexRow.setColumn(1, sQLChar);
                execIndexRow.setColumn(2, sQLVarchar);
                execRow = sYSCOLUMNSRowFactory.makeRow(columnDescriptor, null);
                blArray = new boolean[sYSCOLUMNSRowFactory.getNumIndexes()];
                if (nArray != null) break block3;
                blArray[0] = true;
                blArray[1] = true;
                break block4;
            }
            for (int i = 0; i < nArray.length; ++i) {
                block6: {
                    block5: {
                        if (nArray[i] == 2) break block5;
                        if (nArray[i] != 1) break block6;
                    }
                    blArray[0] = true;
                    break;
                }
                if (nArray[i] != 6) continue;
                blArray[1] = true;
                break;
            }
        }
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController, bl);
    }

    public ViewDescriptor getViewDescriptor(UUID uUID) throws StandardException {
        return this.getViewDescriptor(this.getTableDescriptor(uUID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewDescriptor getViewDescriptor(TableDescriptor tableDescriptor) throws StandardException {
        TableDescriptor tableDescriptor2 = tableDescriptor;
        if (tableDescriptor2.getViewDescriptor() != null) {
            return tableDescriptor2.getViewDescriptor();
        }
        TableDescriptor tableDescriptor3 = tableDescriptor2;
        synchronized (tableDescriptor3) {
            if (tableDescriptor2.getViewDescriptor() != null) {
                return tableDescriptor2.getViewDescriptor();
            }
            tableDescriptor2.setViewDescriptor(this.getViewDescriptorScan(tableDescriptor2));
        }
        return tableDescriptor2.getViewDescriptor();
    }

    private ViewDescriptor getViewDescriptorScan(TableDescriptor tableDescriptor) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(8);
        UUID uUID = tableDescriptor.getUUID();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        ViewDescriptor viewDescriptor = (ViewDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, false);
        if (viewDescriptor != null) {
            viewDescriptor.setViewName(tableDescriptor.getName());
        }
        return viewDescriptor;
    }

    public void dropViewDescriptor(ViewDescriptor viewDescriptor, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(8);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(viewDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    private FileInfoDescriptor getFileInfoDescriptorIndex2Scan(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(12);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return (FileInfoDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, false);
    }

    public FileInfoDescriptor getFileInfoDescriptor(UUID uUID) throws StandardException {
        return this.getFileInfoDescriptorIndex2Scan(uUID);
    }

    private FileInfoDescriptor getFileInfoDescriptorIndex1Scan(UUID uUID, String string) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(12);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        FileInfoDescriptor fileInfoDescriptor = (FileInfoDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, false);
        return fileInfoDescriptor;
    }

    public FileInfoDescriptor getFileInfoDescriptor(SchemaDescriptor schemaDescriptor, String string) throws StandardException {
        return this.getFileInfoDescriptorIndex1Scan(schemaDescriptor.getUUID(), string);
    }

    public void dropFileInfoDescriptor(FileInfoDescriptor fileInfoDescriptor) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(12);
        TransactionController transactionController = this.getTransactionExecute();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(fileInfoDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 1);
    }

    public SPSDescriptor getSPSDescriptor(UUID uUID) throws StandardException {
        SPSDescriptor sPSDescriptor;
        this.getNonCoreTI(11);
        if (this.spsNameCache != null && this.getCacheMode() == 0) {
            sPSDescriptor = (SPSDescriptor)this.spsIdHash.get(uUID);
            if (sPSDescriptor != null) {
                return sPSDescriptor;
            }
            sPSDescriptor = this.getSPSDescriptorIndex2Scan(uUID.toString());
            TableKey tableKey = new TableKey(sPSDescriptor.getSchemaDescriptor().getUUID(), sPSDescriptor.getName());
            try {
                SPSNameCacheable sPSNameCacheable = (SPSNameCacheable)this.spsNameCache.create(tableKey, sPSDescriptor);
                this.spsNameCache.release(sPSNameCacheable);
            }
            catch (StandardException standardException) {
                if ("XBCA0.S".equals(standardException.getMessageId())) {
                    return sPSDescriptor;
                }
                throw standardException;
            }
        } else {
            sPSDescriptor = this.getSPSDescriptorIndex2Scan(uUID.toString());
        }
        return sPSDescriptor;
    }

    void spsCacheEntryAdded(SPSDescriptor sPSDescriptor) {
        this.spsIdHash.put(sPSDescriptor.getUUID(), sPSDescriptor);
    }

    void spsCacheEntryRemoved(SPSDescriptor sPSDescriptor) {
        this.spsIdHash.remove(sPSDescriptor.getUUID());
    }

    public SPSDescriptor getUncachedSPSDescriptor(TableKey tableKey) throws StandardException {
        return this.getSPSDescriptorIndex1Scan(tableKey.getTableName(), tableKey.getSchemaId().toString());
    }

    protected SPSDescriptor getUncachedSPSDescriptor(UUID uUID) throws StandardException {
        return this.getSPSDescriptorIndex2Scan(uUID.toString());
    }

    private SPSDescriptor getSPSDescriptorIndex2Scan(String string) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(11);
        SQLChar sQLChar = new SQLChar(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        SPSDescriptor sPSDescriptor = (SPSDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, false);
        return sPSDescriptor;
    }

    public SPSDescriptor getSPSDescriptor(String string, SchemaDescriptor schemaDescriptor) throws StandardException {
        SPSDescriptor sPSDescriptor = null;
        UUID uUID = schemaDescriptor.getUUID();
        TableKey tableKey = new TableKey(uUID, string);
        if (this.spsNameCache != null && this.getCacheMode() == 0) {
            SPSNameCacheable sPSNameCacheable = (SPSNameCacheable)this.spsNameCache.find(tableKey);
            if (sPSNameCacheable != null) {
                sPSDescriptor = sPSNameCacheable.getSPSDescriptor();
                this.spsNameCache.release(sPSNameCacheable);
            }
            return sPSDescriptor;
        }
        return this.getSPSDescriptorIndex1Scan(string, uUID.toString());
    }

    private SPSDescriptor getSPSDescriptorIndex1Scan(String string, String string2) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(11);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLChar sQLChar = new SQLChar(string2);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        SPSDescriptor sPSDescriptor = (SPSDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, false);
        if (sPSDescriptor != null) {
            Vector vector = new Vector();
            sPSDescriptor.setParams(this.getSPSParams(sPSDescriptor, vector));
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            sPSDescriptor.setParameterDefaults(objectArray);
        }
        return sPSDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSPSDescriptor(SPSDescriptor sPSDescriptor, TransactionController transactionController, boolean bl) throws StandardException {
        int n;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(11);
        SYSSTATEMENTSRowFactory sYSSTATEMENTSRowFactory = (SYSSTATEMENTSRowFactory)tabInfoImpl.getCatalogRowFactory();
        SPSDescriptor sPSDescriptor2 = sPSDescriptor;
        synchronized (sPSDescriptor2) {
            boolean bl2 = sPSDescriptor.initiallyCompilable();
            ExecRow execRow = sYSSTATEMENTSRowFactory.makeSYSSTATEMENTSrow(bl2, sPSDescriptor);
            n = tabInfoImpl.insertRow(execRow, transactionController, bl);
        }
        if (n != -1) {
            throw StandardException.newException("X0Y32.S", sPSDescriptor.getDescriptorType(), (Object)sPSDescriptor.getDescriptorName(), (Object)sPSDescriptor.getSchemaDescriptor().getDescriptorType(), (Object)sPSDescriptor.getSchemaDescriptor().getSchemaName());
        }
        this.addSPSParams(sPSDescriptor, transactionController, bl);
    }

    private void addSPSParams(SPSDescriptor sPSDescriptor, TransactionController transactionController, boolean bl) throws StandardException {
        UUID uUID = sPSDescriptor.getUUID();
        DataTypeDescriptor[] dataTypeDescriptorArray = sPSDescriptor.getParams();
        Object[] objectArray = sPSDescriptor.getParameterDefaults();
        if (dataTypeDescriptorArray == null) {
            return;
        }
        int n = dataTypeDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            ColumnDescriptor columnDescriptor = new ColumnDescriptor("PARAM" + n2, n2, dataTypeDescriptorArray[i], objectArray == null || i >= objectArray.length ? (DataValueDescriptor)null : (DataValueDescriptor)objectArray[i], (DefaultInfo)null, uUID, (UUID)null, 0L, 0L);
            this.addDescriptor(columnDescriptor, null, 2, false, transactionController, bl);
        }
    }

    public DataTypeDescriptor[] getSPSParams(SPSDescriptor sPSDescriptor, Vector vector) throws StandardException {
        ColumnDescriptorList columnDescriptorList = new ColumnDescriptorList();
        this.getColumnDescriptorsScan(sPSDescriptor.getUUID(), columnDescriptorList, sPSDescriptor);
        int n = columnDescriptorList.size();
        DataTypeDescriptor[] dataTypeDescriptorArray = new DataTypeDescriptor[n];
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            dataTypeDescriptorArray[i] = columnDescriptor.getType();
            if (vector == null) continue;
            vector.addElement(columnDescriptor.getDefaultValue());
        }
        return dataTypeDescriptorArray;
    }

    public void updateSPS(SPSDescriptor sPSDescriptor, TransactionController transactionController, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(11);
        SYSSTATEMENTSRowFactory sYSSTATEMENTSRowFactory = (SYSSTATEMENTSRowFactory)tabInfoImpl.getCatalogRowFactory();
        int[] nArray = bl ? (bl4 ? new int[]{5, 7, 9, 10, 11} : new int[]{5, 7, 9, 10}) : new int[]{5};
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(sPSDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        ExecRow execRow = sYSSTATEMENTSRowFactory.makeSYSSTATEMENTSrow(false, sPSDescriptor);
        boolean[] blArray = new boolean[2];
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController, bl3);
        if (!bl2) {
            return;
        }
        DataTypeDescriptor[] dataTypeDescriptorArray = sPSDescriptor.getParams();
        if (dataTypeDescriptorArray == null) {
            return;
        }
        if (bl4) {
            this.addSPSParams(sPSDescriptor, transactionController, bl3);
        } else {
            Object[] objectArray = sPSDescriptor.getParameterDefaults();
            int[] nArray2 = new int[]{4, 5};
            UUID uUID = sPSDescriptor.getUUID();
            for (int i = 0; i < dataTypeDescriptorArray.length; ++i) {
                int n = i + 1;
                ColumnDescriptor columnDescriptor = new ColumnDescriptor("PARAM" + n, n, dataTypeDescriptorArray[i], objectArray == null || i >= objectArray.length ? (DataValueDescriptor)null : (DataValueDescriptor)objectArray[i], (DefaultInfo)null, uUID, (UUID)null, 0L, 0L);
                this.updateColumnDescriptor(columnDescriptor, columnDescriptor.getReferencingUUID(), columnDescriptor.getColumnName(), nArray2, transactionController, bl3);
            }
        }
    }

    public void invalidateAllSPSPlans() throws StandardException {
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        this.startWriting(languageConnectionContext);
        Iterator iterator = this.getAllSPSDescriptors().iterator();
        while (iterator.hasNext()) {
            SPSDescriptor sPSDescriptor = (SPSDescriptor)iterator.next();
            sPSDescriptor.makeInvalid(14, languageConnectionContext);
        }
    }

    void clearSPSPlans() throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(11);
        this.faultInTabInfo(tabInfoImpl);
        TransactionController transactionController = this.getTransactionExecute();
        FormatableBitSet formatableBitSet = new FormatableBitSet(11);
        FormatableBitSet formatableBitSet2 = new FormatableBitSet(11);
        formatableBitSet2.set(4);
        formatableBitSet2.set(9);
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[11];
        dataValueDescriptorArray[4] = this.dvf.getDataValue(false);
        dataValueDescriptorArray[9] = this.dvf.getDataValue((Object)null);
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 4, 7, 4, formatableBitSet, null, 0, null, null, 0);
        while (scanController.fetchNext(null)) {
            scanController.replace(dataValueDescriptorArray, formatableBitSet2);
        }
        scanController.close();
    }

    public void dropSPSDescriptor(SPSDescriptor sPSDescriptor, TransactionController transactionController) throws StandardException {
        this.dropSPSDescriptor(sPSDescriptor.getUUID(), transactionController);
    }

    public void dropSPSDescriptor(UUID uUID, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(11);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
        this.dropAllColumnDescriptors(uUID, transactionController);
    }

    public List getAllSPSDescriptors() throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(11);
        List list = DataDictionaryImpl.newSList();
        this.getDescriptorViaHeap(null, tabInfoImpl, null, list);
        return list;
    }

    private ConstraintDescriptorList getAllConstraintDescriptors() throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
        ConstraintDescriptorList constraintDescriptorList = new ConstraintDescriptorList();
        this.getConstraintDescriptorViaHeap(null, tabInfoImpl, null, constraintDescriptorList);
        return constraintDescriptorList;
    }

    private GenericDescriptorList getAllTriggerDescriptors() throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(13);
        GenericDescriptorList genericDescriptorList = new GenericDescriptorList();
        this.getDescriptorViaHeap(null, tabInfoImpl, null, genericDescriptorList);
        return genericDescriptorList;
    }

    public TriggerDescriptor getTriggerDescriptor(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(13);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return (TriggerDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, false);
    }

    public TriggerDescriptor getTriggerDescriptor(String string, SchemaDescriptor schemaDescriptor) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(13);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(schemaDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        return (TriggerDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericDescriptorList getTriggerDescriptors(TableDescriptor tableDescriptor) throws StandardException {
        GenericDescriptorList genericDescriptorList;
        if (tableDescriptor == null) {
            return this.getAllTriggerDescriptors();
        }
        GenericDescriptorList genericDescriptorList2 = genericDescriptorList = tableDescriptor.getTriggerDescriptorList();
        synchronized (genericDescriptorList2) {
            if (!genericDescriptorList.getScanned()) {
                this.getTriggerDescriptorsScan(tableDescriptor, false);
            }
        }
        return genericDescriptorList;
    }

    private void getTriggerDescriptorsScan(TableDescriptor tableDescriptor, boolean bl) throws StandardException {
        GenericDescriptorList genericDescriptorList = tableDescriptor.getTriggerDescriptorList();
        SQLChar sQLChar = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(13);
        sQLChar = DataDictionaryImpl.getIDValueAsCHAR(tableDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getDescriptorViaIndex(2, execIndexRow, null, tabInfoImpl, null, genericDescriptorList, bl);
        genericDescriptorList.setScanned(true);
    }

    public void dropTriggerDescriptor(TriggerDescriptor triggerDescriptor, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(13);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(triggerDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    public void updateTriggerDescriptor(TriggerDescriptor triggerDescriptor, UUID uUID, int[] nArray, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(13);
        SYSTRIGGERSRowFactory sYSTRIGGERSRowFactory = (SYSTRIGGERSRowFactory)tabInfoImpl.getCatalogRowFactory();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        ExecRow execRow = sYSTRIGGERSRowFactory.makeRow(triggerDescriptor, null);
        boolean[] blArray = new boolean[3];
        if (nArray == null) {
            blArray[0] = true;
            blArray[1] = true;
            blArray[2] = true;
        } else {
            block5: for (int i = 0; i < nArray.length; ++i) {
                switch (nArray[i]) {
                    case 1: {
                        blArray[0] = true;
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        blArray[1] = true;
                        continue block5;
                    }
                    case 9: {
                        blArray[2] = true;
                    }
                }
            }
        }
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController);
    }

    public ConstraintDescriptor getConstraintDescriptor(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return this.getConstraintDescriptorViaIndex(0, execIndexRow, tabInfoImpl, null, null, false);
    }

    public ConstraintDescriptor getConstraintDescriptor(String string, UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        return this.getConstraintDescriptorViaIndex(1, execIndexRow, tabInfoImpl, null, null, false);
    }

    public List getStatisticsDescriptors(TableDescriptor tableDescriptor) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(14);
        List list = DataDictionaryImpl.newSList();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(tableDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, list, false);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintDescriptorList getConstraintDescriptors(TableDescriptor tableDescriptor) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList;
        if (tableDescriptor == null) {
            return this.getAllConstraintDescriptors();
        }
        ConstraintDescriptorList constraintDescriptorList2 = constraintDescriptorList = tableDescriptor.getConstraintDescriptorList();
        synchronized (constraintDescriptorList2) {
            if (!constraintDescriptorList.getScanned()) {
                this.getConstraintDescriptorsScan(tableDescriptor, false);
            }
        }
        return constraintDescriptorList;
    }

    public ConstraintDescriptorList getActiveConstraintDescriptors(ConstraintDescriptorList constraintDescriptorList) throws StandardException {
        return constraintDescriptorList;
    }

    public boolean activeConstraint(ConstraintDescriptor constraintDescriptor) throws StandardException {
        return true;
    }

    public ConstraintDescriptor getConstraintDescriptor(TableDescriptor tableDescriptor, UUID uUID) throws StandardException {
        return this.getConstraintDescriptors(tableDescriptor).getConstraintDescriptor(uUID);
    }

    public ConstraintDescriptor getConstraintDescriptorById(TableDescriptor tableDescriptor, UUID uUID) throws StandardException {
        return this.getConstraintDescriptors(tableDescriptor).getConstraintDescriptorById(uUID);
    }

    public ConstraintDescriptor getConstraintDescriptorByName(TableDescriptor tableDescriptor, SchemaDescriptor schemaDescriptor, String string, boolean bl) throws StandardException {
        if (bl) {
            tableDescriptor.emptyConstraintDescriptorList();
            this.getConstraintDescriptorsScan(tableDescriptor, true);
        }
        return this.getConstraintDescriptors(tableDescriptor).getConstraintDescriptorByName(schemaDescriptor, string);
    }

    private void getConstraintDescriptorsScan(TableDescriptor tableDescriptor, boolean bl) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList = tableDescriptor.getConstraintDescriptorList();
        SQLChar sQLChar = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
        sQLChar = DataDictionaryImpl.getIDValueAsCHAR(tableDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getConstraintDescriptorViaIndex(2, execIndexRow, tabInfoImpl, tableDescriptor, constraintDescriptorList, bl);
        constraintDescriptorList.setScanned(true);
    }

    protected ConstraintDescriptor getConstraintDescriptorViaIndex(int n, ExecIndexRow execIndexRow, TabInfoImpl tabInfoImpl, TableDescriptor tableDescriptor, ConstraintDescriptorList constraintDescriptorList, boolean bl) throws StandardException {
        SYSCONSTRAINTSRowFactory sYSCONSTRAINTSRowFactory = (SYSCONSTRAINTSRowFactory)tabInfoImpl.getCatalogRowFactory();
        ConstraintDescriptor constraintDescriptor = null;
        TransactionController transactionController = this.getTransactionCompile();
        ExecRow execRow = sYSCONSTRAINTSRowFactory.makeEmptyRow();
        ConglomerateController conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4);
        ScanController scanController = transactionController.openScan(tabInfoImpl.getIndexConglomerate(n), false, bl ? 4 : 0, 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
        while (scanController.next()) {
            SubConstraintDescriptor subConstraintDescriptor = null;
            ExecIndexRow execIndexRow2 = DataDictionaryImpl.getIndexRowFromHeapRow(tabInfoImpl.getIndexRowGenerator(n), conglomerateController.newRowLocationTemplate(), execRow);
            scanController.fetch(execIndexRow2.getRowArray());
            RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
            boolean bl2 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
            switch (sYSCONSTRAINTSRowFactory.getConstraintType(execRow)) {
                case 2: 
                case 3: 
                case 6: {
                    subConstraintDescriptor = this.getSubKeyConstraint(sYSCONSTRAINTSRowFactory.getConstraintId(execRow), sYSCONSTRAINTSRowFactory.getConstraintType(execRow));
                    break;
                }
                case 4: {
                    subConstraintDescriptor = this.getSubCheckConstraint(sYSCONSTRAINTSRowFactory.getConstraintId(execRow));
                    break;
                }
            }
            subConstraintDescriptor.setTableDescriptor(tableDescriptor);
            constraintDescriptor = (ConstraintDescriptor)sYSCONSTRAINTSRowFactory.buildDescriptor(execRow, subConstraintDescriptor, this);
            if (constraintDescriptorList == null) break;
            constraintDescriptorList.add(constraintDescriptor);
        }
        scanController.close();
        conglomerateController.close();
        return constraintDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TupleDescriptor getConstraintDescriptorViaHeap(ScanQualifier[][] scanQualifierArray, TabInfoImpl tabInfoImpl, TupleDescriptor tupleDescriptor, List list) throws StandardException {
        SYSCONSTRAINTSRowFactory sYSCONSTRAINTSRowFactory = (SYSCONSTRAINTSRowFactory)tabInfoImpl.getCatalogRowFactory();
        ConstraintDescriptor constraintDescriptor = null;
        TransactionController transactionController = this.getTransactionCompile();
        ExecRow execRow = sYSCONSTRAINTSRowFactory.makeEmptyRow();
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 0, 7, 4, null, null, 0, scanQualifierArray, null, 0);
        try {
            while (scanController.fetchNext(execRow.getRowArray())) {
                SubConstraintDescriptor subConstraintDescriptor = null;
                switch (sYSCONSTRAINTSRowFactory.getConstraintType(execRow)) {
                    case 2: 
                    case 3: 
                    case 6: {
                        subConstraintDescriptor = this.getSubKeyConstraint(sYSCONSTRAINTSRowFactory.getConstraintId(execRow), sYSCONSTRAINTSRowFactory.getConstraintType(execRow));
                        break;
                    }
                    case 4: {
                        subConstraintDescriptor = this.getSubCheckConstraint(sYSCONSTRAINTSRowFactory.getConstraintId(execRow));
                        break;
                    }
                }
                constraintDescriptor = (ConstraintDescriptor)sYSCONSTRAINTSRowFactory.buildDescriptor(execRow, subConstraintDescriptor, this);
                if (list == null) {
                    break;
                }
                list.add(constraintDescriptor);
            }
        }
        finally {
            scanController.close();
        }
        return constraintDescriptor;
    }

    public TableDescriptor getConstraintTableDescriptor(UUID uUID) throws StandardException {
        List list = this.getConstraints(uUID, 0, 2);
        if (list.size() == 0) {
            return null;
        }
        return this.getTableDescriptor((UUID)list.get(0));
    }

    public ConstraintDescriptorList getForeignKeys(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(10);
        List list = DataDictionaryImpl.newSList();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, list, false);
        ConstraintDescriptorList constraintDescriptorList = new ConstraintDescriptorList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SubKeyConstraintDescriptor subKeyConstraintDescriptor = (SubKeyConstraintDescriptor)iterator.next();
            TableDescriptor tableDescriptor = this.getConstraintTableDescriptor(subKeyConstraintDescriptor.getUUID());
            constraintDescriptorList.add(this.getConstraintDescriptors(tableDescriptor).getConstraintDescriptorById(subKeyConstraintDescriptor.getUUID()));
        }
        return constraintDescriptorList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getConstraints(UUID uUID, int n, int n2) throws StandardException {
        List list;
        GenericScanController genericScanController;
        block6: {
            ConglomerateController conglomerateController = null;
            genericScanController = null;
            TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
            SYSCONSTRAINTSRowFactory sYSCONSTRAINTSRowFactory = (SYSCONSTRAINTSRowFactory)tabInfoImpl.getCatalogRowFactory();
            Object var13_8 = null;
            list = DataDictionaryImpl.newSList();
            try {
                SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
                ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
                execIndexRow.setColumn(1, sQLChar);
                TransactionController transactionController = this.getTransactionCompile();
                ExecRow execRow = sYSCONSTRAINTSRowFactory.makeEmptyRow();
                conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4);
                ExecIndexRow execIndexRow2 = DataDictionaryImpl.getIndexRowFromHeapRow(tabInfoImpl.getIndexRowGenerator(n), conglomerateController.newRowLocationTemplate(), execRow);
                DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[7];
                FormatableBitSet formatableBitSet = new FormatableBitSet(7);
                formatableBitSet.set(n2 - 1);
                dataValueDescriptorArray[n2 - 1] = new SQLChar();
                genericScanController = transactionController.openScan(tabInfoImpl.getIndexConglomerate(n), false, 0, 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
                while (genericScanController.fetchNext(execIndexRow2.getRowArray())) {
                    RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
                    boolean bl = conglomerateController.fetch(rowLocation, dataValueDescriptorArray, formatableBitSet);
                    list.add(this.uuidFactory.recreateUUID((String)dataValueDescriptorArray[n2 - 1].getObject()));
                }
                Object var21_19 = null;
                if (conglomerateController == null) break block6;
            }
            catch (Throwable throwable) {
                Object var21_20 = null;
                if (conglomerateController != null) {
                    conglomerateController.close();
                }
                if (genericScanController != null) {
                    genericScanController.close();
                }
                throw throwable;
            }
            conglomerateController.close();
        }
        if (genericScanController != null) {
            genericScanController.close();
        }
        return list;
    }

    public void addConstraintDescriptor(ConstraintDescriptor constraintDescriptor, TransactionController transactionController) throws StandardException {
        Object var3_3 = null;
        int n = constraintDescriptor.getConstraintType();
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
        SYSCONSTRAINTSRowFactory sYSCONSTRAINTSRowFactory = (SYSCONSTRAINTSRowFactory)tabInfoImpl.getCatalogRowFactory();
        this.addDescriptor(constraintDescriptor, constraintDescriptor.getSchemaDescriptor(), 4, false, transactionController);
        switch (n) {
            case 2: 
            case 3: 
            case 6: {
                this.addSubKeyConstraint((KeyConstraintDescriptor)constraintDescriptor, transactionController);
                break;
            }
            case 4: {
                this.addDescriptor(constraintDescriptor, null, 9, true, transactionController);
            }
        }
    }

    public void updateConstraintDescriptor(ConstraintDescriptor constraintDescriptor, UUID uUID, int[] nArray, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
        SYSCONSTRAINTSRowFactory sYSCONSTRAINTSRowFactory = (SYSCONSTRAINTSRowFactory)tabInfoImpl.getCatalogRowFactory();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        ExecRow execRow = sYSCONSTRAINTSRowFactory.makeRow(constraintDescriptor, null);
        boolean[] blArray = new boolean[3];
        if (nArray == null) {
            blArray[0] = true;
            blArray[1] = true;
            blArray[2] = true;
        } else {
            block5: for (int i = 0; i < nArray.length; ++i) {
                switch (nArray[i]) {
                    case 1: {
                        blArray[0] = true;
                        continue block5;
                    }
                    case 3: 
                    case 5: {
                        blArray[1] = true;
                        continue block5;
                    }
                    case 2: {
                        blArray[2] = true;
                    }
                }
            }
        }
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController);
    }

    public void dropConstraintDescriptor(ConstraintDescriptor constraintDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
        switch (constraintDescriptor.getConstraintType()) {
            case 2: 
            case 3: 
            case 6: {
                this.dropSubKeyConstraint(constraintDescriptor, transactionController);
                break;
            }
            case 4: {
                this.dropSubCheckConstraint(constraintDescriptor.getUUID(), transactionController);
            }
        }
        SQLVarchar sQLVarchar = new SQLVarchar(constraintDescriptor.getConstraintName());
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(constraintDescriptor.getSchemaDescriptor().getUUID());
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 1);
    }

    public void dropAllConstraintDescriptors(TableDescriptor tableDescriptor, TransactionController transactionController) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList = this.getConstraintDescriptors(tableDescriptor);
        Iterator iterator = constraintDescriptorList.iterator();
        while (iterator.hasNext()) {
            ConstraintDescriptor constraintDescriptor = (ConstraintDescriptor)iterator.next();
            this.dropConstraintDescriptor(constraintDescriptor, transactionController);
        }
        tableDescriptor.setConstraintDescriptorList(null);
    }

    public SubKeyConstraintDescriptor getSubKeyConstraint(UUID uUID, int n) throws StandardException {
        int n2;
        int n3;
        SQLChar sQLChar = null;
        if (n == 6) {
            n3 = 10;
            n2 = 0;
        } else {
            n3 = 5;
            n2 = 0;
        }
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(n3);
        sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return (SubKeyConstraintDescriptor)this.getDescriptorViaIndex(n2, execIndexRow, null, tabInfoImpl, null, null, false);
    }

    private void addSubKeyConstraint(KeyConstraintDescriptor keyConstraintDescriptor, TransactionController transactionController) throws StandardException {
        ExecRow execRow;
        TabInfoImpl tabInfoImpl;
        if (keyConstraintDescriptor.getConstraintType() == 6) {
            ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)keyConstraintDescriptor;
            tabInfoImpl = this.getNonCoreTI(10);
            SYSFOREIGNKEYSRowFactory sYSFOREIGNKEYSRowFactory = (SYSFOREIGNKEYSRowFactory)tabInfoImpl.getCatalogRowFactory();
            execRow = sYSFOREIGNKEYSRowFactory.makeRow(foreignKeyConstraintDescriptor, null);
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = foreignKeyConstraintDescriptor.getReferencedConstraint();
            referencedKeyConstraintDescriptor.incrementReferenceCount();
            int[] nArray = new int[]{7};
            this.updateConstraintDescriptor(referencedKeyConstraintDescriptor, referencedKeyConstraintDescriptor.getUUID(), nArray, transactionController);
        } else {
            tabInfoImpl = this.getNonCoreTI(5);
            SYSKEYSRowFactory sYSKEYSRowFactory = (SYSKEYSRowFactory)tabInfoImpl.getCatalogRowFactory();
            execRow = sYSKEYSRowFactory.makeRow(keyConstraintDescriptor, null);
        }
        tabInfoImpl.insertRow(execRow, transactionController, true);
    }

    private void dropSubKeyConstraint(ConstraintDescriptor constraintDescriptor, TransactionController transactionController) throws StandardException {
        int n;
        int n2;
        ExecIndexRow execIndexRow = null;
        if (constraintDescriptor.getConstraintType() == 6) {
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor;
            n2 = 10;
            n = 0;
            if (constraintDescriptor.getConstraintType() == 6 && (referencedKeyConstraintDescriptor = (ReferencedKeyConstraintDescriptor)this.getConstraintDescriptor(((ForeignKeyConstraintDescriptor)constraintDescriptor).getReferencedConstraintId())) != null) {
                referencedKeyConstraintDescriptor.decrementReferenceCount();
                int[] nArray = new int[]{7};
                this.updateConstraintDescriptor(referencedKeyConstraintDescriptor, referencedKeyConstraintDescriptor.getUUID(), nArray, transactionController);
            }
        } else {
            n2 = 5;
            n = 0;
        }
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(n2);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(constraintDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, n);
    }

    private SubCheckConstraintDescriptor getSubCheckConstraint(UUID uUID) throws StandardException {
        SQLChar sQLChar = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(9);
        SYSCHECKSRowFactory sYSCHECKSRowFactory = (SYSCHECKSRowFactory)tabInfoImpl.getCatalogRowFactory();
        sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return (SubCheckConstraintDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, false);
    }

    private void dropSubCheckConstraint(UUID uUID, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(9);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    public Hashtable hashAllConglomerateDescriptorsByNumber(TransactionController transactionController) throws StandardException {
        Hashtable<Long, ConglomerateDescriptor> hashtable = new Hashtable<Long, ConglomerateDescriptor>();
        ConglomerateDescriptor conglomerateDescriptor = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SYSCONGLOMERATESRowFactory sYSCONGLOMERATESRowFactory = (SYSCONGLOMERATESRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecRow execRow = sYSCONGLOMERATESRowFactory.makeEmptyRow();
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 1, null, null, 1, null, null, -1);
        while (scanController.fetchNext(execRow.getRowArray())) {
            conglomerateDescriptor = (ConglomerateDescriptor)sYSCONGLOMERATESRowFactory.buildDescriptor(execRow, null, this);
            Long l = new Long(conglomerateDescriptor.getConglomerateNumber());
            hashtable.put(l, conglomerateDescriptor);
        }
        scanController.close();
        return hashtable;
    }

    public Hashtable hashAllTableDescriptorsByTableId(TransactionController transactionController) throws StandardException {
        Hashtable<UUID, TableDescriptor> hashtable = new Hashtable<UUID, TableDescriptor>();
        TabInfoImpl tabInfoImpl = this.coreInfo[1];
        SYSTABLESRowFactory sYSTABLESRowFactory = (SYSTABLESRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecRow execRow = sYSTABLESRowFactory.makeEmptyRow();
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 1, null, null, 1, null, null, -1);
        while (scanController.fetchNext(execRow.getRowArray())) {
            TableDescriptor tableDescriptor = (TableDescriptor)sYSTABLESRowFactory.buildDescriptor(execRow, null, this);
            hashtable.put(tableDescriptor.getUUID(), tableDescriptor);
        }
        scanController.close();
        return hashtable;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(UUID uUID) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.getConglomerateDescriptors(uUID);
        if (conglomerateDescriptorArray.length == 0) {
            return null;
        }
        return conglomerateDescriptorArray[0];
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        List list = DataDictionaryImpl.newSList();
        this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, list, false);
        ConglomerateDescriptor[] conglomerateDescriptorArray = new ConglomerateDescriptor[list.size()];
        list.toArray(conglomerateDescriptorArray);
        return conglomerateDescriptorArray;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(long l) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.getConglomerateDescriptors(l);
        if (conglomerateDescriptorArray.length == 0) {
            return null;
        }
        return conglomerateDescriptorArray[0];
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(long l) throws StandardException {
        NumberDataValue numberDataValue = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SYSCONGLOMERATESRowFactory sYSCONGLOMERATESRowFactory = (SYSCONGLOMERATESRowFactory)tabInfoImpl.getCatalogRowFactory();
        numberDataValue = this.dvf.getDataValue(l);
        ScanQualifier[][] scanQualifierArray = this.exFactory.getScanQualifier(1);
        scanQualifierArray[0][0].setQualifier(3 - 1, numberDataValue, 2, false, false, false);
        ConglomerateDescriptorList conglomerateDescriptorList = new ConglomerateDescriptorList();
        this.getDescriptorViaHeap(scanQualifierArray, tabInfoImpl, null, conglomerateDescriptorList);
        int n = conglomerateDescriptorList.size();
        ConglomerateDescriptor[] conglomerateDescriptorArray = new ConglomerateDescriptor[n];
        for (int i = 0; i < n; ++i) {
            conglomerateDescriptorArray[i] = (ConglomerateDescriptor)conglomerateDescriptorList.get(i);
        }
        return conglomerateDescriptorArray;
    }

    private void getConglomerateDescriptorsScan(TableDescriptor tableDescriptor) throws StandardException {
        ConglomerateDescriptorList conglomerateDescriptorList = tableDescriptor.getConglomerateDescriptorList();
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(tableDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getDescriptorViaIndex(2, execIndexRow, null, tabInfoImpl, null, conglomerateDescriptorList, false);
    }

    public ConglomerateDescriptor getConglomerateDescriptor(String string, SchemaDescriptor schemaDescriptor, boolean bl) throws StandardException {
        ExecIndexRow execIndexRow = null;
        SQLChar sQLChar = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        sQLChar = DataDictionaryImpl.getIDValueAsCHAR(schemaDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        return (ConglomerateDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, bl);
    }

    public void dropConglomerateDescriptor(ConglomerateDescriptor conglomerateDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        SQLChar sQLChar = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SQLVarchar sQLVarchar = new SQLVarchar(conglomerateDescriptor.getConglomerateName());
        sQLChar = DataDictionaryImpl.getIDValueAsCHAR(conglomerateDescriptor.getSchemaID());
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 1);
    }

    public void dropAllConglomerateDescriptors(TableDescriptor tableDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(tableDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 2);
    }

    public void updateConglomerateDescriptor(ConglomerateDescriptor conglomerateDescriptor, long l, TransactionController transactionController) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = new ConglomerateDescriptor[]{conglomerateDescriptor};
        this.updateConglomerateDescriptor(conglomerateDescriptorArray, l, transactionController);
    }

    public void updateSystemSchemaAuthorization(String string, TransactionController transactionController) throws StandardException {
        this.updateSchemaAuth("SYS", string, transactionController);
        this.updateSchemaAuth("SYSIBM", string, transactionController);
        this.updateSchemaAuth("SYSCAT", string, transactionController);
        this.updateSchemaAuth("SYSFUN", string, transactionController);
        this.updateSchemaAuth("SYSPROC", string, transactionController);
        this.updateSchemaAuth("SYSSTAT", string, transactionController);
        this.updateSchemaAuth("NULLID", string, transactionController);
        this.updateSchemaAuth("SQLJ", string, transactionController);
        this.updateSchemaAuth("SYSCS_DIAG", string, transactionController);
        this.updateSchemaAuth("SYSCS_UTIL", string, transactionController);
    }

    public void updateSchemaAuth(String string, String string2, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[3];
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLVarchar);
        SYSSCHEMASRowFactory sYSSCHEMASRowFactory = (SYSSCHEMASRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecRow execRow = sYSSCHEMASRowFactory.makeEmptyRow();
        execRow.setColumn(3, new SQLVarchar(string2));
        boolean[] blArray = new boolean[]{false, false};
        int[] nArray = new int[]{3};
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController);
    }

    public void updateConglomerateDescriptor(ConglomerateDescriptor[] conglomerateDescriptorArray, long l, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SYSCONGLOMERATESRowFactory sYSCONGLOMERATESRowFactory = (SYSCONGLOMERATESRowFactory)tabInfoImpl.getCatalogRowFactory();
        boolean[] blArray = new boolean[]{false, false, false};
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(conglomerateDescriptorArray[i].getUUID());
            execIndexRow = this.exFactory.getIndexableRow(1);
            execIndexRow.setColumn(1, sQLChar);
            conglomerateDescriptorArray[i].setConglomerateNumber(l);
            ExecRow execRow = sYSCONGLOMERATESRowFactory.makeRow(conglomerateDescriptorArray[i], null);
            tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, (int[])null, transactionController);
        }
    }

    public List getDependentsDescriptorList(String string) throws StandardException {
        List list = DataDictionaryImpl.newSList();
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(6);
        SQLChar sQLChar = new SQLChar(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, list, false);
        return list;
    }

    public List getProvidersDescriptorList(String string) throws StandardException {
        List list = DataDictionaryImpl.newSList();
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(6);
        SQLChar sQLChar = new SQLChar(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, list, false);
        return list;
    }

    public List getAllDependencyDescriptorsList() throws StandardException {
        List list = DataDictionaryImpl.newSList();
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(6);
        SYSDEPENDSRowFactory sYSDEPENDSRowFactory = (SYSDEPENDSRowFactory)tabInfoImpl.getCatalogRowFactory();
        TransactionController transactionController = this.getTransactionCompile();
        ExecRow execRow = sYSDEPENDSRowFactory.makeEmptyRow();
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 0, 7, 4, null, null, 1, null, null, -1);
        while (scanController.fetchNext(execRow.getRowArray())) {
            DependencyDescriptor dependencyDescriptor = (DependencyDescriptor)sYSDEPENDSRowFactory.buildDescriptor(execRow, null, this);
            list.add(dependencyDescriptor);
        }
        scanController.close();
        return list;
    }

    public void dropStoredDependency(DependencyDescriptor dependencyDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        UUID uUID = dependencyDescriptor.getUUID();
        UUID uUID2 = dependencyDescriptor.getProviderID();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(6);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        DropDependencyFilter dropDependencyFilter = new DropDependencyFilter(uUID2);
        tabInfoImpl.deleteRows(transactionController, execIndexRow, 1, null, dropDependencyFilter, execIndexRow, -1, 0);
    }

    public void dropDependentsStoredDependencies(UUID uUID, TransactionController transactionController) throws StandardException {
        this.dropDependentsStoredDependencies(uUID, transactionController, true);
    }

    public void dropDependentsStoredDependencies(UUID uUID, TransactionController transactionController, boolean bl) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(6);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0, bl);
    }

    public UUIDFactory getUUIDFactory() {
        return this.uuidFactory;
    }

    public AliasDescriptor getAliasDescriptor(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(7);
        SYSALIASESRowFactory sYSALIASESRowFactory = (SYSALIASESRowFactory)tabInfoImpl.getCatalogRowFactory();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return (AliasDescriptor)this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, false);
    }

    public AliasDescriptor getAliasDescriptor(String string, String string2, char c) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(7);
        SYSALIASESRowFactory sYSALIASESRowFactory = (SYSALIASESRowFactory)tabInfoImpl.getCatalogRowFactory();
        SQLVarchar sQLVarchar = new SQLVarchar(string2);
        char[] cArray = new char[]{c};
        SQLChar sQLChar = new SQLChar(new String(cArray));
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(3);
        execIndexRow.setColumn(1, new SQLChar(string));
        execIndexRow.setColumn(2, sQLVarchar);
        execIndexRow.setColumn(3, sQLChar);
        return (AliasDescriptor)this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, false);
    }

    public List getRoutineList(String string, String string2, char c) throws StandardException {
        ArrayList<AliasDescriptor> arrayList = new ArrayList<AliasDescriptor>();
        if (string.equals("c013800d-00fb-2642-07ec-000000134f30") && c == 'F') {
            for (int i = 0; i < SYSFUN_FUNCTIONS.length; ++i) {
                String[] stringArray = SYSFUN_FUNCTIONS[i];
                String string3 = stringArray[0];
                if (!string3.equals(string2)) continue;
                AliasDescriptor aliasDescriptor = SYSFUN_AD[i];
                if (aliasDescriptor == null) {
                    TypeDescriptor[] typeDescriptorArray;
                    int[] nArray;
                    int n;
                    String[] stringArray2;
                    DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(stringArray[1]);
                    String string4 = stringArray[4];
                    if (string4 != null) {
                        stringArray2 = SYSFUN_PNAME;
                        n = 1;
                        nArray = SYSFUN_PMODE;
                        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(string4)};
                    } else {
                        stringArray2 = null;
                        typeDescriptorArray = null;
                        n = 0;
                        nArray = null;
                    }
                    RoutineAliasInfo routineAliasInfo = new RoutineAliasInfo(stringArray[3], n, stringArray2, typeDescriptorArray, nArray, 0, 0, 3, false, dataTypeDescriptor);
                    DataDictionaryImpl.SYSFUN_AD[i] = aliasDescriptor = new AliasDescriptor(this, this.uuidFactory.createUUID(), string3, this.uuidFactory.recreateUUID(string), stringArray[2], 'F', 'F', true, routineAliasInfo, null);
                }
                arrayList.add(aliasDescriptor);
            }
            return arrayList;
        }
        AliasDescriptor aliasDescriptor = this.getAliasDescriptor(string, string2, c);
        if (aliasDescriptor != null) {
            arrayList.add(aliasDescriptor);
        }
        return arrayList;
    }

    public void dropAliasDescriptor(AliasDescriptor aliasDescriptor, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(7);
        char[] cArray = new char[]{aliasDescriptor.getNameSpace()};
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(3);
        execIndexRow.setColumn(1, DataDictionaryImpl.getIDValueAsCHAR(aliasDescriptor.getSchemaUUID()));
        execIndexRow.setColumn(2, new SQLVarchar(aliasDescriptor.getDescriptorName()));
        execIndexRow.setColumn(3, new SQLChar(new String(cArray)));
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    protected void loadDictionaryTables(TransactionController transactionController, DataDescriptorGenerator dataDescriptorGenerator, Properties properties) throws StandardException {
        this.loadCatalogs(dataDescriptorGenerator, this.coreInfo);
        this.dictionaryVersion = (DD_Version)transactionController.getProperty("DataDictionaryVersion");
        this.softwareVersion.upgradeIfNeeded(this.dictionaryVersion, transactionController, properties);
    }

    public void loadCatalogs(DataDescriptorGenerator dataDescriptorGenerator, TabInfoImpl[] tabInfoImplArray) throws StandardException {
        int n = tabInfoImplArray.length;
        for (int i = 0; i < n; ++i) {
            TabInfoImpl tabInfoImpl = tabInfoImplArray[i];
            int n2 = tabInfoImpl.getNumberOfIndexes();
            if (n2 <= 0) continue;
            for (int j = 0; j < n2; ++j) {
                this.initSystemIndexVariables(dataDescriptorGenerator, tabInfoImpl, j);
            }
        }
    }

    protected void createDictionaryTables(Properties properties, TransactionController transactionController, DataDescriptorGenerator dataDescriptorGenerator) throws StandardException {
        TabInfoImpl tabInfoImpl;
        int n;
        this.systemSchemaDesc = this.newSystemSchemaDesc(this.convertIdToLower ? StringUtil.SQLToLowerCase("SYS") : "SYS", "8000000d-00d0-fd77-3ed8-000a0a0b1900");
        for (n = 0; n < 4; ++n) {
            tabInfoImpl = this.coreInfo[n];
            Properties properties2 = tabInfoImpl.getCreateHeapProperties();
            tabInfoImpl.setHeapConglomerate(this.createConglomerate(tabInfoImpl.getTableName(), transactionController, tabInfoImpl.getCatalogRowFactory().makeEmptyRow(), properties2));
            if (this.coreInfo[n].getNumberOfIndexes() <= 0) continue;
            this.bootStrapSystemIndexes(this.systemSchemaDesc, transactionController, dataDescriptorGenerator, tabInfoImpl);
        }
        for (n = 0; n < 4; ++n) {
            tabInfoImpl = this.coreInfo[n];
            this.addSystemTableToDictionary(tabInfoImpl, this.systemSchemaDesc, transactionController, dataDescriptorGenerator);
        }
        properties.put(CFG_SYSTABLES_ID, Long.toString(this.coreInfo[1].getHeapConglomerate()));
        SYSTABLESRowFactory cfr_ignored_0 = (SYSTABLESRowFactory)this.coreInfo[1].getCatalogRowFactory();
        properties.put(CFG_SYSTABLES_INDEX1_ID, Long.toString(this.coreInfo[1].getIndexConglomerate(0)));
        SYSTABLESRowFactory cfr_ignored_1 = (SYSTABLESRowFactory)this.coreInfo[1].getCatalogRowFactory();
        properties.put(CFG_SYSTABLES_INDEX2_ID, Long.toString(this.coreInfo[1].getIndexConglomerate(1)));
        properties.put(CFG_SYSCOLUMNS_ID, Long.toString(this.coreInfo[2].getHeapConglomerate()));
        SYSCOLUMNSRowFactory cfr_ignored_2 = (SYSCOLUMNSRowFactory)this.coreInfo[2].getCatalogRowFactory();
        properties.put(CFG_SYSCOLUMNS_INDEX1_ID, Long.toString(this.coreInfo[2].getIndexConglomerate(0)));
        SYSCOLUMNSRowFactory cfr_ignored_3 = (SYSCOLUMNSRowFactory)this.coreInfo[2].getCatalogRowFactory();
        properties.put(CFG_SYSCOLUMNS_INDEX2_ID, Long.toString(this.coreInfo[2].getIndexConglomerate(1)));
        properties.put(CFG_SYSCONGLOMERATES_ID, Long.toString(this.coreInfo[0].getHeapConglomerate()));
        SYSCONGLOMERATESRowFactory cfr_ignored_4 = (SYSCONGLOMERATESRowFactory)this.coreInfo[0].getCatalogRowFactory();
        properties.put(CFG_SYSCONGLOMERATES_INDEX1_ID, Long.toString(this.coreInfo[0].getIndexConglomerate(0)));
        SYSCONGLOMERATESRowFactory cfr_ignored_5 = (SYSCONGLOMERATESRowFactory)this.coreInfo[0].getCatalogRowFactory();
        properties.put(CFG_SYSCONGLOMERATES_INDEX2_ID, Long.toString(this.coreInfo[0].getIndexConglomerate(1)));
        SYSCONGLOMERATESRowFactory cfr_ignored_6 = (SYSCONGLOMERATESRowFactory)this.coreInfo[0].getCatalogRowFactory();
        properties.put(CFG_SYSCONGLOMERATES_INDEX3_ID, Long.toString(this.coreInfo[0].getIndexConglomerate(2)));
        properties.put(CFG_SYSSCHEMAS_ID, Long.toString(this.coreInfo[3].getHeapConglomerate()));
        SYSSCHEMASRowFactory cfr_ignored_7 = (SYSSCHEMASRowFactory)this.coreInfo[3].getCatalogRowFactory();
        properties.put(CFG_SYSSCHEMAS_INDEX1_ID, Long.toString(this.coreInfo[3].getIndexConglomerate(0)));
        SYSSCHEMASRowFactory cfr_ignored_8 = (SYSSCHEMASRowFactory)this.coreInfo[3].getCatalogRowFactory();
        properties.put(CFG_SYSSCHEMAS_INDEX2_ID, Long.toString(this.coreInfo[3].getIndexConglomerate(1)));
        this.sysIBMSchemaDesc = this.addSystemSchema("SYSIBM", "c013800d-00f8-5b53-28a9-00000019ed88", transactionController);
        for (n = 0; n < NUM_NONCORE; ++n) {
            int n2 = n + 4;
            boolean bl = n2 == 15;
            TabInfoImpl tabInfoImpl2 = this.getNonCoreTIByNumber(n2);
            this.makeCatalog(tabInfoImpl2, bl ? this.sysIBMSchemaDesc : this.systemSchemaDesc, transactionController);
            if (bl) {
                this.populateSYSDUMMY1(transactionController);
            }
            this.clearNoncoreTable(n);
        }
        this.addDescriptor(this.systemSchemaDesc, null, 3, false, transactionController);
        this.addSystemSchema("SYSCAT", "c013800d-00fb-2641-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSFUN", "c013800d-00fb-2642-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSPROC", "c013800d-00fb-2643-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSSTAT", "c013800d-00fb-2644-07ec-000000134f30", transactionController);
        this.addSystemSchema("NULLID", "c013800d-00fb-2647-07ec-000000134f30", transactionController);
        this.addSystemSchema("SQLJ", "c013800d-00fb-2648-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSCS_DIAG", "c013800d-00fb-2646-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSCS_UTIL", "c013800d-00fb-2649-07ec-000000134f30", transactionController);
        SchemaDescriptor schemaDescriptor = new SchemaDescriptor(this, "APP", "APP", this.uuidFactory.recreateUUID("80000000-00d2-b38f-4cda-000a0a412c00"), false);
        this.addDescriptor(schemaDescriptor, null, 3, false, transactionController);
    }

    private SchemaDescriptor addSystemSchema(String string, String string2, TransactionController transactionController) throws StandardException {
        SchemaDescriptor schemaDescriptor = new SchemaDescriptor(this, this.convertIdToLower ? string.toLowerCase() : string, this.authorizationDatabaseOwner, this.uuidFactory.recreateUUID(string2), true);
        this.addDescriptor(schemaDescriptor, null, 3, false, transactionController);
        return schemaDescriptor;
    }

    protected void upgradeMakeCatalog(TransactionController transactionController, int n) throws StandardException {
        TabInfoImpl tabInfoImpl = n >= 4 ? this.getNonCoreTIByNumber(n) : this.coreInfo[n];
        this.makeCatalog(tabInfoImpl, n == 15 ? this.getSysIBMSchemaDescriptor() : this.getSystemSchemaDescriptor(), transactionController);
    }

    public void makeCatalog(TabInfoImpl tabInfoImpl, SchemaDescriptor schemaDescriptor, TransactionController transactionController) throws StandardException {
        DataDescriptorGenerator dataDescriptorGenerator = this.getDataDescriptorGenerator();
        Properties properties = tabInfoImpl.getCreateHeapProperties();
        tabInfoImpl.setHeapConglomerate(this.createConglomerate(tabInfoImpl.getTableName(), transactionController, tabInfoImpl.getCatalogRowFactory().makeEmptyRow(), properties));
        if (tabInfoImpl.getNumberOfIndexes() > 0) {
            this.bootStrapSystemIndexes(schemaDescriptor, transactionController, dataDescriptorGenerator, tabInfoImpl);
        }
        this.addSystemTableToDictionary(tabInfoImpl, schemaDescriptor, transactionController, dataDescriptorGenerator);
    }

    public void upgrade_setNullability(CatalogRowFactory catalogRowFactory, int n, boolean bl, TransactionController transactionController) throws StandardException {
        SystemColumn[] systemColumnArray = catalogRowFactory.buildColumnList();
        SchemaDescriptor schemaDescriptor = this.getSystemSchemaDescriptor();
        TableDescriptor tableDescriptor = this.getTableDescriptor(catalogRowFactory.getCatalogName(), schemaDescriptor);
        SystemColumn systemColumn = systemColumnArray[n - 1];
        ColumnDescriptor columnDescriptor = this.makeColumnDescriptor(systemColumn, n, tableDescriptor);
        String string = columnDescriptor.getColumnName();
        columnDescriptor.getType().setNullability(bl);
        int[] nArray = new int[]{4};
        this.updateColumnDescriptor(columnDescriptor, tableDescriptor.getUUID(), string, nArray, transactionController, true);
    }

    public void upgrade_addColumns(CatalogRowFactory catalogRowFactory, int[] nArray, TransactionController transactionController) throws StandardException {
        long l;
        TableDescriptor tableDescriptor;
        SystemColumn[] systemColumnArray = catalogRowFactory.buildColumnList();
        ExecRow execRow = catalogRowFactory.makeEmptyRow();
        int n = nArray.length;
        SchemaDescriptor schemaDescriptor = this.getSystemSchemaDescriptor();
        if (catalogRowFactory instanceof SYSTABLESRowFactory) {
            tableDescriptor = this.dataDescriptorGenerator.newTableDescriptor("SYSTABLES", schemaDescriptor, 0, 'R');
            tableDescriptor.setUUID(this.getUUIDForCoreTable("SYSTABLES", schemaDescriptor.getUUID().toString(), transactionController));
            l = this.coreInfo[1].getHeapConglomerate();
        } else if (catalogRowFactory instanceof SYSCOLUMNSRowFactory) {
            tableDescriptor = this.dataDescriptorGenerator.newTableDescriptor("SYSCOLUMNS", schemaDescriptor, 0, 'R');
            tableDescriptor.setUUID(this.getUUIDForCoreTable("SYSCOLUMNS", schemaDescriptor.getUUID().toString(), transactionController));
            l = this.coreInfo[2].getHeapConglomerate();
        } else {
            tableDescriptor = this.getTableDescriptor(catalogRowFactory.getCatalogName(), schemaDescriptor);
            l = tableDescriptor.getHeapConglomerateId();
        }
        this.widenConglomerate(execRow, nArray, l, transactionController);
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[n];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            SystemColumn systemColumn = systemColumnArray[n2 - 1];
            tupleDescriptorArray[i] = this.makeColumnDescriptor(systemColumn, i + 1, tableDescriptor);
        }
        this.addDescriptorArray(tupleDescriptorArray, tableDescriptor, 2, false, transactionController);
    }

    public void upgrade_addInvisibleColumns(CatalogRowFactory catalogRowFactory, int[] nArray, TransactionController transactionController) throws StandardException {
        ExecRow execRow = catalogRowFactory.makeEmptyRow();
        SchemaDescriptor schemaDescriptor = this.getSystemSchemaDescriptor();
        long l = this.getTableDescriptor(catalogRowFactory.getCatalogName(), schemaDescriptor).getHeapConglomerateId();
        this.widenConglomerate(execRow, nArray, l, transactionController);
    }

    private void widenConglomerate(ExecRow execRow, int[] nArray, long l, TransactionController transactionController) throws StandardException {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = n2 - 1;
            transactionController.addColumnToConglomerate(l, n3, execRow.getColumn(n2), 0);
        }
    }

    public long upgrade_makeOneIndex(TransactionController transactionController, TabInfoImpl tabInfoImpl, int n, long l) throws StandardException {
        SchemaDescriptor schemaDescriptor = this.getSystemSchemaDescriptor();
        DataDescriptorGenerator dataDescriptorGenerator = this.getDataDescriptorGenerator();
        ConglomerateDescriptor conglomerateDescriptor = this.bootstrapOneIndex(schemaDescriptor, transactionController, dataDescriptorGenerator, tabInfoImpl, n, l);
        long l2 = conglomerateDescriptor.getConglomerateNumber();
        this.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
        return l2;
    }

    private UUID getUUIDForCoreTable(String string, String string2, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[1];
        SYSTABLESRowFactory sYSTABLESRowFactory = (SYSTABLESRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecRow execRow = this.exFactory.getValueRow(1);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLChar sQLChar = new SQLChar(string2);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        ConglomerateController conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4);
        ExecIndexRow execIndexRow2 = sYSTABLESRowFactory.buildEmptyIndexRow(0, conglomerateController.newRowLocationTemplate());
        ScanController scanController = transactionController.openScan(tabInfoImpl.getIndexConglomerate(0), false, 0, 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
        if (scanController.fetchNext(execIndexRow2.getRowArray())) {
            RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
            execRow.setColumn(1, new SQLChar());
            FormatableBitSet formatableBitSet = new FormatableBitSet(1);
            formatableBitSet.set(0);
            boolean bl = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
        }
        scanController.close();
        conglomerateController.close();
        return this.uuidFactory.recreateUUID(execRow.getColumn(1).toString());
    }

    void upgrade_initSystemTableCols(TransactionController transactionController, boolean bl, int n, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        TabInfoImpl tabInfoImpl;
        TabInfoImpl tabInfoImpl2 = tabInfoImpl = bl ? this.coreInfo[n] : this.getNonCoreTIByNumber(n);
        if (!bl) {
            this.faultInTabInfo(tabInfoImpl);
        }
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 4, 7, 4, RowUtil.EMPTY_ROW_BITSET, null, 0, null, null, 0);
        while (scanController.next()) {
            scanController.replace(dataValueDescriptorArray, formatableBitSet);
        }
        scanController.close();
    }

    private void bootStrapSystemIndexes(SchemaDescriptor schemaDescriptor, TransactionController transactionController, DataDescriptorGenerator dataDescriptorGenerator, TabInfoImpl tabInfoImpl) throws StandardException {
        int n;
        ConglomerateDescriptor[] conglomerateDescriptorArray = new ConglomerateDescriptor[tabInfoImpl.getNumberOfIndexes()];
        for (n = 0; n < tabInfoImpl.getNumberOfIndexes(); ++n) {
            conglomerateDescriptorArray[n] = this.bootstrapOneIndex(schemaDescriptor, transactionController, dataDescriptorGenerator, tabInfoImpl, n, tabInfoImpl.getHeapConglomerate());
        }
        for (n = 0; n < tabInfoImpl.getNumberOfIndexes(); ++n) {
            this.addDescriptor(conglomerateDescriptorArray[n], schemaDescriptor, 0, false, transactionController);
        }
    }

    public RowLocation[] computeAutoincRowLocations(TransactionController transactionController, TableDescriptor tableDescriptor) throws StandardException {
        if (!tableDescriptor.tableHasAutoincrement()) {
            return null;
        }
        int n = tableDescriptor.getNumberOfColumns();
        RowLocation[] rowLocationArray = new RowLocation[n];
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(i + 1);
            if (!columnDescriptor.isAutoincrement()) continue;
            rowLocationArray[i] = this.computeRowLocation(transactionController, tableDescriptor, columnDescriptor.getColumnName());
        }
        return rowLocationArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberDataValue getSetAutoincrementValue(RowLocation rowLocation, TransactionController transactionController, boolean bl, NumberDataValue numberDataValue, boolean bl2) throws StandardException {
        FormatableBitSet formatableBitSet = new FormatableBitSet(9);
        int n = 7;
        TabInfoImpl tabInfoImpl = this.coreInfo[2];
        ConglomerateController conglomerateController = null;
        SYSCOLUMNSRowFactory sYSCOLUMNSRowFactory = (SYSCOLUMNSRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecRow execRow = sYSCOLUMNSRowFactory.makeEmptyRow();
        FormatableBitSet formatableBitSet2 = new FormatableBitSet(9);
        formatableBitSet2.set(n - 1);
        formatableBitSet2.set(n);
        formatableBitSet2.set(n + 1);
        try {
            conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 4 | (bl2 ? 0 : 128), 6, 4);
            boolean bl3 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), formatableBitSet2, bl2);
            formatableBitSet.set(n - 1);
            NumberDataValue numberDataValue2 = (NumberDataValue)execRow.getColumn(n);
            long l = numberDataValue2.getLong();
            NumberDataValue numberDataValue3 = (NumberDataValue)execRow.getColumn(n + 2);
            if (bl) {
                numberDataValue2 = numberDataValue2.plus(numberDataValue2, numberDataValue3, numberDataValue2);
                execRow.setColumn(n, numberDataValue2);
                conglomerateController.replace(rowLocation, execRow.getRowArray(), formatableBitSet);
            }
            if (numberDataValue != null) {
                numberDataValue.setValue(l);
                NumberDataValue numberDataValue4 = numberDataValue;
                return numberDataValue4;
            }
            numberDataValue2.setValue(l);
            NumberDataValue numberDataValue5 = numberDataValue2;
            return numberDataValue5;
        }
        finally {
            if (conglomerateController != null) {
                conglomerateController.close();
            }
        }
    }

    private ConglomerateDescriptor bootstrapOneIndex(SchemaDescriptor schemaDescriptor, TransactionController transactionController, DataDescriptorGenerator dataDescriptorGenerator, TabInfoImpl tabInfoImpl, int n, long l) throws StandardException {
        CatalogRowFactory catalogRowFactory = tabInfoImpl.getCatalogRowFactory();
        this.initSystemIndexVariables(dataDescriptorGenerator, tabInfoImpl, n);
        IndexRowGenerator indexRowGenerator = tabInfoImpl.getIndexRowGenerator(n);
        int n2 = tabInfoImpl.getIndexColumnCount(n);
        boolean bl = tabInfoImpl.isIndexUnique(n);
        ExecIndexRow execIndexRow = indexRowGenerator.getIndexRowTemplate();
        ExecRow execRow = catalogRowFactory.makeEmptyRow();
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, 0, 6, 4);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        conglomerateController.close();
        indexRowGenerator.getIndexRow(execRow, rowLocation, execIndexRow, null);
        Properties properties = tabInfoImpl.getCreateIndexProperties(n);
        properties.put("baseConglomerateId", Long.toString(l));
        properties.put("nUniqueColumns", Integer.toString(bl ? n2 : n2 + 1));
        properties.put("rowLocationColumn", Integer.toString(n2));
        properties.put("nKeyFields", Integer.toString(n2 + 1));
        long l2 = transactionController.createConglomerate("BTREE", execIndexRow.getRowArray(), null, null, properties, 0);
        ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(l2, catalogRowFactory.getIndexName(n), true, indexRowGenerator, false, catalogRowFactory.getCanonicalIndexUUID(n), catalogRowFactory.getCanonicalTableUUID(), schemaDescriptor.getUUID());
        tabInfoImpl.setIndexConglomerate(conglomerateDescriptor);
        return conglomerateDescriptor;
    }

    public void initSystemIndexVariables(DataDescriptorGenerator dataDescriptorGenerator, TabInfoImpl tabInfoImpl, int n) throws StandardException {
        int n2 = tabInfoImpl.getIndexColumnCount(n);
        int[] nArray = new int[n2];
        CatalogRowFactory catalogRowFactory = tabInfoImpl.getCatalogRowFactory();
        for (int i = 0; i < n2; ++i) {
            nArray[i] = tabInfoImpl.getBaseColumnPosition(n, i);
        }
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            blArray[i] = true;
        }
        tabInfoImpl.setIndexRowGenerator(n, new IndexRowGenerator("BTREE", tabInfoImpl.isIndexUnique(n), nArray, blArray, nArray.length));
    }

    protected void populateSYSDUMMY1(TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(15);
        ExecRow execRow = tabInfoImpl.getCatalogRowFactory().makeRow(null, null);
        int n = tabInfoImpl.insertRow(execRow, transactionController, true);
    }

    public void clearCaches() throws StandardException {
        this.nameTdCache.cleanAll();
        this.nameTdCache.ageOut();
        this.OIDTdCache.cleanAll();
        this.OIDTdCache.ageOut();
        if (this.spsNameCache != null) {
            this.spsNameCache.cleanAll();
            this.spsNameCache.ageOut();
            this.spsIdHash.clear();
        }
    }

    private void addSystemTableToDictionary(TabInfoImpl tabInfoImpl, SchemaDescriptor schemaDescriptor, TransactionController transactionController, DataDescriptorGenerator dataDescriptorGenerator) throws StandardException {
        CatalogRowFactory catalogRowFactory = tabInfoImpl.getCatalogRowFactory();
        String string = tabInfoImpl.getTableName();
        long l = tabInfoImpl.getHeapConglomerate();
        SystemColumn[] systemColumnArray = catalogRowFactory.buildColumnList();
        UUID uUID = catalogRowFactory.getCanonicalHeapUUID();
        String string2 = catalogRowFactory.getCanonicalHeapName();
        int n = systemColumnArray.length;
        TableDescriptor tableDescriptor = dataDescriptorGenerator.newTableDescriptor(string, schemaDescriptor, 1, 'R');
        tableDescriptor.setUUID(catalogRowFactory.getCanonicalTableUUID());
        this.addDescriptor(tableDescriptor, schemaDescriptor, 1, false, transactionController);
        UUID uUID2 = tableDescriptor.getUUID();
        ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(l, string2, false, null, false, uUID, uUID2, schemaDescriptor.getUUID());
        this.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[n];
        for (int i = 0; i < n; ++i) {
            SystemColumn systemColumn = systemColumnArray[i];
            tupleDescriptorArray[i] = this.makeColumnDescriptor(systemColumn, i + 1, tableDescriptor);
        }
        this.addDescriptorArray(tupleDescriptorArray, tableDescriptor, 2, false, transactionController);
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        for (int i = 0; i < n; ++i) {
            columnDescriptorList.add(tupleDescriptorArray[i]);
        }
    }

    private ColumnDescriptor makeColumnDescriptor(SystemColumn systemColumn, int n, TableDescriptor tableDescriptor) throws StandardException {
        return new ColumnDescriptor(systemColumn.getName(), n, systemColumn.getType(), null, null, tableDescriptor, (UUID)null, 0L, 0L);
    }

    private long createConglomerate(String string, TransactionController transactionController, ExecRow execRow, Properties properties) throws StandardException {
        long l = transactionController.createConglomerate("heap", execRow.getRowArray(), null, null, properties, 0);
        return l;
    }

    private static SQLChar getIDValueAsCHAR(UUID uUID) {
        String string = uUID.toString();
        return new SQLChar(string);
    }

    public void initializeCatalogInfo() throws StandardException {
        this.initializeCoreInfo();
        this.initializeNoncoreInfo();
    }

    private void initializeCoreInfo() throws StandardException {
        this.coreInfo = new TabInfoImpl[4];
        TabInfoImpl[] tabInfoImplArray = this.coreInfo;
        UUIDFactory uUIDFactory = this.uuidFactory;
        tabInfoImplArray[1] = new TabInfoImpl(new SYSTABLESRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
        tabInfoImplArray[2] = new TabInfoImpl(new SYSCOLUMNSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
        tabInfoImplArray[0] = new TabInfoImpl(new SYSCONGLOMERATESRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
        tabInfoImplArray[3] = new TabInfoImpl(new SYSSCHEMASRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
    }

    private void initializeNoncoreInfo() throws StandardException {
        this.noncoreInfo = new TabInfoImpl[NUM_NONCORE];
    }

    public TransactionController getTransactionCompile() throws StandardException {
        if (this.bootingTC != null) {
            return this.bootingTC;
        }
        LanguageConnectionContext languageConnectionContext = DataDictionaryImpl.getLCC();
        return languageConnectionContext.getTransactionCompile();
    }

    public TransactionController getTransactionExecute() throws StandardException {
        if (this.bootingTC != null) {
            return this.bootingTC;
        }
        LanguageConnectionContext languageConnectionContext = DataDictionaryImpl.getLCC();
        return languageConnectionContext.getTransactionExecute();
    }

    private final TupleDescriptor getDescriptorViaIndex(int n, ExecIndexRow execIndexRow, ScanQualifier[][] scanQualifierArray, TabInfoImpl tabInfoImpl, TupleDescriptor tupleDescriptor, List list, boolean bl) throws StandardException {
        CatalogRowFactory catalogRowFactory = tabInfoImpl.getCatalogRowFactory();
        TupleDescriptor tupleDescriptor2 = null;
        TransactionController transactionController = this.getTransactionCompile();
        ExecRow execRow = catalogRowFactory.makeEmptyRow();
        ConglomerateController conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4);
        ScanController scanController = transactionController.openScan(tabInfoImpl.getIndexConglomerate(n), false, bl ? 4 : 0, 6, 4, null, execIndexRow.getRowArray(), 1, scanQualifierArray, execIndexRow.getRowArray(), -1);
        while (scanController.next()) {
            ExecIndexRow execIndexRow2 = DataDictionaryImpl.getIndexRowFromHeapRow(tabInfoImpl.getIndexRowGenerator(n), conglomerateController.newRowLocationTemplate(), execRow);
            scanController.fetch(execIndexRow2.getRowArray());
            RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
            boolean bl2 = false;
            try {
                bl2 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (StandardException standardException) {
                throw standardException;
            }
            tupleDescriptor2 = catalogRowFactory.buildDescriptor(execRow, tupleDescriptor, this);
            if (list == null) break;
            list.add(tupleDescriptor2);
        }
        scanController.close();
        conglomerateController.close();
        return tupleDescriptor2;
    }

    private void debugGenerateInfo(StringBuffer stringBuffer, TransactionController transactionController, ConglomerateController conglomerateController, TabInfoImpl tabInfoImpl, int n) {
    }

    protected TupleDescriptor getDescriptorViaHeap(ScanQualifier[][] scanQualifierArray, TabInfoImpl tabInfoImpl, TupleDescriptor tupleDescriptor, List list) throws StandardException {
        CatalogRowFactory catalogRowFactory = tabInfoImpl.getCatalogRowFactory();
        TupleDescriptor tupleDescriptor2 = null;
        TransactionController transactionController = this.getTransactionCompile();
        ExecRow execRow = catalogRowFactory.makeEmptyRow();
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 0, 7, 4, null, null, 0, scanQualifierArray, null, 0);
        while (scanController.fetchNext(execRow.getRowArray())) {
            tupleDescriptor2 = catalogRowFactory.buildDescriptor(execRow, tupleDescriptor, this);
            if (list == null) break;
            list.add(tupleDescriptor2);
        }
        scanController.close();
        return tupleDescriptor2;
    }

    private TabInfoImpl getNonCoreTI(int n) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTIByNumber(n);
        this.faultInTabInfo(tabInfoImpl);
        return tabInfoImpl;
    }

    protected TabInfoImpl getNonCoreTIByNumber(int n) throws StandardException {
        int n2 = n - 4;
        TabInfoImpl tabInfoImpl = this.noncoreInfo[n2];
        if (tabInfoImpl == null) {
            UUIDFactory uUIDFactory = this.uuidFactory;
            switch (n) {
                case 4: {
                    tabInfoImpl = new TabInfoImpl(new SYSCONSTRAINTSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 5: {
                    tabInfoImpl = new TabInfoImpl(new SYSKEYSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 6: {
                    tabInfoImpl = new TabInfoImpl(new SYSDEPENDSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 8: {
                    tabInfoImpl = new TabInfoImpl(new SYSVIEWSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 9: {
                    tabInfoImpl = new TabInfoImpl(new SYSCHECKSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 10: {
                    tabInfoImpl = new TabInfoImpl(new SYSFOREIGNKEYSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 11: {
                    tabInfoImpl = new TabInfoImpl(new SYSSTATEMENTSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 12: {
                    tabInfoImpl = new TabInfoImpl(new SYSFILESRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 7: {
                    tabInfoImpl = new TabInfoImpl(new SYSALIASESRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 13: {
                    tabInfoImpl = new TabInfoImpl(new SYSTRIGGERSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 14: {
                    tabInfoImpl = new TabInfoImpl(new SYSSTATISTICSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 15: {
                    tabInfoImpl = new TabInfoImpl(new SYSDUMMY1RowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 16: {
                    tabInfoImpl = new TabInfoImpl(new SYSTABLEPERMSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 17: {
                    tabInfoImpl = new TabInfoImpl(new SYSCOLPERMSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                    break;
                }
                case 18: {
                    tabInfoImpl = new TabInfoImpl(new SYSROUTINEPERMSRowFactory(uUIDFactory, this.exFactory, this.dvf, this.convertIdToLower));
                }
            }
            this.initSystemIndexVariables(tabInfoImpl);
            this.noncoreInfo[n2] = tabInfoImpl;
        }
        return tabInfoImpl;
    }

    protected void initSystemIndexVariables(TabInfoImpl tabInfoImpl) throws StandardException {
        int n = tabInfoImpl.getNumberOfIndexes();
        if (n > 0) {
            DataDescriptorGenerator dataDescriptorGenerator = this.getDataDescriptorGenerator();
            for (int i = 0; i < n; ++i) {
                this.initSystemIndexVariables(dataDescriptorGenerator, tabInfoImpl, i);
            }
        }
    }

    private void clearNoncoreTable(int n) {
        this.noncoreInfo[n] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void faultInTabInfo(TabInfoImpl tabInfoImpl) throws StandardException {
        if (tabInfoImpl.isComplete()) {
            return;
        }
        TabInfoImpl tabInfoImpl2 = tabInfoImpl;
        synchronized (tabInfoImpl2) {
            int n;
            if (tabInfoImpl.isComplete()) {
                return;
            }
            TableDescriptor tableDescriptor = this.getTableDescriptor(tabInfoImpl.getTableName(), this.getSystemSchemaDescriptor());
            if (tableDescriptor == null) {
                return;
            }
            ConglomerateDescriptor conglomerateDescriptor = null;
            ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
            for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
                conglomerateDescriptor = conglomerateDescriptorArray[i];
                if (conglomerateDescriptor.isIndex()) continue;
                tabInfoImpl.setHeapConglomerate(conglomerateDescriptor.getConglomerateNumber());
                break;
            }
            if ((n = tabInfoImpl.getCatalogRowFactory().getNumIndexes()) == 0) {
                return;
            }
            ConglomerateDescriptor conglomerateDescriptor2 = null;
            int n2 = 0;
            for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
                conglomerateDescriptor2 = conglomerateDescriptorArray[i];
                if (!conglomerateDescriptor2.isIndex()) continue;
                tabInfoImpl.setIndexConglomerate(conglomerateDescriptor2);
                ++n2;
            }
        }
    }

    public static ExecIndexRow getIndexRowFromHeapRow(IndexRowGenerator indexRowGenerator, RowLocation rowLocation, ExecRow execRow) throws StandardException {
        ExecIndexRow execIndexRow = indexRowGenerator.getIndexRowTemplate();
        indexRowGenerator.getIndexRow(execRow, rowLocation, execIndexRow, null);
        return execIndexRow;
    }

    public int getEngineType() {
        return this.engineType;
    }

    public long getSYSCOLUMNSHeapConglomerateNumber() {
        return this.coreInfo[2].getHeapConglomerate();
    }

    void addSYSCOLUMNSIndex2Property(TransactionController transactionController, long l) {
        this.startupParameters.put(CFG_SYSCOLUMNS_INDEX2_ID, Long.toString(l));
    }

    private long getBootParameter(Properties properties, String string, boolean bl) throws StandardException {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            if (!bl) {
                return -1L;
            }
            throw StandardException.newException("XCY03.S", string);
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("XCY00.S", (Object)string, (Object)string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSystemSQLName() {
        StringBuffer stringBuffer = new StringBuffer("SQL");
        DataDictionaryImpl dataDictionaryImpl = this;
        synchronized (dataDictionaryImpl) {
            long l = System.currentTimeMillis() / 10L * 10L;
            if (l > this.timeForLastSystemSQLName) {
                this.systemSQLNameNumber = 0;
                this.calendarForLastSystemSQLName.setTimeInMillis(l);
                this.timeForLastSystemSQLName = l;
            } else {
                ++this.systemSQLNameNumber;
                if (this.systemSQLNameNumber == 10) {
                    this.systemSQLNameNumber = 0;
                    this.timeForLastSystemSQLName += 10L;
                    this.calendarForLastSystemSQLName.setTimeInMillis(this.timeForLastSystemSQLName);
                }
            }
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(1)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(2) + 1));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(5)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(11)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(12)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(13)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(14) / 10));
            stringBuffer.append(this.systemSQLNameNumber);
        }
        return stringBuffer.toString();
    }

    private static String twoDigits(int n) {
        String string;
        if (n < 10) {
            string = "0" + n;
        } else {
            int n2 = Integer.toString(n).length();
            string = Integer.toString(n).substring(n2 - 2);
        }
        return string;
    }

    public void setAutoincrementValue(TransactionController transactionController, UUID uUID, String string, long l, boolean bl) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[2];
        ExecIndexRow execIndexRow = null;
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, DataDictionaryImpl.getIDValueAsCHAR(uUID));
        execIndexRow.setColumn(2, new SQLChar(string));
        SYSCOLUMNSRowFactory sYSCOLUMNSRowFactory = (SYSCOLUMNSRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecRow execRow = sYSCOLUMNSRowFactory.makeEmptyRow();
        boolean[] blArray = new boolean[2];
        for (int i = 0; i < 2; ++i) {
            blArray[i] = false;
        }
        int[] nArray = new int[]{7};
        if (bl) {
            ExecRow execRow2 = tabInfoImpl.getRow(transactionController, execIndexRow, 0);
            NumberDataValue numberDataValue = (NumberDataValue)execRow2.getColumn(9);
            l += numberDataValue.getLong();
        }
        execRow.setColumn(7, this.dvf.getDataValue(l));
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController);
    }

    private RowLocation computeRowLocation(TransactionController transactionController, TableDescriptor tableDescriptor, String string) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[2];
        ExecIndexRow execIndexRow = null;
        UUID uUID = tableDescriptor.getUUID();
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, DataDictionaryImpl.getIDValueAsCHAR(uUID));
        execIndexRow.setColumn(2, new SQLChar(string));
        return tabInfoImpl.getRowLocation(transactionController, execIndexRow, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowLocation getRowLocationTemplate(LanguageConnectionContext languageConnectionContext, TableDescriptor tableDescriptor) throws StandardException {
        RowLocation rowLocation;
        ConglomerateController conglomerateController = null;
        TransactionController transactionController = languageConnectionContext.getTransactionCompile();
        long l = tableDescriptor.getHeapConglomerateId();
        conglomerateController = transactionController.openConglomerate(l, false, 0, 6, 2);
        try {
            rowLocation = conglomerateController.newRowLocationTemplate();
        }
        finally {
            conglomerateController.close();
        }
        return rowLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableDescriptorToOtherCache(TableDescriptor tableDescriptor, Cacheable cacheable) throws StandardException {
        CacheManager cacheManager = cacheable instanceof OIDTDCacheable ? this.nameTdCache : this.OIDTdCache;
        TDCacheable tDCacheable = null;
        Object object = cacheManager == this.nameTdCache ? new TableKey(tableDescriptor.getSchemaDescriptor().getUUID(), tableDescriptor.getName()) : tableDescriptor.getUUID();
        try {
            tDCacheable = (TDCacheable)cacheManager.create(object, tableDescriptor);
        }
        catch (StandardException standardException) {
            if (!standardException.getMessageId().equals("XBCA0.S")) {
                throw standardException;
            }
        }
        finally {
            if (tDCacheable != null) {
                cacheManager.release(tDCacheable);
            }
        }
    }

    public void dropStatisticsDescriptors(UUID uUID, UUID uUID2, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(14);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        if (uUID2 != null) {
            execIndexRow = this.exFactory.getIndexableRow(2);
            SQLChar sQLChar2 = DataDictionaryImpl.getIDValueAsCHAR(uUID2);
            execIndexRow.setColumn(2, sQLChar2);
        } else {
            execIndexRow = this.exFactory.getIndexableRow(1);
        }
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    private static LanguageConnectionContext getLCC() {
        return (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
    }

    private SchemaDescriptor newSystemSchemaDesc(String string, String string2) {
        return new SchemaDescriptor(this, string, this.authorizationDatabaseOwner, this.uuidFactory.recreateUUID(string2), true);
    }

    private SchemaDescriptor newDeclaredGlobalTemporaryTablesSchemaDesc(String string) {
        return new SchemaDescriptor(this, string, this.authorizationDatabaseOwner, null, false);
    }

    public boolean checkVersion(int n, String string) throws StandardException {
        if (n == -1) {
            n = this.softwareVersion.majorVersionNumber;
        }
        return this.dictionaryVersion.checkVersion(n, string);
    }

    void createSystemSps(TransactionController transactionController) throws StandardException {
        this.createSPSSet(transactionController, false, this.getSystemSchemaDescriptor().getUUID());
        this.createSPSSet(transactionController, true, this.getSysIBMSchemaDescriptor().getUUID());
    }

    protected void createSPSSet(TransactionController transactionController, boolean bl, UUID uUID) throws StandardException {
        Properties properties = this.getQueryDescriptions(bl);
        Enumeration<Object> enumeration = properties.keys();
        boolean bl2 = true;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            SPSDescriptor sPSDescriptor = new SPSDescriptor(this, string, this.getUUIDFactory().createUUID(), uUID, uUID, 'S', !bl2, string2, !bl2);
            this.addSPSDescriptor(sPSDescriptor, transactionController, true);
        }
    }

    private final UUID createSystemProcedureOrFunction(String string, UUID uUID, String[] stringArray, TypeDescriptor[] typeDescriptorArray, int n, int n2, short s, TypeDescriptor typeDescriptor, TransactionController transactionController, String string2) throws StandardException {
        int n3 = 0;
        if (stringArray != null) {
            n3 = stringArray.length;
        }
        int[] nArray = null;
        if (n3 != 0) {
            int n4;
            nArray = new int[n3];
            int n5 = n3 - n;
            for (n4 = 0; n4 < n5; ++n4) {
                nArray[n4] = 1;
            }
            for (n4 = 0; n4 < n; ++n4) {
                nArray[n5 + n4] = 4;
            }
        }
        RoutineAliasInfo routineAliasInfo = new RoutineAliasInfo(string, n3, stringArray, typeDescriptorArray, nArray, n2, 0, s, true, typeDescriptor);
        UUID uUID2 = this.getUUIDFactory().createUUID();
        AliasDescriptor aliasDescriptor = new AliasDescriptor(this, uUID2, string, uUID, string2, typeDescriptor == null ? (char)'P' : 'F', typeDescriptor == null ? (char)'P' : 'F', false, routineAliasInfo, null);
        this.addDescriptor(aliasDescriptor, null, 7, false, transactionController);
        return uUID2;
    }

    private final UUID createSystemProcedureOrFunction(String string, UUID uUID, String[] stringArray, TypeDescriptor[] typeDescriptorArray, int n, int n2, short s, TypeDescriptor typeDescriptor, TransactionController transactionController) throws StandardException {
        UUID uUID2 = this.createSystemProcedureOrFunction(string, uUID, stringArray, typeDescriptorArray, n, n2, s, typeDescriptor, transactionController, "org.apache.derby.catalog.SystemProcedures");
        return uUID2;
    }

    private final void create_SYSCS_procedures(TransactionController transactionController) throws StandardException {
        UUID uUID = null;
        UUID uUID2 = this.getSystemUtilSchemaDescriptor().getUUID();
        Object object = new String[]{"KEY", "VALUE"};
        Object[] objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_SET_DATABASE_PROPERTY", uUID2, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, null, transactionController);
        object = new String[]{"SCHEMANAME", "TABLENAME", "SEQUENTIAL"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        uUID = this.createSystemProcedureOrFunction("SYSCS_COMPRESS_TABLE", uUID2, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, null, transactionController);
        this.createRoutinePermPublicDescriptor(uUID, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_CHECKPOINT_DATABASE", uUID2, null, null, 0, 0, (short)2, null, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_FREEZE_DATABASE", uUID2, null, null, 0, 0, (short)2, null, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_UNFREEZE_DATABASE", uUID2, null, null, 0, 0, (short)2, null, transactionController);
        object = new String[]{"BACKUPDIR"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_BACKUP_DATABASE", uUID2, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, null, transactionController);
        object = new String[]{"BACKUPDIR", "DELETE_ARCHIVED_LOG_FILES"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        this.createSystemProcedureOrFunction("SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE", uUID2, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, null, transactionController);
        object = new String[]{"DELETE_ARCHIVED_LOG_FILES"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        this.createSystemProcedureOrFunction("SYSCS_DISABLE_LOG_ARCHIVE_MODE", uUID2, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, null, transactionController);
        object = new String[]{"ENABLE"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        uUID = this.createSystemProcedureOrFunction("SYSCS_SET_RUNTIMESTATISTICS", uUID2, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)2, null, transactionController);
        this.createRoutinePermPublicDescriptor(uUID, transactionController);
        object = new String[]{"ENABLE"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        uUID = this.createSystemProcedureOrFunction("SYSCS_SET_STATISTICS_TIMING", uUID2, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)2, null, transactionController);
        this.createRoutinePermPublicDescriptor(uUID, transactionController);
        object = new String[]{"KEY"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128)};
        this.createSystemProcedureOrFunction("SYSCS_GET_DATABASE_PROPERTY", uUID2, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)1, DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), transactionController);
        object = new String[]{"SCHEMANAME", "TABLENAME"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128)};
        this.createSystemProcedureOrFunction("SYSCS_CHECK_TABLE", uUID2, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)1, DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), transactionController);
        uUID = this.createSystemProcedureOrFunction("SYSCS_GET_RUNTIMESTATISTICS", uUID2, null, null, 0, 0, (short)2, DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), transactionController);
        this.createRoutinePermPublicDescriptor(uUID, transactionController);
        object = this.getSchemaDescriptor("SQLJ", transactionController, true).getUUID();
        objectArray = new String[]{"URL", "JAR", "DEPLOY"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 256), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4)};
        this.createSystemProcedureOrFunction("INSTALL_JAR", (UUID)object, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        objectArray = new String[]{"URL", "JAR"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 256), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128)};
        this.createSystemProcedureOrFunction("REPLACE_JAR", (UUID)object, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        objectArray = new String[]{"JAR", "UNDEPLOY"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4)};
        this.createSystemProcedureOrFunction("REMOVE_JAR", (UUID)object, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128)};
        this.createSystemProcedureOrFunction("SYSCS_EXPORT_TABLE", uUID2, (String[])objectArray, typeDescriptorArray, 0, 0, (short)1, null, transactionController);
        objectArray = new String[]{"selectStatement", "fileName", " columnDelimiter", "characterDelimiter", "codeset"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128)};
        this.createSystemProcedureOrFunction("SYSCS_EXPORT_QUERY", uUID2, (String[])objectArray, typeDescriptorArray, 0, 0, (short)1, null, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_TABLE", uUID2, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "insertColumnList", "columnIndexes", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_DATA", uUID2, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "vtiName", "vtiArg"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_BULK_INSERT", uUID2, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        this.create_10_1_system_procedures(transactionController, uUID2);
        this.create_10_2_system_procedures(transactionController, uUID2);
        this.create_10_3_system_procedures(transactionController);
    }

    protected final void create_SYSIBM_procedures(TransactionController transactionController) throws StandardException {
        UUID uUID = this.getSysIBMSchemaDescriptor().getUUID();
        String[] stringArray = new String[]{"SQLCODE", "SQLERRML", "SQLERRMC", "SQLERRP", "SQLERRD0", "SQLERRD1", "SQLERRD2", "SQLERRD3", "SQLERRD4", "SQLERRD5", "SQLWARN", "SQLSTATE", "FILE", "LOCALE", "MESSAGE", "RETURNCODE"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 2400), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 8), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 11), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 50), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 2400), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4)};
        this.createSystemProcedureOrFunction("SQLCAMESSAGE", uUID, stringArray, typeDescriptorArray, 2, 0, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "PROCNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLPROCEDURES", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLTABLEPRIVILEGES", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLPRIMARYKEYS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "TABLETYPE", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLTABLES", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "PROCNAME", "PARAMNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLPROCEDURECOLS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "COLUMNNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLCOLUMNS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "COLUMNNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLCOLPRIVILEGES", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMAPATTERN", "TYPENAMEPATTERN", "UDTTYPES", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLUDTS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"PKCATALOGNAME", "PKSCHEMANAME", "PKTABLENAME", "FKCATALOGNAME", "FKSCHEMANAME", "FKTABLENAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLFOREIGNKEYS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"COLTYPE", "CATALOGNAME", "SCHEMANAME", "TABLENAME", "SCOPE", "NULLABLE", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLSPECIALCOLUMNS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"DATATYPE", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLGETTYPEINFO", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "UNIQUE", "RESERVED", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLSTATISTICS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        this.createSystemProcedureOrFunction("METADATA", uUID, null, null, 0, 1, (short)1, null, transactionController);
    }

    public void grantPublicAccessToSystemRoutines(TransactionController transactionController, String string) throws StandardException {
        int n;
        String string2 = this.getSystemUtilSchemaDescriptor().getUUID().toString();
        for (n = 0; n < sysUtilProceduresWithPublicAccess.length; ++n) {
            this.grantPublicAccessToSystemRoutine(string2, sysUtilProceduresWithPublicAccess[n], 'P', transactionController, string);
        }
        for (n = 0; n < sysUtilFunctionsWithPublicAccess.length; ++n) {
            this.grantPublicAccessToSystemRoutine(string2, sysUtilFunctionsWithPublicAccess[n], 'F', transactionController, string);
        }
    }

    private void grantPublicAccessToSystemRoutine(String string, String string2, char c, TransactionController transactionController, String string3) throws StandardException {
        AliasDescriptor aliasDescriptor = this.getAliasDescriptor(string, string2, c);
        UUID uUID = aliasDescriptor.getUUID();
        this.createRoutinePermPublicDescriptor(uUID, transactionController, string3);
    }

    void createRoutinePermPublicDescriptor(UUID uUID, TransactionController transactionController) throws StandardException {
        this.createRoutinePermPublicDescriptor(uUID, transactionController, this.authorizationDatabaseOwner);
    }

    void createRoutinePermPublicDescriptor(UUID uUID, TransactionController transactionController, String string) throws StandardException {
        RoutinePermsDescriptor routinePermsDescriptor = new RoutinePermsDescriptor(this, "PUBLIC", string, uUID);
        this.addDescriptor(routinePermsDescriptor, null, 18, false, transactionController);
    }

    void create_10_1_system_procedures(TransactionController transactionController, UUID uUID) throws StandardException {
        UUID uUID2 = null;
        String[] stringArray = new String[]{"SCHEMANAME", "TABLENAME", "PURGE_ROWS", "DEFRAGMENT_ROWS", "TRUNCATE_END"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        uUID2 = this.createSystemProcedureOrFunction("SYSCS_INPLACE_COMPRESS_TABLE", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        this.createRoutinePermPublicDescriptor(uUID2, transactionController);
    }

    void create_10_2_system_procedures(TransactionController transactionController, UUID uUID) throws StandardException {
        String[] stringArray = new String[]{"BACKUPDIR"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_BACKUP_DATABASE_NOWAIT", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        stringArray = new String[]{"BACKUPDIR", "DELETE_ARCHIVED_LOG_FILES"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        this.createSystemProcedureOrFunction("SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "FUNCNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLFUNCTIONS", this.getSysIBMSchemaDescriptor().getUUID(), stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "FUNCNAME", "PARAMNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 4000)};
        this.createSystemProcedureOrFunction("SQLFUNCTIONPARAMS", this.getSysIBMSchemaDescriptor().getUUID(), stringArray, typeDescriptorArray, 0, 1, (short)1, null, transactionController);
    }

    private void create_10_3_system_procedures_SYSIBM(TransactionController transactionController) throws StandardException {
        UUID uUID = this.getSysIBMSchemaDescriptor().getUUID();
        UUID uUID2 = null;
        String[] stringArray = null;
        TypeDescriptor[] typeDescriptorArray = null;
        uUID2 = this.createSystemProcedureOrFunction("CLOBCREATELOCATOR", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, DataTypeDescriptor.getBuiltInDataTypeDescriptor(4, Integer.MAX_VALUE), transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = new String[]{"LOCATOR"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4)};
        uUID2 = this.createSystemProcedureOrFunction("CLOBRELEASELOCATOR", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, null, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = new String[]{"LOCATOR", "SEARCHSTR", "POS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12), DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5)};
        uUID2 = this.createSystemProcedureOrFunction("CLOBGETPOSITIONFROMSTRING", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5, Integer.MAX_VALUE), transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = new String[]{"LOCATOR", "SEARCHLOCATOR", "POS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5)};
        uUID2 = this.createSystemProcedureOrFunction("CLOBGETPOSITIONFROMLOCATOR", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5, Integer.MAX_VALUE), transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = new String[]{"LOCATOR"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4)};
        uUID2 = this.createSystemProcedureOrFunction("CLOBGETLENGTH", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5, Integer.MAX_VALUE), transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = new String[]{"LOCATOR", "POS", "LEN"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4)};
        uUID2 = this.createSystemProcedureOrFunction("CLOBGETSUBSTRING", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = new String[]{"LOCATOR", "POS", "LEN", "REPLACESTR"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12)};
        uUID2 = this.createSystemProcedureOrFunction("CLOBSETSTRING", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, null, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = new String[]{"LOCATOR", "LEN"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5)};
        uUID2 = this.createSystemProcedureOrFunction("CLOBTRUNCATE", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, null, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = null;
        typeDescriptorArray = null;
        uUID2 = this.createSystemProcedureOrFunction("BLOBCREATELOCATOR", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, DataTypeDescriptor.getBuiltInDataTypeDescriptor(4, Integer.MAX_VALUE), transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = new String[]{"LOCATOR"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4)};
        uUID2 = this.createSystemProcedureOrFunction("BLOBRELEASELOCATOR", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, null, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = new String[]{"LOCATOR", "SEARCHBYTES", "POS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(-3), DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5)};
        uUID2 = this.createSystemProcedureOrFunction("BLOBGETPOSITIONFROMBYTES", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5, Integer.MAX_VALUE), transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = new String[]{"LOCATOR", "SEARCHLOCATOR", "POS"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5)};
        uUID2 = this.createSystemProcedureOrFunction("BLOBGETPOSITIONFROMLOCATOR", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5, Integer.MAX_VALUE), transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = new String[]{"LOCATOR"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4)};
        uUID2 = this.createSystemProcedureOrFunction("BLOBGETLENGTH", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5, Integer.MAX_VALUE), transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = new String[]{"LOCATOR", "POS", "LEN"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4)};
        uUID2 = this.createSystemProcedureOrFunction("BLOBGETBYTES", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, DataTypeDescriptor.getBuiltInDataTypeDescriptor(-3, 32672), transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = new String[]{"LOCATOR", "POS", "LEN", "REPLACEBYTES"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5), DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(-3)};
        uUID2 = this.createSystemProcedureOrFunction("BLOBSETBYTES", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, null, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        uUID2 = null;
        stringArray = new String[]{"LOCATOR", "LEN"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(4), DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5)};
        uUID2 = this.createSystemProcedureOrFunction("BLOBTRUNCATE", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, null, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
    }

    void create_10_3_system_procedures(TransactionController transactionController) throws StandardException {
        this.create_10_3_system_procedures_SYSCS_UTIL(transactionController);
        this.create_10_3_system_procedures_SYSIBM(transactionController);
    }

    void create_10_3_system_procedures_SYSCS_UTIL(TransactionController transactionController) throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128);
        UUID uUID = this.getSystemUtilSchemaDescriptor().getUUID();
        Object[] objectArray = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "lobsFileName"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_EXPORT_TABLE_LOBS_TO_EXTFILE", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)1, null, transactionController);
        objectArray = new String[]{"selectStatement", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "lobsFileName"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_EXPORT_QUERY_LOBS_TO_EXTFILE", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)1, null, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "insertColumnList", "columnIndexes", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 32672), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, 128), DataTypeDescriptor.getBuiltInDataTypeDescriptor(5)};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, null, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_RELOAD_SECURITY_POLICY", uUID, null, null, 0, 0, (short)3, null, transactionController);
        objectArray = new TypeDescriptor[]{dataTypeDescriptor, dataTypeDescriptor};
        this.createSystemProcedureOrFunction("SYSCS_SET_USER_ACCESS", uUID, new String[]{"USERNAME", "CONNECTIONPERMISSION"}, (TypeDescriptor[])objectArray, 0, 0, (short)0, null, transactionController);
        objectArray = new TypeDescriptor[]{dataTypeDescriptor};
        this.createSystemProcedureOrFunction("SYSCS_GET_USER_ACCESS", uUID, new String[]{"USERNAME"}, (TypeDescriptor[])objectArray, 0, 0, (short)1, dataTypeDescriptor, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_EMPTY_STATEMENT_CACHE", uUID, null, null, 0, 0, (short)3, null, transactionController);
    }

    private final synchronized Properties getQueryDescriptions(boolean bl) {
        this.spsSet = bl ? "metadata_net.properties" : "/org/apache/derby/impl/jdbc/metadata.properties";
        return (Properties)AccessController.doPrivileged(this);
    }

    public final Object run() {
        Properties properties = new Properties();
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(this.spsSet);
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    private static List newSList() {
        return Collections.synchronizedList(new LinkedList());
    }

    public TablePermsDescriptor getTablePermissions(UUID uUID, String string) throws StandardException {
        TablePermsDescriptor tablePermsDescriptor = new TablePermsDescriptor(this, string, null, uUID);
        return (TablePermsDescriptor)this.getPermissions(tablePermsDescriptor);
    }

    public TablePermsDescriptor getTablePermissions(UUID uUID) throws StandardException {
        TablePermsDescriptor tablePermsDescriptor = new TablePermsDescriptor(this, uUID);
        return this.getUncachedTablePermsDescriptor(tablePermsDescriptor);
    }

    private Object getPermissions(PermissionsDescriptor permissionsDescriptor) throws StandardException {
        Cacheable cacheable = this.getPermissionsCache().find(permissionsDescriptor);
        if (cacheable == null) {
            return null;
        }
        Object object = cacheable.getIdentity();
        this.getPermissionsCache().release(cacheable);
        return object;
    }

    public ColPermsDescriptor getColumnPermissions(UUID uUID) throws StandardException {
        ColPermsDescriptor colPermsDescriptor = new ColPermsDescriptor(this, uUID);
        return this.getUncachedColPermsDescriptor(colPermsDescriptor);
    }

    public ColPermsDescriptor getColumnPermissions(UUID uUID, int n, boolean bl, String string) throws StandardException {
        String string2 = bl ? colPrivTypeMapForGrant[n] : colPrivTypeMap[n];
        ColPermsDescriptor colPermsDescriptor = new ColPermsDescriptor(this, string, null, uUID, string2);
        return (ColPermsDescriptor)this.getPermissions(colPermsDescriptor);
    }

    public ColPermsDescriptor getColumnPermissions(UUID uUID, String string, boolean bl, String string2) throws StandardException {
        ColPermsDescriptor colPermsDescriptor = new ColPermsDescriptor(this, string2, null, uUID, string);
        return (ColPermsDescriptor)this.getPermissions(colPermsDescriptor);
    }

    public RoutinePermsDescriptor getRoutinePermissions(UUID uUID, String string) throws StandardException {
        RoutinePermsDescriptor routinePermsDescriptor = new RoutinePermsDescriptor(this, string, null, uUID);
        return (RoutinePermsDescriptor)this.getPermissions(routinePermsDescriptor);
    }

    public RoutinePermsDescriptor getRoutinePermissions(UUID uUID) throws StandardException {
        RoutinePermsDescriptor routinePermsDescriptor = new RoutinePermsDescriptor(this, uUID);
        return this.getUncachedRoutinePermsDescriptor(routinePermsDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRemovePermissionsDescriptor(boolean bl, PermissionsDescriptor permissionsDescriptor, String string, TransactionController transactionController) throws StandardException {
        int n = permissionsDescriptor.getCatalogNumber();
        permissionsDescriptor.setUUID(null);
        permissionsDescriptor.setGrantee(string);
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(n);
        PermissionsCatalogRowFactory permissionsCatalogRowFactory = (PermissionsCatalogRowFactory)tabInfoImpl.getCatalogRowFactory();
        int n2 = permissionsCatalogRowFactory.getPrimaryKeyIndexNumber();
        ConglomerateController conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4);
        RowLocation rowLocation = null;
        try {
            rowLocation = conglomerateController.newRowLocationTemplate();
        }
        finally {
            conglomerateController.close();
            conglomerateController = null;
        }
        ExecIndexRow execIndexRow = permissionsCatalogRowFactory.buildIndexKeyRow(n2, permissionsDescriptor);
        ExecRow execRow = tabInfoImpl.getRow(transactionController, execIndexRow, n2);
        if (execRow == null) {
            if (!bl) {
                return false;
            }
            ExecRow execRow2 = tabInfoImpl.getCatalogRowFactory().makeRow(permissionsDescriptor, null);
            int n3 = tabInfoImpl.insertRow(execRow2, transactionController, true);
        } else {
            boolean[] blArray = new boolean[execRow.nColumns()];
            boolean[] blArray2 = new boolean[permissionsCatalogRowFactory.getNumIndexes()];
            int n4 = 0;
            n4 = bl ? permissionsCatalogRowFactory.orPermissions(execRow, permissionsDescriptor, blArray) : permissionsCatalogRowFactory.removePermissions(execRow, permissionsDescriptor, blArray);
            if (n4 == 0) {
                return false;
            }
            if (!bl) {
                permissionsCatalogRowFactory.setUUIDOfThePassedDescriptor(execRow, permissionsDescriptor);
            }
            if (n4 < 0) {
                tabInfoImpl.deleteRow(transactionController, execIndexRow, n2);
            } else if (n4 > 0) {
                int[] nArray = new int[n4];
                n4 = 0;
                for (int i = 0; i < blArray.length; ++i) {
                    if (!blArray[i]) continue;
                    nArray[n4++] = i + 1;
                }
                tabInfoImpl.updateRow(execIndexRow, execRow, n2, blArray2, nArray, transactionController, true);
            }
        }
        this.removePermEntryInCache(permissionsDescriptor);
        return !bl;
    }

    TablePermsDescriptor getUncachedTablePermsDescriptor(TablePermsDescriptor tablePermsDescriptor) throws StandardException {
        if (tablePermsDescriptor.getObjectID() == null) {
            return (TablePermsDescriptor)this.getUncachedPermissionsDescriptor(16, 0, tablePermsDescriptor);
        }
        return (TablePermsDescriptor)this.getUncachedPermissionsDescriptor(16, 1, tablePermsDescriptor);
    }

    ColPermsDescriptor getUncachedColPermsDescriptor(ColPermsDescriptor colPermsDescriptor) throws StandardException {
        if (colPermsDescriptor.getObjectID() == null) {
            return (ColPermsDescriptor)this.getUncachedPermissionsDescriptor(17, 0, colPermsDescriptor);
        }
        return (ColPermsDescriptor)this.getUncachedPermissionsDescriptor(17, 1, colPermsDescriptor);
    }

    private TupleDescriptor getUncachedPermissionsDescriptor(int n, int n2, PermissionsDescriptor permissionsDescriptor) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(n);
        PermissionsCatalogRowFactory permissionsCatalogRowFactory = (PermissionsCatalogRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecIndexRow execIndexRow = permissionsCatalogRowFactory.buildIndexKeyRow(n2, permissionsDescriptor);
        return this.getDescriptorViaIndex(n2, execIndexRow, null, tabInfoImpl, null, null, false);
    }

    RoutinePermsDescriptor getUncachedRoutinePermsDescriptor(RoutinePermsDescriptor routinePermsDescriptor) throws StandardException {
        if (routinePermsDescriptor.getObjectID() == null) {
            return (RoutinePermsDescriptor)this.getUncachedPermissionsDescriptor(18, 0, routinePermsDescriptor);
        }
        return (RoutinePermsDescriptor)this.getUncachedPermissionsDescriptor(18, 1, routinePermsDescriptor);
    }

    public String getVTIClass(TableDescriptor tableDescriptor, boolean bl) throws StandardException {
        if (!"SYSCS_DIAG".equals(tableDescriptor.getSchemaName())) {
            return null;
        }
        String[][] stringArray = bl ? this.DIAG_VTI_TABLE_FUNCTION_CLASSES : this.DIAG_VTI_TABLE_CLASSES;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            if (!stringArray2[0].equals(tableDescriptor.getDescriptorName())) continue;
            return stringArray2[1];
        }
        return null;
    }

    static {
        DataDictionaryImpl.colPrivTypeMap[0] = "s";
        DataDictionaryImpl.colPrivTypeMapForGrant[0] = "S";
        DataDictionaryImpl.colPrivTypeMap[1] = "u";
        DataDictionaryImpl.colPrivTypeMapForGrant[1] = "U";
        DataDictionaryImpl.colPrivTypeMap[2] = "r";
        DataDictionaryImpl.colPrivTypeMapForGrant[2] = "R";
    }
}

