/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.CoGProperties;
import org.globus.gsi.CertUtil;
import org.globus.util.TimestampEntry;

public class TrustedCertificates
implements Serializable {
    private static Log logger = LogFactory.getLog((class$org$globus$gsi$TrustedCertificates == null ? (class$org$globus$gsi$TrustedCertificates = TrustedCertificates.class$("org.globus.gsi.TrustedCertificates")) : class$org$globus$gsi$TrustedCertificates).getName());
    public static final CertFilter certFileFilter = new CertFilter();
    private static TrustedCertificates trustedCertificates = null;
    private Map certSubjectDNMap;
    private Map certFileMap;
    private boolean changed;
    static /* synthetic */ Class class$org$globus$gsi$TrustedCertificates;

    protected TrustedCertificates() {
    }

    public TrustedCertificates(X509Certificate[] certs) {
        this.certSubjectDNMap = new HashMap();
        for (int i = 0; i < certs.length; ++i) {
            this.certSubjectDNMap.put(((Object)certs[i].getSubjectDN()).toString(), certs[i]);
        }
    }

    public X509Certificate[] getCertificates() {
        if (this.certSubjectDNMap == null) {
            return null;
        }
        Collection certs = this.certSubjectDNMap.values();
        X509Certificate[] retCerts = new X509Certificate[certs.size()];
        Iterator iterator = certs.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            retCerts[i++] = (X509Certificate)iterator.next();
        }
        return retCerts;
    }

    public X509Certificate getCertificate(String subject) {
        if (this.certSubjectDNMap == null) {
            return null;
        }
        return (X509Certificate)this.certSubjectDNMap.get(subject);
    }

    public static X509Certificate[] loadCertificates(String locations) {
        TrustedCertificates tc = TrustedCertificates.load(locations);
        return tc == null ? null : tc.getCertificates();
    }

    public static TrustedCertificates load(String locations) {
        TrustedCertificates tc = new TrustedCertificates();
        tc.reload(locations);
        return tc;
    }

    public static FilenameFilter getCertFilter() {
        return certFileFilter;
    }

    public void refresh() {
        this.reload(null);
    }

    public synchronized void reload(String locations) {
        if (locations == null) {
            return;
        }
        this.changed = false;
        StringTokenizer tokens = new StringTokenizer(locations, ",");
        File caFile = null;
        HashMap newCertFileMap = new HashMap();
        HashMap newCertSubjectDNMap = new HashMap();
        while (tokens.hasMoreTokens()) {
            caFile = new File(tokens.nextToken().toString().trim());
            if (!caFile.canRead()) {
                logger.debug("Cannot read: " + caFile.getAbsolutePath());
                continue;
            }
            if (caFile.isDirectory()) {
                String[] caCertFiles = caFile.list(TrustedCertificates.getCertFilter());
                if (caCertFiles == null) {
                    logger.debug("Cannot load certificates from " + caFile.getAbsolutePath() + " directory.");
                    continue;
                }
                logger.debug("Loading certificates from " + caFile.getAbsolutePath() + " directory.");
                for (int i = 0; i < caCertFiles.length; ++i) {
                    String caFilename = caFile.getPath() + File.separatorChar + caCertFiles[i];
                    File caFilenameFile = new File(caFilename);
                    if (caFilenameFile.canRead()) {
                        this.loadCert(caFilename, caFilenameFile.lastModified(), newCertFileMap, newCertSubjectDNMap);
                        continue;
                    }
                    logger.debug("Cannot read: " + caFilenameFile.getAbsolutePath());
                }
                continue;
            }
            this.loadCert(caFile.getAbsolutePath(), caFile.lastModified(), newCertFileMap, newCertSubjectDNMap);
        }
        if (!this.changed && this.certFileMap != null && this.certFileMap.size() != newCertFileMap.size()) {
            this.changed = true;
        }
        this.certFileMap = newCertFileMap;
        this.certSubjectDNMap = newCertSubjectDNMap;
    }

    private void loadCert(String certPath, long latestLastModified, Map newCertFileMap, Map newCertSubjectDNMap) {
        X509Certificate cert = null;
        if (this.certFileMap == null) {
            this.certFileMap = new HashMap();
        }
        TimestampEntry certEntry = (TimestampEntry)this.certFileMap.get(certPath);
        try {
            if (certEntry == null) {
                logger.debug("Loading " + certPath + " certificate.");
                cert = CertUtil.loadCertificate(certPath);
                certEntry = new TimestampEntry(cert, latestLastModified);
                this.changed = true;
            } else if (latestLastModified > certEntry.getLastModified()) {
                logger.debug("Reloading " + certPath + " certificate.");
                cert = CertUtil.loadCertificate(certPath);
                certEntry.setValue(cert);
                certEntry.setLastModified(latestLastModified);
                this.changed = true;
            } else {
                logger.debug("Certificate " + certPath + " is up-to-date.");
                cert = (X509Certificate)certEntry.getValue();
            }
            newCertFileMap.put(certPath, certEntry);
            newCertSubjectDNMap.put(cert.getSubjectDN().getName(), cert);
        }
        catch (Exception e) {
            logger.error("Certificate " + certPath + " failed to load.", e);
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public static synchronized TrustedCertificates getDefaultTrustedCertificates() {
        return TrustedCertificates.getDefault();
    }

    public static void setDefaultTrustedCertificates(TrustedCertificates trusted) {
        trustedCertificates = trusted;
    }

    public static synchronized TrustedCertificates getDefault() {
        if (trustedCertificates == null) {
            trustedCertificates = new DefaultTrustedCertificates();
        }
        trustedCertificates.refresh();
        return trustedCertificates;
    }

    public String toString() {
        if (this.certSubjectDNMap == null) {
            return "cert list is empty";
        }
        return this.certSubjectDNMap.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DefaultTrustedCertificates
    extends TrustedCertificates {
        private DefaultTrustedCertificates() {
        }

        public void refresh() {
            this.reload(CoGProperties.getDefault().getCaCertLocations());
        }
    }

    public static class CertFilter
    implements FilenameFilter {
        public boolean accept(File dir, String file) {
            int length = file.length();
            return length > 2 && file.charAt(length - 2) == '.' && file.charAt(length - 1) >= '0' && file.charAt(length - 1) <= '9';
        }
    }
}

