/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rsl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.globus.rsl.AbstractRslNode;
import org.globus.rsl.Bindings;
import org.globus.rsl.NameOpValue;
import org.globus.rsl.RslEvaluationException;

public class RslNode
extends AbstractRslNode {
    protected Map _relations;
    protected Map _bindings;

    public RslNode() {
    }

    public RslNode(int operator) {
        super(operator);
    }

    public Bindings put(Bindings bindings) {
        if (this._bindings == null) {
            this._bindings = new HashMap();
        }
        String attrName = bindings.getAttribute();
        return this._bindings.put(RslNode.canonicalize(attrName), bindings);
    }

    public boolean add(Bindings bindings) {
        return this.put(bindings) == null;
    }

    public NameOpValue put(NameOpValue relation) {
        if (this._relations == null) {
            this._relations = new HashMap();
        }
        String attrName = relation.getAttribute();
        return this._relations.put(RslNode.canonicalize(attrName), relation);
    }

    public boolean add(NameOpValue relation) {
        return this.put(relation) == null;
    }

    public void mergeTo(AbstractRslNode dstNode) {
        Iterator iter = null;
        String attr = null;
        super.mergeTo(dstNode);
        if (this._relations != null) {
            iter = this._relations.keySet().iterator();
            while (iter.hasNext()) {
                attr = (String)iter.next();
                NameOpValue nov = dstNode.getParam(attr);
                if (nov == null) {
                    dstNode.add(this.getParam(attr));
                    continue;
                }
                nov.merge(this.getParam(attr));
            }
        }
        if (this._bindings != null) {
            iter = this._bindings.keySet().iterator();
            while (iter.hasNext()) {
                attr = (String)iter.next();
                Bindings bind = dstNode.getBindings(attr);
                if (bind == null) {
                    dstNode.add(this.getBindings(attr));
                    continue;
                }
                bind.merge(this.getBindings(attr));
            }
        }
    }

    public NameOpValue getParam(String attribute) {
        if (this._relations == null || attribute == null) {
            return null;
        }
        return (NameOpValue)this._relations.get(RslNode.canonicalize(attribute));
    }

    public Bindings getBindings(String attribute) {
        if (this._bindings == null || attribute == null) {
            return null;
        }
        return (Bindings)this._bindings.get(RslNode.canonicalize(attribute));
    }

    public NameOpValue removeParam(String attribute) {
        if (this._relations == null || attribute == null) {
            return null;
        }
        return (NameOpValue)this._relations.remove(RslNode.canonicalize(attribute));
    }

    public Bindings removeBindings(String attribute) {
        if (this._relations == null || attribute == null) {
            return null;
        }
        return (Bindings)this._bindings.remove(RslNode.canonicalize(attribute));
    }

    public Map getRelations() {
        return this._relations;
    }

    public Map getBindings() {
        return this._bindings;
    }

    public AbstractRslNode evaluate(Map symbolTable) throws RslEvaluationException {
        Iterator<Object> iter;
        if (symbolTable == null) {
            symbolTable = new HashMap();
        }
        HashMap localSymbolTable = null;
        RslNode finalRsl = new RslNode(this.getOperator());
        if (this._bindings != null && this._bindings.size() > 0) {
            localSymbolTable = new HashMap(symbolTable);
            iter = this._bindings.keySet().iterator();
            while (iter.hasNext()) {
                Bindings binds = this.getBindings((String)iter.next());
                finalRsl.put(binds.evaluate(localSymbolTable));
            }
        } else {
            localSymbolTable = symbolTable;
        }
        if (this._relations != null && this._relations.size() > 0) {
            iter = this._relations.keySet().iterator();
            while (iter.hasNext()) {
                NameOpValue nov = this.getParam((String)iter.next());
                finalRsl.put(nov.evaluate(localSymbolTable));
            }
        }
        if (this._specifications != null && this._specifications.size() > 0) {
            iter = this._specifications.iterator();
            while (iter.hasNext()) {
                AbstractRslNode node = (AbstractRslNode)iter.next();
                finalRsl.add(node.evaluate(localSymbolTable));
            }
        }
        return finalRsl;
    }

    public void toRSL(StringBuffer buf, boolean explicitConcat) {
        Iterator<Object> iter;
        buf.append(this.getOperatorAsString());
        if (this._bindings != null && this._bindings.size() > 0) {
            iter = this._bindings.keySet().iterator();
            while (iter.hasNext()) {
                Bindings binds = this.getBindings((String)iter.next());
                binds.toRSL(buf, explicitConcat);
            }
        }
        if (this._relations != null && this._relations.size() > 0) {
            iter = this._relations.keySet().iterator();
            while (iter.hasNext()) {
                NameOpValue nov = this.getParam((String)iter.next());
                nov.toRSL(buf, explicitConcat);
            }
        }
        if (this._specifications != null && this._specifications.size() > 0) {
            iter = this._specifications.iterator();
            while (iter.hasNext()) {
                AbstractRslNode node = (AbstractRslNode)iter.next();
                buf.append(" (");
                node.toRSL(buf, explicitConcat);
                buf.append(" )");
            }
        }
    }
}

