/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.ui.proxy;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.X509ExtensionSet;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.myproxy.MyProxy;
import org.globus.tools.ui.proxy.GridProxyDialog;
import org.globus.tools.ui.proxy.MyproxyDialog;
import org.globus.tools.ui.proxy.MyproxyGUI;
import org.globus.tools.ui.proxy.PasswordDialog;
import org.globus.tools.ui.util.JJPanel;
import org.globus.tools.ui.util.UITools;
import org.globus.util.Util;

public class MyproxyInit
extends MyproxyGUI
implements ActionListener,
WindowListener {
    public static final int FRAME_WIDTH = 430;
    public static final int FRAME_HEIGHT = 180;
    private JTextField usernameTF = new JTextField(15);
    private JPasswordField passwordTF = new JPasswordField(15);
    private JButton createButton;
    private JButton sendButton;
    private JButton killLocButton;
    private JButton killRemButton;
    private boolean runAsApplication = true;
    private GlobusCredential gridProxy = null;
    private String myproxyPassword = "";

    public MyproxyInit() {
        this.setTitle("Myproxy Init");
        this.setSize(430, 180);
        this.addWindowListener(this);
        Container contentPane = this.getContentPane();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        exitMenuItem.addActionListener(this);
        fileMenu.add(exitMenuItem);
        JMenu editMenu = new JMenu("Edit");
        menuBar.add(editMenu);
        JMenuItem cpMenuItem = new JMenuItem("Certificate Properties");
        cpMenuItem.addActionListener(this);
        editMenu.add(cpMenuItem);
        JMenuItem mpMenuItem = new JMenuItem("Myproxy Properties");
        mpMenuItem.addActionListener(this);
        editMenu.add(mpMenuItem);
        JPanel buttonPanel = new JPanel();
        JPanel proxyPanel = new JPanel();
        proxyPanel.setBorder(BorderFactory.createTitledBorder(" Local Proxy "));
        this.createButton = new JButton("Create");
        this.killLocButton = new JButton("Destroy");
        this.createButton.addActionListener(this);
        this.killLocButton.addActionListener(this);
        proxyPanel.add(this.createButton);
        proxyPanel.add(this.killLocButton);
        JPanel myproxyPanel = new JPanel();
        myproxyPanel.setBorder(BorderFactory.createTitledBorder(" Myproxy "));
        this.sendButton = new JButton("Init");
        this.killRemButton = new JButton("Destroy");
        this.sendButton.addActionListener(this);
        this.killRemButton.addActionListener(this);
        myproxyPanel.add(this.sendButton);
        myproxyPanel.add(this.killRemButton);
        buttonPanel.add(proxyPanel);
        buttonPanel.add(myproxyPanel);
        JJPanel mainPanel = new JJPanel();
        mainPanel.setInsets(5, 5, 5, 5);
        mainPanel.setAnchor(13);
        mainPanel.add(new JLabel("Username: "), 0, 0, 1, 1);
        mainPanel.add(new JLabel("PEM Passphrase: "), 0, 1, 1, 1);
        mainPanel.setAnchor(17);
        mainPanel.gbc.weightx = 1.0;
        mainPanel.setFill(2);
        mainPanel.add(this.usernameTF, 1, 0, 1, 1);
        this.usernameTF.addActionListener(this);
        mainPanel.add(this.passwordTF, 1, 1, 1, 1);
        this.passwordTF.addActionListener(this);
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)buttonPanel, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        String cmd = evt.getActionCommand();
        if (cmd.equals("Certificate Properties")) {
            GridProxyDialog gpd = new GridProxyDialog(this.gridProps);
            UITools.center(this, gpd);
            gpd.show();
            return;
        }
        if (cmd.equals("Myproxy Properties")) {
            MyproxyDialog mpd = new MyproxyDialog(this);
            UITools.center(this, mpd);
            mpd.show();
            return;
        }
        if (cmd.equals("Exit")) {
            this.exit(0);
            return;
        }
        if (source == this.createButton) {
            if (this.validatePassword() && this.createProxy(this.gridProps.getHours())) {
                JOptionPane.showMessageDialog(this, "Succesfully created a proxy in " + this.gridProps.getProxyFile(), "Success", -1);
            }
        } else if (source == this.sendButton) {
            if (this.validateUsername() && this.validatePassword() && this.validateMyproxyPassword() && this.createProxy(this.gridProps.getCredLifetime())) {
                this.sendProxy();
            }
        } else if (source == this.killLocButton) {
            this.deleteProxy();
        } else if (source == this.killRemButton) {
            if (this.validateUsername() && this.validateMyproxyPassword()) {
                this.deleteMyproxy();
            }
        } else {
            System.err.println("Unidentified event in MyproxyInit" + cmd + source);
        }
    }

    private boolean validateUsername() {
        if (this.usernameTF.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this, "Please enter your username.", "Need More Information", 2);
            return false;
        }
        return true;
    }

    private boolean validatePassword() {
        if (this.passwordTF.getPassword().length == 0) {
            JOptionPane.showMessageDialog(this, "Please enter your password.", "Need More Information", 2);
            return false;
        }
        return true;
    }

    private boolean validateMyproxyPassword() {
        if (this.myproxyPassword.equals("")) {
            PasswordDialog passDialog = new PasswordDialog(this);
            UITools.center(this, passDialog);
            passDialog.show();
            return !passDialog.isCanceled();
        }
        return true;
    }

    public void deleteProxy() {
        this.gridProxy = null;
        if (!this.gridProps.getProxyFile().equals("")) {
            File proxyFile = new File(this.gridProps.getProxyFile());
            if (proxyFile.exists()) {
                if (!Util.destroy(proxyFile)) {
                    JOptionPane.showMessageDialog(this, "Unable to destroy local proxy", "Error", 0);
                } else {
                    JOptionPane.showMessageDialog(this, "Succesfully destroyed proxy in " + this.gridProps.getProxyFile(), "Success", -1);
                }
            } else {
                JOptionPane.showMessageDialog(this, "No proxy exists in " + this.gridProps.getProxyFile(), "Information", 1);
            }
        }
    }

    public void deleteMyproxy() {
        if (this.gridProxy == null) {
            return;
        }
        try {
            MyProxy.destroy(this.gridProps.getMyproxyServer(), this.gridProps.getMyproxyPort(), new GlobusGSSCredentialImpl(this.gridProxy, 0), this.usernameTF.getText().trim(), this.myproxyPassword);
            JOptionPane.showMessageDialog(this, "Succesfully destroyed proxy from myproxy server", "Success", -1);
            return;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to delete proxy from myproxy server!\n\"" + e.getMessage() + "\"", "Error", 0);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createProxy(int hours) {
        FileOutputStream out;
        block18: {
            PrivateKey userKey;
            X509Certificate userCert;
            block17: {
                block16: {
                    userCert = null;
                    userKey = null;
                    out = null;
                    userCert = CertUtil.loadCertificate(this.gridProps.getUserCertFile());
                    if (userCert != null) break block16;
                    JOptionPane.showMessageDialog(this, "Failed to load cert: " + this.gridProps.getUserCertFile(), "Error", 0);
                    boolean bl = false;
                    Object var12_8 = null;
                    if (out == null) return bl;
                    try {
                        out.close();
                        return bl;
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return bl;
                }
                char[] pwd = this.passwordTF.getPassword();
                BouncyCastleOpenSSLKey key = new BouncyCastleOpenSSLKey(this.gridProps.getUserKeyFile());
                if (key.isEncrypted()) {
                    key.decrypt(new String(pwd));
                }
                userKey = key.getPrivateKey();
                pwd = null;
                if (userKey != null) break block17;
                JOptionPane.showMessageDialog(this, "Failed to load private key: " + this.gridProps.getUserKeyFile(), "Error", 0);
                boolean bl = false;
                Object var12_9 = null;
                if (out == null) return bl;
                try {
                    out.close();
                    return bl;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return bl;
            }
            BouncyCastleCertProcessingFactory factory = BouncyCastleCertProcessingFactory.getDefault();
            int proxyType = this.gridProps.getLimited() ? 11 : 10;
            X509ExtensionSet extSet = null;
            this.gridProxy = factory.createCredential(new X509Certificate[]{userCert}, userKey, this.gridProps.getBits(), hours, proxyType, extSet);
            if (this.gridProxy != null) break block18;
            JOptionPane.showMessageDialog(this, "Failed to create proxy!", "Error", 0);
            boolean bl = false;
            Object var12_10 = null;
            if (out == null) return bl;
            try {
                out.close();
                return bl;
            }
            catch (IOException e2) {
                // empty catch block
            }
            return bl;
        }
        File file = Util.createFile(this.gridProps.getProxyFile());
        if (!Util.setOwnerAccessOnly(this.gridProps.getProxyFile())) {
            // empty if block
        }
        out = new FileOutputStream(file);
        this.gridProxy.save(out);
        Object var12_11 = null;
        if (out == null) return true;
        try {
            out.close();
            return true;
        }
        catch (IOException e2) {}
        return true;
        {
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Failed to create proxy!\n\"" + e.getMessage() + "\"", "Error", 0);
                boolean bl = false;
                Object var12_12 = null;
                if (out == null) return bl;
                try {
                    out.close();
                    return bl;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void sendProxy() {
        if (this.gridProxy == null || this.myproxyPassword.equals("")) {
            return;
        }
        if (this.myproxyPassword.equals("")) {
            PasswordDialog passDialog = new PasswordDialog(this);
            UITools.center(this, passDialog);
            passDialog.show();
        }
        try {
            MyProxy.put(this.gridProps.getMyproxyServer(), this.gridProps.getMyproxyPort(), new GlobusGSSCredentialImpl(this.gridProxy, 0), this.usernameTF.getText().trim(), this.myproxyPassword, this.gridProps.getCredLifetime());
            JOptionPane.showMessageDialog(this, "Succesfully delegated a proxy to myproxy server", "Success", -1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to delegate proxy to myproxy server!\n\"" + e.getMessage() + "\"", "Error", 0);
        }
    }

    public void setMyproxyPassword(String password) {
        this.myproxyPassword = password;
    }

    public void setRunAsApplication(boolean runAsApplication) {
        this.runAsApplication = runAsApplication;
    }

    public boolean isRunAsApplication() {
        return this.runAsApplication;
    }

    private void exit(int exitValue) {
        if (this.isRunAsApplication()) {
            System.exit(exitValue);
        } else {
            this.setVisible(false);
        }
    }

    public void windowActivated(WindowEvent we) {
    }

    public void windowClosed(WindowEvent we) {
    }

    public void windowDeactivated(WindowEvent we) {
    }

    public void windowDeiconified(WindowEvent we) {
    }

    public void windowIconified(WindowEvent we) {
    }

    public void windowOpened(WindowEvent we) {
    }

    public void windowClosing(WindowEvent we) {
        this.exit(0);
    }

    public static void main(String[] args) {
        MyproxyInit mpiFrame = new MyproxyInit();
        UITools.center(null, mpiFrame);
        mpiFrame.setVisible(true);
    }
}

