/*
 * Decompiled with CFR 0.152.
 */
package org.gwe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.gwe.drivers.fileSystems.GridFileSystem;
import org.gwe.drivers.netAccess.GridNetworkAccess;
import org.gwe.p2el.P2ELEngine;
import org.gwe.persistence.model.EventLogger;
import org.gwe.persistence.model.IEventLogger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWEAppContext {
    private static Log log = LogFactory.getLog(GWEAppContext.class);
    public static final String DEFAULT_COMMONS_CONF = "gwe-core.xml";
    public static final String APPLICATION_WORKSPACE_KEY = "application.workspace";
    public static final PatternLayout LOG_LAYOUT = new PatternLayout("%-10d{HH:mm:ss} [%t] %-5p  - %c{1}:%L %x - %m%n");
    protected static GWEAppContext instance = null;
    protected AbstractApplicationContext appContext;
    private EventLogger eventLogger = new EventLogger();
    private P2ELEngine p2elEngine;
    protected GridFileSystem gridFileSystem;
    protected GridNetworkAccess gridNetworkAccess;
    private String appWorkspace;

    public static GWEAppContext getInstance() {
        return instance;
    }

    public static void setInstance(GWEAppContext appContext) {
        instance = appContext;
    }

    public static P2ELEngine getP2ELEngine() {
        return GWEAppContext.getInstance().p2elEngine;
    }

    public static GridFileSystem getGridFileSystem() {
        return GWEAppContext.getInstance().gridFileSystem;
    }

    public static GridNetworkAccess getGridNetworkAccess() {
        return GWEAppContext.getInstance().gridNetworkAccess;
    }

    public GWEAppContext(String appWorkspace, String ... contextFiles) {
        this.appWorkspace = appWorkspace;
        contextFiles = this.addCoreContextIfNotPresent(contextFiles);
        if (appWorkspace == null || "".equals(appWorkspace)) {
            appWorkspace = "";
        }
        System.setProperty(APPLICATION_WORKSPACE_KEY, appWorkspace);
        this.createLoggerAppender(true);
        for (int idx = 0; idx < contextFiles.length; ++idx) {
            contextFiles[idx] = "classpath*:" + contextFiles[idx];
        }
        try {
            this.appContext = new ClassPathXmlApplicationContext(contextFiles);
            this.p2elEngine = this.getBeanOfClass(P2ELEngine.class);
            this.gridFileSystem = this.getBeanOfClass(GridFileSystem.class);
            this.gridNetworkAccess = this.getBeanOfClass(GridNetworkAccess.class);
        }
        catch (Throwable e) {
            log.fatal(e);
        }
    }

    private String[] addCoreContextIfNotPresent(String ... contextFiles) {
        ArrayList<String> allCtxFiles = new ArrayList<String>();
        allCtxFiles.addAll(Arrays.asList(contextFiles));
        if (allCtxFiles.size() < 1 || !((String)allCtxFiles.get(0)).equals(DEFAULT_COMMONS_CONF)) {
            allCtxFiles.remove(DEFAULT_COMMONS_CONF);
            allCtxFiles.add(0, DEFAULT_COMMONS_CONF);
        }
        return allCtxFiles.toArray(new String[0]);
    }

    protected void createLoggerAppender(boolean production) {
        String appLog = this.appWorkspace + "app.log";
        try {
            Level level;
            if (production) {
                Logger.getRootLogger().removeAllAppenders();
                level = Level.INFO;
            } else {
                Logger.getRootLogger().addAppender(new ConsoleAppender());
                level = Level.ALL;
            }
            Logger.getRootLogger().addAppender(new FileAppender((Layout)LOG_LAYOUT, appLog));
            Logger.getRootLogger().setLevel(level);
        }
        catch (IOException e) {
            log.warn("Couldn't create file log appender '" + appLog + "'", e);
        }
    }

    public <T> List<T> getContextBeans(ApplicationContext ctx, Class<T> clazz) {
        ArrayList result = new ArrayList();
        while (ctx != null) {
            result.addAll(ctx.getBeansOfType(clazz).values());
            ctx = ctx.getParent();
        }
        return result;
    }

    public <T> List<T> getContextBeanNames(ApplicationContext ctx, Class<T> clazz) {
        ArrayList result = new ArrayList();
        while (ctx != null) {
            result.addAll(ctx.getBeansOfType(clazz).keySet());
            ctx = ctx.getParent();
        }
        return result;
    }

    public final AbstractApplicationContext getAppContext() {
        return this.appContext;
    }

    public final <T> T getBean(String beanName) {
        return (T)this.appContext.getBean(beanName);
    }

    public final <T> T getBeanOfClass(Class<T> beanClass) {
        Collection values = this.appContext.getBeansOfType(beanClass).values();
        return (T)values.iterator().next();
    }

    public IEventLogger getEventLogger() {
        return this.eventLogger;
    }
}

