/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.api;

import org.gwe.drivers.osAppManagers.OSAppFolder;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.utils.cmd.OptionTemplate;
import org.gwe.utils.cmd.OptionableAppTemplate;

public class DaemonAppTemplate
extends OptionableAppTemplate {
    private static String CONFIG_MODE_NO = "no";
    private static String CONFIG_MODE_YES = "yes";
    private final OptionTemplate OPT_HOST = new OptionTemplate('H', "host", "Host address of this daemon as referenced by clients");
    private final OptionTemplate OPT_PORT = new OptionTemplate('p', "port", "Port where the RMI registry daemon will run", "1099");
    private final OptionTemplate OPT_DEST = new OptionTemplate('d', "dest", "Root directory where to install GWE applications");
    private final OptionTemplate OPT_NAME = new OptionTemplate('n', "name", "Friendly name of this daemon. To be persisted in the DB");
    private final OptionTemplate OPT_AGE = new OptionTemplate('a', "max_age", "Maximum number of minutes an allocation can remain alive");
    private final OptionTemplate OPT_IDLE = new OptionTemplate('i', "max_idle", "Maximum number of minutes an allocation can remain alive in idle state");
    private final OptionTemplate OPT_SIZE = new OptionTemplate('s', "size", "Maximum number of simultaneous allocations. A value less than one represent no limit");
    private final OptionTemplate OPT_MODE = new OptionTemplate('c', "config_mode", "Application mode to only run initial installation configuration. By default is not set", CONFIG_MODE_NO);
    private final OptionTemplate OPT_EXIT = new OptionTemplate('t', "exit_token", "Token to be output after application completes launching");

    public DaemonAppTemplate(OptionTemplate ... additionalOptions) {
        this.addOptions(this.OPT_HOST, this.OPT_PORT, this.OPT_DEST, this.OPT_NAME, this.OPT_AGE, this.OPT_IDLE, this.OPT_SIZE, this.OPT_MODE, this.OPT_EXIT);
        this.addOptions(additionalOptions);
    }

    public HeadResourceInfo createDaemonInfoUsingArgs() {
        Integer size;
        Long idle;
        HeadResourceInfo daemonInfo = new HeadResourceInfo(this.getArg(this.OPT_HOST), this.getArgAsInt(this.OPT_PORT));
        daemonInfo.setName(this.getArg(this.OPT_NAME));
        Long age = this.getArgAsLong(this.OPT_AGE);
        if (age != null) {
            daemonInfo.setMaxHijackMillis(age);
        }
        if ((idle = this.getArgAsLong(this.OPT_IDLE)) != null) {
            daemonInfo.setMaxIdleMillis(idle);
        }
        if ((size = this.getArgAsInt(this.OPT_SIZE)) != null) {
            daemonInfo.setQueueSize(size);
        }
        daemonInfo.setDaemonOSApp(null);
        return daemonInfo;
    }

    public String getGWEAppsRoot() {
        return this.getArg(this.OPT_DEST);
    }

    public boolean isConfigMode() {
        return !this.getArg(this.OPT_MODE).equals(CONFIG_MODE_NO);
    }

    public String getExitToken() {
        return this.getArg(this.OPT_EXIT);
    }

    public String[] createAppArgs(boolean configMode, HeadResourceInfo daemonInfo, String exitToken) {
        OptionableAppTemplate result = new OptionableAppTemplate();
        if (configMode) {
            result.addOption(this.OPT_MODE, CONFIG_MODE_YES);
        }
        result.addOption(this.OPT_NAME, daemonInfo.getName());
        result.addOption(this.OPT_HOST, daemonInfo.getHost());
        result.addOption(this.OPT_PORT, daemonInfo.getRegistryPort());
        result.addOption(this.OPT_DEST, daemonInfo.getDaemonOSApp().getFolderFullPath(OSAppFolder.ROOT));
        result.addOption(this.OPT_AGE, daemonInfo.getMaxHijackMillis());
        result.addOption(this.OPT_IDLE, daemonInfo.getMaxIdleMillis());
        result.addOption(this.OPT_SIZE, daemonInfo.getQueueSize());
        result.addOption(this.OPT_EXIT, exitToken);
        return result.getInvocationArgs();
    }
}

