/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.api;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.api.EventListener;
import org.gwe.api.ServerAPI4Monitor;
import org.gwe.api.ServerAPIAccessor;
import org.gwe.api.ServerAPIConnectionException;
import org.gwe.api.ServerAPISession;
import org.gwe.api.event.DefaultEventFilter;
import org.gwe.api.event.Event;
import org.gwe.api.event.EventFilter;
import org.gwe.utils.concurrent.ThreadPoolUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventMonitor
extends ServerAPISession<ServerAPI4Monitor> {
    private static final long MINIMUM_DELAY_PERIOD = 1000L;
    private static Log log = LogFactory.getLog(EventMonitor.class);
    private ExecutorService monitorsThreadPool = null;
    private Map<Long, EventQueueReader> eventQueues = new HashMap<Long, EventQueueReader>();
    private ServerAPI4Monitor monitorAPI = (ServerAPI4Monitor)this.getServerAPI();

    public EventMonitor(ServerAPIAccessor accessor) throws ServerAPIConnectionException {
        super(ServerAPI4Monitor.class, accessor);
        this.monitorsThreadPool = ThreadPoolUtils.createThreadPool("Event Monitors", false);
    }

    public void abortMonitorEventsFor(long handle) {
        try {
            this.prepareTunnel();
            this.monitorAPI.abortCurrentMonitoring(handle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void monitorEvents(EventListener listener) throws RemoteException {
        this.monitorEvents(listener, new DefaultEventFilter(null));
    }

    public void monitorEvents(EventListener listener, EventFilter filter) throws RemoteException {
        this.monitorEvents(1000L, listener, filter);
    }

    public void monitorEvents(long millisRefresh, EventListener listener, EventFilter filter) throws RemoteException {
        this.prepareTunnel();
        long handle = this.monitorAPI.createHandle();
        EventQueueReader queueReader = this.eventQueues.get(handle);
        if (queueReader == null) {
            queueReader = new EventQueueReader(handle, Math.max(1000L, millisRefresh), listener, filter);
            this.eventQueues.put(handle, queueReader);
        } else {
            queueReader.setNotifParameters(listener, filter);
            this.abortMonitorEventsFor(handle);
        }
        this.monitorsThreadPool.submit(queueReader);
    }

    public void shutdown() {
        this.monitorsThreadPool.shutdownNow();
    }

    class EventQueueReader
    implements Runnable {
        private long handle;
        private long delay;
        private EventListener listener;
        private EventFilter filter;

        public EventQueueReader(long handle, long refreshDelay, EventListener listener, EventFilter filter) {
            this.handle = handle;
            this.delay = refreshDelay;
            this.setNotifParameters(listener, filter);
        }

        public synchronized void setNotifParameters(EventListener listener, EventFilter filter) {
            this.listener = listener;
            this.filter = filter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    EventQueueReader eventQueueReader = this;
                    synchronized (eventQueueReader) {
                        EventMonitor.this.prepareTunnel();
                        List<Event> newEvents = EventMonitor.this.monitorAPI.getNextEvents(this.handle, this.filter);
                        for (Event ev : newEvents) {
                            try {
                                this.listener.eventPerformed(ev);
                            }
                            catch (Exception e) {}
                        }
                    }
                }
                catch (Exception e) {
                    log.debug(e);
                }
                try {
                    Thread.yield();
                    Thread.sleep(this.delay);
                    Thread.yield();
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

