/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.api;

import java.rmi.RemoteException;
import java.util.List;
import org.gwe.api.ClientOrderBasedOperation;
import org.gwe.api.ClientOrderBasedQuery;
import org.gwe.api.ServerAPI4UserRegular;
import org.gwe.api.ServerAPIAccessor;
import org.gwe.api.ServerAPIConnectionException;
import org.gwe.api.ServerAPISession;
import org.gwe.api.ServerAPISessionRequest;
import org.gwe.api.exceptions.GWEDomainException;
import org.gwe.api.exceptions.GridNotFoundException;
import org.gwe.api.exceptions.GridNotSpecifiedException;
import org.gwe.api.exceptions.OrderNotOwnedException;
import org.gwe.api.exceptions.OrderNotSpecifiedException;
import org.gwe.api.exceptions.PasswordMismatchException;
import org.gwe.api.exceptions.UserNotSpecifiedException;
import org.gwe.persistence.model.JobInfo;
import org.gwe.persistence.model.OrderInfo;
import org.gwe.persistence.model.UserInfo;
import org.gwe.utils.security.KeyStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerAPI4ClientSession
extends ServerAPISession<ServerAPI4UserRegular> {
    private UserInfo user;

    ServerAPI4ClientSession(ServerAPIAccessor accessor, UserInfo user) {
        super(ServerAPI4UserRegular.class, accessor);
        this.user = user;
    }

    public String doOrderBasedOperation(ClientOrderBasedOperation oper, int orderId) throws ServerAPIConnectionException, RemoteException, PasswordMismatchException, OrderNotOwnedException, GWEDomainException {
        if (oper == null) {
            return "No operation specified!";
        }
        switch (oper) {
            case PAUSE: {
                this.pauseOrder(orderId);
            }
            case RESUME: {
                this.resumeOrder(orderId);
            }
            case ABORT: {
                this.abortOrder(orderId);
            }
            case DELETE: {
                this.deleteOrder(orderId);
            }
        }
        return "Operation '" + oper.getId() + "' executed sucessfully over order " + orderId;
    }

    public String doOrderBasedQuery(ClientOrderBasedQuery oper, int orderId, int jobNum) throws ServerAPIConnectionException, RemoteException, GWEDomainException {
        return oper == null ? "No query specified." : oper.getOutput(this.getOrderBasedQueryResultModel(oper, orderId, jobNum));
    }

    private Object getOrderBasedQueryResultModel(ClientOrderBasedQuery oper, int orderId, int jobNum) throws ServerAPIConnectionException, RemoteException, GWEDomainException {
        switch (oper) {
            case GET_ORDER: {
                return this.getOrderDetails(orderId, false);
            }
            case GET_JOB: {
                return this.getJobDetails(orderId, jobNum);
            }
            case LIST_ORDERS: {
                return this.getOrdersList(false);
            }
            case LIST_JOBS: {
                return this.getOrderDetails(orderId, true);
            }
            case STREAM_RESULT: {
                JobInfo jobDetails = this.getJobDetails(orderId, jobNum);
                return jobDetails != null ? jobDetails.getRequestResult() : null;
            }
        }
        return null;
    }

    public void loginUser() throws ServerAPIConnectionException, RemoteException, GWEDomainException, PasswordMismatchException, UserNotSpecifiedException {
        this.executeRequest(new ServerAPI4ClientSessionRequest<Void>(){

            @Override
            public Void execute(ServerAPI4UserRegular serverAPI) throws RemoteException, PasswordMismatchException, UserNotSpecifiedException {
                serverAPI.loginUser(ServerAPI4ClientSession.this.user);
                return null;
            }
        });
    }

    public void setUserKeyStore(final KeyStore keys) throws ServerAPIConnectionException, RemoteException, GWEDomainException, PasswordMismatchException {
        this.executeRequest(new ServerAPI4ClientSessionRequest<Void>(){

            @Override
            public Void execute(ServerAPI4UserRegular serverAPI) throws RemoteException, PasswordMismatchException {
                serverAPI.setUserKeyStore(ServerAPI4ClientSession.this.user, keys);
                return null;
            }
        });
    }

    public int queueOrder(final OrderInfo order) throws ServerAPIConnectionException, RemoteException, GWEDomainException, PasswordMismatchException, OrderNotSpecifiedException, GridNotSpecifiedException, GridNotFoundException {
        return this.executeRequest(new ServerAPI4ClientSessionRequest<Integer>(){

            @Override
            public Integer execute(ServerAPI4UserRegular serverAPI) throws RemoteException, PasswordMismatchException, OrderNotSpecifiedException, GridNotSpecifiedException, GridNotFoundException {
                return serverAPI.queueOrder(ServerAPI4ClientSession.this.user, order);
            }
        });
    }

    public void pauseOrder(final int orderId) throws ServerAPIConnectionException, RemoteException, GWEDomainException, PasswordMismatchException, OrderNotOwnedException {
        this.executeRequest(new ServerAPI4ClientSessionRequest<Void>(){

            @Override
            public Void execute(ServerAPI4UserRegular serverAPI) throws RemoteException, PasswordMismatchException, OrderNotOwnedException {
                serverAPI.pauseOrder(ServerAPI4ClientSession.this.user, orderId);
                return null;
            }
        });
    }

    public void resumeOrder(final int orderId) throws ServerAPIConnectionException, RemoteException, GWEDomainException {
        this.executeRequest(new ServerAPI4ClientSessionRequest<Void>(){

            @Override
            public Void execute(ServerAPI4UserRegular serverAPI) throws RemoteException, PasswordMismatchException, OrderNotOwnedException {
                serverAPI.resumeOrder(ServerAPI4ClientSession.this.user, orderId);
                return null;
            }
        });
    }

    public void abortOrder(final int orderId) throws ServerAPIConnectionException, RemoteException, GWEDomainException {
        this.executeRequest(new ServerAPI4ClientSessionRequest<Void>(){

            @Override
            public Void execute(ServerAPI4UserRegular serverAPI) throws RemoteException, PasswordMismatchException, OrderNotOwnedException {
                serverAPI.abortOrder(ServerAPI4ClientSession.this.user, orderId);
                return null;
            }
        });
    }

    public void deleteOrder(final int orderId) throws ServerAPIConnectionException, RemoteException, GWEDomainException {
        this.executeRequest(new ServerAPI4ClientSessionRequest<Void>(){

            @Override
            public Void execute(ServerAPI4UserRegular serverAPI) throws RemoteException, PasswordMismatchException, OrderNotOwnedException {
                serverAPI.deleteOrder(ServerAPI4ClientSession.this.user, orderId);
                return null;
            }
        });
    }

    public OrderInfo getOrderDetails(final int orderId, final boolean includeJobDetails) throws ServerAPIConnectionException, RemoteException, GWEDomainException {
        return this.executeRequest(new ServerAPI4ClientSessionRequest<OrderInfo>(){

            @Override
            public OrderInfo execute(ServerAPI4UserRegular serverAPI) throws RemoteException, PasswordMismatchException, OrderNotOwnedException {
                return serverAPI.getOrderDetails(ServerAPI4ClientSession.this.user, orderId, includeJobDetails);
            }
        });
    }

    public List<OrderInfo> getOrdersList(final boolean includeJobDetails) throws ServerAPIConnectionException, RemoteException, GWEDomainException {
        return this.executeRequest(new ServerAPI4ClientSessionRequest<List<OrderInfo>>(){

            @Override
            public List<OrderInfo> execute(ServerAPI4UserRegular serverAPI) throws RemoteException, PasswordMismatchException {
                return serverAPI.getOrdersList(ServerAPI4ClientSession.this.user, includeJobDetails);
            }
        });
    }

    public JobInfo getJobDetails(final int orderId, final int jobNum) throws ServerAPIConnectionException, RemoteException, GWEDomainException {
        return this.executeRequest(new ServerAPI4ClientSessionRequest<JobInfo>(){

            @Override
            public JobInfo execute(ServerAPI4UserRegular serverAPI) throws RemoteException, PasswordMismatchException, OrderNotOwnedException {
                return serverAPI.getJobDetails(ServerAPI4ClientSession.this.user, orderId, jobNum);
            }
        });
    }

    public List<OrderInfo> getOrders(final String description) throws ServerAPIConnectionException, RemoteException, GWEDomainException, PasswordMismatchException {
        return this.executeRequest(new ServerAPI4ClientSessionRequest<List<OrderInfo>>(){

            @Override
            public List<OrderInfo> execute(ServerAPI4UserRegular serverAPI) throws RemoteException, PasswordMismatchException {
                return serverAPI.getOrdersByDescription(ServerAPI4ClientSession.this.user, description);
            }
        });
    }

    public String getUsername() {
        return this.user.getId();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ServerAPI4ClientSessionRequest<RETURN_TYPE>
    extends ServerAPISessionRequest<ServerAPI4UserRegular, RETURN_TYPE> {
    }
}

