/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.api;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Set;
import org.gwe.api.exceptions.GridNotFoundException;
import org.gwe.api.exceptions.GridNotSpecifiedException;
import org.gwe.api.exceptions.OrderNotOwnedException;
import org.gwe.api.exceptions.OrderNotSpecifiedException;
import org.gwe.api.exceptions.PasswordMismatchException;
import org.gwe.api.exceptions.UserNotSpecifiedException;
import org.gwe.persistence.model.GridInfo;
import org.gwe.persistence.model.JobInfo;
import org.gwe.persistence.model.OrderInfo;
import org.gwe.persistence.model.UserInfo;
import org.gwe.utils.security.KeyStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ServerAPI4UserRegular
extends Remote {
    public UserInfo loginUser(UserInfo var1) throws RemoteException, PasswordMismatchException, UserNotSpecifiedException;

    public Set<GridInfo> getGridsDefined(UserInfo var1) throws RemoteException, PasswordMismatchException;

    public GridInfo defineGrid(UserInfo var1, String var2, String[] var3) throws RemoteException, PasswordMismatchException;

    public List<OrderInfo> getOrdersDefined(UserInfo var1) throws RemoteException, PasswordMismatchException;

    public int queueOrder(UserInfo var1, OrderInfo var2) throws RemoteException, PasswordMismatchException, OrderNotSpecifiedException, GridNotSpecifiedException, GridNotFoundException;

    public int queueOrder(UserInfo var1, String var2, OrderInfo var3) throws RemoteException, PasswordMismatchException, OrderNotSpecifiedException, GridNotSpecifiedException, GridNotFoundException;

    public void pauseOrder(UserInfo var1, int var2) throws RemoteException, PasswordMismatchException, OrderNotOwnedException;

    public void resumeOrder(UserInfo var1, int var2) throws RemoteException, PasswordMismatchException, OrderNotOwnedException;

    public void abortOrder(UserInfo var1, int var2) throws RemoteException, PasswordMismatchException, OrderNotOwnedException;

    public void deleteOrder(UserInfo var1, int var2) throws RemoteException, PasswordMismatchException, OrderNotOwnedException;

    public void updateOrder(UserInfo var1, int var2, OrderInfo var3) throws RemoteException;

    public List<OrderInfo> getOrdersByDescription(UserInfo var1, String var2) throws RemoteException, PasswordMismatchException;

    public OrderInfo getOrderDetails(UserInfo var1, int var2, boolean var3) throws RemoteException, PasswordMismatchException, OrderNotOwnedException;

    public OrderInfo getOrderDetails(UserInfo var1, String var2, boolean var3) throws RemoteException, PasswordMismatchException, OrderNotOwnedException;

    public JobInfo getJobDetails(UserInfo var1, int var2, int var3) throws RemoteException, PasswordMismatchException, OrderNotOwnedException;

    public List<OrderInfo> getOrdersList(UserInfo var1, boolean var2) throws RemoteException, PasswordMismatchException;

    public void setUserKeyStore(UserInfo var1, KeyStore var2) throws RemoteException, PasswordMismatchException;
}

