/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.api.EventMonitor;
import org.gwe.api.ServerAPI4ClientSession;
import org.gwe.api.ServerAPIConnectionException;
import org.gwe.api.TunneledSocketFactory;
import org.gwe.api.exceptions.GWEDomainException;
import org.gwe.api.exceptions.PasswordMismatchException;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.UserInfo;
import org.gwe.utils.concurrent.HeartBeater;
import org.gwe.utils.concurrent.PulsingServerAPI;
import org.gwe.utils.concurrent.PulsingServerAPIProxyCreator;
import org.gwe.utils.security.KeyStore;
import org.gwe.utils.security.URILink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerAPIAccessor {
    private static Log log = LogFactory.getLog(ServerAPIAccessor.class);
    private static HeartBeater<PulsingServerAPI> beatingActor = new HeartBeater<PulsingServerAPI>(){

        @Override
        public boolean beatAndReportIfMustContinue(Object id, PulsingServerAPI heartContainer) {
            try {
                heartContainer.heartBeat(id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return true;
        }
    };
    private HeadResourceInfo daemonInfo;
    private URILink link;

    public static <RT extends Remote> String getRegistryId(Class<RT> remoteClass) {
        return "/" + remoteClass.getName().replace('.', '/');
    }

    public ServerAPIAccessor(HeadResourceInfo daemonInfo, URILink link) {
        this.daemonInfo = daemonInfo;
        this.link = link;
    }

    public HeadResourceInfo getDaemonInfo() {
        return this.daemonInfo;
    }

    public URILink getLink() {
        return this.link;
    }

    public ServerAPI4ClientSession createClientSession(UserInfo user) {
        return new ServerAPI4ClientSession(this, user);
    }

    public ServerAPI4ClientSession createLoggedInSession(UserInfo user, KeyStore keys) throws ServerAPIConnectionException, RemoteException, PasswordMismatchException {
        ServerAPI4ClientSession session = this.createClientSession(user);
        try {
            session.loginUser();
            session.setUserKeyStore(keys);
        }
        catch (GWEDomainException e) {
            log.warn("IMPOSSIBLE. Problems login user " + user.getName(), e);
        }
        return session;
    }

    public EventMonitor createEventMonitor() throws Exception {
        return new EventMonitor(this);
    }

    public <RT extends Remote> RT createLink(Class<RT> remoteClass) throws URISyntaxException, RemoteException, NotBoundException {
        log.info("Trying to establish a link to '" + remoteClass.getSimpleName() + "' API server from daemon at '" + this.daemonInfo.getLocation() + "'...");
        String serverId = ServerAPIAccessor.getRegistryId(remoteClass);
        String uriStr = new HeadResourceInfo("127.0.0.1", this.daemonInfo.getRegistryPort()).getLocation() + serverId;
        URI uriObj = new URI(uriStr);
        TunneledSocketFactory.setLinkForTunnel(this.link);
        Registry registry = LocateRegistry.getRegistry(uriObj.getHost(), uriObj.getPort(), new TunneledSocketFactory());
        log.info("Registry obtained! " + registry);
        log.info("Retrieving remote object '" + uriObj.toString() + "'...");
        Remote serverAPI = registry.lookup(uriObj.getPath().substring(1));
        log.info("Remote proxy object created: '" + serverAPI + "'. Actual object at '" + uriObj.toString() + "'");
        return (RT)PulsingServerAPIProxyCreator.createProxyIfNecessary(serverAPI, beatingActor);
    }
}

