/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.api;

import java.net.URISyntaxException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.api.ServerAPIAccessor;
import org.gwe.api.ServerAPIConnectionException;
import org.gwe.api.ServerAPISessionRequest;
import org.gwe.api.TunneledSocketFactory;
import org.gwe.api.exceptions.GWEDomainException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerAPISession<API_TYPE extends Remote> {
    private static Log log = LogFactory.getLog(ServerAPISession.class);
    private API_TYPE serverAPI;
    private Class<API_TYPE> serverAPIClass;
    private ServerAPIAccessor accessor;

    public ServerAPISession(Class<API_TYPE> serverAPIClass, ServerAPIAccessor accessor) {
        this.accessor = accessor;
        this.serverAPIClass = serverAPIClass;
    }

    protected void prepareTunnel() {
        TunneledSocketFactory.setLinkForTunnel(this.accessor.getLink());
    }

    public <RETURN_TYPE> RETURN_TYPE executeRequest(ServerAPISessionRequest<API_TYPE, RETURN_TYPE> req) throws ServerAPIConnectionException, RemoteException, GWEDomainException {
        this.prepareTunnel();
        try {
            try {
                return req.execute(this.getServerAPI());
            }
            catch (RemoteException e) {
                this.serverAPI = null;
                return req.execute(this.getServerAPI());
            }
        }
        catch (ServerAPIConnectionException e) {
            log.warn(e);
            throw e;
        }
    }

    protected API_TYPE getServerAPI() throws ServerAPIConnectionException {
        if (this.serverAPI == null) {
            try {
                this.serverAPI = this.accessor.createLink(this.serverAPIClass);
            }
            catch (URISyntaxException e) {
                throw new ServerAPIConnectionException("Could not connect to remote GWE daemon. Make sure a valid URI can be built with host '" + this.accessor.getDaemonInfo().getHost() + "' and port '" + this.accessor.getDaemonInfo().getRegistryPort() + "'", e);
            }
            catch (RemoteException e) {
                throw new ServerAPIConnectionException("Could not connect to remote GWE daemon. Make sure there are not network connectivity issues including invalid network level credentials to SSH into host '" + this.accessor.getDaemonInfo().getHost() + "'", e);
            }
            catch (NotBoundException e) {
                throw new ServerAPIConnectionException("Could not connect to remote GWE daemon. Make sure it is remotely installed at '" + this.accessor.getDaemonInfo().getHost() + "' and launched on port '" + this.accessor.getDaemonInfo().getRegistryPort() + "'", e);
            }
        }
        return this.serverAPI;
    }
}

