/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.api;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.netAccess.SSHDriver;
import org.gwe.drivers.netAccess.SSHHandle;
import org.gwe.utils.security.URILink;

public class TunneledSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static Log log = LogFactory.getLog(TunneledSocketFactory.class);
    private static ThreadLocal<URILink> linkForTunnel = new ThreadLocal();
    private String serverAddress;

    public static void setLinkForTunnel(URILink link) {
        linkForTunnel.set(link);
    }

    public TunneledSocketFactory() {
        this("127.0.0.1");
    }

    public TunneledSocketFactory(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public Socket createSocket(String host, int port) throws IOException {
        try {
            return this.createLoopbackSocket(port);
        }
        catch (ConnectException e) {
            this.openTunnel(port);
            return this.createLoopbackSocket(port);
        }
    }

    private Socket createLoopbackSocket(int port) throws UnknownHostException, IOException {
        Socket socket = new Socket(Proxy.NO_PROXY);
        InetAddress localHost = InetAddress.getByName(this.serverAddress);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(localHost, port);
        socket.connect(inetSocketAddress);
        return socket;
    }

    private void openTunnel(int port) {
        try {
            SSHHandle handle = new SSHDriver().tryToCreateHandle(linkForTunnel.get());
            handle.openTunnel(port);
        }
        catch (Exception e) {
            log.warn("Problems opening tunnel on port " + port + ". (" + linkForTunnel + ")");
        }
    }
}

