/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.api.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gwe.persistence.model.BaseModelInfo;
import org.gwe.persistence.model.EventType;
import org.gwe.persistence.model.ModelSummary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event
implements Serializable {
    private EventType eventType;
    private List<ModelSummary> modelSums = new ArrayList<ModelSummary>();

    public Event(EventType evType, BaseModelInfo<?> source, BaseModelInfo ... models) {
        this.modelSums.add(source.createModelSummaryFor(evType));
        for (BaseModelInfo modelInfo : models) {
            this.modelSums.add(modelInfo.createModelSummaryFor(evType));
        }
        this.eventType = evType;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public List<ModelSummary> getModelIdentifiers() {
        return this.modelSums;
    }

    public String toString() {
        String result = "EVENT [" + (Object)((Object)this.eventType) + "] =====> ";
        for (int idx = 0; idx < this.modelSums.size(); ++idx) {
            ModelSummary modelSum = this.modelSums.get(idx);
            result = result + "{" + this.createFieldEntry(idx, "SRC", modelSum.getModelInfoClass().getSimpleName()) + "," + this.createFieldEntry(idx, "KEY", modelSum.getKey()) + "," + this.createFieldEntry(idx, "PAYLOAD", modelSum.getPayload()) + " }";
        }
        return result;
    }

    private String createFieldEntry(int idx, String fieldName, Object value) {
        if (value == null || value.toString().equals("")) {
            return "";
        }
        return " M(" + idx + ")." + fieldName + "=[" + value + "]";
    }
}

