/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.api.impl;

import java.lang.reflect.ParameterizedType;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.api.ServerAPIAccessor;
import org.gwe.api.TunneledSocketFactory;
import org.gwe.app.daemon.domain.BaseDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseServerAPIImpl<API_TYPE extends Remote, DOM_TYPE extends BaseDomain>
implements Remote {
    private static Log log = LogFactory.getLog(BaseServerAPIImpl.class);
    protected Class<API_TYPE> remoteInterface;
    protected DOM_TYPE domain;

    public BaseServerAPIImpl() {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.remoteInterface = (Class)genericSuperclass.getActualTypeArguments()[0];
    }

    public DOM_TYPE getDomain() {
        return this.domain;
    }

    public void setDomain(DOM_TYPE domain) {
        this.domain = domain;
    }

    protected Remote createExportableServerObject() {
        return this;
    }

    public API_TYPE bind(String daemonLocation) throws RemoteException {
        TunneledSocketFactory daemonSocketFactory = new TunneledSocketFactory();
        Remote stub = UnicastRemoteObject.exportObject(this.createExportableServerObject(), 0, daemonSocketFactory, RMISocketFactory.getDefaultSocketFactory());
        String apiId = ServerAPIAccessor.getRegistryId(this.remoteInterface);
        String location = daemonLocation + apiId;
        log.info("Binding remote object of class '" + this.getClass().getName() + "' to RMI registry: '" + location + "'");
        try {
            Naming.rebind(daemonLocation + apiId, stub);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        log.info("Remote stub object of class '" + stub.getClass().getName() + "' bound to RMI registry: '" + location + "'!");
        return (API_TYPE)stub;
    }
}

