/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.api.impl;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.api.ServerAPI4Agent;
import org.gwe.api.ShutdownDaemonRequest;
import org.gwe.api.impl.PulsingServerAPIImpl;
import org.gwe.app.daemon.domain.AgentDomain;
import org.gwe.persistence.model.ComputeResourceInfo;
import org.gwe.persistence.model.order.DaemonRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerAPI4AgentImpl
extends PulsingServerAPIImpl<ServerAPI4Agent, AgentDomain>
implements ServerAPI4Agent {
    private static Log log = LogFactory.getLog(ServerAPI4AgentImpl.class);

    @Override
    public boolean reserveAllocation(int allocId, ComputeResourceInfo compRes) throws RemoteException {
        log.trace("Allocation " + allocId + " called back! - 'reserveAllocation' method");
        try {
            return ((AgentDomain)this.domain).createAllocation(allocId, compRes);
        }
        catch (Exception e) {
            this.disposeAllocation(allocId, e);
            return false;
        }
    }

    @Override
    public DaemonRequest<?> getNextRequest(int allocId) throws RemoteException {
        log.trace("Allocation " + allocId + " called back! - 'getNextRequest' method");
        try {
            return ((AgentDomain)this.domain).extractRequestFromNextJobAssignedBlocking(allocId);
        }
        catch (Exception e) {
            return this.disposeAllocation(allocId, e);
        }
    }

    @Override
    public boolean reportRequestCompletion(int allocId, Serializable result) throws RemoteException {
        log.trace("Allocation " + allocId + " called back! - 'reportRequestCompletion' method");
        try {
            ((AgentDomain)this.domain).cleanAllocAndFinalizeJobAsync(allocId, result);
            return true;
        }
        catch (Exception e) {
            this.disposeAllocation(allocId, e);
            return false;
        }
    }

    @Override
    public boolean reportAgentProblem(int allocId, Exception exception) throws RemoteException {
        log.trace("Allocation " + allocId + " called back! - 'reportAgentProblem' method");
        this.disposeAllocation(allocId, exception);
        return true;
    }

    private ShutdownDaemonRequest disposeAllocation(int allocId, Exception e) {
        log.trace("Allocation " + allocId + " disposing sequence started...");
        ShutdownDaemonRequest shutdownReq = ((AgentDomain)this.domain).disposeLiveAllocation(allocId, e);
        super.disposeHeart(allocId);
        return shutdownReq;
    }

    @Override
    public void processHeartBeatOverdue(Object id) {
        Integer allocId = (Integer)id;
        log.warn("Heartbeat overdue for allocation '" + allocId + "' detected. Disposing allocation " + id);
        this.disposeAllocation(allocId, null);
    }
}

