/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.api.impl;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.api.ServerAPI4UserRegular;
import org.gwe.api.exceptions.GridNotFoundException;
import org.gwe.api.exceptions.GridNotSpecifiedException;
import org.gwe.api.exceptions.OrderNotOwnedException;
import org.gwe.api.exceptions.OrderNotSpecifiedException;
import org.gwe.api.exceptions.PasswordMismatchException;
import org.gwe.api.exceptions.UserNotSpecifiedException;
import org.gwe.api.impl.BaseServerAPIImpl;
import org.gwe.app.daemon.domain.UserRegularDomain;
import org.gwe.persistence.model.GridInfo;
import org.gwe.persistence.model.JobInfo;
import org.gwe.persistence.model.OrderInfo;
import org.gwe.persistence.model.UserInfo;
import org.gwe.utils.security.KeyStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerAPI4UserRegularImpl
extends BaseServerAPIImpl<ServerAPI4UserRegular, UserRegularDomain>
implements ServerAPI4UserRegular {
    private static Log log = LogFactory.getLog(ServerAPI4UserRegularImpl.class);

    @Override
    public UserInfo loginUser(UserInfo user) throws RemoteException, PasswordMismatchException, UserNotSpecifiedException {
        return ((UserRegularDomain)this.domain).getPersistedUser(user, false);
    }

    public UserInfo loginOrCreateUser(UserInfo user) throws RemoteException, PasswordMismatchException, UserNotSpecifiedException {
        return ((UserRegularDomain)this.domain).getOrCreateUser(user);
    }

    @Override
    public void setUserKeyStore(UserInfo user, KeyStore keys) throws RemoteException, PasswordMismatchException {
        ((UserRegularDomain)this.domain).setUserKeyStore(user, keys);
    }

    @Override
    public Set<GridInfo> getGridsDefined(UserInfo user) throws RemoteException, PasswordMismatchException {
        return ((UserRegularDomain)this.domain).getGridsDefined(user);
    }

    @Override
    public GridInfo defineGrid(UserInfo user, String name, String[] headLocations) throws RemoteException, PasswordMismatchException {
        return ((UserRegularDomain)this.domain).defineGrid(user, name, headLocations);
    }

    @Override
    public List<OrderInfo> getOrdersDefined(UserInfo user) throws RemoteException, PasswordMismatchException {
        return ((UserRegularDomain)this.domain).getOrdersDefined(user);
    }

    @Override
    public int queueOrder(UserInfo user, OrderInfo order) throws RemoteException, PasswordMismatchException, OrderNotSpecifiedException, GridNotSpecifiedException, GridNotFoundException {
        order = ((UserRegularDomain)this.domain).persistOrder(user, order);
        return this.queueOrder(order);
    }

    @Override
    public int queueOrder(UserInfo user, String gridId, OrderInfo order) throws RemoteException, PasswordMismatchException, OrderNotSpecifiedException, GridNotSpecifiedException, GridNotFoundException {
        order = ((UserRegularDomain)this.domain).persistOrder(user, gridId, order);
        return this.queueOrder(order);
    }

    private int queueOrder(OrderInfo order) {
        ((UserRegularDomain)this.domain).queueOrder(order);
        log.info("Request to queue an order received: " + order);
        return order.getId();
    }

    @Override
    public void pauseOrder(UserInfo user, int orderId) throws RemoteException, PasswordMismatchException, OrderNotOwnedException {
        this.setPause(user, orderId, true);
    }

    @Override
    public void resumeOrder(UserInfo user, int orderId) throws RemoteException, PasswordMismatchException, OrderNotOwnedException {
        this.setPause(user, orderId, false);
    }

    private void setPause(UserInfo user, int orderId, boolean pause) throws PasswordMismatchException, OrderNotOwnedException {
        ((UserRegularDomain)this.domain).pauseOrder(user, orderId, pause);
    }

    @Override
    public void abortOrder(UserInfo user, int orderId) throws RemoteException, PasswordMismatchException, OrderNotOwnedException {
        ((UserRegularDomain)this.domain).abortOrder(user, orderId);
    }

    @Override
    public void deleteOrder(UserInfo user, int orderId) throws RemoteException, PasswordMismatchException, OrderNotOwnedException {
        ((UserRegularDomain)this.domain).deleteOrder(user, orderId);
    }

    @Override
    public void updateOrder(UserInfo user, int orderId, OrderInfo order) throws RemoteException {
        log.info("Request to update an order received: " + order);
    }

    @Override
    public List<OrderInfo> getOrdersByDescription(UserInfo user, String description) throws RemoteException, PasswordMismatchException {
        return ((UserRegularDomain)this.domain).getOrdersByDescription(user, description);
    }

    @Override
    public OrderInfo getOrderDetails(UserInfo user, int orderId, boolean includeJobs) throws RemoteException, PasswordMismatchException, OrderNotOwnedException {
        return ((UserRegularDomain)this.domain).getOrder(user, orderId, includeJobs);
    }

    @Override
    public OrderInfo getOrderDetails(UserInfo user, String userOrderId, boolean includeJobs) throws RemoteException, PasswordMismatchException, OrderNotOwnedException {
        return ((UserRegularDomain)this.domain).getOrderDetails(user, userOrderId, includeJobs);
    }

    @Override
    public List<OrderInfo> getOrdersList(UserInfo user, boolean includeJobs) throws RemoteException, PasswordMismatchException {
        return ((UserRegularDomain)this.domain).getOrdersList(user, includeJobs);
    }

    @Override
    public JobInfo getJobDetails(UserInfo user, int orderId, int jobNum) throws RemoteException, PasswordMismatchException, OrderNotOwnedException {
        return ((UserRegularDomain)this.domain).getJobDetails(user, orderId, jobNum);
    }
}

