/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.agent;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.GWEAppContext;
import org.gwe.api.ServerAPI4Agent;
import org.gwe.api.ServerAPIAccessor;
import org.gwe.api.SystemDaemonRequest;
import org.gwe.persistence.model.ComputeResourceInfo;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.order.DaemonRequest;
import org.gwe.utils.security.URILink;

public class AgentApp {
    private static Log log = LogFactory.getLog(AgentApp.class);
    private ServerAPI4Agent agentAPI;
    private int allocId;
    private String workspace;

    public static void main(String[] args) {
        try {
            String workspace = args[4] + "/";
            GWEAppContext.setInstance(new GWEAppContext(workspace, new String[0]));
            AgentApp agentApp = new AgentApp(args[0], Integer.parseInt(args[1]), args[2], Integer.parseInt(args[3]), workspace);
            agentApp.run();
        }
        catch (Exception e) {
            log.fatal("Non-recoverable exception occured in agent. Exiting!", e);
            AgentApp.exit();
        }
        log.info("Bye!");
        AgentApp.exit();
    }

    private static void exit() {
        System.exit(0);
    }

    public AgentApp(String host, int port, String linkSerFile, int allocId, String workspace) throws Exception {
        this.allocId = allocId;
        this.workspace = workspace;
        log.info("Parameters parsed. Deserializing link to create an ssh tunnel into the compute resource where GWE daemon is running...");
        FileInputStream fis = new FileInputStream(linkSerFile);
        ObjectInputStream ois = new ObjectInputStream(fis);
        URILink link = (URILink)ois.readObject();
        HeadResourceInfo daemonInfo = new HeadResourceInfo(host, port);
        log.info("Link deserialized. Trying to callback '" + daemonInfo + "' to get AgentAPI...");
        ServerAPIAccessor accessor = new ServerAPIAccessor(daemonInfo, link);
        this.agentAPI = accessor.createLink(ServerAPI4Agent.class);
    }

    private void run() throws RemoteException {
        boolean accepted = this.agentAPI.reserveAllocation(this.allocId, ComputeResourceInfo.createLocalInfo(this.allocId));
        log.info("Agent registered: '" + accepted + "'");
        while (accepted && this.processRequest(this.allocId)) {
        }
        log.info("Shuting down...");
    }

    private boolean processRequest(int allocId) throws RemoteException {
        Serializable result;
        DaemonRequest<?> req;
        try {
            log.info("Querying daemon for next request...");
            req = this.agentAPI.getNextRequest(allocId);
        }
        catch (Exception e) {
            log.warn("Request process failed with exception", e);
            this.agentAPI.reportAgentProblem(allocId, e);
            return false;
        }
        if (req instanceof SystemDaemonRequest) {
            log.info("Daemon sent a " + req + " request...");
            return ((SystemDaemonRequest)req).systemProcess();
        }
        if (req == null) {
            log.info("Daemon sent a 'null' request...");
            log.info("Shutting down...");
            return false;
        }
        log.info("Invoking 'request.process'...");
        try {
            result = req.process(this.workspace);
            log.info("Request processed with results:\n" + result);
        }
        catch (Exception e) {
            this.agentAPI.reportRequestCompletion(allocId, e);
            log.warn("Request process failed with exception", e);
            return false;
        }
        return this.agentAPI.reportRequestCompletion(allocId, result);
    }
}

