/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.GWEAppContext;
import org.gwe.api.ServerAPI4ClientSession;
import org.gwe.api.ServerAPIAccessor;
import org.gwe.api.ServerAPIConnectionException;
import org.gwe.api.exceptions.PasswordMismatchException;
import org.gwe.app.client.ClusterNotSpecifiedException;
import org.gwe.p2el.P2ELExpressionContext;
import org.gwe.p2el.P2ELStatement;
import org.gwe.p2el.P2ELSyntaxException;
import org.gwe.persistence.model.GridInfo;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.UserInfo;
import org.gwe.utils.cmd.OptionParser;
import org.gwe.utils.security.AccountInfo;
import org.gwe.utils.security.CredentialNotFoundException;
import org.gwe.utils.security.KeyStore;
import org.gwe.utils.security.URILink;

public class ClientAppConfig {
    private static Log log = LogFactory.getLog(ClientAppConfig.class);
    public static final String LOGIN_ARG_PREFIX = "-login=";
    private KeyStore keys;
    private HeadResourceInfo clusterSelected;
    private GridInfo grid = null;
    private String gweUser;
    private String gwePassword;

    public static String extractGWE_HOME() {
        return System.getenv("GWE_HOME");
    }

    public ClientAppConfig(String loginArg) {
        this(ClientAppConfig.extractGWE_HOME(), loginArg);
    }

    public ClientAppConfig(String gweHome, String loginArg) {
        gweHome = gweHome == null || "".equals(gweHome) ? "" : gweHome + "/";
        OptionParser option = new OptionParser(LOGIN_ARG_PREFIX, loginArg, new char[]{':'});
        this.gweUser = option.getEle(0, null);
        this.gwePassword = option.getEle(1, null);
        GWEAppContext.setInstance(new GWEAppContext(gweHome, new String[0]));
    }

    public String getGweUser() {
        return this.gweUser;
    }

    public String getGwePassword() {
        return this.gwePassword;
    }

    public void load(String connnURL) throws CredentialNotFoundException, ClusterNotSpecifiedException {
        String[] part = connnURL.split("@");
        String[] login = part[0].split(":");
        String[] location = part[1].split(":");
        if (login.length == 0) {
            throw new CredentialNotFoundException("User missing");
        }
        if (login.length == 1) {
            throw new CredentialNotFoundException("Password missing");
        }
        if (location.length == 0) {
            throw new CredentialNotFoundException("Host missing");
        }
        String host = location[0];
        int port = location.length > 1 ? Integer.parseInt(location[1]) : 1099;
        this.load(host, port, login[0], login[1]);
    }

    public void load(String host, int port, String user, String password) throws CredentialNotFoundException, ClusterNotSpecifiedException {
        this.load(host, port, KeyStore.createKeyStore(host, user, "", password));
    }

    public void load(String host, int port, KeyStore keys) throws CredentialNotFoundException, ClusterNotSpecifiedException {
        this.load(new HeadResourceInfo(host, port), keys, new GridInfo[0]);
    }

    public void load(HeadResourceInfo clusterHeadNode, KeyStore keys, GridInfo ... grids) throws CredentialNotFoundException, ClusterNotSpecifiedException {
        if (clusterHeadNode == null) {
            throw new ClusterNotSpecifiedException();
        }
        keys.verifyCredentials();
        this.keys = keys;
        this.clusterSelected = clusterHeadNode;
        if (grids.length > 0) {
            this.grid = grids[0];
        }
        if (this.getNodeAccount() != null) {
            return;
        }
        throw new CredentialNotFoundException(this.clusterSelected.getCompURI());
    }

    public AccountInfo getNodeAccount() {
        return this.getNodeLink().getAccountInfo();
    }

    public URILink getNodeLink() {
        try {
            return this.clusterSelected.getHost().equals("localhost") ? URILink.createLocalLink(URI.create("ssh://localhost")) : this.keys.generateURILink(this.clusterSelected.getCompURI());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String getConnectionURL() {
        return this.getConnectionURL(true);
    }

    public String getConnectionURL(boolean includeUser) {
        try {
            URILink link = this.getKeys().generateURILink(this.clusterSelected.getCompURI());
            AccountInfo auth = link.getAccountInfo();
            if (this.clusterSelected.getHost() == null || auth == null) {
                return "";
            }
            String preffix = includeUser ? auth.getUserName() + "@" : "";
            return preffix + this.clusterSelected.getHost() + ":" + this.clusterSelected.getRegistryPort();
        }
        catch (URISyntaxException e) {
            return "";
        }
    }

    public P2ELStatement createStatement(String stmtTxt) throws P2ELSyntaxException {
        return GWEAppContext.getP2ELEngine().createStatement(new P2ELExpressionContext(null, this.getKeys()), stmtTxt);
    }

    public KeyStore getKeys() {
        return this.keys;
    }

    public HeadResourceInfo getClusterSelected() {
        return this.clusterSelected;
    }

    public GridInfo getGrid() {
        return this.grid;
    }

    public void setClusterSelected(HeadResourceInfo clusterSelected) {
        this.clusterSelected = clusterSelected;
    }

    public ServerAPIAccessor createAPIAccessor() {
        return new ServerAPIAccessor(this.getClusterSelected(), this.getNodeLink());
    }

    public ServerAPI4ClientSession createLoggedInSession(UserInfo user) throws ServerAPIConnectionException, RemoteException, PasswordMismatchException {
        return this.createAPIAccessor().createLoggedInSession(user, this.getKeys());
    }
}

